(* :Name: SmoothGraphics` *)

(* :Title: SmoothGraphics *)

(* :Author: Tom Wickham-Jones*)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 2.2 *)

(* :Copyright: Copyright 1992, Wolfram Research, Inc.
*)

(* :History:
	Created summer 1992 by Tom Wickham-Jones.

	This package is described in the book
	Mathematica Graphics: Techniques and Applications.
	Tom Wickham-Jones, TELOS/Springer-Verlag 1994.

*)



BeginPackage[ "ExtendGraphics`SmoothGraphics`"]


SmoothGraphics::usage = "SmoothGraphics[ gobj, num]
	generates smooth Contour, Surface and Density graphics objects.
	This is done by subdividing each cell num times."
	
Begin[ "`Private`"]

SmoothGraphics[ 
	head_[ data_, opts___] /;  MemberQ[ 
					{
					ContourGraphics, 
					SurfaceGraphics, 
					DensityGraphics
					}, head], smooth_Integer?Positive] :=
    Block[ {mesh, xn, yn, x0, x1, y0, y1, ndata}, 
         mesh = MeshRange /. Flatten[{opts}] /. Options[ head] ;
        {xn, yn} = N[ Dimensions[ data]] ;
        {{x0, x1}, {y0, y1}} =
                If[ mesh === Automatic, {{1,xn}, {1, yn}}, mesh] ;
        ndata = Table[ 
                   {  
                   x0 + (i-1) (x1 - x0)/(xn - 1), 
                   y0 + (j-1) (y1 - y0)/(yn - 1),
                   Part[ data, i, j]
                   }, {i, xn}, {j,yn}] ;
        ndata = Interpolation[ Flatten[ ndata, 1]] ;
		x0 += (1+Abs[x0]) $MachineEpsilon; y0 += (1+Abs[y0]) $MachineEpsilon;                  
		x1 -= (1+Abs[x1]) $MachineEpsilon; y1 -= (1+Abs[y1]) $MachineEpsilon;                  
        ndata = Table[ 
                     ndata[ x, y], 
                     { x, x0, x1, (x1 - x0)/(xn smooth -1)}, 
                     { y, y0, y1, (y1 - y0)/(yn smooth -1)}] ;
        head[ ndata, opts] 
        ]   

SmoothGraphicsDisplay[ function_, object_, smooth_] :=
    (function[ 
	SmoothGraphics[ object, smooth]] /. 
		(DisplayFunction -> _) -> (DisplayFunction -> function))
	
	

	
End[]

EndPackage[]


(*

Examples

ContourPlot[ Sin[x] Cos[y], {x,-Pi,Pi}, {y,-Pi,Pi}]

Show[ SmoothGraphics[ %, 3]]

Plot3D[ Sin[x y], {x,-Pi,Pi}, {y,-Pi,Pi}]

Show[ SmoothGraphics[ %, 3]]

To use automatically:

SetOptions[ 
	ContourPlot, 
	DisplayFunction -> (SmoothGraphicsDisplay[ $DisplayFunction, #, 3]&)
	]
	
	
then just use

ContourPlot[ Sin[x y], {x,0,2Pi}, {y,.0,Pi}]

*)
