
Get[ "ExtendGraphics`Ticks`"]

Unprotect[ PolarPlot]

Clear[ PolarPlot]

Options[ PolarPlot] = Options[ ParametricPlot]

SetOptions[ PolarPlot, 
	Axes -> Polar,
	AxesStyle -> {Dashing[ {0.02,0.06}], Thickness[ 0.0005]},
	AspectRatio -> Automatic]

PolarPlot[ r_, {t_, tmin_, tmax_}, opts___] :=
    PolarPlot[ {r}, {t, tmin, tmax}, opts]

PolarPlot[r_List, {t_, tmin_, tmax_}, opts___] :=
    Block[{dfun, funs, plot, rng, ticks, style},
        funs = Transpose[ { r Cos[t], r Sin[t]}] ;
    	plot = ParametricPlot[Evaluate[ funs], 
    			{t, tmin, tmax}, 
    			DisplayFunction -> Identity,
			Axes -> False,
    			opts, Evaluate[Options[ PolarPlot]]] ;
	dfun = DisplayFunction /. {opts} /. Options[ PolarPlot] ;
	axes = Axes /. {opts} /. Options[ PolarPlot] ;
	If[ axes === Polar,
	    	axes = False;
		style = AxesStyle /. {opts} /. Options[ PolarPlot] ;
		rng = Transpose[ FullOptions[ plot, PlotRange]] ;
		ticks = CircularAxes[ rng, style] ;
		plot = Insert[ plot, ticks, {1,-1}]] ;
    	Show[ plot,
		Axes -> axes,
    		DisplayFunction -> dfun]
       ]


CircularAxes[ pts_, style_] :=
    Block[{rmax, rticks, labels, tticks},
	rmax = Map[ (First[#]^2 + Last[#]^2)&, pts] ;  
	rmax = Sqrt[ Max[ rmax]] ;
	rticks = Rest[ TickPosition[ 0.0, rmax, 8]] ;
	rmax = Last[ rticks] ;
	labels = 
		Map[ Text[ #, {0,#}, {1.2, -1.2}, Background -> Automatic]&, rticks] ;
	rticks = Map[ Circle[ {0,0}, #]&, rticks] ;
	tticks = Table[ i 2Pi/8, {i,8}] ;
	tticks = Map[ 
		      Line[ {{0,0}, {rmax Sin[#], rmax Cos[#]}}]&,
		      tticks] ;
	Join[ 
	      style,
	      rticks,
	      tticks,
	      Drop[ labels, -1]]
	]


(*

<</twj/og/part2/chap7/PolarPlot.m

<</twj/og/part2/chap7/Axes.m

TickList[ 2.44, 10.5, 40]

PolarPlot[ 2, {t,0,2Pi}]

PolarPlot[Cos[t]^2, {t,0,2Pi}, Axes -> Polar]

PolarPlot[ Cos[2 t] , {t,0,2Pi}, Axes -> Automatic]

PolarPlot[ LegendreP[ 3, Cos[t]] , {t,0,2Pi}]



*)

