(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4595,        169]*)
(*NotebookOutlinePosition[      5506,        200]*)
(*  CellTagsIndexPosition[      5462,        196]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Delaunay Triangulation"], "Title",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
This notebook demonstrates how to generate and display Delaunay \
triangulations. 
The topic is described in more detail in the book:

\tMathematica Graphics: Techniques and Applications.
\tTom Wickham-Jones, TELOS/Springer-Verlag 1994.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "This package is now updated to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version 3.0."
}], "Text"],

Cell[CellGroupData[{

Cell["Installation and Initialization", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The ",
  StyleBox["ExtendGraphics", "Input"],
  " directory should be put in one of the canonical places for AddOns.   Two \
recommended places are first inside the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distribution in:"
}], "Text"],

Cell[BoxData[
    \(ToFileName[\ {$TopDirectory, \ "\<AddOns\>", \ "\<Applications\>"}]\)], 
  "Input"],

Cell["a second in the preferences directory:", "Text"],

Cell[BoxData[
    \(ToFileName[
      \ {$PreferencesDirectory, \ "\<AddOns\>", \ "\<Applications\>"}]\)], 
  "Input"],

Cell[TextData[{
  "When one of these locations is used there is no need to set $Path and the \
loading instructions are identical for all versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " binary delaunay.exe is provided for the Windows95 and Macintosh versions. \
 For other versions it should be built with the mcc tools that are provided."
}], "Text"],

Cell[TextData[{
  "The  ",
  StyleBox["ExtendGraphics`Delaunay` ", "Input"],
  "package can  be loaded"
}], "Text"],

Cell["Needs[ \"ExtendGraphics`Delaunay`\"]", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Turn off spelling checker"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Off[ General::spell];
Off[ General::spell1];
\
\>", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Delaunay Triangulation"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["These are some two-dimensional points to triangulate."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["pts = Table[ {Random[], Random[]}, {100}];", "Input",
  AspectRatioFixed->True],

Cell[TextData["This plots the triangulation."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["TrianglePlot[ pts];", "Input",
  AspectRatioFixed->True],

Cell[TextData["This plots the convex hull."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["ConvexHullPlot[ pts];", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{464, 404},
WindowMargins->{{66, Automatic}, {Automatic, 21}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 97, 2, 105, "Title"],
Cell[1831, 55, 308, 9, 109, "Text"],
Cell[2142, 66, 134, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[2301, 75, 98, 2, 53, "Section"],
Cell[2402, 79, 272, 8, 53, "Text"],
Cell[2677, 89, 103, 2, 30, "Input"],
Cell[2783, 93, 54, 0, 33, "Text"],
Cell[2840, 95, 118, 3, 50, "Input"],
Cell[2961, 100, 222, 6, 52, "Text"],
Cell[3186, 108, 244, 6, 52, "Text"],
Cell[3433, 116, 115, 4, 34, "Text"],
Cell[3551, 122, 79, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[3655, 127, 105, 2, 47, "Subsection"],
Cell[3763, 131, 96, 5, 66, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3908, 142, 99, 2, 33, "Section"],
Cell[4010, 146, 127, 2, 33, "Text"],
Cell[4140, 150, 85, 1, 30, "Input"],
Cell[4228, 153, 103, 2, 33, "Text"],
Cell[4334, 157, 62, 1, 30, "Input"],
Cell[4399, 160, 101, 2, 33, "Text"],
Cell[4503, 164, 64, 1, 30, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

