from __future__ import absolute_import, division, print_function
import iotbx.pdb
import mmtbx.model.statistics
from six.moves import cStringIO as StringIO
from libtbx.utils import null_out
import mmtbx.model

pdb_str = """\
CRYST1   75.460  158.580   93.580  90.00  90.00  90.00 C 2 2 21
SCALE1      0.013252  0.000000  0.000000        0.00000
SCALE2      0.000000  0.006306  0.000000        0.00000
SCALE3      0.000000  0.000000  0.010686        0.00000
ATOM      1  N   THR A   7     -22.717 -50.890   5.476  1.00141.14           N
ATOM      2  CA  THR A   7     -23.899 -50.050   5.310  1.00136.21           C
ATOM      3  C   THR A   7     -23.861 -48.839   6.242  1.00132.81           C
ATOM      4  O   THR A   7     -24.260 -48.928   7.404  1.00131.01           O
ATOM      5  CB  THR A   7     -25.193 -50.847   5.568  1.00134.75           C
ATOM      6  OG1 THR A   7     -25.230 -51.272   6.936  1.00136.94           O
ATOM      7  CG2 THR A   7     -25.257 -52.066   4.659  1.00137.71           C
ATOM      8  N   ILE A   8     -23.387 -47.709   5.725  1.00131.81           N
ATOM      9  CA  ILE A   8     -23.246 -46.495   6.526  1.00131.70           C
ATOM     10  C   ILE A   8     -24.367 -45.494   6.208  1.00126.04           C
ATOM     11  O   ILE A   8     -24.786 -45.359   5.057  1.00127.64           O
ATOM     12  CB  ILE A   8     -21.849 -45.850   6.305  1.00122.41           C
ATOM     13  CG1 ILE A   8     -21.569 -44.758   7.340  1.00110.30           C
ATOM     14  CG2 ILE A   8     -21.697 -45.333   4.877  1.00128.50           C
ATOM     15  CD1 ILE A   8     -20.114 -44.324   7.369  1.00107.55           C
ATOM     16  N   SER A   9     -24.860 -44.808   7.238  1.00118.07           N
ATOM     17  CA  SER A   9     -26.035 -43.945   7.109  1.00115.52           C
ATOM     18  C   SER A   9     -25.681 -42.514   6.708  1.00109.50           C
ATOM     19  O   SER A   9     -24.673 -41.971   7.156  1.00109.49           O
ATOM     20  CB  SER A   9     -26.821 -43.925   8.421  1.00113.58           C
ATOM     21  OG  SER A   9     -26.071 -43.309   9.452  1.00110.08           O
ATOM     22  N   GLY A  10     -26.523 -41.900   5.881  1.00103.14           N
ATOM     23  CA  GLY A  10     -26.266 -40.558   5.384  1.00 92.45           C
ATOM     24  C   GLY A  10     -26.310 -39.481   6.451  1.00 84.77           C
ATOM     25  O   GLY A  10     -26.826 -39.700   7.547  1.00 77.99           O
ATOM     26  N   VAL A  11     -25.753 -38.316   6.134  1.00 71.51           N
ATOM     27  CA  VAL A  11     -25.857 -37.162   7.016  1.00 69.96           C
ATOM     28  C   VAL A  11     -27.212 -36.488   6.816  1.00 72.87           C
ATOM     29  O   VAL A  11     -27.539 -36.029   5.721  1.00 72.60           O
ATOM     30  CB  VAL A  11     -24.713 -36.145   6.780  1.00 74.36           C
ATOM     31  CG1 VAL A  11     -24.429 -35.982   5.291  1.00 93.11           C
ATOM     32  CG2 VAL A  11     -25.045 -34.808   7.429  1.00 70.19           C
ATOM     33  N   THR A  12     -28.006 -36.453   7.880  1.00 67.58           N
ATOM     34  CA  THR A  12     -29.359 -35.919   7.810  1.00 56.36           C
ATOM     35  C   THR A  12     -29.386 -34.419   8.081  1.00 56.13           C
ATOM     36  O   THR A  12     -28.861 -33.957   9.093  1.00 52.01           O
ATOM     37  CB  THR A  12     -30.285 -36.629   8.808  1.00 66.11           C
ATOM     38  OG1 THR A  12     -30.238 -38.043   8.581  1.00 70.25           O
ATOM     39  CG2 THR A  12     -31.709 -36.143   8.649  1.00 65.09           C
ATOM     40  N   PRO A  13     -29.997 -33.651   7.168  1.00 56.19           N
ATOM     41  CA  PRO A  13     -30.121 -32.203   7.348  1.00 51.55           C
ATOM     42  C   PRO A  13     -31.151 -31.828   8.412  1.00 49.07           C
ATOM     43  O   PRO A  13     -32.260 -32.367   8.429  1.00 51.23           O
ATOM     44  CB  PRO A  13     -30.561 -31.715   5.963  1.00 52.91           C
ATOM     45  CG  PRO A  13     -31.258 -32.884   5.363  1.00 59.36           C
ATOM     46  CD  PRO A  13     -30.530 -34.096   5.867  1.00 62.94           C
ATOM     47  N   VAL A  14     -30.769 -30.919   9.301  1.00 48.63           N
ATOM     48  CA  VAL A  14     -31.683 -30.370  10.289  1.00 46.07           C
ATOM     49  C   VAL A  14     -31.733 -28.864  10.081  1.00 41.16           C
ATOM     50  O   VAL A  14     -30.914 -28.114  10.615  1.00 47.97           O
ATOM     51  CB  VAL A  14     -31.254 -30.717  11.728  1.00 54.55           C
ATOM     52  CG1 VAL A  14     -32.167 -30.041  12.741  1.00 49.75           C
ATOM     53  CG2 VAL A  14     -31.267 -32.221  11.925  1.00 53.30           C
ATOM     54  N   ALA A  15     -32.688 -28.433   9.265  1.00 48.44           N
ATOM     55  CA  ALA A  15     -32.791 -27.035   8.878  1.00 48.71           C
ATOM     56  C   ALA A  15     -33.746 -26.288   9.793  1.00 44.49           C
ATOM     57  O   ALA A  15     -34.893 -26.698   9.981  1.00 56.01           O
ATOM     58  CB  ALA A  15     -33.241 -26.919   7.424  1.00 47.71           C
ATOM     59  N   VAL A  16     -33.258 -25.196  10.371  1.00 47.55           N
ATOM     60  CA  VAL A  16     -34.070 -24.359  11.244  1.00 51.32           C
ATOM     61  C   VAL A  16     -33.896 -22.898  10.849  1.00 51.13           C
ATOM     62  O   VAL A  16     -32.884 -22.527  10.255  1.00 53.69           O
ATOM     63  CB  VAL A  16     -33.694 -24.547  12.729  1.00 48.59           C
ATOM     64  CG1 VAL A  16     -33.883 -26.001  13.147  1.00 49.08           C
ATOM     65  CG2 VAL A  16     -32.261 -24.105  12.976  1.00 44.32           C
HETATM   66  N   MSE A  17     -34.886 -22.071  11.165  1.00 46.28           N
HETATM   67  CA  MSE A  17     -34.799 -20.648  10.861  1.00 51.69           C
HETATM   68  C   MSE A  17     -34.630 -19.811  12.117  1.00 49.49           C
HETATM   69  O   MSE A  17     -35.085 -20.191  13.196  1.00 58.95           O
HETATM   70  CB  MSE A  17     -36.041 -20.170  10.113  1.00 50.07           C
HETATM   71  CG  MSE A  17     -36.182 -20.707   8.709  1.00 76.34           C
HETATM   72 SE   MSE A  17     -37.379 -19.594   7.653  1.00 73.34          Se
HETATM   73  CE  MSE A  17     -36.261 -18.004   7.506  1.00 73.69           C
ATOM     74  N   THR A  18     -33.982 -18.662  11.967  1.00 53.24           N
ATOM     75  CA  THR A  18     -33.883 -17.707  13.060  1.00 61.39           C
ATOM     76  C   THR A  18     -35.062 -16.746  13.006  1.00 58.85           C
ATOM     77  O   THR A  18     -35.795 -16.708  12.018  1.00 53.50           O
ATOM     78  CB  THR A  18     -32.565 -16.925  13.011  1.00 71.15           C
ATOM     79  OG1 THR A  18     -32.433 -16.286  11.735  1.00 64.88           O
ATOM     80  CG2 THR A  18     -31.405 -17.873  13.214  1.00 70.61           C
ATOM     81  N   LYS A  19     -35.242 -15.977  14.074  1.00 54.96           N
ATOM     82  CA  LYS A  19     -36.374 -15.066  14.179  1.00 60.47           C
ATOM     83  C   LYS A  19     -36.300 -13.969  13.122  1.00 58.72           C
ATOM     84  O   LYS A  19     -35.214 -13.636  12.642  1.00 50.86           O
ATOM     85  CB  LYS A  19     -36.436 -14.448  15.581  1.00 58.87           C
ATOM     86  CG  LYS A  19     -35.279 -13.521  15.917  1.00 54.97           C
ATOM     87  CD  LYS A  19     -35.405 -12.998  17.344  1.00 59.63           C
ATOM     88  CE  LYS A  19     -34.270 -12.050  17.696  1.00 57.53           C
ATOM     89  NZ  LYS A  19     -34.391 -11.532  19.091  1.00 67.01           N
ATOM     90  N   PRO A  20     -37.461 -13.420  12.736  1.00 62.97           N
ATOM     91  CA  PRO A  20     -37.478 -12.268  11.832  1.00 64.92           C
ATOM     92  C   PRO A  20     -36.710 -11.091  12.424  1.00 62.14           C
ATOM     93  O   PRO A  20     -37.006 -10.652  13.535  1.00 62.63           O
ATOM     94  CB  PRO A  20     -38.970 -11.948  11.697  1.00 60.68           C
ATOM     95  CG  PRO A  20     -39.650 -13.246  11.965  1.00 61.23           C
ATOM     96  CD  PRO A  20     -38.819 -13.915  13.019  1.00 56.73           C
ATOM     97  N   LEU A  21     -35.724 -10.601  11.682  1.00 61.25           N
ATOM     98  CA  LEU A  21     -34.863  -9.520  12.147  1.00 65.78           C
ATOM     99  C   LEU A  21     -35.074  -8.255  11.324  1.00 73.45           C
ATOM    100  O   LEU A  21     -35.473  -8.328  10.162  1.00 78.02           O
ATOM    101  CB  LEU A  21     -33.396  -9.952  12.081  1.00 61.86           C
ATOM    102  CG  LEU A  21     -33.000 -11.138  12.959  1.00 69.12           C
ATOM    103  CD1 LEU A  21     -31.669 -11.712  12.507  1.00 75.44           C
ATOM    104  CD2 LEU A  21     -32.938 -10.720  14.421  1.00 61.28           C
ATOM    105  N   PRO A  22     -34.812  -7.085  11.927  1.00 80.07           N
ATOM    106  CA  PRO A  22     -34.861  -5.835  11.163  1.00 80.43           C
ATOM    107  C   PRO A  22     -33.764  -5.794  10.103  1.00 77.69           C
ATOM    108  O   PRO A  22     -32.770  -6.511  10.233  1.00 65.58           O
ATOM    109  CB  PRO A  22     -34.641  -4.758  12.231  1.00 82.27           C
ATOM    110  CG  PRO A  22     -33.926  -5.462  13.336  1.00 85.55           C
ATOM    111  CD  PRO A  22     -34.481  -6.855  13.344  1.00 84.87           C
ATOM    112  N   CYS A  23     -33.948  -4.978   9.070  1.00 71.30           N
ATOM    113  CA  CYS A  23     -32.962  -4.870   8.001  1.00 73.58           C
ATOM    114  C   CYS A  23     -31.622  -4.379   8.541  1.00 76.74           C
ATOM    115  O   CYS A  23     -31.571  -3.402   9.287  1.00 82.00           O
ATOM    116  CB  CYS A  23     -33.466  -3.936   6.899  1.00 66.71           C
ATOM    117  SG  CYS A  23     -34.965  -4.514   6.065  1.00 66.86           S
ATOM    118  N   PRO A  24     -30.532  -5.071   8.170  1.00 72.17           N
ATOM    119  CA  PRO A  24     -29.168  -4.750   8.609  1.00 81.68           C
ATOM    120  C   PRO A  24     -28.769  -3.307   8.306  1.00 89.16           C
ATOM    121  O   PRO A  24     -28.013  -2.706   9.069  1.00 98.94           O
ATOM    122  CB  PRO A  24     -28.306  -5.731   7.808  1.00 80.64           C
ATOM    123  CG  PRO A  24     -29.211  -6.877   7.527  1.00 74.52           C
ATOM    124  CD  PRO A  24     -30.564  -6.268   7.311  1.00 66.69           C
ATOM    125  N   GLY A  25     -29.277  -2.762   7.206  1.00 85.32           N
ATOM    126  CA  GLY A  25     -28.992  -1.387   6.839  1.00 87.53           C
ATOM    127  C   GLY A  25     -30.041  -0.424   7.358  1.00 90.38           C
ATOM    128  O   GLY A  25     -31.112  -0.837   7.804  1.00 94.35           O
ATOM    129  N   LYS A  26     -29.730   0.868   7.305  1.00 89.41           N
ATOM    130  CA  LYS A  26     -30.661   1.897   7.755  1.00 86.86           C
ATOM    131  C   LYS A  26     -31.308   2.599   6.563  1.00 90.33           C
ATOM    132  O   LYS A  26     -30.694   3.441   5.912  1.00101.18           O
ATOM    133  CB  LYS A  26     -29.952   2.913   8.648  1.00 84.96           C
ATOM    134  CG  LYS A  26     -29.486   2.344   9.977  0.00 80.43           C
ATOM    135  CD  LYS A  26     -30.657   1.836  10.800  0.00 76.05           C
ATOM    136  CE  LYS A  26     -30.193   1.281  12.135  0.00 75.33           C
ATOM    137  NZ  LYS A  26     -31.332   0.774  12.952  0.00 74.04           N
ATOM    138  N   CYS A  27     -32.556   2.237   6.285  1.00 85.64           N
ATOM    139  CA  CYS A  27     -33.291   2.780   5.150  1.00 77.39           C
ATOM    140  C   CYS A  27     -34.772   2.896   5.487  1.00 72.58           C
ATOM    141  O   CYS A  27     -35.398   1.920   5.897  1.00 74.86           O
ATOM    142  CB  CYS A  27     -33.090   1.900   3.913  1.00 79.70           C
ATOM    143  SG  CYS A  27     -34.077   2.365   2.467  1.00 80.11           S
ATOM    144  N   ILE A  28     -35.325   4.092   5.314  1.00 69.97           N
ATOM    145  CA  ILE A  28     -36.721   4.349   5.649  1.00 76.39           C
ATOM    146  C   ILE A  28     -37.694   3.646   4.715  1.00 80.84           C
ATOM    147  O   ILE A  28     -38.854   3.441   5.064  1.00 82.69           O
ATOM    148  CB  ILE A  28     -37.030   5.855   5.634  1.00 80.11           C
ATOM    149  CG1 ILE A  28     -36.697   6.453   4.266  1.00 80.69           C
ATOM    150  CG2 ILE A  28     -36.259   6.553   6.734  1.00 90.32           C
ATOM    151  CD1 ILE A  28     -37.070   7.912   4.128  1.00 91.41           C
ATOM    152  N   TYR A  29     -37.220   3.274   3.531  1.00 81.51           N
ATOM    153  CA  TYR A  29     -38.069   2.610   2.549  1.00 77.44           C
ATOM    154  C   TYR A  29     -38.055   1.092   2.727  1.00 73.25           C
ATOM    155  O   TYR A  29     -38.963   0.401   2.274  1.00 73.34           O
ATOM    156  CB  TYR A  29     -37.633   2.980   1.126  1.00 76.25           C
ATOM    157  CG  TYR A  29     -37.935   4.409   0.725  1.00 74.08           C
ATOM    158  CD1 TYR A  29     -39.157   4.750   0.163  1.00 75.09           C
ATOM    159  CD2 TYR A  29     -36.993   5.411   0.894  1.00 74.97           C
ATOM    160  CE1 TYR A  29     -39.436   6.053  -0.212  1.00 78.36           C
ATOM    161  CE2 TYR A  29     -37.260   6.717   0.524  1.00 79.94           C
ATOM    162  CZ  TYR A  29     -38.483   7.032  -0.029  1.00 82.42           C
ATOM    163  OH  TYR A  29     -38.746   8.331  -0.396  1.00 86.23           O
ATOM    164  N   CYS A  30     -37.021   0.584   3.389  1.00 70.96           N
ATOM    165  CA  CYS A  30     -36.869  -0.853   3.598  1.00 67.97           C
ATOM    166  C   CYS A  30     -38.021  -1.434   4.421  1.00 70.27           C
ATOM    167  O   CYS A  30     -38.601  -0.743   5.263  1.00 72.56           O
ATOM    168  CB  CYS A  30     -35.533  -1.153   4.279  1.00 69.53           C
ATOM    169  SG  CYS A  30     -34.146  -1.304   3.123  1.00 69.36           S
ATOM    170  N   PRO A  31     -38.368  -2.708   4.164  1.00 67.43           N
ATOM    171  CA  PRO A  31     -39.465  -3.384   4.868  1.00 69.29           C
ATOM    172  C   PRO A  31     -39.198  -3.540   6.359  1.00 69.55           C
ATOM    173  O   PRO A  31     -38.062  -3.369   6.802  1.00 70.38           O
ATOM    174  CB  PRO A  31     -39.533  -4.755   4.181  1.00 72.69           C
ATOM    175  CG  PRO A  31     -38.180  -4.952   3.597  1.00 73.92           C
ATOM    176  CD  PRO A  31     -37.744  -3.590   3.163  1.00 73.00           C
ATOM    177  N   THR A  32     -40.245  -3.861   7.113  1.00 70.59           N
ATOM    178  CA  THR A  32     -40.155  -4.005   8.562  1.00 69.97           C
ATOM    179  C   THR A  32     -39.098  -5.029   8.966  1.00 73.22           C
ATOM    180  O   THR A  32     -38.285  -4.780   9.857  1.00 74.53           O
ATOM    181  CB  THR A  32     -41.514  -4.416   9.160  1.00 76.52           C
ATOM    182  OG1 THR A  32     -42.505  -3.440   8.813  1.00 89.31           O
ATOM    183  CG2 THR A  32     -41.426  -4.529  10.673  1.00 71.42           C
ATOM    184  N   PHE A  33     -39.112  -6.178   8.298  1.00 70.62           N
ATOM    185  CA  PHE A  33     -38.148  -7.235   8.576  1.00 66.95           C
ATOM    186  C   PHE A  33     -37.263  -7.505   7.364  1.00 65.06           C
ATOM    187  O   PHE A  33     -37.677  -7.299   6.221  1.00 67.72           O
ATOM    188  CB  PHE A  33     -38.865  -8.516   9.004  1.00 64.24           C
ATOM    189  CG  PHE A  33     -39.684  -8.361  10.254  1.00 68.23           C
ATOM    190  CD1 PHE A  33     -39.077  -8.357  11.499  1.00 67.67           C
ATOM    191  CD2 PHE A  33     -41.061  -8.219  10.185  1.00 77.30           C
ATOM    192  CE1 PHE A  33     -39.826  -8.213  12.653  1.00 68.67           C
ATOM    193  CE2 PHE A  33     -41.817  -8.076  11.336  1.00 76.73           C
ATOM    194  CZ  PHE A  33     -41.197  -8.072  12.571  1.00 72.63           C
ATOM    195  N   ALA A  34     -36.040  -7.957   7.624  1.00 58.71           N
ATOM    196  CA  ALA A  34     -35.093  -8.263   6.560  1.00 64.71           C
ATOM    197  C   ALA A  34     -35.614  -9.397   5.687  1.00 67.53           C
ATOM    198  O   ALA A  34     -36.133 -10.392   6.191  1.00 68.38           O
ATOM    199  CB  ALA A  34     -33.737  -8.619   7.145  1.00 60.73           C
ATOM    200  N   ALA A  35     -35.480  -9.240   4.375  1.00 61.56           N
ATOM    201  CA  ALA A  35     -35.961 -10.245   3.436  1.00 64.90           C
ATOM    202  C   ALA A  35     -35.106 -11.507   3.487  1.00 69.74           C
ATOM    203  O   ALA A  35     -33.877 -11.440   3.513  1.00 80.68           O
ATOM    204  CB  ALA A  35     -35.989  -9.682   2.023  1.00 63.48           C
ATOM    205  N   THR A  36     -35.770 -12.657   3.506  1.00 64.39           N
ATOM    206  CA  THR A  36     -35.087 -13.943   3.474  1.00 70.17           C
ATOM    207  C   THR A  36     -35.335 -14.618   2.128  1.00 67.50           C
ATOM    208  O   THR A  36     -36.337 -14.339   1.472  1.00 66.50           O
ATOM    209  CB  THR A  36     -35.564 -14.864   4.616  1.00 69.84           C
ATOM    210  OG1 THR A  36     -36.957 -15.153   4.449  1.00 75.81           O
ATOM    211  CG2 THR A  36     -35.348 -14.196   5.966  1.00 73.14           C
ATOM    212  N   PRO A  37     -34.413 -15.494   1.698  1.00 79.75           N
ATOM    213  CA  PRO A  37     -34.642 -16.266   0.471  1.00 80.19           C
ATOM    214  C   PRO A  37     -35.881 -17.149   0.591  1.00 81.47           C
ATOM    215  O   PRO A  37     -36.626 -17.327  -0.379  1.00 82.30           O
ATOM    216  CB  PRO A  37     -33.374 -17.116   0.347  1.00 85.42           C
ATOM    217  CG  PRO A  37     -32.338 -16.364   1.109  1.00 89.77           C
ATOM    218  CD  PRO A  37     -33.066 -15.721   2.250  1.00 84.17           C
ATOM    219  N   GLN A  38     -36.104 -17.669   1.796  1.00 79.08           N
ATOM    220  CA  GLN A  38     -37.227 -18.556   2.079  1.00 81.89           C
ATOM    221  C   GLN A  38     -38.579 -17.874   1.872  1.00 84.39           C
ATOM    222  O   GLN A  38     -39.617 -18.534   1.865  1.00 85.71           O
ATOM    223  CB  GLN A  38     -37.132 -19.091   3.512  1.00 80.42           C
ATOM    224  CG  GLN A  38     -35.969 -20.049   3.753  1.00 75.46           C
ATOM    225  CD  GLN A  38     -34.627 -19.346   3.845  1.00 74.85           C
ATOM    226  OE1 GLN A  38     -34.552 -18.168   4.196  1.00 75.42           O
ATOM    227  NE2 GLN A  38     -33.559 -20.067   3.523  1.00 76.93           N
ATOM    228  N   SER A  39     -38.562 -16.555   1.704  1.00 85.62           N
ATOM    229  CA  SER A  39     -39.777 -15.808   1.399  1.00 97.26           C
ATOM    230  C   SER A  39     -40.317 -16.194   0.025  1.00 96.14           C
ATOM    231  O   SER A  39     -41.488 -15.960  -0.280  1.00 96.58           O
ATOM    232  CB  SER A  39     -39.516 -14.302   1.458  1.00105.82           C
ATOM    233  OG  SER A  39     -39.031 -13.917   2.732  1.00111.61           O
ATOM    234  N   TYR A  40     -39.460 -16.784  -0.804  1.00 87.68           N
ATOM    235  CA  TYR A  40     -39.884 -17.239  -2.122  1.00 97.23           C
ATOM    236  C   TYR A  40     -39.979 -18.760  -2.168  1.00104.83           C
ATOM    237  O   TYR A  40     -40.199 -19.351  -3.225  1.00108.84           O
ATOM    238  CB  TYR A  40     -38.936 -16.709  -3.196  1.00 92.47           C
ATOM    239  CG  TYR A  40     -39.035 -15.209  -3.354  1.00 88.83           C
ATOM    240  CD1 TYR A  40     -38.300 -14.355  -2.539  1.00 76.94           C
ATOM    241  CD2 TYR A  40     -39.882 -14.646  -4.299  1.00 93.08           C
ATOM    242  CE1 TYR A  40     -38.397 -12.984  -2.672  1.00 87.23           C
ATOM    243  CE2 TYR A  40     -39.986 -13.275  -4.439  1.00 98.40           C
ATOM    244  CZ  TYR A  40     -39.241 -12.449  -3.623  1.00101.64           C
ATOM    245  OH  TYR A  40     -39.341 -11.084  -3.760  1.00112.79           O
ATOM    246  N   THR A  41     -39.805 -19.383  -1.006  1.00102.33           N
ATOM    247  CA  THR A  41     -40.142 -20.790  -0.811  1.00106.31           C
ATOM    248  C   THR A  41     -40.993 -20.921   0.451  1.00110.25           C
ATOM    249  O   THR A  41     -40.578 -21.560   1.420  1.00103.13           O
ATOM    250  CB  THR A  41     -38.888 -21.683  -0.682  1.00106.79           C
ATOM    251  OG1 THR A  41     -38.212 -21.391   0.548  1.00111.21           O
ATOM    252  CG2 THR A  41     -37.937 -21.458  -1.850  1.00101.78           C
ATOM    253  N   PRO A  42     -42.194 -20.316   0.441  1.00113.80           N
ATOM    254  CA  PRO A  42     -42.986 -20.165   1.667  1.00110.97           C
ATOM    255  C   PRO A  42     -43.636 -21.460   2.145  1.00110.08           C
ATOM    256  O   PRO A  42     -43.832 -21.633   3.348  1.00110.41           O
ATOM    257  CB  PRO A  42     -44.053 -19.147   1.260  1.00110.12           C
ATOM    258  CG  PRO A  42     -44.260 -19.404  -0.192  1.00107.22           C
ATOM    259  CD  PRO A  42     -42.916 -19.813  -0.743  1.00110.47           C
ATOM    260  N   GLU A  43     -43.962 -22.354   1.218  1.00105.22           N
ATOM    261  CA  GLU A  43     -44.668 -23.580   1.568  1.00108.25           C
ATOM    262  C   GLU A  43     -43.708 -24.711   1.919  1.00105.34           C
ATOM    263  O   GLU A  43     -44.118 -25.864   2.056  1.00108.85           O
ATOM    264  CB  GLU A  43     -45.594 -24.005   0.426  1.00121.70           C
ATOM    265  CG  GLU A  43     -46.605 -22.940   0.024  1.00131.01           C
ATOM    266  CD  GLU A  43     -47.459 -22.468   1.189  1.00133.22           C
ATOM    267  OE1 GLU A  43     -47.850 -23.309   2.026  1.00136.07           O
ATOM    268  OE2 GLU A  43     -47.736 -21.252   1.268  1.00129.74           O
ATOM    269  N   SER A  44     -42.429 -24.378   2.063  1.00 99.09           N
ATOM    270  CA  SER A  44     -41.439 -25.350   2.506  1.00106.19           C
ATOM    271  C   SER A  44     -41.767 -25.803   3.925  1.00107.23           C
ATOM    272  O   SER A  44     -42.185 -24.994   4.753  1.00104.68           O
ATOM    273  CB  SER A  44     -40.029 -24.758   2.441  1.00104.26           C
ATOM    274  OG  SER A  44     -39.057 -25.696   2.869  1.00104.42           O
ATOM    275  N   PRO A  45     -41.597 -27.105   4.205  1.00108.14           N
ATOM    276  CA  PRO A  45     -41.902 -27.647   5.534  1.00113.32           C
ATOM    277  C   PRO A  45     -41.140 -26.939   6.652  1.00111.79           C
ATOM    278  O   PRO A  45     -41.704 -26.702   7.719  1.00113.39           O
ATOM    279  CB  PRO A  45     -41.465 -29.111   5.423  1.00111.53           C
ATOM    280  CG  PRO A  45     -41.573 -29.424   3.969  1.00111.83           C
ATOM    281  CD  PRO A  45     -41.183 -28.158   3.260  1.00110.97           C
ATOM    282  N   ALA A  46     -39.884 -26.588   6.392  1.00109.98           N
ATOM    283  CA  ALA A  46     -39.005 -26.043   7.421  1.00107.66           C
ATOM    284  C   ALA A  46     -39.359 -24.614   7.842  1.00102.03           C
ATOM    285  O   ALA A  46     -39.212 -24.265   9.012  1.00101.29           O
ATOM    286  CB  ALA A  46     -37.562 -26.102   6.950  1.00103.69           C
ATOM    287  N   VAL A  47     -39.811 -23.786   6.903  1.00 84.97           N
ATOM    288  CA  VAL A  47     -40.151 -22.400   7.228  1.00 77.98           C
ATOM    289  C   VAL A  47     -41.511 -22.323   7.927  1.00 83.12           C
ATOM    290  O   VAL A  47     -41.685 -21.579   8.902  1.00 92.24           O
ATOM    291  CB  VAL A  47     -40.143 -21.494   5.964  1.00 84.67           C
ATOM    292  CG1 VAL A  47     -40.873 -22.153   4.810  1.00 94.15           C
ATOM    293  CG2 VAL A  47     -40.737 -20.122   6.271  1.00 71.35           C
ATOM    294  N   LEU A  48     -42.466 -23.106   7.436  1.00 79.25           N
ATOM    295  CA  LEU A  48     -43.767 -23.212   8.080  1.00 77.68           C
ATOM    296  C   LEU A  48     -43.597 -23.763   9.494  1.00 70.05           C
ATOM    297  O   LEU A  48     -44.224 -23.280  10.443  1.00 79.39           O
ATOM    298  CB  LEU A  48     -44.702 -24.096   7.254  1.00 83.99           C
ATOM    299  CG  LEU A  48     -45.066 -23.518   5.883  1.00 86.06           C
ATOM    300  CD1 LEU A  48     -45.712 -24.572   5.003  1.00 86.62           C
ATOM    301  CD2 LEU A  48     -45.981 -22.308   6.027  1.00 80.17           C
ATOM    302  N   ARG A  49     -42.728 -24.762   9.627  1.00 58.53           N
ATOM    303  CA  ARG A  49     -42.389 -25.322  10.930  1.00 67.68           C
ATOM    304  C   ARG A  49     -41.741 -24.267  11.821  1.00 68.91           C
ATOM    305  O   ARG A  49     -42.007 -24.206  13.020  1.00 74.99           O
ATOM    306  CB  ARG A  49     -41.456 -26.521  10.769  1.00 72.61           C
ATOM    307  CG  ARG A  49     -41.916 -27.777  11.482  1.00 93.81           C
ATOM    308  CD  ARG A  49     -41.520 -29.016  10.699  1.00107.33           C
ATOM    309  NE  ARG A  49     -40.120 -28.986  10.287  1.00115.11           N
ATOM    310  CZ  ARG A  49     -39.649 -29.604   9.208  1.00120.81           C
ATOM    311  NH1 ARG A  49     -40.470 -30.297   8.428  1.00124.29           N
ATOM    312  NH2 ARG A  49     -38.361 -29.525   8.903  1.00121.03           N
ATOM    313  N   ALA A  50     -40.890 -23.438  11.222  1.00 68.23           N
ATOM    314  CA  ALA A  50     -40.203 -22.377  11.950  1.00 64.85           C
ATOM    315  C   ALA A  50     -41.198 -21.381  12.530  1.00 68.18           C
ATOM    316  O   ALA A  50     -41.090 -20.993  13.693  1.00 59.54           O
ATOM    317  CB  ALA A  50     -39.208 -21.667  11.044  1.00 56.30           C
ATOM    318  N   LYS A  51     -42.169 -20.971  11.719  1.00 64.44           N
ATOM    319  CA  LYS A  51     -43.185 -20.039  12.193  1.00 63.16           C
ATOM    320  C   LYS A  51     -44.092 -20.702  13.227  1.00 64.81           C
ATOM    321  O   LYS A  51     -44.565 -20.047  14.158  1.00 71.24           O
ATOM    322  CB  LYS A  51     -44.018 -19.499  11.029  1.00 71.36           C
ATOM    323  CG  LYS A  51     -44.984 -18.394  11.436  1.00 75.25           C
ATOM    324  CD  LYS A  51     -45.763 -17.857  10.249  1.00 87.11           C
ATOM    325  CE  LYS A  51     -46.734 -16.768  10.681  1.00 91.29           C
ATOM    326  NZ  LYS A  51     -47.512 -16.224   9.535  1.00 91.07           N
ATOM    327  N   SER A  52     -44.327 -22.002  13.068  1.00 52.43           N
ATOM    328  CA  SER A  52     -45.190 -22.729  13.995  1.00 58.53           C
ATOM    329  C   SER A  52     -44.539 -22.901  15.370  1.00 58.67           C
ATOM    330  O   SER A  52     -45.217 -23.198  16.354  1.00 64.23           O
ATOM    331  CB  SER A  52     -45.564 -24.097  13.420  1.00 63.78           C
ATOM    332  OG  SER A  52     -44.461 -24.984  13.448  1.00 71.72           O
ATOM    333  N   CYS A  53     -43.223 -22.714  15.431  1.00 60.26           N
ATOM    334  CA  CYS A  53     -42.477 -22.848  16.680  1.00 60.47           C
ATOM    335  C   CYS A  53     -42.082 -21.489  17.252  1.00 56.22           C
ATOM    336  O   CYS A  53     -41.304 -21.417  18.204  1.00 61.75           O
ATOM    337  CB  CYS A  53     -41.218 -23.698  16.467  1.00 50.21           C
ATOM    338  SG  CYS A  53     -41.510 -25.449  16.115  1.00 57.59           S
ATOM    339  N   GLU A  54     -42.622 -20.422  16.666  1.00 52.53           N
ATOM    340  CA  GLU A  54     -42.229 -19.048  16.987  1.00 54.54           C
ATOM    341  C   GLU A  54     -40.720 -18.850  16.867  1.00 54.57           C
ATOM    342  O   GLU A  54     -40.130 -18.060  17.604  1.00 52.02           O
ATOM    343  CB  GLU A  54     -42.696 -18.651  18.392  1.00 67.56           C
ATOM    344  CG  GLU A  54     -44.193 -18.392  18.510  1.00 72.56           C
ATOM    345  CD  GLU A  54     -45.006 -19.665  18.655  1.00 98.52           C
ATOM    346  OE1 GLU A  54     -46.103 -19.743  18.061  1.00111.16           O
ATOM    347  OE2 GLU A  54     -44.556 -20.588  19.369  1.00104.18           O
ATOM    348  N   TYR A  55     -40.113 -19.580  15.934  1.00 47.45           N
ATOM    349  CA  TYR A  55     -38.691 -19.461  15.614  1.00 52.16           C
ATOM    350  C   TYR A  55     -37.772 -19.837  16.779  1.00 52.35           C
ATOM    351  O   TYR A  55     -36.620 -19.408  16.824  1.00 50.39           O
ATOM    352  CB  TYR A  55     -38.374 -18.040  15.134  1.00 51.19           C
ATOM    353  CG  TYR A  55     -39.187 -17.614  13.930  1.00 63.08           C
ATOM    354  CD1 TYR A  55     -38.743 -17.874  12.640  1.00 68.41           C
ATOM    355  CD2 TYR A  55     -40.401 -16.955  14.084  1.00 65.05           C
ATOM    356  CE1 TYR A  55     -39.484 -17.487  11.535  1.00 63.58           C
ATOM    357  CE2 TYR A  55     -41.150 -16.568  12.987  1.00 59.78           C
ATOM    358  CZ  TYR A  55     -40.686 -16.835  11.716  1.00 66.74           C
ATOM    359  OH  TYR A  55     -41.431 -16.448  10.625  1.00 75.96           O
ATOM    360  N   GLN A  56     -38.277 -20.643  17.709  1.00 52.69           N
ATOM    361  CA  GLN A  56     -37.459 -21.136  18.817  1.00 46.95           C
ATOM    362  C   GLN A  56     -36.509 -22.225  18.337  1.00 45.95           C
ATOM    363  O   GLN A  56     -36.940 -23.215  17.752  1.00 51.66           O
ATOM    364  CB  GLN A  56     -38.334 -21.679  19.946  1.00 51.46           C
ATOM    365  CG  GLN A  56     -39.290 -20.673  20.555  1.00 46.97           C
ATOM    366  CD  GLN A  56     -40.284 -21.330  21.492  1.00 60.64           C
ATOM    367  OE1 GLN A  56     -41.472 -21.010  21.479  1.00 69.11           O
ATOM    368  NE2 GLN A  56     -39.803 -22.259  22.310  1.00 49.82           N
ATOM    369  N   ALA A  57     -35.218 -22.042  18.597  1.00 43.83           N
ATOM    370  CA  ALA A  57     -34.195 -22.983  18.141  1.00 53.99           C
ATOM    371  C   ALA A  57     -34.377 -24.386  18.723  1.00 51.18           C
ATOM    372  O   ALA A  57     -34.435 -25.373  17.979  1.00 44.05           O
ATOM    373  CB  ALA A  57     -32.813 -22.454  18.483  1.00 42.69           C
ATOM    374  N   TYR A  58     -34.462 -24.468  20.051  1.00 47.42           N
ATOM    375  CA  TYR A  58     -34.574 -25.754  20.734  1.00 44.10           C
ATOM    376  C   TYR A  58     -35.791 -26.530  20.244  1.00 43.38           C
ATOM    377  O   TYR A  58     -35.690 -27.709  19.896  1.00 45.42           O
ATOM    378  CB  TYR A  58     -34.651 -25.562  22.257  1.00 42.82           C
ATOM    379  CG  TYR A  58     -34.650 -26.869  23.021  1.00 45.37           C
ATOM    380  CD1 TYR A  58     -33.458 -27.468  23.409  1.00 46.58           C
ATOM    381  CD2 TYR A  58     -35.841 -27.514  23.340  1.00 50.15           C
ATOM    382  CE1 TYR A  58     -33.452 -28.667  24.097  1.00 50.01           C
ATOM    383  CE2 TYR A  58     -35.842 -28.713  24.025  1.00 52.43           C
ATOM    384  CZ  TYR A  58     -34.646 -29.285  24.400  1.00 52.11           C
ATOM    385  OH  TYR A  58     -34.644 -30.479  25.084  1.00 64.97           O
ATOM    386  N   LYS A  59     -36.935 -25.855  20.209  1.00 44.80           N
ATOM    387  CA  LYS A  59     -38.186 -26.477  19.794  1.00 44.79           C
ATOM    388  C   LYS A  59     -38.130 -26.929  18.331  1.00 47.37           C
ATOM    389  O   LYS A  59     -38.605 -28.015  17.991  1.00 46.14           O
ATOM    390  CB  LYS A  59     -39.354 -25.511  20.013  1.00 52.18           C
ATOM    391  CG  LYS A  59     -40.727 -26.145  19.881  1.00 55.02           C
ATOM    392  CD  LYS A  59     -41.816 -25.182  20.326  1.00 51.40           C
ATOM    393  CE  LYS A  59     -43.195 -25.815  20.219  1.00 52.38           C
ATOM    394  NZ  LYS A  59     -44.267 -24.907  20.706  1.00 55.04           N
ATOM    395  N   GLN A  60     -37.541 -26.097  17.475  1.00 41.88           N
ATOM    396  CA  GLN A  60     -37.391 -26.434  16.059  1.00 51.29           C
ATOM    397  C   GLN A  60     -36.555 -27.691  15.878  1.00 42.14           C
ATOM    398  O   GLN A  60     -36.949 -28.610  15.153  1.00 46.20           O
ATOM    399  CB  GLN A  60     -36.748 -25.281  15.282  1.00 42.12           C
ATOM    400  CG  GLN A  60     -37.701 -24.177  14.858  1.00 43.23           C
ATOM    401  CD  GLN A  60     -37.009 -23.120  14.014  1.00 51.55           C
ATOM    402  OE1 GLN A  60     -36.883 -23.266  12.799  1.00 51.71           O
ATOM    403  NE2 GLN A  60     -36.544 -22.056  14.659  1.00 40.17           N
ATOM    404  N   VAL A  61     -35.402 -27.730  16.542  1.00 45.14           N
ATOM    405  CA  VAL A  61     -34.503 -28.873  16.414  1.00 45.45           C
ATOM    406  C   VAL A  61     -35.124 -30.149  16.988  1.00 55.56           C
ATOM    407  O   VAL A  61     -35.036 -31.213  16.376  1.00 53.93           O
ATOM    408  CB  VAL A  61     -33.148 -28.609  17.101  1.00 43.40           C
ATOM    409  CG1 VAL A  61     -32.254 -29.834  17.002  1.00 44.08           C
ATOM    410  CG2 VAL A  61     -32.463 -27.406  16.472  1.00 47.20           C
ATOM    411  N   ALA A  62     -35.754 -30.042  18.155  1.00 49.15           N
ATOM    412  CA  ALA A  62     -36.404 -31.195  18.776  1.00 45.67           C
ATOM    413  C   ALA A  62     -37.512 -31.754  17.883  1.00 48.27           C
ATOM    414  O   ALA A  62     -37.598 -32.973  17.655  1.00 51.19           O
ATOM    415  CB  ALA A  62     -36.963 -30.817  20.144  1.00 45.78           C
ATOM    416  N   LEU A  63     -38.354 -30.855  17.378  1.00 44.94           N
ATOM    417  CA  LEU A  63     -39.439 -31.242  16.482  1.00 54.81           C
ATOM    418  C   LEU A  63     -38.900 -31.918  15.227  1.00 48.12           C
ATOM    419  O   LEU A  63     -39.416 -32.958  14.800  1.00 54.79           O
ATOM    420  CB  LEU A  63     -40.282 -30.024  16.103  1.00 57.34           C
ATOM    421  CG  LEU A  63     -41.427 -30.285  15.123  1.00 74.65           C
ATOM    422  CD1 LEU A  63     -42.381 -31.333  15.675  1.00 79.23           C
ATOM    423  CD2 LEU A  63     -42.168 -28.997  14.816  1.00 76.35           C
ATOM    424  N   ARG A  64     -37.856 -31.331  14.647  1.00 47.19           N
ATOM    425  CA  ARG A  64     -37.252 -31.884  13.438  1.00 54.07           C
ATOM    426  C   ARG A  64     -36.706 -33.286  13.689  1.00 61.74           C
ATOM    427  O   ARG A  64     -36.940 -34.199  12.898  1.00 56.04           O
ATOM    428  CB  ARG A  64     -36.143 -30.966  12.914  1.00 54.09           C
ATOM    429  CG  ARG A  64     -35.504 -31.455  11.627  1.00 64.34           C
ATOM    430  CD  ARG A  64     -36.559 -31.787  10.576  1.00 68.37           C
ATOM    431  NE  ARG A  64     -35.975 -32.368   9.370  1.00 87.17           N
ATOM    432  CZ  ARG A  64     -36.682 -32.792   8.326  1.00 86.22           C
ATOM    433  NH1 ARG A  64     -38.008 -32.703   8.333  1.00 75.95           N
ATOM    434  NH2 ARG A  64     -36.065 -33.307   7.272  1.00 88.53           N
ATOM    435  N   LEU A  65     -35.990 -33.450  14.796  1.00 54.42           N
ATOM    436  CA  LEU A  65     -35.469 -34.755  15.187  1.00 53.91           C
ATOM    437  C   LEU A  65     -36.594 -35.776  15.315  1.00 55.08           C
ATOM    438  O   LEU A  65     -36.483 -36.900  14.811  1.00 54.07           O
ATOM    439  CB  LEU A  65     -34.693 -34.660  16.505  1.00 52.87           C
ATOM    440  CG  LEU A  65     -33.306 -34.016  16.451  1.00 56.49           C
ATOM    441  CD1 LEU A  65     -32.715 -33.888  17.847  1.00 60.24           C
ATOM    442  CD2 LEU A  65     -32.381 -34.819  15.550  1.00 63.18           C
ATOM    443  N   ARG A  66     -37.681 -35.384  15.975  1.00 49.04           N
ATOM    444  CA  ARG A  66     -38.824 -36.286  16.114  1.00 50.12           C
ATOM    445  C   ARG A  66     -39.406 -36.683  14.754  1.00 60.90           C
ATOM    446  O   ARG A  66     -39.724 -37.850  14.526  1.00 60.50           O
ATOM    447  CB  ARG A  66     -39.917 -35.653  16.973  1.00 59.79           C
ATOM    448  CG  ARG A  66     -41.089 -36.584  17.229  1.00 69.86           C
ATOM    449  CD  ARG A  66     -42.321 -35.819  17.668  1.00 80.79           C
ATOM    450  NE  ARG A  66     -42.770 -34.875  16.649  0.00 72.17           N
ATOM    451  CZ  ARG A  66     -43.626 -35.176  15.677  0.00 70.35           C
ATOM    452  NH1 ARG A  66     -44.128 -36.399  15.589  0.00 72.05           N
ATOM    453  NH2 ARG A  66     -43.979 -34.253  14.793  0.00 69.24           N
ATOM    454  N   ILE A  67     -39.546 -35.712  13.855  1.00 57.98           N
ATOM    455  CA  ILE A  67     -40.091 -35.980  12.525  1.00 64.30           C
ATOM    456  C   ILE A  67     -39.212 -36.957  11.740  1.00 55.55           C
ATOM    457  O   ILE A  67     -39.699 -37.956  11.195  1.00 61.64           O
ATOM    458  CB  ILE A  67     -40.253 -34.680  11.716  1.00 63.94           C
ATOM    459  CG1 ILE A  67     -41.344 -33.808  12.339  1.00 64.75           C
ATOM    460  CG2 ILE A  67     -40.586 -34.988  10.264  1.00 71.79           C
ATOM    461  CD1 ILE A  67     -41.549 -32.494  11.631  1.00 68.29           C
ATOM    462  N   ILE A  68     -37.915 -36.663  11.700  1.00 51.89           N
ATOM    463  CA  ILE A  68     -36.944 -37.515  11.021  1.00 54.53           C
ATOM    464  C   ILE A  68     -36.974 -38.931  11.583  1.00 64.18           C
ATOM    465  O   ILE A  68     -36.931 -39.909  10.836  1.00 63.94           O
ATOM    466  CB  ILE A  68     -35.516 -36.952  11.145  1.00 54.27           C
ATOM    467  CG1 ILE A  68     -35.434 -35.571  10.497  1.00 60.48           C
ATOM    468  CG2 ILE A  68     -34.514 -37.888  10.499  1.00 59.92           C
ATOM    469  CD1 ILE A  68     -34.192 -34.800  10.881  1.00 66.87           C
ATOM    470  N   GLN A  69     -37.061 -39.036  12.904  1.00 68.80           N
ATOM    471  CA  GLN A  69     -37.111 -40.342  13.550  1.00 63.93           C
ATOM    472  C   GLN A  69     -38.404 -41.081  13.207  1.00 69.75           C
ATOM    473  O   GLN A  69     -38.415 -42.306  13.079  1.00 69.40           O
ATOM    474  CB  GLN A  69     -36.965 -40.191  15.064  1.00 74.86           C
ATOM    475  CG  GLN A  69     -36.797 -41.503  15.803  1.00 94.34           C
ATOM    476  CD  GLN A  69     -35.995 -41.349  17.078  1.00107.86           C
ATOM    477  OE1 GLN A  69     -35.446 -40.282  17.354  1.00110.37           O
ATOM    478  NE2 GLN A  69     -35.921 -42.417  17.864  1.00112.28           N
ATOM    479  N   ASP A  70     -39.490 -40.331  13.047  1.00 64.21           N
ATOM    480  CA  ASP A  70     -40.780 -40.924  12.711  1.00 63.32           C
ATOM    481  C   ASP A  70     -40.831 -41.363  11.252  1.00 67.39           C
ATOM    482  O   ASP A  70     -41.616 -42.238  10.891  1.00 64.17           O
ATOM    483  CB  ASP A  70     -41.919 -39.945  13.000  1.00 76.11           C
ATOM    484  CG  ASP A  70     -42.171 -39.763  14.483  1.00 92.11           C
ATOM    485  OD1 ASP A  70     -41.733 -40.627  15.274  1.00 88.52           O
ATOM    486  OD2 ASP A  70     -42.815 -38.761  14.859  1.00101.69           O
HETATM  487  N   MSE A  71     -40.000 -40.754  10.412  1.00 62.20           N
HETATM  488  CA  MSE A  71     -39.916 -41.167   9.014  1.00 70.12           C
HETATM  489  C   MSE A  71     -39.126 -42.462   8.859  1.00 74.52           C
HETATM  490  O   MSE A  71     -39.194 -43.118   7.819  1.00 79.12           O
HETATM  491  CB  MSE A  71     -39.273 -40.077   8.160  1.00 71.96           C
HETATM  492  CG  MSE A  71     -40.067 -38.795   8.075  1.00 77.78           C
HETATM  493 SE   MSE A  71     -39.328 -37.624   6.713  1.00 92.57          Se
HETATM  494  CE  MSE A  71     -37.478 -37.568   7.325  1.00 81.51           C
ATOM    495  N   GLY A  72     -38.373 -42.823   9.892  1.00 69.18           N
ATOM    496  CA  GLY A  72     -37.537 -44.007   9.842  1.00 66.69           C
ATOM    497  C   GLY A  72     -36.145 -43.700   9.320  1.00 68.24           C
ATOM    498  O   GLY A  72     -35.404 -44.605   8.937  1.00 78.54           O
ATOM    499  N   HIS A  73     -35.795 -42.417   9.304  1.00 61.29           N
ATOM    500  CA  HIS A  73     -34.480 -41.974   8.848  1.00 65.19           C
ATOM    501  C   HIS A  73     -33.503 -41.848  10.020  1.00 74.89           C
ATOM    502  O   HIS A  73     -33.913 -41.557  11.144  1.00 77.57           O
ATOM    503  CB  HIS A  73     -34.595 -40.636   8.110  1.00 66.50           C
ATOM    504  CG  HIS A  73     -35.343 -40.721   6.815  1.00 78.85           C
ATOM    505  ND1 HIS A  73     -35.270 -39.736   5.850  1.00 75.73           N
ATOM    506  CD2 HIS A  73     -36.178 -41.664   6.325  1.00 77.55           C
ATOM    507  CE1 HIS A  73     -36.027 -40.073   4.824  1.00 83.16           C
ATOM    508  NE2 HIS A  73     -36.591 -41.239   5.085  1.00 89.26           N
ATOM    509  N   PRO A  74     -32.203 -42.068   9.760  1.00 82.16           N
ATOM    510  CA  PRO A  74     -31.181 -42.014  10.812  1.00 77.56           C
ATOM    511  C   PRO A  74     -30.925 -40.603  11.331  1.00 74.18           C
ATOM    512  O   PRO A  74     -31.099 -39.630  10.598  1.00 74.28           O
ATOM    513  CB  PRO A  74     -29.934 -42.564  10.114  1.00 76.67           C
ATOM    514  CG  PRO A  74     -30.148 -42.247   8.677  1.00 82.30           C
ATOM    515  CD  PRO A  74     -31.621 -42.424   8.453  1.00 87.81           C
ATOM    516  N   THR A  75     -30.509 -40.503  12.590  1.00 69.55           N
ATOM    517  CA  THR A  75     -30.204 -39.215  13.202  1.00 64.05           C
ATOM    518  C   THR A  75     -28.849 -39.238  13.905  1.00 62.31           C
ATOM    519  O   THR A  75     -28.521 -38.327  14.665  1.00 63.22           O
ATOM    520  CB  THR A  75     -31.286 -38.800  14.221  1.00 66.69           C
ATOM    521  OG1 THR A  75     -31.522 -39.879  15.134  1.00 68.77           O
ATOM    522  CG2 THR A  75     -32.585 -38.458  13.513  1.00 77.60           C
ATOM    523  N   ASP A  76     -28.065 -40.281  13.646  1.00 55.41           N
ATOM    524  CA  ASP A  76     -26.758 -40.428  14.279  1.00 56.70           C
ATOM    525  C   ASP A  76     -25.754 -39.430  13.710  1.00 58.64           C
ATOM    526  O   ASP A  76     -24.806 -39.039  14.389  1.00 60.81           O
ATOM    527  CB  ASP A  76     -26.240 -41.860  14.118  1.00 70.43           C
ATOM    528  CG  ASP A  76     -26.051 -42.254  12.667  1.00 95.76           C
ATOM    529  OD1 ASP A  76     -27.055 -42.595  12.006  1.00102.12           O
ATOM    530  OD2 ASP A  76     -24.898 -42.231  12.189  1.00107.19           O
ATOM    531  N   LYS A  77     -25.964 -39.023  12.461  1.00 60.14           N
ATOM    532  CA  LYS A  77     -25.156 -37.974  11.847  1.00 58.08           C
ATOM    533  C   LYS A  77     -26.054 -36.863  11.322  1.00 62.20           C
ATOM    534  O   LYS A  77     -26.923 -37.098  10.485  1.00 62.54           O
ATOM    535  CB  LYS A  77     -24.294 -38.527  10.715  1.00 56.14           C
ATOM    536  CG  LYS A  77     -23.320 -39.608  11.131  1.00 62.94           C
ATOM    537  CD  LYS A  77     -22.400 -39.955   9.976  1.00 72.85           C
ATOM    538  CE  LYS A  77     -21.862 -41.367  10.093  1.00 81.00           C
ATOM    539  NZ  LYS A  77     -20.984 -41.681   8.938  1.00 91.16           N
ATOM    540  N   VAL A  78     -25.828 -35.650  11.809  1.00 51.08           N
ATOM    541  CA  VAL A  78     -26.713 -34.530  11.518  1.00 48.05           C
ATOM    542  C   VAL A  78     -25.935 -33.307  11.045  1.00 51.71           C
ATOM    543  O   VAL A  78     -24.854 -33.016  11.557  1.00 62.11           O
ATOM    544  CB  VAL A  78     -27.563 -34.168  12.770  1.00 62.15           C
ATOM    545  CG1 VAL A  78     -27.827 -32.670  12.861  1.00 60.64           C
ATOM    546  CG2 VAL A  78     -28.864 -34.961  12.782  1.00 64.36           C
ATOM    547  N   GLU A  79     -26.476 -32.606  10.052  1.00 45.18           N
ATOM    548  CA  GLU A  79     -25.943 -31.302   9.680  1.00 41.20           C
ATOM    549  C   GLU A  79     -26.940 -30.203  10.020  1.00 45.39           C
ATOM    550  O   GLU A  79     -28.004 -30.112   9.413  1.00 55.52           O
ATOM    551  CB  GLU A  79     -25.596 -31.241   8.191  1.00 51.05           C
ATOM    552  CG  GLU A  79     -24.977 -29.910   7.782  1.00 65.11           C
ATOM    553  CD  GLU A  79     -24.696 -29.812   6.296  1.00 77.37           C
ATOM    554  OE1 GLU A  79     -25.334 -30.550   5.516  1.00 96.34           O
ATOM    555  OE2 GLU A  79     -23.835 -28.995   5.909  1.00 70.83           O
ATOM    556  N   LEU A  80     -26.590 -29.371  10.995  1.00 46.30           N
ATOM    557  CA  LEU A  80     -27.412 -28.224  11.351  1.00 45.73           C
ATOM    558  C   LEU A  80     -27.341 -27.164  10.263  1.00 48.78           C
ATOM    559  O   LEU A  80     -26.253 -26.787   9.826  1.00 50.95           O
ATOM    560  CB  LEU A  80     -26.966 -27.627  12.690  1.00 48.02           C
ATOM    561  CG  LEU A  80     -27.385 -28.360  13.962  1.00 56.11           C
ATOM    562  CD1 LEU A  80     -26.747 -27.711  15.179  1.00 51.53           C
ATOM    563  CD2 LEU A  80     -28.900 -28.365  14.085  1.00 50.33           C
ATOM    564  N   ILE A  81     -28.501 -26.686   9.827  1.00 48.19           N
ATOM    565  CA  ILE A  81     -28.547 -25.630   8.827  1.00 44.24           C
ATOM    566  C   ILE A  81     -29.329 -24.433   9.349  1.00 41.04           C
ATOM    567  O   ILE A  81     -30.535 -24.521   9.590  1.00 48.94           O
ATOM    568  CB  ILE A  81     -29.174 -26.121   7.506  1.00 49.22           C
ATOM    569  CG1 ILE A  81     -28.421 -27.348   6.987  1.00 49.49           C
ATOM    570  CG2 ILE A  81     -29.168 -25.004   6.474  1.00 51.14           C
ATOM    571  CD1 ILE A  81     -28.967 -27.895   5.684  1.00 57.15           C
ATOM    572  N   ILE A  82     -28.628 -23.319   9.535  1.00 47.33           N
ATOM    573  CA  ILE A  82     -29.237 -22.093  10.037  1.00 44.71           C
ATOM    574  C   ILE A  82     -29.654 -21.188   8.882  1.00 49.92           C
ATOM    575  O   ILE A  82     -28.811 -20.570   8.229  1.00 50.19           O
ATOM    576  CB  ILE A  82     -28.276 -21.318  10.961  1.00 51.47           C
ATOM    577  CG1 ILE A  82     -27.612 -22.261  11.969  1.00 61.87           C
ATOM    578  CG2 ILE A  82     -29.011 -20.187  11.660  1.00 43.41           C
ATOM    579  CD1 ILE A  82     -28.581 -22.979  12.871  1.00 53.47           C
HETATM  580  N   MSE A  83     -30.957 -21.109   8.640  1.00 46.91           N
HETATM  581  CA  MSE A  83     -31.484 -20.365   7.502  1.00 54.34           C
HETATM  582  C   MSE A  83     -31.916 -18.950   7.871  1.00 59.25           C
HETATM  583  O   MSE A  83     -32.252 -18.669   9.022  1.00 54.11           O
HETATM  584  CB  MSE A  83     -32.663 -21.117   6.884  1.00 53.12           C
HETATM  585  CG  MSE A  83     -32.301 -22.480   6.320  1.00 54.31           C
HETATM  586 SE   MSE A  83     -33.834 -23.382   5.523  1.00 66.79          Se
HETATM  587  CE  MSE A  83     -34.909 -23.634   7.128  1.00 56.97           C
ATOM    588  N   GLY A  84     -31.908 -18.065   6.879  1.00 59.44           N
ATOM    589  CA  GLY A  84     -32.315 -16.686   7.076  1.00 64.47           C
ATOM    590  C   GLY A  84     -31.434 -15.703   6.329  1.00 58.95           C
ATOM    591  O   GLY A  84     -31.926 -14.766   5.700  1.00 63.63           O
ATOM    592  N   GLY A  85     -30.124 -15.916   6.405  1.00 54.45           N
ATOM    593  CA  GLY A  85     -29.167 -15.056   5.735  1.00 48.72           C
ATOM    594  C   GLY A  85     -28.856 -13.789   6.507  1.00 61.48           C
ATOM    595  O   GLY A  85     -27.971 -13.024   6.127  1.00 66.89           O
ATOM    596  N   THR A  86     -29.583 -13.570   7.599  1.00 59.47           N
ATOM    597  CA  THR A  86     -29.445 -12.348   8.383  1.00 71.94           C
ATOM    598  C   THR A  86     -29.056 -12.649   9.827  1.00 70.62           C
ATOM    599  O   THR A  86     -28.985 -11.749  10.662  1.00 71.05           O
ATOM    600  CB  THR A  86     -30.750 -11.533   8.373  1.00 83.02           C
ATOM    601  OG1 THR A  86     -31.809 -12.316   8.939  1.00 76.03           O
ATOM    602  CG2 THR A  86     -31.120 -11.146   6.950  1.00 90.57           C
ATOM    603  N   PHE A  87     -28.799 -13.924  10.102  1.00 66.41           N
ATOM    604  CA  PHE A  87     -28.494 -14.407  11.445  1.00 65.08           C
ATOM    605  C   PHE A  87     -27.294 -13.709  12.086  1.00 65.68           C
ATOM    606  O   PHE A  87     -27.326 -13.366  13.267  1.00 57.71           O
ATOM    607  CB  PHE A  87     -28.255 -15.919  11.394  1.00 64.73           C
ATOM    608  CG  PHE A  87     -27.767 -16.510  12.685  1.00 57.26           C
ATOM    609  CD1 PHE A  87     -28.484 -16.345  13.855  1.00 55.35           C
ATOM    610  CD2 PHE A  87     -26.600 -17.257  12.719  1.00 60.30           C
ATOM    611  CE1 PHE A  87     -28.044 -16.904  15.037  1.00 53.75           C
ATOM    612  CE2 PHE A  87     -26.151 -17.814  13.899  1.00 58.53           C
ATOM    613  CZ  PHE A  87     -26.874 -17.638  15.059  1.00 51.00           C
ATOM    614  N   LEU A  88     -26.244 -13.490  11.303  1.00 62.73           N
ATOM    615  CA  LEU A  88     -25.007 -12.923  11.831  1.00 60.19           C
ATOM    616  C   LEU A  88     -25.119 -11.432  12.143  1.00 62.54           C
ATOM    617  O   LEU A  88     -24.244 -10.864  12.796  1.00 66.58           O
ATOM    618  CB  LEU A  88     -23.858 -13.164  10.850  1.00 60.62           C
ATOM    619  CG  LEU A  88     -23.510 -14.634  10.609  1.00 65.34           C
ATOM    620  CD1 LEU A  88     -22.408 -14.770   9.570  1.00 68.14           C
ATOM    621  CD2 LEU A  88     -23.107 -15.303  11.914  1.00 58.65           C
ATOM    622  N   SER A  89     -26.196 -10.803  11.682  1.00 63.87           N
ATOM    623  CA  SER A  89     -26.412  -9.380  11.930  1.00 64.68           C
ATOM    624  C   SER A  89     -27.239  -9.151  13.192  1.00 65.84           C
ATOM    625  O   SER A  89     -27.502  -8.011  13.573  1.00 73.11           O
ATOM    626  CB  SER A  89     -27.102  -8.721  10.735  1.00 66.94           C
ATOM    627  OG  SER A  89     -28.455  -9.133  10.639  1.00 74.48           O
ATOM    628  N   ALA A  90     -27.651 -10.240  13.832  1.00 68.16           N
ATOM    629  CA  ALA A  90     -28.439 -10.151  15.056  1.00 69.30           C
ATOM    630  C   ALA A  90     -27.543  -9.939  16.268  1.00 72.91           C
ATOM    631  O   ALA A  90     -26.319 -10.023  16.168  1.00 76.29           O
ATOM    632  CB  ALA A  90     -29.282 -11.402  15.236  1.00 66.44           C
ATOM    633  N   ASP A  91     -28.165  -9.662  17.409  1.00 65.23           N
ATOM    634  CA  ASP A  91     -27.445  -9.499  18.665  1.00 64.41           C
ATOM    635  C   ASP A  91     -26.615 -10.742  18.986  1.00 64.33           C
ATOM    636  O   ASP A  91     -27.058 -11.868  18.761  1.00 64.98           O
ATOM    637  CB  ASP A  91     -28.430  -9.198  19.797  1.00 82.13           C
ATOM    638  CG  ASP A  91     -27.817  -9.371  21.168  1.00103.30           C
ATOM    639  OD1 ASP A  91     -27.090  -8.461  21.619  1.00120.68           O
ATOM    640  OD2 ASP A  91     -28.071 -10.417  21.798  1.00105.62           O
ATOM    641  N   ILE A  92     -25.409 -10.521  19.503  1.00 67.35           N
ATOM    642  CA  ILE A  92     -24.447 -11.592  19.764  1.00 73.98           C
ATOM    643  C   ILE A  92     -24.986 -12.661  20.724  1.00 65.53           C
ATOM    644  O   ILE A  92     -24.923 -13.868  20.435  1.00 67.04           O
ATOM    645  CB  ILE A  92     -23.135 -11.013  20.339  1.00 77.96           C
ATOM    646  CG1 ILE A  92     -22.680  -9.802  19.520  1.00 80.39           C
ATOM    647  CG2 ILE A  92     -22.051 -12.070  20.375  1.00 74.21           C
ATOM    648  CD1 ILE A  92     -22.348 -10.127  18.077  1.00 79.78           C
ATOM    649  N   THR A  93     -25.513 -12.203  21.859  1.00 67.48           N
ATOM    650  CA  THR A  93     -26.123 -13.078  22.860  1.00 65.02           C
ATOM    651  C   THR A  93     -27.206 -13.964  22.246  1.00 63.03           C
ATOM    652  O   THR A  93     -27.298 -15.154  22.558  1.00 74.23           O
ATOM    653  CB  THR A  93     -26.739 -12.264  24.022  1.00 70.41           C
ATOM    654  OG1 THR A  93     -25.723 -11.473  24.650  1.00 64.85           O
ATOM    655  CG2 THR A  93     -27.361 -13.185  25.058  1.00 68.49           C
ATOM    656  N   TYR A  94     -28.019 -13.381  21.368  1.00 55.82           N
ATOM    657  CA  TYR A  94     -29.049 -14.141  20.667  1.00 57.31           C
ATOM    658  C   TYR A  94     -28.442 -15.241  19.806  1.00 51.20           C
ATOM    659  O   TYR A  94     -28.925 -16.369  19.814  1.00 57.51           O
ATOM    660  CB  TYR A  94     -29.914 -13.232  19.791  1.00 59.76           C
ATOM    661  CG  TYR A  94     -30.848 -14.008  18.890  1.00 57.13           C
ATOM    662  CD1 TYR A  94     -32.010 -14.575  19.391  1.00 57.07           C
ATOM    663  CD2 TYR A  94     -30.561 -14.189  17.545  1.00 54.81           C
ATOM    664  CE1 TYR A  94     -32.868 -15.294  18.577  1.00 57.96           C
ATOM    665  CE2 TYR A  94     -31.413 -14.911  16.720  1.00 50.74           C
ATOM    666  CZ  TYR A  94     -32.564 -15.459  17.243  1.00 56.98           C
ATOM    667  OH  TYR A  94     -33.414 -16.173  16.432  1.00 49.46           O
ATOM    668  N   GLN A  95     -27.394 -14.902  19.058  1.00 53.97           N
ATOM    669  CA  GLN A  95     -26.726 -15.863  18.184  1.00 58.58           C
ATOM    670  C   GLN A  95     -26.180 -17.051  18.975  1.00 57.33           C
ATOM    671  O   GLN A  95     -26.510 -18.223  18.693  1.00 57.08           O
ATOM    672  CB  GLN A  95     -25.591 -15.183  17.409  1.00 62.42           C
ATOM    673  CG  GLN A  95     -26.038 -14.013  16.541  1.00 64.19           C
ATOM    674  CD  GLN A  95     -24.884 -13.334  15.817  1.00 65.91           C
ATOM    675  OE1 GLN A  95     -23.933 -13.986  15.387  1.00 65.96           O
ATOM    676  NE2 GLN A  95     -24.965 -12.015  15.684  1.00 63.40           N
ATOM    677  N   TYR A  96     -25.352 -16.739  19.972  1.00 60.32           N
ATOM    678  CA  TYR A  96     -24.748 -17.773  20.810  1.00 54.94           C
ATOM    679  C   TYR A  96     -25.803 -18.625  21.514  1.00 50.21           C
ATOM    680  O   TYR A  96     -25.673 -19.846  21.587  1.00 54.32           O
ATOM    681  CB  TYR A  96     -23.798 -17.144  21.835  1.00 52.60           C
ATOM    682  CG  TYR A  96     -22.428 -16.825  21.271  1.00 64.79           C
ATOM    683  CD1 TYR A  96     -22.189 -15.633  20.602  1.00 72.57           C
ATOM    684  CD2 TYR A  96     -21.377 -17.722  21.401  1.00 66.24           C
ATOM    685  CE1 TYR A  96     -20.939 -15.341  20.080  1.00 70.09           C
ATOM    686  CE2 TYR A  96     -20.124 -17.440  20.885  1.00 65.18           C
ATOM    687  CZ  TYR A  96     -19.911 -16.247  20.225  1.00 67.85           C
ATOM    688  OH  TYR A  96     -18.669 -15.960  19.709  1.00 71.32           O
ATOM    689  N   GLY A  97     -26.853 -17.979  22.015  1.00 58.70           N
ATOM    690  CA  GLY A  97     -27.938 -18.689  22.671  1.00 58.62           C
ATOM    691  C   GLY A  97     -28.688 -19.606  21.720  1.00 58.59           C
ATOM    692  O   GLY A  97     -29.147 -20.680  22.108  1.00 57.38           O
ATOM    693  N   PHE A  98     -28.808 -19.177  20.468  1.00 50.33           N
ATOM    694  CA  PHE A  98     -29.482 -19.952  19.430  1.00 47.78           C
ATOM    695  C   PHE A  98     -28.696 -21.220  19.120  1.00 47.02           C
ATOM    696  O   PHE A  98     -29.233 -22.341  19.172  1.00 58.49           O
ATOM    697  CB  PHE A  98     -29.651 -19.104  18.164  1.00 50.34           C
ATOM    698  CG  PHE A  98     -30.589 -19.695  17.151  1.00 46.41           C
ATOM    699  CD1 PHE A  98     -30.148 -20.649  16.249  1.00 41.91           C
ATOM    700  CD2 PHE A  98     -31.910 -19.285  17.092  1.00 48.04           C
ATOM    701  CE1 PHE A  98     -31.010 -21.193  15.314  1.00 47.17           C
ATOM    702  CE2 PHE A  98     -32.777 -19.821  16.158  1.00 51.74           C
ATOM    703  CZ  PHE A  98     -32.328 -20.776  15.269  1.00 45.80           C
ATOM    704  N   ILE A  99     -27.418 -21.035  18.799  1.00 48.78           N
ATOM    705  CA  ILE A  99     -26.550 -22.172  18.505  1.00 43.80           C
ATOM    706  C   ILE A  99     -26.506 -23.146  19.691  1.00 49.50           C
ATOM    707  O   ILE A  99     -26.634 -24.370  19.526  1.00 44.18           O
ATOM    708  CB  ILE A  99     -25.125 -21.705  18.158  1.00 51.25           C
ATOM    709  CG1 ILE A  99     -25.158 -20.751  16.962  1.00 51.79           C
ATOM    710  CG2 ILE A  99     -24.230 -22.890  17.855  1.00 56.96           C
ATOM    711  CD1 ILE A  99     -25.723 -21.377  15.708  1.00 51.57           C
ATOM    712  N   LYS A 100     -26.347 -22.586  20.886  1.00 49.11           N
ATOM    713  CA  LYS A 100     -26.308 -23.375  22.110  1.00 50.75           C
ATOM    714  C   LYS A 100     -27.598 -24.173  22.285  1.00 46.32           C
ATOM    715  O   LYS A 100     -27.562 -25.339  22.672  1.00 50.95           O
ATOM    716  CB  LYS A 100     -26.068 -22.467  23.321  1.00 51.25           C
ATOM    717  CG  LYS A 100     -25.564 -23.177  24.566  1.00 61.98           C
ATOM    718  CD  LYS A 100     -26.700 -23.536  25.504  1.00 67.52           C
ATOM    719  CE  LYS A 100     -26.173 -24.121  26.803  1.00 58.13           C
ATOM    720  NZ  LYS A 100     -27.285 -24.573  27.681  1.00 49.67           N
ATOM    721  N   ASP A 101     -28.734 -23.546  21.991  1.00 48.69           N
ATOM    722  CA  ASP A 101     -30.020 -24.235  22.047  1.00 46.50           C
ATOM    723  C   ASP A 101     -30.059 -25.407  21.072  1.00 55.09           C
ATOM    724  O   ASP A 101     -30.537 -26.496  21.412  1.00 50.62           O
ATOM    725  CB  ASP A 101     -31.168 -23.269  21.746  1.00 58.04           C
ATOM    726  CG  ASP A 101     -31.601 -22.475  22.964  1.00 70.45           C
ATOM    727  OD1 ASP A 101     -31.411 -22.967  24.097  1.00 80.82           O
ATOM    728  OD2 ASP A 101     -32.141 -21.362  22.789  1.00 73.67           O
ATOM    729  N   CYS A 102     -29.556 -25.179  19.860  1.00 50.25           N
ATOM    730  CA  CYS A 102     -29.482 -26.252  18.869  1.00 46.96           C
ATOM    731  C   CYS A 102     -28.675 -27.438  19.388  1.00 40.35           C
ATOM    732  O   CYS A 102     -29.123 -28.593  19.321  1.00 42.57           O
ATOM    733  CB  CYS A 102     -28.872 -25.741  17.564  1.00 43.72           C
ATOM    734  SG  CYS A 102     -29.883 -24.523  16.710  1.00 47.93           S
ATOM    735  N   TYR A 103     -27.487 -27.150  19.913  1.00 39.77           N
ATOM    736  CA  TYR A 103     -26.634 -28.209  20.445  1.00 48.51           C
ATOM    737  C   TYR A 103     -27.279 -28.936  21.623  1.00 52.44           C
ATOM    738  O   TYR A 103     -27.156 -30.153  21.745  1.00 52.06           O
ATOM    739  CB  TYR A 103     -25.275 -27.650  20.862  1.00 49.91           C
ATOM    740  CG  TYR A 103     -24.322 -27.483  19.706  1.00 49.17           C
ATOM    741  CD1 TYR A 103     -23.900 -28.582  18.972  1.00 52.42           C
ATOM    742  CD2 TYR A 103     -23.845 -26.231  19.345  1.00 47.23           C
ATOM    743  CE1 TYR A 103     -23.032 -28.440  17.910  1.00 58.39           C
ATOM    744  CE2 TYR A 103     -22.971 -26.080  18.285  1.00 52.00           C
ATOM    745  CZ  TYR A 103     -22.570 -27.186  17.571  1.00 57.31           C
ATOM    746  OH  TYR A 103     -21.702 -27.035  16.516  1.00 58.76           O
ATOM    747  N   ASP A 104     -27.965 -28.192  22.484  1.00 59.04           N
ATOM    748  CA  ASP A 104     -28.677 -28.790  23.610  1.00 51.24           C
ATOM    749  C   ASP A 104     -29.751 -29.745  23.115  1.00 52.58           C
ATOM    750  O   ASP A 104     -29.925 -30.833  23.658  1.00 46.87           O
ATOM    751  CB  ASP A 104     -29.311 -27.716  24.498  1.00 46.79           C
ATOM    752  CG  ASP A 104     -28.312 -27.063  25.432  1.00 48.69           C
ATOM    753  OD1 ASP A 104     -27.175 -27.568  25.543  1.00 53.33           O
ATOM    754  OD2 ASP A 104     -28.669 -26.049  26.067  1.00 61.06           O
ATOM    755  N   ALA A 105     -30.467 -29.336  22.074  1.00 50.99           N
ATOM    756  CA  ALA A 105     -31.517 -30.175  21.514  1.00 54.66           C
ATOM    757  C   ALA A 105     -30.932 -31.435  20.880  1.00 54.10           C
ATOM    758  O   ALA A 105     -31.524 -32.512  20.966  1.00 49.57           O
ATOM    759  CB  ALA A 105     -32.329 -29.395  20.505  1.00 48.37           C
ATOM    760  N   LEU A 106     -29.766 -31.303  20.253  1.00 51.05           N
ATOM    761  CA  LEU A 106     -29.092 -32.473  19.689  1.00 52.01           C
ATOM    762  C   LEU A 106     -28.595 -33.428  20.777  1.00 56.51           C
ATOM    763  O   LEU A 106     -28.635 -34.647  20.612  1.00 55.13           O
ATOM    764  CB  LEU A 106     -27.921 -32.045  18.801  1.00 45.54           C
ATOM    765  CG  LEU A 106     -28.279 -31.402  17.463  1.00 52.33           C
ATOM    766  CD1 LEU A 106     -27.021 -31.074  16.673  1.00 48.29           C
ATOM    767  CD2 LEU A 106     -29.195 -32.320  16.664  1.00 42.12           C
ATOM    768  N   ASN A 107     -28.136 -32.869  21.890  1.00 51.16           N
ATOM    769  CA  ASN A 107     -27.516 -33.662  22.948  1.00 50.60           C
ATOM    770  C   ASN A 107     -28.514 -34.381  23.844  1.00 56.93           C
ATOM    771  O   ASN A 107     -28.199 -35.419  24.425  1.00 61.67           O
ATOM    772  CB  ASN A 107     -26.619 -32.776  23.812  1.00 50.63           C
ATOM    773  CG  ASN A 107     -25.392 -32.301  23.072  1.00 51.83           C
ATOM    774  OD1 ASN A 107     -24.966 -32.919  22.098  1.00 54.55           O
ATOM    775  ND2 ASN A 107     -24.810 -31.200  23.533  1.00 52.33           N
ATOM    776  N   GLY A 108     -29.711 -33.822  23.967  1.00 57.59           N
ATOM    777  CA  GLY A 108     -30.710 -34.376  24.860  1.00 52.76           C
ATOM    778  C   GLY A 108     -30.501 -33.910  26.288  1.00 60.80           C
ATOM    779  O   GLY A 108     -31.295 -34.221  27.175  1.00 66.63           O
ATOM    780  N   VAL A 109     -29.425 -33.164  26.512  1.00 56.65           N
ATOM    781  CA  VAL A 109     -29.139 -32.605  27.828  1.00 63.55           C
ATOM    782  C   VAL A 109     -28.810 -31.119  27.723  1.00 65.22           C
ATOM    783  O   VAL A 109     -28.328 -30.651  26.689  1.00 59.80           O
ATOM    784  CB  VAL A 109     -27.971 -33.339  28.518  1.00 66.66           C
ATOM    785  CG1 VAL A 109     -28.350 -34.784  28.812  1.00 61.92           C
ATOM    786  CG2 VAL A 109     -26.716 -33.275  27.661  1.00 59.83           C
ATOM    787  N   VAL A 110     -29.078 -30.381  28.795  1.00 66.32           N
ATOM    788  CA  VAL A 110     -28.805 -28.950  28.831  1.00 64.21           C
ATOM    789  C   VAL A 110     -27.444 -28.673  29.456  1.00 65.57           C
ATOM    790  O   VAL A 110     -27.219 -28.974  30.627  1.00 63.61           O
ATOM    791  CB  VAL A 110     -29.889 -28.190  29.617  1.00 67.29           C
ATOM    792  CG1 VAL A 110     -29.544 -26.711  29.704  1.00 72.84           C
ATOM    793  CG2 VAL A 110     -31.251 -28.395  28.971  1.00 65.75           C
ATOM    794  N   ALA A 111     -26.540 -28.098  28.670  1.00 62.50           N
ATOM    795  CA  ALA A 111     -25.186 -27.825  29.133  1.00 59.70           C
ATOM    796  C   ALA A 111     -25.090 -26.461  29.816  1.00 63.64           C
ATOM    797  O   ALA A 111     -26.014 -25.648  29.737  1.00 64.16           O
ATOM    798  CB  ALA A 111     -24.209 -27.906  27.974  1.00 57.40           C
ATOM    799  N   GLY A 112     -23.964 -26.216  30.480  1.00 76.52           N
ATOM    800  CA  GLY A 112     -23.747 -24.972  31.197  1.00 74.43           C
ATOM    801  C   GLY A 112     -23.250 -23.859  30.295  1.00 76.99           C
ATOM    802  O   GLY A 112     -23.280 -22.687  30.667  1.00 74.92           O
ATOM    803  N   SER A 113     -22.787 -24.230  29.105  1.00 71.89           N
ATOM    804  CA  SER A 113     -22.320 -23.258  28.122  1.00 69.39           C
ATOM    805  C   SER A 113     -22.312 -23.859  26.723  1.00 57.93           C
ATOM    806  O   SER A 113     -22.624 -25.036  26.542  1.00 62.23           O
ATOM    807  CB  SER A 113     -20.920 -22.755  28.479  1.00 75.60           C
ATOM    808  OG  SER A 113     -19.965 -23.800  28.405  1.00 73.49           O
ATOM    809  N   LEU A 114     -21.947 -23.044  25.739  1.00 57.96           N
ATOM    810  CA  LEU A 114     -21.861 -23.501  24.359  1.00 62.19           C
ATOM    811  C   LEU A 114     -20.707 -24.481  24.188  1.00 66.04           C
ATOM    812  O   LEU A 114     -20.833 -25.491  23.493  1.00 64.51           O
ATOM    813  CB  LEU A 114     -21.696 -22.313  23.409  1.00 50.85           C
ATOM    814  CG  LEU A 114     -21.448 -22.630  21.930  1.00 60.49           C
ATOM    815  CD1 LEU A 114     -22.567 -23.483  21.352  1.00 54.39           C
ATOM    816  CD2 LEU A 114     -21.285 -21.348  21.130  1.00 58.27           C
ATOM    817  N   GLU A 115     -19.584 -24.180  24.832  1.00 65.85           N
ATOM    818  CA  GLU A 115     -18.405 -25.033  24.743  1.00 66.52           C
ATOM    819  C   GLU A 115     -18.665 -26.418  25.324  1.00 67.78           C
ATOM    820  O   GLU A 115     -18.242 -27.429  24.754  1.00 69.02           O
ATOM    821  CB  GLU A 115     -17.218 -24.376  25.448  1.00 69.48           C
ATOM    822  CG  GLU A 115     -16.483 -23.369  24.583  1.00 84.06           C
ATOM    823  CD  GLU A 115     -15.936 -23.995  23.313  1.00 99.52           C
ATOM    824  OE1 GLU A 115     -15.354 -25.097  23.398  1.00107.83           O
ATOM    825  OE2 GLU A 115     -16.094 -23.392  22.231  1.00 96.95           O
ATOM    826  N   GLU A 116     -19.365 -26.464  26.453  1.00 65.67           N
ATOM    827  CA  GLU A 116     -19.707 -27.740  27.065  1.00 66.70           C
ATOM    828  C   GLU A 116     -20.706 -28.492  26.197  1.00 55.36           C
ATOM    829  O   GLU A 116     -20.664 -29.716  26.120  1.00 66.89           O
ATOM    830  CB  GLU A 116     -20.278 -27.548  28.472  1.00 67.83           C
ATOM    831  CG  GLU A 116     -20.541 -28.863  29.195  1.00 85.57           C
ATOM    832  CD  GLU A 116     -21.284 -28.686  30.504  1.00 99.26           C
ATOM    833  OE1 GLU A 116     -21.410 -29.677  31.253  1.00 94.32           O
ATOM    834  OE2 GLU A 116     -21.744 -27.559  30.782  1.00109.07           O
ATOM    835  N   ALA A 117     -21.603 -27.758  25.547  1.00 56.28           N
ATOM    836  CA  ALA A 117     -22.589 -28.370  24.660  1.00 60.66           C
ATOM    837  C   ALA A 117     -21.902 -29.031  23.467  1.00 53.98           C
ATOM    838  O   ALA A 117     -22.254 -30.146  23.072  1.00 53.08           O
ATOM    839  CB  ALA A 117     -23.597 -27.336  24.186  1.00 54.83           C
ATOM    840  N   LYS A 118     -20.920 -28.336  22.902  1.00 55.01           N
ATOM    841  CA  LYS A 118     -20.138 -28.870  21.791  1.00 56.34           C
ATOM    842  C   LYS A 118     -19.333 -30.095  22.226  1.00 59.55           C
ATOM    843  O   LYS A 118     -19.375 -31.152  21.573  1.00 57.56           O
ATOM    844  CB  LYS A 118     -19.216 -27.787  21.231  1.00 61.25           C
ATOM    845  CG  LYS A 118     -19.967 -26.642  20.560  1.00 58.83           C
ATOM    846  CD  LYS A 118     -19.129 -25.373  20.496  1.00 58.60           C
ATOM    847  CE  LYS A 118     -17.852 -25.586  19.708  1.00 64.97           C
ATOM    848  NZ  LYS A 118     -17.035 -24.342  19.653  1.00 66.58           N
ATOM    849  N   THR A 119     -18.610 -29.948  23.335  1.00 61.42           N
ATOM    850  CA  THR A 119     -17.827 -31.047  23.892  1.00 51.87           C
ATOM    851  C   THR A 119     -18.694 -32.286  24.102  1.00 54.08           C
ATOM    852  O   THR A 119     -18.295 -33.400  23.768  1.00 59.28           O
ATOM    853  CB  THR A 119     -17.170 -30.649  25.231  1.00 66.24           C
ATOM    854  OG1 THR A 119     -16.280 -29.545  25.019  1.00 69.70           O
ATOM    855  CG2 THR A 119     -16.389 -31.818  25.814  1.00 64.17           C
ATOM    856  N   ILE A 120     -19.886 -32.079  24.649  1.00 53.78           N
ATOM    857  CA  ILE A 120     -20.840 -33.162  24.853  1.00 55.77           C
ATOM    858  C   ILE A 120     -21.268 -33.763  23.515  1.00 57.93           C
ATOM    859  O   ILE A 120     -21.341 -34.985  23.371  1.00 61.29           O
ATOM    860  CB  ILE A 120     -22.081 -32.678  25.633  1.00 56.02           C
ATOM    861  CG1 ILE A 120     -21.736 -32.494  27.113  1.00 60.26           C
ATOM    862  CG2 ILE A 120     -23.228 -33.666  25.499  1.00 48.11           C
ATOM    863  CD1 ILE A 120     -22.834 -31.839  27.915  1.00 60.68           C
ATOM    864  N   ASN A 121     -21.530 -32.907  22.531  1.00 54.24           N
ATOM    865  CA  ASN A 121     -21.960 -33.392  21.225  1.00 50.03           C
ATOM    866  C   ASN A 121     -20.881 -34.214  20.532  1.00 48.62           C
ATOM    867  O   ASN A 121     -21.183 -35.029  19.659  1.00 71.63           O
ATOM    868  CB  ASN A 121     -22.382 -32.236  20.322  1.00 48.19           C
ATOM    869  CG  ASN A 121     -23.010 -32.720  19.026  1.00 54.14           C
ATOM    870  OD1 ASN A 121     -22.340 -32.827  18.000  1.00 53.18           O
ATOM    871  ND2 ASN A 121     -24.299 -33.036  19.074  1.00 48.27           N
ATOM    872  N   GLU A 122     -19.626 -34.006  20.927  1.00 59.16           N
ATOM    873  CA  GLU A 122     -18.518 -34.776  20.359  1.00 64.73           C
ATOM    874  C   GLU A 122     -18.709 -36.291  20.504  1.00 72.10           C
ATOM    875  O   GLU A 122     -18.238 -37.059  19.666  1.00 75.77           O
ATOM    876  CB  GLU A 122     -17.191 -34.362  20.997  1.00 64.08           C
ATOM    877  CG  GLU A 122     -16.775 -32.933  20.682  1.00 68.86           C
ATOM    878  CD  GLU A 122     -15.399 -32.591  21.219  1.00 74.42           C
ATOM    879  OE1 GLU A 122     -14.654 -33.522  21.588  1.00 79.21           O
ATOM    880  OE2 GLU A 122     -15.064 -31.389  21.273  1.00 83.46           O
ATOM    881  N   THR A 123     -19.402 -36.718  21.558  1.00 66.47           N
ATOM    882  CA  THR A 123     -19.666 -38.142  21.766  1.00 56.18           C
ATOM    883  C   THR A 123     -21.153 -38.441  21.979  1.00 58.36           C
ATOM    884  O   THR A 123     -21.509 -39.461  22.574  1.00 64.99           O
ATOM    885  CB  THR A 123     -18.879 -38.701  22.979  1.00 70.90           C
ATOM    886  OG1 THR A 123     -19.328 -38.061  24.180  1.00 63.55           O
ATOM    887  CG2 THR A 123     -17.377 -38.474  22.811  1.00 72.03           C
ATOM    888  N   ALA A 124     -22.020 -37.556  21.500  1.00 56.76           N
ATOM    889  CA  ALA A 124     -23.457 -37.751  21.659  1.00 62.08           C
ATOM    890  C   ALA A 124     -23.998 -38.722  20.614  1.00 64.41           C
ATOM    891  O   ALA A 124     -23.280 -39.133  19.701  1.00 59.47           O
ATOM    892  CB  ALA A 124     -24.186 -36.420  21.576  1.00 51.82           C
ATOM    893  N   GLN A 125     -25.265 -39.093  20.756  1.00 58.65           N
ATOM    894  CA  GLN A 125     -25.908 -39.982  19.797  1.00 66.81           C
ATOM    895  C   GLN A 125     -26.154 -39.255  18.482  1.00 67.52           C
ATOM    896  O   GLN A 125     -25.851 -39.771  17.407  1.00 63.45           O
ATOM    897  CB  GLN A 125     -27.224 -40.518  20.354  1.00 81.41           C
ATOM    898  CG  GLN A 125     -27.981 -41.411  19.387  1.00 98.58           C
ATOM    899  CD  GLN A 125     -29.370 -41.751  19.882  1.00117.01           C
ATOM    900  OE1 GLN A 125     -29.812 -41.252  20.917  1.00122.68           O
ATOM    901  NE2 GLN A 125     -30.070 -42.604  19.142  1.00120.52           N
ATOM    902  N   HIS A 126     -26.709 -38.051  18.579  1.00 55.83           N
ATOM    903  CA  HIS A 126     -26.948 -37.216  17.410  1.00 51.68           C
ATOM    904  C   HIS A 126     -25.742 -36.327  17.136  1.00 51.06           C
ATOM    905  O   HIS A 126     -25.697 -35.178  17.572  1.00 55.81           O
ATOM    906  CB  HIS A 126     -28.201 -36.359  17.606  1.00 49.90           C
ATOM    907  CG  HIS A 126     -29.409 -37.142  18.013  1.00 59.09           C
ATOM    908  ND1 HIS A 126     -29.900 -38.193  17.268  1.00 65.05           N
ATOM    909  CD2 HIS A 126     -30.227 -37.027  19.086  1.00 68.33           C
ATOM    910  CE1 HIS A 126     -30.967 -38.693  17.867  1.00 68.90           C
ATOM    911  NE2 HIS A 126     -31.187 -38.002  18.971  1.00 70.70           N
ATOM    912  N   ARG A 127     -24.765 -36.868  16.417  1.00 51.72           N
ATOM    913  CA  ARG A 127     -23.545 -36.133  16.104  1.00 50.30           C
ATOM    914  C   ARG A 127     -23.804 -35.005  15.113  1.00 57.56           C
ATOM    915  O   ARG A 127     -24.427 -35.213  14.074  1.00 53.63           O
ATOM    916  CB  ARG A 127     -22.483 -37.078  15.536  1.00 58.64           C
ATOM    917  CG  ARG A 127     -22.108 -38.232  16.448  1.00 64.35           C
ATOM    918  CD  ARG A 127     -21.254 -37.771  17.617  1.00 63.02           C
ATOM    919  NE  ARG A 127     -20.731 -38.907  18.370  1.00 69.23           N
ATOM    920  CZ  ARG A 127     -19.552 -39.474  18.141  1.00 71.22           C
ATOM    921  NH1 ARG A 127     -18.763 -39.005  17.184  1.00 68.69           N
ATOM    922  NH2 ARG A 127     -19.158 -40.508  18.874  1.00 73.35           N
ATOM    923  N   CYS A 128     -23.325 -33.812  15.442  1.00 52.71           N
ATOM    924  CA  CYS A 128     -23.375 -32.690  14.515  1.00 53.51           C
ATOM    925  C   CYS A 128     -22.111 -32.689  13.661  1.00 53.60           C
ATOM    926  O   CYS A 128     -21.123 -32.039  14.003  1.00 46.72           O
ATOM    927  CB  CYS A 128     -23.517 -31.368  15.269  1.00 53.35           C
ATOM    928  SG  CYS A 128     -23.693 -29.913  14.211  1.00 57.01           S
ATOM    929  N   VAL A 129     -22.142 -33.429  12.558  1.00 56.86           N
ATOM    930  CA  VAL A 129     -20.961 -33.588  11.715  1.00 56.16           C
ATOM    931  C   VAL A 129     -20.739 -32.375  10.820  1.00 54.47           C
ATOM    932  O   VAL A 129     -19.729 -32.285  10.123  1.00 57.01           O
ATOM    933  CB  VAL A 129     -21.059 -34.850  10.835  1.00 56.70           C
ATOM    934  CG1 VAL A 129     -21.204 -36.089  11.704  1.00 52.15           C
ATOM    935  CG2 VAL A 129     -22.222 -34.731   9.861  1.00 48.54           C
ATOM    936  N   GLY A 130     -21.687 -31.444  10.844  1.00 54.06           N
ATOM    937  CA  GLY A 130     -21.581 -30.236  10.051  1.00 56.08           C
ATOM    938  C   GLY A 130     -22.569 -29.177  10.494  1.00 53.00           C
ATOM    939  O   GLY A 130     -23.657 -29.487  10.973  1.00 53.39           O
ATOM    940  N   LEU A 131     -22.182 -27.918  10.341  1.00 49.16           N
ATOM    941  CA  LEU A 131     -23.065 -26.808  10.660  1.00 48.47           C
ATOM    942  C   LEU A 131     -22.996 -25.775   9.543  1.00 49.08           C
ATOM    943  O   LEU A 131     -21.943 -25.191   9.290  1.00 47.60           O
ATOM    944  CB  LEU A 131     -22.688 -26.184  12.005  1.00 46.28           C
ATOM    945  CG  LEU A 131     -23.735 -25.346  12.749  1.00 62.27           C
ATOM    946  CD1 LEU A 131     -23.336 -25.196  14.208  1.00 61.73           C
ATOM    947  CD2 LEU A 131     -23.929 -23.977  12.117  1.00 61.78           C
ATOM    948  N   CYS A 132     -24.125 -25.550   8.880  1.00 47.88           N
ATOM    949  CA  CYS A 132     -24.172 -24.616   7.763  1.00 49.72           C
ATOM    950  C   CYS A 132     -24.953 -23.357   8.114  1.00 43.77           C
ATOM    951  O   CYS A 132     -26.056 -23.426   8.653  1.00 51.76           O
ATOM    952  CB  CYS A 132     -24.787 -25.281   6.531  1.00 56.96           C
ATOM    953  SG  CYS A 132     -24.976 -24.161   5.126  1.00 55.89           S
ATOM    954  N   ILE A 133     -24.372 -22.205   7.798  1.00 45.81           N
ATOM    955  CA  ILE A 133     -25.029 -20.931   8.042  1.00 48.54           C
ATOM    956  C   ILE A 133     -25.248 -20.165   6.743  1.00 50.95           C
ATOM    957  O   ILE A 133     -24.315 -19.972   5.964  1.00 53.18           O
ATOM    958  CB  ILE A 133     -24.212 -20.060   9.013  1.00 50.15           C
ATOM    959  CG1 ILE A 133     -24.206 -20.688  10.408  1.00 60.84           C
ATOM    960  CG2 ILE A 133     -24.773 -18.649   9.066  1.00 46.70           C
ATOM    961  CD1 ILE A 133     -23.530 -19.834  11.459  1.00 62.96           C
ATOM    962  N   GLU A 134     -26.487 -19.744   6.508  1.00 50.90           N
ATOM    963  CA  GLU A 134     -26.784 -18.840   5.405  1.00 56.96           C
ATOM    964  C   GLU A 134     -26.457 -17.415   5.815  1.00 54.60           C
ATOM    965  O   GLU A 134     -26.824 -16.979   6.905  1.00 58.11           O
ATOM    966  CB  GLU A 134     -28.252 -18.933   4.990  1.00 52.86           C
ATOM    967  CG  GLU A 134     -28.665 -20.264   4.392  1.00 72.95           C
ATOM    968  CD  GLU A 134     -30.112 -20.262   3.934  1.00 89.60           C
ATOM    969  OE1 GLU A 134     -30.832 -19.288   4.242  1.00 88.00           O
ATOM    970  OE2 GLU A 134     -30.530 -21.230   3.265  1.00 95.34           O
ATOM    971  N   THR A 135     -25.766 -16.689   4.946  1.00 53.53           N
ATOM    972  CA  THR A 135     -25.480 -15.287   5.213  1.00 59.77           C
ATOM    973  C   THR A 135     -25.374 -14.496   3.917  1.00 60.30           C
ATOM    974  O   THR A 135     -25.166 -15.063   2.843  1.00 61.62           O
ATOM    975  CB  THR A 135     -24.181 -15.113   6.023  1.00 61.09           C
ATOM    976  OG1 THR A 135     -24.079 -13.758   6.480  1.00 67.02           O
ATOM    977  CG2 THR A 135     -22.964 -15.454   5.176  1.00 53.64           C
ATOM    978  N   ARG A 136     -25.534 -13.183   4.027  1.00 62.94           N
ATOM    979  CA  ARG A 136     -25.382 -12.290   2.889  1.00 63.00           C
ATOM    980  C   ARG A 136     -23.903 -11.976   2.674  1.00 67.16           C
ATOM    981  O   ARG A 136     -23.125 -11.967   3.628  1.00 66.12           O
ATOM    982  CB  ARG A 136     -26.187 -11.005   3.108  1.00 62.87           C
ATOM    983  CG  ARG A 136     -27.675 -11.236   3.335  1.00 59.25           C
ATOM    984  CD  ARG A 136     -28.417  -9.922   3.528  1.00 64.78           C
ATOM    985  NE  ARG A 136     -29.844 -10.123   3.761  1.00 65.66           N
ATOM    986  CZ  ARG A 136     -30.721  -9.137   3.928  1.00 65.78           C
ATOM    987  NH1 ARG A 136     -30.319  -7.874   3.887  1.00 63.71           N
ATOM    988  NH2 ARG A 136     -32.001  -9.414   4.136  1.00 68.10           N
ATOM    989  N   PRO A 137     -23.506 -11.737   1.413  1.00 64.41           N
ATOM    990  CA  PRO A 137     -22.115 -11.424   1.059  1.00 59.54           C
ATOM    991  C   PRO A 137     -21.536 -10.236   1.827  1.00 66.24           C
ATOM    992  O   PRO A 137     -20.348 -10.242   2.154  1.00 68.48           O
ATOM    993  CB  PRO A 137     -22.204 -11.105  -0.435  1.00 61.09           C
ATOM    994  CG  PRO A 137     -23.372 -11.891  -0.908  1.00 60.33           C
ATOM    995  CD  PRO A 137     -24.362 -11.858   0.219  1.00 62.67           C
ATOM    996  N   ASP A 138     -22.361  -9.232   2.108  1.00 66.80           N
ATOM    997  CA  ASP A 138     -21.896  -8.044   2.818  1.00 76.92           C
ATOM    998  C   ASP A 138     -21.949  -8.232   4.335  1.00 76.70           C
ATOM    999  O   ASP A 138     -21.470  -7.385   5.090  1.00 84.40           O
ATOM   1000  CB  ASP A 138     -22.716  -6.818   2.403  1.00 83.91           C
ATOM   1001  CG  ASP A 138     -24.206  -7.022   2.583  1.00 94.03           C
ATOM   1002  OD1 ASP A 138     -24.661  -8.183   2.525  1.00 85.35           O
ATOM   1003  OD2 ASP A 138     -24.925  -6.019   2.777  1.00107.22           O
ATOM   1004  N   ILE A 139     -22.531  -9.343   4.775  1.00 70.77           N
ATOM   1005  CA  ILE A 139     -22.532  -9.699   6.189  1.00 73.27           C
ATOM   1006  C   ILE A 139     -21.699 -10.962   6.390  1.00 71.17           C
ATOM   1007  O   ILE A 139     -22.212 -12.004   6.801  1.00 72.30           O
ATOM   1008  CB  ILE A 139     -23.960  -9.928   6.726  1.00 71.77           C
ATOM   1009  CG1 ILE A 139     -24.923  -8.888   6.153  1.00 80.88           C
ATOM   1010  CG2 ILE A 139     -23.978  -9.890   8.250  1.00 68.40           C
ATOM   1011  CD1 ILE A 139     -26.350  -9.058   6.627  1.00 82.31           C
ATOM   1012  N   CYS A 140     -20.408 -10.864   6.088  1.00 71.47           N
ATOM   1013  CA  CYS A 140     -19.523 -12.018   6.154  1.00 65.85           C
ATOM   1014  C   CYS A 140     -18.069 -11.578   6.286  1.00 66.16           C
ATOM   1015  O   CYS A 140     -17.226 -11.929   5.462  1.00 62.63           O
ATOM   1016  CB  CYS A 140     -19.706 -12.897   4.914  1.00 65.83           C
ATOM   1017  SG  CYS A 140     -19.019 -14.564   5.043  1.00 68.95           S
ATOM   1018  N   GLY A 141     -17.785 -10.802   7.328  1.00 68.33           N
ATOM   1019  CA  GLY A 141     -16.442 -10.308   7.576  1.00 67.32           C
ATOM   1020  C   GLY A 141     -15.674 -11.182   8.548  1.00 62.62           C
ATOM   1021  O   GLY A 141     -16.133 -12.264   8.913  1.00 59.53           O
ATOM   1022  N   LYS A 142     -14.507 -10.707   8.973  1.00 65.99           N
ATOM   1023  CA  LYS A 142     -13.632 -11.474   9.856  1.00 70.43           C
ATOM   1024  C   LYS A 142     -14.287 -11.795  11.201  1.00 73.46           C
ATOM   1025  O   LYS A 142     -14.137 -12.902  11.723  1.00 73.30           O
ATOM   1026  CB  LYS A 142     -12.317 -10.721  10.081  1.00 70.45           C
ATOM   1027  CG  LYS A 142     -11.368 -11.407  11.050  1.00 78.56           C
ATOM   1028  CD  LYS A 142     -10.022 -10.703  11.107  1.00 79.90           C
ATOM   1029  CE  LYS A 142      -9.241 -10.900   9.819  0.00 76.06           C
ATOM   1030  NZ  LYS A 142      -8.906 -12.333   9.588  0.00 73.07           N
ATOM   1031  N   ALA A 143     -15.013 -10.827  11.753  1.00 73.40           N
ATOM   1032  CA  ALA A 143     -15.687 -11.009  13.035  1.00 76.91           C
ATOM   1033  C   ALA A 143     -16.790 -12.064  12.943  1.00 75.49           C
ATOM   1034  O   ALA A 143     -16.862 -12.982  13.771  1.00 74.60           O
ATOM   1035  CB  ALA A 143     -16.259  -9.687  13.522  1.00 78.81           C
ATOM   1036  N   GLU A 144     -17.647 -11.922  11.933  1.00 69.11           N
ATOM   1037  CA  GLU A 144     -18.722 -12.877  11.689  1.00 63.02           C
ATOM   1038  C   GLU A 144     -18.160 -14.281  11.528  1.00 64.33           C
ATOM   1039  O   GLU A 144     -18.685 -15.241  12.096  1.00 67.61           O
ATOM   1040  CB  GLU A 144     -19.526 -12.493  10.442  1.00 64.43           C
ATOM   1041  CG  GLU A 144     -20.416 -11.268  10.601  1.00 63.89           C
ATOM   1042  CD  GLU A 144     -19.652  -9.965  10.482  1.00 75.91           C
ATOM   1043  OE1 GLU A 144     -18.467 -10.002  10.091  1.00 81.55           O
ATOM   1044  OE2 GLU A 144     -20.239  -8.903  10.779  1.00 76.10           O
ATOM   1045  N   ILE A 145     -17.083 -14.389  10.758  1.00 62.67           N
ATOM   1046  CA  ILE A 145     -16.445 -15.675  10.516  1.00 67.79           C
ATOM   1047  C   ILE A 145     -15.887 -16.263  11.809  1.00 63.27           C
ATOM   1048  O   ILE A 145     -16.058 -17.450  12.070  1.00 60.74           O
ATOM   1049  CB  ILE A 145     -15.325 -15.557   9.464  1.00 71.93           C
ATOM   1050  CG1 ILE A 145     -15.934 -15.324   8.081  1.00 70.11           C
ATOM   1051  CG2 ILE A 145     -14.470 -16.812   9.444  1.00 68.98           C
ATOM   1052  CD1 ILE A 145     -14.919 -15.241   6.972  1.00 69.50           C
ATOM   1053  N   GLN A 146     -15.238 -15.435  12.623  1.00 63.60           N
ATOM   1054  CA  GLN A 146     -14.721 -15.900  13.908  1.00 63.56           C
ATOM   1055  C   GLN A 146     -15.846 -16.422  14.800  1.00 64.06           C
ATOM   1056  O   GLN A 146     -15.706 -17.469  15.449  1.00 71.55           O
ATOM   1057  CB  GLN A 146     -13.951 -14.784  14.616  1.00 73.15           C
ATOM   1058  CG  GLN A 146     -12.555 -14.557  14.056  1.00 88.95           C
ATOM   1059  CD  GLN A 146     -11.815 -13.432  14.754  1.00104.38           C
ATOM   1060  OE1 GLN A 146     -12.410 -12.426  15.140  1.00112.26           O
ATOM   1061  NE2 GLN A 146     -10.508 -13.600  14.922  1.00106.91           N
ATOM   1062  N   ARG A 147     -16.967 -15.704  14.821  1.00 63.77           N
ATOM   1063  CA  ARG A 147     -18.132 -16.171  15.567  1.00 62.54           C
ATOM   1064  C   ARG A 147     -18.621 -17.511  15.027  1.00 62.15           C
ATOM   1065  O   ARG A 147     -18.993 -18.398  15.798  1.00 65.17           O
ATOM   1066  CB  ARG A 147     -19.264 -15.144  15.522  1.00 66.48           C
ATOM   1067  CG  ARG A 147     -19.050 -13.954  16.437  1.00 79.79           C
ATOM   1068  CD  ARG A 147     -20.354 -13.233  16.723  1.00 79.85           C
ATOM   1069  NE  ARG A 147     -20.997 -12.752  15.505  1.00 72.76           N
ATOM   1070  CZ  ARG A 147     -20.718 -11.590  14.925  1.00 79.15           C
ATOM   1071  NH1 ARG A 147     -19.799 -10.789  15.447  1.00 77.29           N
ATOM   1072  NH2 ARG A 147     -21.355 -11.229  13.819  1.00 85.18           N
HETATM 1073  N   MSE A 148     -18.609 -17.662  13.705  1.00 56.76           N
HETATM 1074  CA  MSE A 148     -19.027 -18.918  13.089  1.00 53.20           C
HETATM 1075  C   MSE A 148     -18.102 -20.067  13.485  1.00 44.83           C
HETATM 1076  O   MSE A 148     -18.555 -21.195  13.679  1.00 53.05           O
HETATM 1077  CB  MSE A 148     -19.084 -18.780  11.567  1.00 56.55           C
HETATM 1078  CG  MSE A 148     -20.217 -17.892  11.087  1.00 59.73           C
HETATM 1079 SE   MSE A 148     -20.597 -18.083   9.188  1.00 71.20          Se
HETATM 1080  CE  MSE A 148     -18.945 -17.366   8.458  1.00 47.93           C
ATOM   1081  N   ILE A 149     -16.810 -19.775  13.609  1.00 48.66           N
ATOM   1082  CA  ILE A 149     -15.853 -20.750  14.118  1.00 59.53           C
ATOM   1083  C   ILE A 149     -16.231 -21.114  15.548  1.00 65.72           C
ATOM   1084  O   ILE A 149     -16.179 -22.282  15.935  1.00 67.97           O
ATOM   1085  CB  ILE A 149     -14.405 -20.222  14.093  1.00 64.82           C
ATOM   1086  CG1 ILE A 149     -14.030 -19.721  12.699  1.00 73.40           C
ATOM   1087  CG2 ILE A 149     -13.433 -21.304  14.548  1.00 60.75           C
ATOM   1088  CD1 ILE A 149     -14.116 -20.774  11.631  1.00 72.85           C
ATOM   1089  N   ASP A 150     -16.621 -20.109  16.329  1.00 62.19           N
ATOM   1090  CA  ASP A 150     -17.069 -20.353  17.699  1.00 66.87           C
ATOM   1091  C   ASP A 150     -18.311 -21.239  17.744  1.00 66.75           C
ATOM   1092  O   ASP A 150     -18.523 -21.976  18.707  1.00 62.39           O
ATOM   1093  CB  ASP A 150     -17.351 -19.033  18.421  1.00 61.87           C
ATOM   1094  CG  ASP A 150     -16.088 -18.339  18.881  1.00 74.94           C
ATOM   1095  OD1 ASP A 150     -15.081 -19.038  19.122  1.00 84.47           O
ATOM   1096  OD2 ASP A 150     -16.102 -17.097  19.008  1.00 87.95           O
ATOM   1097  N   PHE A 151     -19.129 -21.163  16.698  1.00 53.65           N
ATOM   1098  CA  PHE A 151     -20.364 -21.941  16.634  1.00 53.97           C
ATOM   1099  C   PHE A 151     -20.101 -23.389  16.238  1.00 55.45           C
ATOM   1100  O   PHE A 151     -20.912 -24.276  16.508  1.00 52.70           O
ATOM   1101  CB  PHE A 151     -21.345 -21.307  15.645  1.00 52.92           C
ATOM   1102  CG  PHE A 151     -21.785 -19.924  16.029  1.00 58.56           C
ATOM   1103  CD1 PHE A 151     -21.714 -19.501  17.346  1.00 59.72           C
ATOM   1104  CD2 PHE A 151     -22.271 -19.046  15.073  1.00 57.19           C
ATOM   1105  CE1 PHE A 151     -22.115 -18.230  17.704  1.00 58.62           C
ATOM   1106  CE2 PHE A 151     -22.676 -17.770  15.425  1.00 62.28           C
ATOM   1107  CZ  PHE A 151     -22.597 -17.363  16.744  1.00 58.64           C
ATOM   1108  N   GLY A 152     -18.964 -23.622  15.592  1.00 58.75           N
ATOM   1109  CA  GLY A 152     -18.657 -24.929  15.046  1.00 54.82           C
ATOM   1110  C   GLY A 152     -19.145 -25.043  13.612  1.00 54.74           C
ATOM   1111  O   GLY A 152     -19.559 -26.114  13.168  1.00 51.25           O
ATOM   1112  N   THR A 153     -19.100 -23.927  12.891  1.00 53.16           N
ATOM   1113  CA  THR A 153     -19.545 -23.879  11.501  1.00 49.32           C
ATOM   1114  C   THR A 153     -18.552 -24.581  10.574  1.00 50.27           C
ATOM   1115  O   THR A 153     -17.339 -24.473  10.754  1.00 58.69           O
ATOM   1116  CB  THR A 153     -19.740 -22.422  11.028  1.00 55.51           C
ATOM   1117  OG1 THR A 153     -20.577 -21.723  11.958  1.00 51.36           O
ATOM   1118  CG2 THR A 153     -20.373 -22.375   9.644  1.00 54.94           C
ATOM   1119  N   THR A 154     -19.072 -25.300   9.584  1.00 54.91           N
ATOM   1120  CA  THR A 154     -18.230 -26.011   8.630  1.00 56.40           C
ATOM   1121  C   THR A 154     -18.516 -25.588   7.192  1.00 57.96           C
ATOM   1122  O   THR A 154     -17.699 -25.805   6.298  1.00 58.89           O
ATOM   1123  CB  THR A 154     -18.422 -27.533   8.740  1.00 55.06           C
ATOM   1124  OG1 THR A 154     -19.781 -27.866   8.431  1.00 54.32           O
ATOM   1125  CG2 THR A 154     -18.095 -28.011  10.144  1.00 58.85           C
ATOM   1126  N   ARG A 155     -19.680 -24.986   6.974  1.00 54.21           N
ATOM   1127  CA  ARG A 155     -20.112 -24.627   5.629  1.00 59.62           C
ATOM   1128  C   ARG A 155     -20.893 -23.318   5.627  1.00 57.74           C
ATOM   1129  O   ARG A 155     -21.638 -23.030   6.562  1.00 55.06           O
ATOM   1130  CB  ARG A 155     -20.959 -25.755   5.031  1.00 56.49           C
ATOM   1131  CG  ARG A 155     -21.348 -25.550   3.577  1.00 60.10           C
ATOM   1132  CD  ARG A 155     -21.866 -26.839   2.957  1.00 63.58           C
ATOM   1133  NE  ARG A 155     -23.096 -27.314   3.587  1.00 49.07           N
ATOM   1134  CZ  ARG A 155     -24.316 -26.975   3.182  1.00 59.23           C
ATOM   1135  NH1 ARG A 155     -24.469 -26.152   2.152  1.00 59.84           N
ATOM   1136  NH2 ARG A 155     -25.383 -27.453   3.807  1.00 55.57           N
ATOM   1137  N   VAL A 156     -20.711 -22.522   4.578  1.00 52.16           N
ATOM   1138  CA  VAL A 156     -21.436 -21.265   4.438  1.00 47.87           C
ATOM   1139  C   VAL A 156     -22.115 -21.165   3.074  1.00 56.70           C
ATOM   1140  O   VAL A 156     -21.500 -21.430   2.040  1.00 58.37           O
ATOM   1141  CB  VAL A 156     -20.503 -20.053   4.636  1.00 55.13           C
ATOM   1142  CG1 VAL A 156     -21.222 -18.758   4.287  1.00 53.20           C
ATOM   1143  CG2 VAL A 156     -19.985 -20.009   6.067  1.00 59.41           C
ATOM   1144  N   GLU A 157     -23.394 -20.800   3.084  1.00 53.36           N
ATOM   1145  CA  GLU A 157     -24.122 -20.513   1.855  1.00 60.12           C
ATOM   1146  C   GLU A 157     -24.271 -19.005   1.677  1.00 57.30           C
ATOM   1147  O   GLU A 157     -25.072 -18.373   2.364  1.00 53.03           O
ATOM   1148  CB  GLU A 157     -25.501 -21.180   1.866  1.00 60.54           C
ATOM   1149  CG  GLU A 157     -25.468 -22.701   1.805  1.00 69.44           C
ATOM   1150  CD  GLU A 157     -26.853 -23.318   1.694  1.00 83.94           C
ATOM   1151  OE1 GLU A 157     -27.847 -22.562   1.678  1.00 80.04           O
ATOM   1152  OE2 GLU A 157     -26.948 -24.562   1.620  1.00 89.52           O
"""

def test_1():
  pdb_inp = iotbx.pdb.input(source_info=None, lines = pdb_str)
  model = mmtbx.model.manager(model_input = pdb_inp, log = null_out())
  model.process(make_restraints=True)
  model.get_restraints_manager()
  for cp in [True, False]:
    for fc in [True, False]:
      if not cp and fc:
        # incompatible parameters
        continue
      stats = mmtbx.model.statistics.geometry(
          model=model,
          condensed_probe=cp,
          fast_clash=fc)
      out = StringIO()
      stats.show(log=out)
      val = out.getvalue()
      exp = """
GEOMETRY RESTRAINTS LIBRARY: GEOSTD + MONOMER LIBRARY + CDL V1.2
DEVIATIONS FROM IDEAL VALUES - RMSD, RMSZ FOR BONDS AND ANGLES.
  BOND      :  0.004   0.020   1174  Z= 0.292
  ANGLE     :  0.908   4.674   1594  Z= 0.671
  CHIRALITY :  0.038   0.125    186
  PLANARITY :  0.003   0.018    205
  DIHEDRAL  : 11.055  85.166    440
  MIN NONBONDED DISTANCE : 2.457

MOLPROBITY STATISTICS.
  ALL-ATOM CLASHSCORE : 3.50
  RAMACHANDRAN PLOT:
    OUTLIERS :  0.00 %
    ALLOWED  :  2.68 %
    FAVORED  : 97.32 %
  ROTAMER:
    OUTLIERS :  2.36 %
    ALLOWED  :  0.79 %
    FAVORED  : 96.85 %
  CBETA DEVIATIONS :  0.00 %
  PEPTIDE PLANE:
    CIS-PROLINE     : 0.00 %
    CIS-GENERAL     : 0.00 %
    TWISTED PROLINE : 0.00 %
    TWISTED GENERAL : 0.00 %

RAMA-Z (RAMACHANDRAN PLOT Z-SCORE):
INTERPRETATION: BAD |RAMA-Z| > 3; SUSPICIOUS 2 < |RAMA-Z| < 3; GOOD |RAMA-Z| < 2.
SCORES FOR WHOLE/HELIX/SHEET/LOOP ARE SCALED INDEPENDENTLY;
THEREFORE, THE VALUES ARE NOT RELATED IN A SIMPLE MANNER.
  WHOLE: -0.62 (0.62), RESIDUES: 149
  HELIX:  0.29 (0.58), RESIDUES: 67
  SHEET: -1.83 (0.89), RESIDUES: 20
  LOOP : -0.50 (0.74), RESIDUES: 62

MAX DEVIATION FROM PLANES:
   TYPE  MAXDEV  MEANDEV LINEINFILE
   ARG   0.002   0.000   ARG A  49
   TYR   0.008   0.002   TYR A  40
   PHE   0.008   0.001   PHE A  87
   HIS   0.001   0.000   HIS A 126
"""
  val = [l.strip() for l in val.splitlines() if l.strip() != '']
  exp = [l.strip() for l in exp.splitlines() if l.strip() != '']
  assert val == exp

if __name__ == '__main__':
  test_1()
  print ('OK')
