/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


//
// $Id: ValidTypes.H,v 1.3 2001/10/17 17:53:33 lijewski Exp $
//
#ifndef _ValidType_
#define _ValidType_

#include <iostream>

#include "REAL.H"
#include "aString.H"
#include "ArrayLim.H"

#include "StatTypes.H"

// ============================================================
// ===== Routine:  ValidType(aString reqType) 
// ============================================================
//
// This routine checks the type specified in reqType against those defined
// in the structure StatsTypes to make sure that reqType is valid.  It then
// returns the integer index in StatsTypes[] to the defined type corresponding 
// to reqType.  If reqType is not valid, the code is aborted.
//

int
ValidType (aString reqType)
{
  int whichType = -1;
  bool foundType = false;

  for (int nDefined = 0; nDefined < NumStatsTypes; ++nDefined) 
  {
    if (reqType == StatsTypes[nDefined].name)
    {
        foundType = true;
        whichType = nDefined;
        break;
    }
  }

  if (!foundType)
  {
    cerr << "Invalid statistics type:  " << reqType << '\n';
    BoxLib::Abort();
  }

  return whichType;
}
#endif
