/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _PROB_F_H_
#define _PROB_F_H_

/*
** $Id: PROB_F.H,v 1.9 2002/04/26 22:10:02 lijewski Exp $
*/

#ifdef BL_LANG_FORT
#    define FORT_INITDATA    initdata
#    define FORT_DENFILL     denfill
#    define FORT_ADVFILL     advfill
#    define FORT_XVELFILL    xvelfill
#    define FORT_YVELFILL    yvelfill
#    define FORT_ZVELFILL    zvelfill
#    define FORT_PRESFILL    presfill
#    define FORT_TEMPFILL    tempfill
#    define FORT_DIVUFILL    divufill
#    define FORT_DSDTFILL    dsdtfill
#    define FORT_DENERROR    denerror
#    define FORT_ADVERROR    adverror
#    define FORT_TEMPERROR   temperror
#    define FORT_MVERROR     mverror
#else
#  if  defined(BL_FORT_USE_UPPERCASE)
#    define FORT_INITDATA    INITDATA
#    define FORT_DENFILL     DENFILL
#    define FORT_ADVFILL     ADVFILL
#    define FORT_XVELFILL    XVELFILL
#    define FORT_YVELFILL    YVELFILL
#    define FORT_ZVELFILL    ZVELFILL
#    define FORT_PRESFILL    PRESFILL
#    define FORT_TEMPFILL    TEMPFILL
#    define FORT_DIVUFILL    DIVUFILL
#    define FORT_DSDTFILL    DSDTFILL
#    define FORT_DENERROR    DENERROR
#    define FORT_ADVERROR    ADVERROR
#    define FORT_TEMPERROR   TEMPERROR
#    define FORT_MVERROR     MVERROR
#  elif defined(BL_FORT_USE_LOWERCASE)
#    define FORT_INITDATA    initdata
#    define FORT_DENFILL     denfill
#    define FORT_ADVFILL     advfill
#    define FORT_XVELFILL    xvelfill
#    define FORT_YVELFILL    yvelfill
#    define FORT_ZVELFILL    zvelfill
#    define FORT_PRESFILL    presfill
#    define FORT_TEMPFILL    tempfill
#    define FORT_DIVUFILL    divufill
#    define FORT_DSDTFILL    dsdtfill
#    define FORT_DENERROR    denerror
#    define FORT_ADVERROR    adverror
#    define FORT_TEMPERROR   temperror
#    define FORT_MVERROR     mverror
#  elif defined(BL_FORT_USE_UNDERSCORE)
#    define FORT_INITDATA    initdata_
#    define FORT_DENFILL     denfill_
#    define FORT_ADVFILL     advfill_
#    define FORT_XVELFILL    xvelfill_
#    define FORT_YVELFILL    yvelfill_
#    define FORT_ZVELFILL    zvelfill_
#    define FORT_PRESFILL    presfill_
#    define FORT_TEMPFILL    tempfill_
#    define FORT_DIVUFILL    divufill_
#    define FORT_DSDTFILL    dsdtfill_
#    define FORT_DENERROR    denerror_
#    define FORT_ADVERROR    adverror_
#    define FORT_TEMPERROR   temperror_
#    define FORT_MVERROR     mverror_
#  endif

#include "ArrayLim.H"

  extern "C" {

     void FORT_INITDATA (const int* level, const Real* time,
                         const int* lo, const int* hi,
                         const int* nscal,
                         Real* vel, Real* scal, 
                         ARLIM_P(s_lo), ARLIM_P(s_hi),
                         Real* press,
                         ARLIM_P(p_lo), ARLIM_P(p_hi),
                         const Real* dx,
                         const Real* xlo, const Real* xhi);

     void FORT_DENFILL  (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);

     void FORT_ADVFILL  (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi), 
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);

     void FORT_XVELFILL (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);

     void FORT_YVELFILL (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);

#if (BL_SPACEDIM == 3)
     void FORT_ZVELFILL (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);
#endif
     void FORT_PRESFILL (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);

     void FORT_TEMPFILL (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi), 
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);

     void FORT_DIVUFILL (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);

     void FORT_DSDTFILL (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                         const int* dom_lo, const int* dom_hi,
                         const Real* dx, const Real* grd_lo,
                         const Real* time, const int* bc);

     void FORT_DENERROR  (int* tag, ARLIM_P(tlo), ARLIM_P(thi),
                          const int* tagval, const int* clearval,
                          Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                          const int* lo, const int* hi, const int* nvar,
                          const int* domain_lo, const int* domain_hi,
                          const Real* dx, const Real* xlo,
                          const Real* prob_lo, const Real* time,
                          const int* level);
 
     void FORT_ADVERROR  (int* tag, ARLIM_P(tlo), ARLIM_P(thi),
                          const int* tagval, const int* clearval,
                          Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                          const int* lo, const int* hi, const int* nvar,
                          const int* domain_lo, const int* domain_hi,
                          const Real* dx, const Real* xlo,
                          const Real* prob_lo, const Real* time,
                          const int* level);
 
     void FORT_TEMPERROR  (int* tag, ARLIM_P(tlo), ARLIM_P(thi),
                           const int* tagval, const int* clearval,
                           Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                           const int* lo, const int* hi, const int* nvar,
                           const int* domain_lo, const int* domain_hi,
                           const Real* dx, const Real* xlo,
                           const Real* prob_lo, const Real* time,
                           const int* level);

     void FORT_MVERROR   (int* tag, ARLIM_P(tlo), ARLIM_P(thi),
                          const int* tagval, const int* clearval,
                          Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                          const int* lo, const int* hi, const int* nvar,
                          const int* domain_lo, const int* domain_hi,
                          const Real* dx, const Real* xlo,
                          const Real* prob_lo, const Real* time,
                          const int* level);

  }
#endif
#endif /*_PROB_F_H_*/
