######################################################################
# qmake file for macos
# Contributed by J. Ralls, June 2011
#
# 1) run 'qmake -project -r' to create .pro skeleton
# 2) edit to match other settings from old .pro file
# 3) run 'qmake -spec macx-xcode' to create a xcodeproj file 
#
######################################################################

TEMPLATE = app
TARGET = cb2bib
DEPENDPATH += . src src/c2b src/c2b/qtregexp src/qtsingleapplication/src
INCLUDEPATH += . src src/c2b src/qtsingleapplication/src src/c2b/qtregexp

# Input
HEADERS += src/bookmarkPlugin.h \
           src/c2b.h \
           src/c2bAnnote.h \
           src/c2bBibHighlighter.h \
           src/c2bBibMenu.h \
           src/c2bBibParser.h \
           src/c2bBibPreparserLog.h \
           src/c2bCiter.h \
           src/c2bCiterModel.h \
           src/c2bCiterView.h \
           src/c2bClipboard.h \
           src/c2bClipEdit.h \
           src/c2bColors.h \
           src/c2bComboBox.h \
           src/c2bConfigure.h \
           src/c2bConfigureFR.h \
           src/c2bConsole.h \
           src/c2bCoreCiter.h \
           src/c2bEditor.h \
           src/c2bExport.h \
           src/c2bExportDialog.h \
           src/c2bFileDialog.h \
           src/c2bHighlighter.h \
           src/c2bIdLineEdit.h \
           src/c2bLineEdit.h \
           src/c2bNetworkQuery.h \
           src/c2bNetworkQueryInfo.h \
           src/c2bPdfImport.h \
           src/c2bPostprocess.h \
           src/c2bReferenceList.h \
           src/c2bREHighlighter.h \
           src/c2bRLWebSearchSettings.h \
           src/c2bSaveRegExp.h \
           src/c2bSaveREHighlighter.h \
           src/c2bSearchInFiles.h \
           src/c2bSearchInFilesPattern.h \
           src/c2bSettings.h \
           src/c2bShortcutPushButton.h \
           src/c2bShortcutWidget.h \
           src/c2bTests.h \
           src/c2bTextBrowser.h \
           src/c2bTextEdit.h \
           src/c2bUpdateMetadata.h \
           src/c2bUtils.h \
           src/c2bWebBrowser.h \
           src/cb2Bib.h \
           src/findDialog.h \
           src/c2b/approximatePattern.h \
           src/c2b/authorString.h \
           src/c2b/bibExtractor.h \
           src/c2b/bibParser.h \
           src/c2b/bibPreparser.h \
           src/c2b/bibReference.h \
           src/c2b/bibSearcher.h \
           src/c2b/cb2bib_parameters.h \
           src/c2b/cb2bib_utilities.h \
           src/c2b/compositePattern.h \
           src/c2b/coreBibParser.h \
           src/c2b/document.h \
           src/c2b/documentCache.h \
           src/c2b/documentContents.h \
           src/c2b/heuristicBibParser.h \
           src/c2b/idMaker.h \
           src/c2b/journalDB.h \
           src/c2b/metadataParser.h \
           src/c2b/monthDB.h \
           src/c2b/network.h \
           src/c2b/networkQuery.h \
           src/c2b/preprocess.h \
           src/c2b/pubmedXml.h \
           src/c2b/searchPattern.h \
           src/c2b/settings.h \
           src/c2b/substringMatcher.h \
           src/c2b/texParser.h \
           src/c2b/texToHtml.h \
           src/c2b/triads.h \
           src/c2b/wordMatcher.h \
           src/c2b/wordPattern.h \
           src/c2b/qtregexp/eqregexp.h \
           src/qtsingleapplication/src/qtlocalpeer.h \
           src/qtsingleapplication/src/qtlockedfile.h \
           src/qtsingleapplication/src/qtsingleapplication.h \
           src/qtsingleapplication/src/qtsinglecoreapplication.h \
           src/qtsingleapplication/src/qtlockedfile.cpp \
           src/qtsingleapplication/src/qtlockedfile_win.cpp \
           src/qtsingleapplication/src/qtlockedfile_unix.cpp
FORMS += src/c2bCiter.ui \
         src/c2bConfigure.ui \
         src/c2bConfigureFR.ui \
         src/c2bEditor.ui \
         src/c2bExportDialog.ui \
         src/c2bLogWidget.ui \
         src/c2bPdfImport.ui \
         src/c2bReferenceList.ui \
         src/c2bRLWebSearchSettings.ui \
         src/c2bSaveRegExp.ui \
         src/c2bSearchInFiles.ui \
         src/c2bSearchInFilesPattern.ui \
         src/c2bSearchInFilesPatternEdit.ui \
         src/c2bShortcutWidget.ui \
         src/cb2Bib.ui \
         src/findDialog.ui \
         src/proxyDialog.ui
SOURCES += src/bookmarkPlugin.cpp \
           src/c2b.cpp \
           src/c2bAnnote.cpp \
           src/c2bBibHighlighter.cpp \
           src/c2bBibMenu.cpp \
           src/c2bBibParser.cpp \
           src/c2bBibPreparserLog.cpp \
           src/c2bCiter.cpp \
           src/c2bCiterModel.cpp \
           src/c2bCiterView.cpp \
           src/c2bClipboard.cpp \
           src/c2bClipEdit.cpp \
           src/c2bColors.cpp \
           src/c2bComboBox.cpp \
           src/c2bConfigure.cpp \
           src/c2bConfigureFR.cpp \
           src/c2bConsole.cpp \
           src/c2bCoreCiter.cpp \
           src/c2bEditor.cpp \
           src/c2bExport.cpp \
           src/c2bExportDialog.cpp \
           src/c2bFileDialog.cpp \
           src/c2bHighlighter.cpp \
           src/c2bIdLineEdit.cpp \
           src/c2bLineEdit.cpp \
           src/c2bNetworkQuery.cpp \
           src/c2bNetworkQueryInfo.cpp \
           src/c2bPdfImport.cpp \
           src/c2bPostprocess.cpp \
           src/c2bReferenceList.cpp \
           src/c2bREHighlighter.cpp \
           src/c2bRLWebSearchSettings.cpp \
           src/c2bSaveRegExp.cpp \
           src/c2bSaveREHighlighter.cpp \
           src/c2bSearchInFiles.cpp \
           src/c2bSearchInFilesPattern.cpp \
           src/c2bSettings.cpp \
           src/c2bShortcutPushButton.cpp \
           src/c2bShortcutWidget.cpp \
           src/c2bTests.cpp \
           src/c2bTextBrowser.cpp \
           src/c2bTextEdit.cpp \
           src/c2bUpdateMetadata.cpp \
           src/c2bUtils.cpp \
           src/c2bWebBrowser.cpp \
           src/cb2Bib.cpp \
           src/findDialog.cpp \
           src/main.cpp \
           src/c2b/approximatePattern.cpp \
           src/c2b/authorString.cpp \
           src/c2b/bibExtractor.cpp \
           src/c2b/bibParser.cpp \
           src/c2b/bibPreparser.cpp \
           src/c2b/bibSearcher.cpp \
           src/c2b/cb2bib_utilities.cpp \
           src/c2b/compositePattern.cpp \
           src/c2b/coreBibParser.cpp \
           src/c2b/document.cpp \
           src/c2b/documentCache.cpp \
           src/c2b/heuristicBibParser.cpp \
           src/c2b/idMaker.cpp \
           src/c2b/journalDB.cpp \
           src/c2b/metadataParser.cpp \
           src/c2b/monthDB.cpp \
           src/c2b/network.cpp \
           src/c2b/networkQuery.cpp \
           src/c2b/preprocess.cpp \
           src/c2b/pubmedXml.cpp \
           src/c2b/searchPattern.cpp \
           src/c2b/settings.cpp \
           src/c2b/substringMatcher.cpp \
           src/c2b/texParser.cpp \
           src/c2b/texToHtml.cpp \
           src/c2b/triads.cpp \
           src/c2b/wordMatcher.cpp \
           src/c2b/wordPattern.cpp \
           src/c2b/qtregexp/eqregexp.cpp \
           src/qtsingleapplication/src/qtlocalpeer.cpp \
           src/qtsingleapplication/src/qtlockedfile.cpp \
           src/qtsingleapplication/src/qtlockedfile_unix.cpp \
           src/qtsingleapplication/src/qtlockedfile_win.cpp \
           src/qtsingleapplication/src/qtsingleapplication.cpp \
           src/qtsingleapplication/src/qtsinglecoreapplication.cpp

win32 {
     SOURCES += src/win/main.cpp
     RC_FILE = cb2bib.rc
     DEPEND += src/win 
}

unix:!macx {
    !disable_cbpoll {
       HEADERS += src/clipboardPoll.h
       SOURCES += src/clipboardPoll.cpp
       DEFINES += C2B_USE_CBPOLL
    }
    INSTALLS += target script cb2bibdata icons desktop
    target.path = /usr/bin
    script.files += c2bscripts/c2bimport c2bscripts/c2bciter
    script.path = /usr/bin
    script.extra = chmod +x c2bscripts/c2bimport; chmod +x c2bscripts/c2bciter
    desktop.files += c2bscripts/cb2bib.desktop c2bscripts/c2bciter.desktop c2bscripts/c2bimport.desktop
    desktop.path = /usr/share/applications
    icons.files += src/icons/cb2bib.png
    icons.path = /usr/share/pixmaps
    cb2bibdata.files += AUTHORS COPYRIGHT LICENSE CHANGELOG data c2btools testPDFImport
    cb2bibdata.path = /usr/share/cb2bib
}
macx {
    ICON = src/icons/cb2bib.icns
    INSTALLS += target script cb2bibdata
    script.files += c2bscripts/c2bimport c2bscripts/c2bciter
    script.extra = chmod +x c2bscripts/c2bimport; chmod +x c2bscripts/c2bciter
    cb2bibdata.files += AUTHORS COPYRIGHT LICENSE CHANGELOG data c2btools testPDFImport
    cb2bibdata.path = Contents/Resources
    QMAKE_BUNDLE_DATA += script cb2bibdata
#   Set this directory if third party tools, like pdftotext are packaged
#   INSTALLS += externtools
#   externtools.files +=
#   externtools.path = c2bExternTools
#   Set Library data
#   QMAKE_BUNDLE_DATA += externtools

}

RESOURCES += src/cb2bib.qrc src/c2b/c2blib.qrc
TEMPLATE = app
QT += network webkit
CONFIG +=
!macx {
    LIBS += -lc2b
    LIBPATH += .
}
INCLUDEPATH += c2b .
DEFINES += C2B_USE_QMAKE
QTVERSION = $$[QT_VERSION]
contains(QTVERSION, 4\.3.*) {
    message(Using Qt < 4.4 --> Added xml libs)
    QT += xml
} else {
    exists($$[QT_INSTALL_HEADERS]/QtWebKit/qwebview.h) {
        message(Using Qt > 4.4 --> Added webkit libs)
        QT += webkit
        CONFIG += use_webkit
    }
}
