#!/usr/bin/env python3
"""
Cylinder form factor in DWBA with detector resolution function applied
"""
import bornagain as ba
from bornagain import ba_plot as bp, deg, nm


def get_sample():
    from bornagain import std_samples
    return std_samples.cylinders()


def get_simulation(sample):
    beam = ba.Beam(1e9, 0.1*nm, 0.2*deg)
    detector = ba.SphericalDetector(<%= sm ? 11 : 100 %>, 2*deg, 1*deg, 1*deg)
    detector.setResolutionFunction(
        ba.ResolutionFunction2DGaussian(0.02*deg, 0.02*deg))
    return ba.ScatteringSimulation(beam, sample, detector)


if __name__ == '__main__':
    sample = get_sample()
    simulation = get_simulation(sample)
    result = simulation.simulate()
    bp.plot_simulation_result(result)
