//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Sample/Lattice2DItemCatalog.cpp
//! @brief     Implements class Lattice2DItemCatalog
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Sample/Lattice2DItemCatalog.h"
#include "Base/Util/Assert.h"
#include "GUI/Model/Sample/Lattice2DItems.h"

Lattice2DItemCatalog::CatalogedType* Lattice2DItemCatalog::create(Type type)
{
    switch (type) {
    case Type::Basic:
        return new BasicLattice2DItem();
    case Type::Square:
        return new SquareLattice2DItem();
    case Type::Hexagonal:
        return new HexagonalLattice2DItem();
    default:
        ASSERT(false);
    }
}

QVector<Lattice2DItemCatalog::Type> Lattice2DItemCatalog::types()
{
    return {Type::Basic, Type::Square, Type::Hexagonal};
}

UiInfo Lattice2DItemCatalog::uiInfo(Type type)
{
    switch (type) {
    case Type::Basic:
        return {"Basic", "Two dimensional lattice", ""};
    case Type::Square:
        return {"Square", "", ""};
    case Type::Hexagonal:
        return {"Hexagonal", "", ""};
    default:
        ASSERT(false);
    }
}

Lattice2DItemCatalog::Type Lattice2DItemCatalog::type(const CatalogedType* item)
{
    ASSERT(item);

    if (dynamic_cast<const BasicLattice2DItem*>(item))
        return Type::Basic;
    if (dynamic_cast<const SquareLattice2DItem*>(item))
        return Type::Square;
    if (dynamic_cast<const HexagonalLattice2DItem*>(item))
        return Type::Hexagonal;

    ASSERT(false);
}
