#ifndef PROGBOB_AVRISP_H
#define PROGBOB_AVRISP_H

#include <string>
#include <vector>
#include "programmer-base.h"

class ProgBob_AVRISP_priv;

class ProgBob_AVRISP : public ProgrammerBase {
    private:
        ProgBob_AVRISP_priv * priv;
    public:
        ProgBob_AVRISP(progress_fn callback);
        virtual ~ProgBob_AVRISP();
        void connect(const std::string & port);
        void configure(const std::string & part);
        std::string getStatus();
        void reset();
        void erase();
        void program(const std::string & segment, unsigned int startAddress, const std::vector<uint8_t> & memory);
        void verify(const std::string & segment, unsigned int startAddress, const std::vector<uint8_t> & memory);
        void startProgramMode(const std::string & mode, bool erase);
        void leaveProgramMode();
        void signalError();
        void checkSignature();
};





#endif
