#include "Bdef.h"

#if (INTFACE == C_CALL)
double Cdcputime00()
#else
double dcputime00_()
#endif
{
#ifdef UseTIMES
#include <sys/times.h>
#include <unistd.h>
   struct tms ts;
   static double ClockTick=0.0;

   if (ClockTick == 0.0) ClockTick = (double) sysconf(_SC_CLK_TCK);
   if ( times(&ts) == -1 )
      BlacsWarn(-1, __LINE__, __FILE__, "times not working");
   return( (double) ts.tms_utime / ClockTick );
#else
#include <sys/time.h>
#include <sys/resource.h>
   struct rusage ruse;
   if ( getrusage(RUSAGE_SELF, &ruse) ) /* info for cputime */
      BlacsWarn(-1, __LINE__, __FILE__, "getrusage not working");
   return( (double)(ruse.ru_utime.tv_sec+ruse.ru_utime.tv_usec / 1000000.0) );
#endif
}
