/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _BOOK_H
#define _BOOK_H

#include <iostream>
#include <libintl.h>

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)

using namespace std;

class Book {
public:
  Book();
  virtual ~Book();
  
  /* When compared with other books, compare /only/ the "originator" fields. */
  bool operator ==(Book book);
  
  /* Defines the book author. */
  void set_author(string author);
  
  /* Returns the book author. */
  string get_author(void);
  
  /* Defines the book title. */
  void set_title(string title);
  
  /* Returns the book title. */
  string get_title(void);
  
  /* Defines the book ISBN. */
  void set_isbn(string isbn);
  
  /* Returns the book ISBN. */
  string get_isbn(void);
  
  /* Defines the book category. */
  void set_category(string category);
  
  /* Returns the book category. */
  string get_category(void);
  
  /* Defines the book summary. */
  void set_summary(string summary);
  
  /* Returns the book summary. */
  string get_summary(void);
  
  /* Returns the first 'len' characters of the book summary. */
  string get_summary(unsigned int len);
  
  /* Defines the book review. */
  void set_review(string review);
  
  /* Returns the book review. */
  string get_review(void);
  
  /* Defines the book rating. */
  void set_rating(int rating);
  
  /* Returns the book rating. */
  int get_rating(void);
  
  /* Defines the book read date. */
  void set_readdate(unsigned int year, unsigned int month, unsigned int day);
  
  /* Defines the book read date. */
  void set_readdate_string(string date);
  
  /* Returns the book read date. */
  tm get_readdate(void);
  
  /* Returns the book read date as a string. */
  string get_readdate_string(void);
  
  /* Defines the book filename. */
  void set_filename(string filename);
  
  /* Returns the book filename. */
  string get_filename(void);
  
  /* Returns the originator (a unique identifier for the book, which is stable
   * for the complete runtime (only). */
  Book* get_originator(void);
  
protected:
  Book*     originator;
  string    author;
  string    title;
  string    isbn;
  string    category;
  string    summary;
  string    review;
  int       rating;
  struct tm readdate;
  string    filename;
};

#endif /* _BOOK_H */
