/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import yuku.alkitab.util.Ari;
import yuku.alkitabconverter.util.Rec;

public class TextDb {
    public static final String TAG = TextDb.class.getSimpleName();
    TreeMap<Integer, VerseState> map = new TreeMap();

    public TextDb() {
    }

    public TextDb(List<Rec> recs) {
        for (Rec rec : recs) {
            int key = Ari.encode(rec.book_1 - 1, rec.chapter_1, rec.verse_1);
            VerseState value = new VerseState();
            value.text = rec.text;
            this.map.put(key, value);
        }
    }

    public String append(int bookId, int chapter_1, int verse_1, String s, int currentIndent) {
        return this.append(Ari.encode(bookId, chapter_1, verse_1), s, currentIndent);
    }

    public String append(int bookId, int chapter_1, int verse_1, String s, int currentIndent, String separatorWhenExisting) {
        return this.append(Ari.encode(bookId, chapter_1, verse_1), s, currentIndent, separatorWhenExisting);
    }

    public String append(int ari, String s, int currentIndent) {
        return this.append(ari, s, currentIndent, null);
    }

    public String append(int ari, String text, int currentIndent, String separatorWhenExisting) {
        VerseState as = this.map.get(ari);
        boolean isNew = false;
        if (as == null) {
            as = new VerseState();
            as.text = "";
            this.map.put(ari, as);
            isNew = true;
        }
        boolean writtenParaMarker = false;
        if (currentIndent != -1) {
            if (currentIndent == -2) {
                as.text = as.text + "@^";
            } else {
                if (currentIndent < 0 || currentIndent > 4) {
                    throw new RuntimeException("menjorok ngaco: " + currentIndent);
                }
                as.text = as.text + "@" + String.valueOf(currentIndent);
            }
            writtenParaMarker = true;
        }
        if (!isNew && separatorWhenExisting != null) {
            as.text = as.text + separatorWhenExisting;
        }
        as.text = writtenParaMarker ? as.text + TextDb.leftSpaceTrim(text) : as.text + text;
        while (as.text.startsWith(" ")) {
            as.text = as.text.substring(1);
        }
        if (as.text.contains("@") && !as.text.startsWith("@@")) {
            as.text = "@@" + as.text;
        }
        return as.text;
    }

    private static String leftSpaceTrim(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ') continue;
            return s.substring(i);
        }
        return s;
    }

    public void normalize() {
        TreeSet<Integer> keys = new TreeSet<Integer>(this.map.keySet());
        int last_bookId = -1;
        int last_chapter_1 = 0;
        int last_verse_1 = 0;
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int ari = (Integer)iterator.next();
            int bookId = Ari.toBook(ari);
            int chapter_1 = Ari.toChapter(ari);
            int verse_1 = Ari.toVerse(ari);
            if (bookId != last_bookId) {
                if (chapter_1 != 1 || verse_1 != 1) {
                    throw new RuntimeException("at " + bookId + " " + chapter_1 + " " + verse_1 + ": " + " new book does not start from 1:1");
                }
                last_bookId = bookId;
                last_chapter_1 = chapter_1;
                last_verse_1 = verse_1;
                continue;
            }
            if (chapter_1 == last_chapter_1) {
                if (verse_1 != last_verse_1 + 1) {
                    System.out.println("at " + bookId + " " + chapter_1 + " " + verse_1 + ": " + " skipped after " + last_bookId + " " + last_chapter_1 + " " + last_verse_1);
                    System.out.println("Adding empty verses:");
                    for (int a = last_verse_1 + 1; a < verse_1; ++a) {
                        System.out.println("  at " + bookId + " " + chapter_1 + " " + a + ": " + " (blank)");
                        this.append(bookId, chapter_1, a, "", 0);
                    }
                }
            } else if (chapter_1 == last_chapter_1 + 1) {
                if (verse_1 != 1) {
                    throw new RuntimeException("at " + bookId + " " + chapter_1 + " " + verse_1 + ": " + " verse_1 is not 1");
                }
            } else {
                throw new RuntimeException("at " + bookId + " " + chapter_1 + " " + verse_1 + ": " + " so wrong! it's after " + last_bookId + " " + last_chapter_1 + " " + last_verse_1);
            }
            last_bookId = bookId;
            last_chapter_1 = chapter_1;
            last_verse_1 = verse_1;
        }
        System.out.println("normalize done");
    }

    public void removeEmptyVerses() {
        for (Map.Entry<Integer, VerseState> entry : this.map.entrySet()) {
            VerseState vs = entry.getValue();
            if (!"@@@0".equals(vs.text)) continue;
            vs.text = "";
        }
    }

    public void dump(PrintStream ps) {
        ps.println("TOTAL text: " + this.map.size());
        for (Map.Entry<Integer, VerseState> e : this.map.entrySet()) {
            ps.printf("%d\t%d\t%d\t%s%n", Ari.toBook(e.getKey()) + 1, Ari.toChapter(e.getKey()), Ari.toVerse(e.getKey()), e.getValue().text);
        }
    }

    public void dump() {
        this.dump(System.out);
    }

    public int size() {
        return this.map.size();
    }

    public List<Rec> toRecList() {
        ArrayList<Rec> res = new ArrayList<Rec>();
        for (Map.Entry<Integer, VerseState> e : this.map.entrySet()) {
            Rec rec = new Rec();
            int ari = e.getKey();
            rec.book_1 = Ari.toBook(ari) + 1;
            rec.chapter_1 = Ari.toChapter(ari);
            rec.verse_1 = Ari.toVerse(ari);
            rec.text = e.getValue().text;
            res.add(rec);
        }
        return res;
    }

    public void processEach(TextProcessor textProcessor) {
        for (Map.Entry<Integer, VerseState> e : this.map.entrySet()) {
            textProcessor.process(e.getKey(), e.getValue());
        }
    }

    public int getBookCount() {
        LinkedHashSet<Integer> bookIds = new LinkedHashSet<Integer>();
        for (Map.Entry<Integer, VerseState> e : this.map.entrySet()) {
            int bookId = Ari.toBook(e.getKey());
            bookIds.add(bookId);
        }
        return bookIds.size();
    }

    public int[] getBookIds() {
        TreeSet<Integer> bookIds = new TreeSet<Integer>();
        for (Map.Entry<Integer, VerseState> e : this.map.entrySet()) {
            int bookId = Ari.toBook(e.getKey());
            bookIds.add(bookId);
        }
        int[] res = new int[bookIds.size()];
        int c = 0;
        for (Integer bookId : bookIds) {
            res[c++] = bookId;
        }
        return res;
    }

    public int getChapterCountForBook(int bookId) {
        int maxChapter = 0;
        for (Map.Entry<Integer, VerseState> e : this.map.entrySet()) {
            int chapter_1;
            int ari = e.getKey();
            if (Ari.toBook(ari) != bookId || (chapter_1 = Ari.toChapter(ari)) <= maxChapter) continue;
            maxChapter = chapter_1;
        }
        return maxChapter;
    }

    public int getVerseCountForBookChapter(int bookId, int chapter_1) {
        int maxVerse = 0;
        for (Map.Entry<Integer, VerseState> e : this.map.entrySet()) {
            int verse_1;
            int ari = e.getKey();
            if (Ari.toBook(ari) != bookId || Ari.toChapter(ari) != chapter_1 || (verse_1 = Ari.toVerse(ari)) <= maxVerse) continue;
            maxVerse = verse_1;
        }
        return maxVerse;
    }

    public String getVerseText(int bookId, int chapter_1, int verse_1) {
        return this.map.get((Object)Integer.valueOf((int)Ari.encode((int)bookId, (int)chapter_1, (int)verse_1))).text;
    }

    public static class VerseState {
        public String text;
    }

    public static interface TextProcessor {
        public void process(int var1, VerseState var2);
    }
}

