/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.yes2.io;

import yuku.alkitab.io.Utf8Decoder;
import yuku.bintex.BintexReader;

public interface Yes2VerseTextDecoder {
    public String[] separateIntoVerses(BintexReader var1, int var2, boolean var3) throws Exception;

    public String makeIntoSingleString(BintexReader var1, int var2, boolean var3) throws Exception;

    public static class Utf8
    implements Yes2VerseTextDecoder {
        ThreadLocal<byte[]> verseBuf_ = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[4000];
            }
        };

        @Override
        public String[] separateIntoVerses(BintexReader br, int verse_count, boolean lowercased) throws Exception {
            byte[] verseBuf = this.verseBuf_.get();
            String[] res = new String[verse_count];
            for (int i = 0; i < verse_count; ++i) {
                int verse_len = br.readVarUint();
                if (verse_len > verseBuf.length) {
                    verseBuf = new byte[verse_len + 1000];
                    this.verseBuf_.set(verseBuf);
                }
                br.readRaw(verseBuf, 0, verse_len);
                String verse = lowercased ? Utf8Decoder.toStringLowerCase(verseBuf, 0, verse_len) : Utf8Decoder.toString(verseBuf, 0, verse_len);
                res[i] = verse;
            }
            return res;
        }

        @Override
        public String makeIntoSingleString(BintexReader br, int verse_count, boolean lowercased) throws Exception {
            return Utf8Decoder.toStringFromVersesWithPrependedLengths(br, verse_count, lowercased);
        }
    }

    public static class Ascii
    implements Yes2VerseTextDecoder {
        ThreadLocal<byte[]> verseBuf_ = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[4000];
            }
        };

        @Override
        public String[] separateIntoVerses(BintexReader br, int verse_count, boolean lowercased) throws Exception {
            byte[] verseBuf = this.verseBuf_.get();
            String[] res = new String[verse_count];
            for (int i = 0; i < verse_count; ++i) {
                String verse;
                int verse_len = br.readVarUint();
                br.readRaw(verseBuf, 0, verse_len);
                if (lowercased) {
                    for (int j = 0; j < verse_len; ++j) {
                        byte b = verseBuf[j];
                        if (b > 90 || b < 65) continue;
                        int n = i;
                        verseBuf[n] = (byte)(verseBuf[n] | 0x20);
                    }
                }
                res[i] = verse = new String(verseBuf, 0, 0, verse_len);
            }
            return res;
        }

        @Override
        public String makeIntoSingleString(BintexReader br, int verse_count, boolean lowercased) throws Exception {
            String[] verses;
            StringBuilder sb = new StringBuilder();
            for (String verse : verses = this.separateIntoVerses(br, verse_count, lowercased)) {
                sb.append(verse).append('\n');
            }
            return sb.toString();
        }
    }
}

