#!/bin/sh -e
# Repackaging script to be called by Uscan

echo "Repackaging ..."
TMP="../"
PKG="`dpkg-parsechangelog|sed 's/^Source: //p;d'`_$2+repack.orig"


echo "Extracting tarball ..."
echo "$3 -->>  $2"
tar xzf "$3" -C "$TMP"
cd "$TMP"

echo "Rename source dir"
ls -l
mv Argyll_V$2 argyll_$2

echo "Removing unwanted stuff ..."
cd argyll_$2
ls -l
rm -f yajl/yajl_test.exe yajl/yajl_test.obj
rm -fr usb/bin
rm -fr jpeg
rm -fr tiff
rm -fr zlib
rm -fr png
chmod -R -x+X *
ls -l
#cd ..

echo "Creating repack tarball ..."
tar -caf "../argyll_$2+repack.orig.tar.xz" *

cd ..
echo "Clean tmp dir ..."
rm -rf argyll_$2

echo "Clean uscan files ..."
rm -rf Argyll_V$2_src.zip
#rm -rf argyll_$2.orig.tar.gz

echo "Repackaged tarball created"



	unzip ../Argyll_V${VERSION}_src.zip  -d ../
	mv ../Argyll_V${VERSION} ../argyll_${VERSION}
	rm -f ../argyll_${VERSION}/yajl/yajl_test.exe ../argyll_${VERSION}/yajl/yajl_test.obj
	rm -fr ../argyll_${VERSION}/usb/bin
	rm -fr ../argyll_${VERSION}/jpeg
	rm -fr ../argyll_${VERSION}/tiff
	rm -fr ../argyll_${VERSION}/zlib
	rm -fr ../argyll_${VERSION}/png
	chmod -R -x+X ../argyll_${VERSION}/*
	tar cJf ../argyll_${VERSION}+repack.orig.tar.xz ../argyll_${VERSION}
	rm -fr ../argyll_${VERSION} ../Argyll_V${VERSION}_src.zip 
