/*
 * Copyright 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package benchmarks;
import com.google.caliper.BeforeExperiment;

/**
 * This file is script-generated by ImtConflictBenchmarkGen.py.
 * It measures the performance impact of conflicts in interface method tables.
 * Run `python ImtConflictBenchmarkGen.py > ImtConflictBenchmark.java` to regenerate.
 *
 * Each interface has 64 methods, which is the current size of an IMT. C0 implements
 * one interface, C1 implements two, C2 implements three, and so on. The intent
 * is that C0 has no conflicts in its IMT, C1 has depth-2 conflicts in
 * its IMT, C2 has depth-3 conflicts, etc. This is currently guaranteed by
 * the fact that we hash interface methods by taking their method index modulo 64.
 * (Note that a "conflict depth" of 1 means no conflict at all.)
 */
public class ImtConflictBenchmark {
    @BeforeExperiment
    public void setup() {
        C0 c0 = new C0();
        callF0(c0);
        C1 c1 = new C1();
        callF0(c1);
        callF43(c1);
        C2 c2 = new C2();
        callF0(c2);
        callF43(c2);
        callF86(c2);
        C3 c3 = new C3();
        callF0(c3);
        callF43(c3);
        callF86(c3);
        callF129(c3);
        C4 c4 = new C4();
        callF0(c4);
        callF43(c4);
        callF86(c4);
        callF129(c4);
        callF172(c4);
        C5 c5 = new C5();
        callF0(c5);
        callF43(c5);
        callF86(c5);
        callF129(c5);
        callF172(c5);
        callF215(c5);
        C6 c6 = new C6();
        callF0(c6);
        callF43(c6);
        callF86(c6);
        callF129(c6);
        callF172(c6);
        callF215(c6);
        callF258(c6);
        C7 c7 = new C7();
        callF0(c7);
        callF43(c7);
        callF86(c7);
        callF129(c7);
        callF172(c7);
        callF215(c7);
        callF258(c7);
        callF301(c7);
        C8 c8 = new C8();
        callF0(c8);
        callF43(c8);
        callF86(c8);
        callF129(c8);
        callF172(c8);
        callF215(c8);
        callF258(c8);
        callF301(c8);
        callF344(c8);
        C9 c9 = new C9();
        callF0(c9);
        callF43(c9);
        callF86(c9);
        callF129(c9);
        callF172(c9);
        callF215(c9);
        callF258(c9);
        callF301(c9);
        callF344(c9);
        callF387(c9);
        C10 c10 = new C10();
        callF0(c10);
        callF43(c10);
        callF86(c10);
        callF129(c10);
        callF172(c10);
        callF215(c10);
        callF258(c10);
        callF301(c10);
        callF344(c10);
        callF387(c10);
        callF430(c10);
        C11 c11 = new C11();
        callF0(c11);
        callF43(c11);
        callF86(c11);
        callF129(c11);
        callF172(c11);
        callF215(c11);
        callF258(c11);
        callF301(c11);
        callF344(c11);
        callF387(c11);
        callF430(c11);
        callF473(c11);
        C12 c12 = new C12();
        callF0(c12);
        callF43(c12);
        callF86(c12);
        callF129(c12);
        callF172(c12);
        callF215(c12);
        callF258(c12);
        callF301(c12);
        callF344(c12);
        callF387(c12);
        callF430(c12);
        callF473(c12);
        callF516(c12);
        C13 c13 = new C13();
        callF0(c13);
        callF43(c13);
        callF86(c13);
        callF129(c13);
        callF172(c13);
        callF215(c13);
        callF258(c13);
        callF301(c13);
        callF344(c13);
        callF387(c13);
        callF430(c13);
        callF473(c13);
        callF516(c13);
        callF559(c13);
        C14 c14 = new C14();
        callF0(c14);
        callF43(c14);
        callF86(c14);
        callF129(c14);
        callF172(c14);
        callF215(c14);
        callF258(c14);
        callF301(c14);
        callF344(c14);
        callF387(c14);
        callF430(c14);
        callF473(c14);
        callF516(c14);
        callF559(c14);
        callF602(c14);
        C15 c15 = new C15();
        callF0(c15);
        callF43(c15);
        callF86(c15);
        callF129(c15);
        callF172(c15);
        callF215(c15);
        callF258(c15);
        callF301(c15);
        callF344(c15);
        callF387(c15);
        callF430(c15);
        callF473(c15);
        callF516(c15);
        callF559(c15);
        callF602(c15);
        callF645(c15);
        C16 c16 = new C16();
        callF0(c16);
        callF43(c16);
        callF86(c16);
        callF129(c16);
        callF172(c16);
        callF215(c16);
        callF258(c16);
        callF301(c16);
        callF344(c16);
        callF387(c16);
        callF430(c16);
        callF473(c16);
        callF516(c16);
        callF559(c16);
        callF602(c16);
        callF645(c16);
        callF688(c16);
        C17 c17 = new C17();
        callF0(c17);
        callF43(c17);
        callF86(c17);
        callF129(c17);
        callF172(c17);
        callF215(c17);
        callF258(c17);
        callF301(c17);
        callF344(c17);
        callF387(c17);
        callF430(c17);
        callF473(c17);
        callF516(c17);
        callF559(c17);
        callF602(c17);
        callF645(c17);
        callF688(c17);
        callF731(c17);
        C18 c18 = new C18();
        callF0(c18);
        callF43(c18);
        callF86(c18);
        callF129(c18);
        callF172(c18);
        callF215(c18);
        callF258(c18);
        callF301(c18);
        callF344(c18);
        callF387(c18);
        callF430(c18);
        callF473(c18);
        callF516(c18);
        callF559(c18);
        callF602(c18);
        callF645(c18);
        callF688(c18);
        callF731(c18);
        callF774(c18);
        C19 c19 = new C19();
        callF0(c19);
        callF43(c19);
        callF86(c19);
        callF129(c19);
        callF172(c19);
        callF215(c19);
        callF258(c19);
        callF301(c19);
        callF344(c19);
        callF387(c19);
        callF430(c19);
        callF473(c19);
        callF516(c19);
        callF559(c19);
        callF602(c19);
        callF645(c19);
        callF688(c19);
        callF731(c19);
        callF774(c19);
        callF817(c19);
    }
    public void timeConflictDepth01(int nreps) {
        C0 c0 = new C0();
        for (int i = 0; i < nreps; i++) {
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
            callF0(c0);
        }
    }
    public void timeConflictDepth02(int nreps) {
        C1 c1 = new C1();
        for (int i = 0; i < nreps; i++) {
            callF0(c1);
            callF43(c1);
            callF0(c1);
            callF43(c1);
            callF0(c1);
            callF43(c1);
            callF0(c1);
            callF43(c1);
            callF0(c1);
            callF43(c1);
            callF0(c1);
            callF43(c1);
            callF0(c1);
            callF43(c1);
            callF0(c1);
            callF43(c1);
            callF0(c1);
            callF43(c1);
            callF0(c1);
            callF43(c1);
        }
    }
    public void timeConflictDepth03(int nreps) {
        C2 c2 = new C2();
        for (int i = 0; i < nreps; i++) {
            callF0(c2);
            callF43(c2);
            callF86(c2);
            callF0(c2);
            callF43(c2);
            callF86(c2);
            callF0(c2);
            callF43(c2);
            callF86(c2);
            callF0(c2);
            callF43(c2);
            callF86(c2);
            callF0(c2);
            callF43(c2);
            callF86(c2);
            callF0(c2);
            callF43(c2);
            callF86(c2);
            callF0(c2);
            callF43(c2);
        }
    }
    public void timeConflictDepth04(int nreps) {
        C3 c3 = new C3();
        for (int i = 0; i < nreps; i++) {
            callF0(c3);
            callF43(c3);
            callF86(c3);
            callF129(c3);
            callF0(c3);
            callF43(c3);
            callF86(c3);
            callF129(c3);
            callF0(c3);
            callF43(c3);
            callF86(c3);
            callF129(c3);
            callF0(c3);
            callF43(c3);
            callF86(c3);
            callF129(c3);
            callF0(c3);
            callF43(c3);
            callF86(c3);
            callF129(c3);
        }
    }
    public void timeConflictDepth05(int nreps) {
        C4 c4 = new C4();
        for (int i = 0; i < nreps; i++) {
            callF0(c4);
            callF43(c4);
            callF86(c4);
            callF129(c4);
            callF172(c4);
            callF0(c4);
            callF43(c4);
            callF86(c4);
            callF129(c4);
            callF172(c4);
            callF0(c4);
            callF43(c4);
            callF86(c4);
            callF129(c4);
            callF172(c4);
            callF0(c4);
            callF43(c4);
            callF86(c4);
            callF129(c4);
            callF172(c4);
        }
    }
    public void timeConflictDepth06(int nreps) {
        C5 c5 = new C5();
        for (int i = 0; i < nreps; i++) {
            callF0(c5);
            callF43(c5);
            callF86(c5);
            callF129(c5);
            callF172(c5);
            callF215(c5);
            callF0(c5);
            callF43(c5);
            callF86(c5);
            callF129(c5);
            callF172(c5);
            callF215(c5);
            callF0(c5);
            callF43(c5);
            callF86(c5);
            callF129(c5);
            callF172(c5);
            callF215(c5);
            callF0(c5);
            callF43(c5);
        }
    }
    public void timeConflictDepth07(int nreps) {
        C6 c6 = new C6();
        for (int i = 0; i < nreps; i++) {
            callF0(c6);
            callF43(c6);
            callF86(c6);
            callF129(c6);
            callF172(c6);
            callF215(c6);
            callF258(c6);
            callF0(c6);
            callF43(c6);
            callF86(c6);
            callF129(c6);
            callF172(c6);
            callF215(c6);
            callF258(c6);
            callF0(c6);
            callF43(c6);
            callF86(c6);
            callF129(c6);
            callF172(c6);
            callF215(c6);
        }
    }
    public void timeConflictDepth08(int nreps) {
        C7 c7 = new C7();
        for (int i = 0; i < nreps; i++) {
            callF0(c7);
            callF43(c7);
            callF86(c7);
            callF129(c7);
            callF172(c7);
            callF215(c7);
            callF258(c7);
            callF301(c7);
            callF0(c7);
            callF43(c7);
            callF86(c7);
            callF129(c7);
            callF172(c7);
            callF215(c7);
            callF258(c7);
            callF301(c7);
            callF0(c7);
            callF43(c7);
            callF86(c7);
            callF129(c7);
        }
    }
    public void timeConflictDepth09(int nreps) {
        C8 c8 = new C8();
        for (int i = 0; i < nreps; i++) {
            callF0(c8);
            callF43(c8);
            callF86(c8);
            callF129(c8);
            callF172(c8);
            callF215(c8);
            callF258(c8);
            callF301(c8);
            callF344(c8);
            callF0(c8);
            callF43(c8);
            callF86(c8);
            callF129(c8);
            callF172(c8);
            callF215(c8);
            callF258(c8);
            callF301(c8);
            callF344(c8);
            callF0(c8);
            callF43(c8);
        }
    }
    public void timeConflictDepth10(int nreps) {
        C9 c9 = new C9();
        for (int i = 0; i < nreps; i++) {
            callF0(c9);
            callF43(c9);
            callF86(c9);
            callF129(c9);
            callF172(c9);
            callF215(c9);
            callF258(c9);
            callF301(c9);
            callF344(c9);
            callF387(c9);
            callF0(c9);
            callF43(c9);
            callF86(c9);
            callF129(c9);
            callF172(c9);
            callF215(c9);
            callF258(c9);
            callF301(c9);
            callF344(c9);
            callF387(c9);
        }
    }
    public void timeConflictDepth11(int nreps) {
        C10 c10 = new C10();
        for (int i = 0; i < nreps; i++) {
            callF0(c10);
            callF43(c10);
            callF86(c10);
            callF129(c10);
            callF172(c10);
            callF215(c10);
            callF258(c10);
            callF301(c10);
            callF344(c10);
            callF387(c10);
            callF430(c10);
            callF0(c10);
            callF43(c10);
            callF86(c10);
            callF129(c10);
            callF172(c10);
            callF215(c10);
            callF258(c10);
            callF301(c10);
            callF344(c10);
        }
    }
    public void timeConflictDepth12(int nreps) {
        C11 c11 = new C11();
        for (int i = 0; i < nreps; i++) {
            callF0(c11);
            callF43(c11);
            callF86(c11);
            callF129(c11);
            callF172(c11);
            callF215(c11);
            callF258(c11);
            callF301(c11);
            callF344(c11);
            callF387(c11);
            callF430(c11);
            callF473(c11);
            callF0(c11);
            callF43(c11);
            callF86(c11);
            callF129(c11);
            callF172(c11);
            callF215(c11);
            callF258(c11);
            callF301(c11);
        }
    }
    public void timeConflictDepth13(int nreps) {
        C12 c12 = new C12();
        for (int i = 0; i < nreps; i++) {
            callF0(c12);
            callF43(c12);
            callF86(c12);
            callF129(c12);
            callF172(c12);
            callF215(c12);
            callF258(c12);
            callF301(c12);
            callF344(c12);
            callF387(c12);
            callF430(c12);
            callF473(c12);
            callF516(c12);
            callF0(c12);
            callF43(c12);
            callF86(c12);
            callF129(c12);
            callF172(c12);
            callF215(c12);
            callF258(c12);
        }
    }
    public void timeConflictDepth14(int nreps) {
        C13 c13 = new C13();
        for (int i = 0; i < nreps; i++) {
            callF0(c13);
            callF43(c13);
            callF86(c13);
            callF129(c13);
            callF172(c13);
            callF215(c13);
            callF258(c13);
            callF301(c13);
            callF344(c13);
            callF387(c13);
            callF430(c13);
            callF473(c13);
            callF516(c13);
            callF559(c13);
            callF0(c13);
            callF43(c13);
            callF86(c13);
            callF129(c13);
            callF172(c13);
            callF215(c13);
        }
    }
    public void timeConflictDepth15(int nreps) {
        C14 c14 = new C14();
        for (int i = 0; i < nreps; i++) {
            callF0(c14);
            callF43(c14);
            callF86(c14);
            callF129(c14);
            callF172(c14);
            callF215(c14);
            callF258(c14);
            callF301(c14);
            callF344(c14);
            callF387(c14);
            callF430(c14);
            callF473(c14);
            callF516(c14);
            callF559(c14);
            callF602(c14);
            callF0(c14);
            callF43(c14);
            callF86(c14);
            callF129(c14);
            callF172(c14);
        }
    }
    public void timeConflictDepth16(int nreps) {
        C15 c15 = new C15();
        for (int i = 0; i < nreps; i++) {
            callF0(c15);
            callF43(c15);
            callF86(c15);
            callF129(c15);
            callF172(c15);
            callF215(c15);
            callF258(c15);
            callF301(c15);
            callF344(c15);
            callF387(c15);
            callF430(c15);
            callF473(c15);
            callF516(c15);
            callF559(c15);
            callF602(c15);
            callF645(c15);
            callF0(c15);
            callF43(c15);
            callF86(c15);
            callF129(c15);
        }
    }
    public void timeConflictDepth17(int nreps) {
        C16 c16 = new C16();
        for (int i = 0; i < nreps; i++) {
            callF0(c16);
            callF43(c16);
            callF86(c16);
            callF129(c16);
            callF172(c16);
            callF215(c16);
            callF258(c16);
            callF301(c16);
            callF344(c16);
            callF387(c16);
            callF430(c16);
            callF473(c16);
            callF516(c16);
            callF559(c16);
            callF602(c16);
            callF645(c16);
            callF688(c16);
            callF0(c16);
            callF43(c16);
            callF86(c16);
        }
    }
    public void timeConflictDepth18(int nreps) {
        C17 c17 = new C17();
        for (int i = 0; i < nreps; i++) {
            callF0(c17);
            callF43(c17);
            callF86(c17);
            callF129(c17);
            callF172(c17);
            callF215(c17);
            callF258(c17);
            callF301(c17);
            callF344(c17);
            callF387(c17);
            callF430(c17);
            callF473(c17);
            callF516(c17);
            callF559(c17);
            callF602(c17);
            callF645(c17);
            callF688(c17);
            callF731(c17);
            callF0(c17);
            callF43(c17);
        }
    }
    public void timeConflictDepth19(int nreps) {
        C18 c18 = new C18();
        for (int i = 0; i < nreps; i++) {
            callF0(c18);
            callF43(c18);
            callF86(c18);
            callF129(c18);
            callF172(c18);
            callF215(c18);
            callF258(c18);
            callF301(c18);
            callF344(c18);
            callF387(c18);
            callF430(c18);
            callF473(c18);
            callF516(c18);
            callF559(c18);
            callF602(c18);
            callF645(c18);
            callF688(c18);
            callF731(c18);
            callF774(c18);
            callF0(c18);
        }
    }
    public void timeConflictDepth20(int nreps) {
        C19 c19 = new C19();
        for (int i = 0; i < nreps; i++) {
            callF0(c19);
            callF43(c19);
            callF86(c19);
            callF129(c19);
            callF172(c19);
            callF215(c19);
            callF258(c19);
            callF301(c19);
            callF344(c19);
            callF387(c19);
            callF430(c19);
            callF473(c19);
            callF516(c19);
            callF559(c19);
            callF602(c19);
            callF645(c19);
            callF688(c19);
            callF731(c19);
            callF774(c19);
            callF817(c19);
        }
    }
    public void callF0(I0 i) { i.f0(); }
    public void callF43(I1 i) { i.f43(); }
    public void callF86(I2 i) { i.f86(); }
    public void callF129(I3 i) { i.f129(); }
    public void callF172(I4 i) { i.f172(); }
    public void callF215(I5 i) { i.f215(); }
    public void callF258(I6 i) { i.f258(); }
    public void callF301(I7 i) { i.f301(); }
    public void callF344(I8 i) { i.f344(); }
    public void callF387(I9 i) { i.f387(); }
    public void callF430(I10 i) { i.f430(); }
    public void callF473(I11 i) { i.f473(); }
    public void callF516(I12 i) { i.f516(); }
    public void callF559(I13 i) { i.f559(); }
    public void callF602(I14 i) { i.f602(); }
    public void callF645(I15 i) { i.f645(); }
    public void callF688(I16 i) { i.f688(); }
    public void callF731(I17 i) { i.f731(); }
    public void callF774(I18 i) { i.f774(); }
    public void callF817(I19 i) { i.f817(); }
    static class C0 implements I0 {}
    static class C1 implements I0, I1 {}
    static class C2 implements I0, I1, I2 {}
    static class C3 implements I0, I1, I2, I3 {}
    static class C4 implements I0, I1, I2, I3, I4 {}
    static class C5 implements I0, I1, I2, I3, I4, I5 {}
    static class C6 implements I0, I1, I2, I3, I4, I5, I6 {}
    static class C7 implements I0, I1, I2, I3, I4, I5, I6, I7 {}
    static class C8 implements I0, I1, I2, I3, I4, I5, I6, I7, I8 {}
    static class C9 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9 {}
    static class C10 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10 {}
    static class C11 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11 {}
    static class C12 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12 {}
    static class C13 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13 {}
    static class C14 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14 {}
    static class C15 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15 {}
    static class C16 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16 {}
    static class C17 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17 {}
    static class C18 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18 {}
    static class C19 implements I0, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19 {}
    static interface I0 {
        default void f0() {}
        default void f1() {}
        default void f2() {}
        default void f3() {}
        default void f4() {}
        default void f5() {}
        default void f6() {}
        default void f7() {}
        default void f8() {}
        default void f9() {}
        default void f10() {}
        default void f11() {}
        default void f12() {}
        default void f13() {}
        default void f14() {}
        default void f15() {}
        default void f16() {}
        default void f17() {}
        default void f18() {}
        default void f19() {}
        default void f20() {}
        default void f21() {}
        default void f22() {}
        default void f23() {}
        default void f24() {}
        default void f25() {}
        default void f26() {}
        default void f27() {}
        default void f28() {}
        default void f29() {}
        default void f30() {}
        default void f31() {}
        default void f32() {}
        default void f33() {}
        default void f34() {}
        default void f35() {}
        default void f36() {}
        default void f37() {}
        default void f38() {}
        default void f39() {}
        default void f40() {}
        default void f41() {}
        default void f42() {}
    }
    static interface I1 {
        default void f43() {}
        default void f44() {}
        default void f45() {}
        default void f46() {}
        default void f47() {}
        default void f48() {}
        default void f49() {}
        default void f50() {}
        default void f51() {}
        default void f52() {}
        default void f53() {}
        default void f54() {}
        default void f55() {}
        default void f56() {}
        default void f57() {}
        default void f58() {}
        default void f59() {}
        default void f60() {}
        default void f61() {}
        default void f62() {}
        default void f63() {}
        default void f64() {}
        default void f65() {}
        default void f66() {}
        default void f67() {}
        default void f68() {}
        default void f69() {}
        default void f70() {}
        default void f71() {}
        default void f72() {}
        default void f73() {}
        default void f74() {}
        default void f75() {}
        default void f76() {}
        default void f77() {}
        default void f78() {}
        default void f79() {}
        default void f80() {}
        default void f81() {}
        default void f82() {}
        default void f83() {}
        default void f84() {}
        default void f85() {}
    }
    static interface I2 {
        default void f86() {}
        default void f87() {}
        default void f88() {}
        default void f89() {}
        default void f90() {}
        default void f91() {}
        default void f92() {}
        default void f93() {}
        default void f94() {}
        default void f95() {}
        default void f96() {}
        default void f97() {}
        default void f98() {}
        default void f99() {}
        default void f100() {}
        default void f101() {}
        default void f102() {}
        default void f103() {}
        default void f104() {}
        default void f105() {}
        default void f106() {}
        default void f107() {}
        default void f108() {}
        default void f109() {}
        default void f110() {}
        default void f111() {}
        default void f112() {}
        default void f113() {}
        default void f114() {}
        default void f115() {}
        default void f116() {}
        default void f117() {}
        default void f118() {}
        default void f119() {}
        default void f120() {}
        default void f121() {}
        default void f122() {}
        default void f123() {}
        default void f124() {}
        default void f125() {}
        default void f126() {}
        default void f127() {}
        default void f128() {}
    }
    static interface I3 {
        default void f129() {}
        default void f130() {}
        default void f131() {}
        default void f132() {}
        default void f133() {}
        default void f134() {}
        default void f135() {}
        default void f136() {}
        default void f137() {}
        default void f138() {}
        default void f139() {}
        default void f140() {}
        default void f141() {}
        default void f142() {}
        default void f143() {}
        default void f144() {}
        default void f145() {}
        default void f146() {}
        default void f147() {}
        default void f148() {}
        default void f149() {}
        default void f150() {}
        default void f151() {}
        default void f152() {}
        default void f153() {}
        default void f154() {}
        default void f155() {}
        default void f156() {}
        default void f157() {}
        default void f158() {}
        default void f159() {}
        default void f160() {}
        default void f161() {}
        default void f162() {}
        default void f163() {}
        default void f164() {}
        default void f165() {}
        default void f166() {}
        default void f167() {}
        default void f168() {}
        default void f169() {}
        default void f170() {}
        default void f171() {}
    }
    static interface I4 {
        default void f172() {}
        default void f173() {}
        default void f174() {}
        default void f175() {}
        default void f176() {}
        default void f177() {}
        default void f178() {}
        default void f179() {}
        default void f180() {}
        default void f181() {}
        default void f182() {}
        default void f183() {}
        default void f184() {}
        default void f185() {}
        default void f186() {}
        default void f187() {}
        default void f188() {}
        default void f189() {}
        default void f190() {}
        default void f191() {}
        default void f192() {}
        default void f193() {}
        default void f194() {}
        default void f195() {}
        default void f196() {}
        default void f197() {}
        default void f198() {}
        default void f199() {}
        default void f200() {}
        default void f201() {}
        default void f202() {}
        default void f203() {}
        default void f204() {}
        default void f205() {}
        default void f206() {}
        default void f207() {}
        default void f208() {}
        default void f209() {}
        default void f210() {}
        default void f211() {}
        default void f212() {}
        default void f213() {}
        default void f214() {}
    }
    static interface I5 {
        default void f215() {}
        default void f216() {}
        default void f217() {}
        default void f218() {}
        default void f219() {}
        default void f220() {}
        default void f221() {}
        default void f222() {}
        default void f223() {}
        default void f224() {}
        default void f225() {}
        default void f226() {}
        default void f227() {}
        default void f228() {}
        default void f229() {}
        default void f230() {}
        default void f231() {}
        default void f232() {}
        default void f233() {}
        default void f234() {}
        default void f235() {}
        default void f236() {}
        default void f237() {}
        default void f238() {}
        default void f239() {}
        default void f240() {}
        default void f241() {}
        default void f242() {}
        default void f243() {}
        default void f244() {}
        default void f245() {}
        default void f246() {}
        default void f247() {}
        default void f248() {}
        default void f249() {}
        default void f250() {}
        default void f251() {}
        default void f252() {}
        default void f253() {}
        default void f254() {}
        default void f255() {}
        default void f256() {}
        default void f257() {}
    }
    static interface I6 {
        default void f258() {}
        default void f259() {}
        default void f260() {}
        default void f261() {}
        default void f262() {}
        default void f263() {}
        default void f264() {}
        default void f265() {}
        default void f266() {}
        default void f267() {}
        default void f268() {}
        default void f269() {}
        default void f270() {}
        default void f271() {}
        default void f272() {}
        default void f273() {}
        default void f274() {}
        default void f275() {}
        default void f276() {}
        default void f277() {}
        default void f278() {}
        default void f279() {}
        default void f280() {}
        default void f281() {}
        default void f282() {}
        default void f283() {}
        default void f284() {}
        default void f285() {}
        default void f286() {}
        default void f287() {}
        default void f288() {}
        default void f289() {}
        default void f290() {}
        default void f291() {}
        default void f292() {}
        default void f293() {}
        default void f294() {}
        default void f295() {}
        default void f296() {}
        default void f297() {}
        default void f298() {}
        default void f299() {}
        default void f300() {}
    }
    static interface I7 {
        default void f301() {}
        default void f302() {}
        default void f303() {}
        default void f304() {}
        default void f305() {}
        default void f306() {}
        default void f307() {}
        default void f308() {}
        default void f309() {}
        default void f310() {}
        default void f311() {}
        default void f312() {}
        default void f313() {}
        default void f314() {}
        default void f315() {}
        default void f316() {}
        default void f317() {}
        default void f318() {}
        default void f319() {}
        default void f320() {}
        default void f321() {}
        default void f322() {}
        default void f323() {}
        default void f324() {}
        default void f325() {}
        default void f326() {}
        default void f327() {}
        default void f328() {}
        default void f329() {}
        default void f330() {}
        default void f331() {}
        default void f332() {}
        default void f333() {}
        default void f334() {}
        default void f335() {}
        default void f336() {}
        default void f337() {}
        default void f338() {}
        default void f339() {}
        default void f340() {}
        default void f341() {}
        default void f342() {}
        default void f343() {}
    }
    static interface I8 {
        default void f344() {}
        default void f345() {}
        default void f346() {}
        default void f347() {}
        default void f348() {}
        default void f349() {}
        default void f350() {}
        default void f351() {}
        default void f352() {}
        default void f353() {}
        default void f354() {}
        default void f355() {}
        default void f356() {}
        default void f357() {}
        default void f358() {}
        default void f359() {}
        default void f360() {}
        default void f361() {}
        default void f362() {}
        default void f363() {}
        default void f364() {}
        default void f365() {}
        default void f366() {}
        default void f367() {}
        default void f368() {}
        default void f369() {}
        default void f370() {}
        default void f371() {}
        default void f372() {}
        default void f373() {}
        default void f374() {}
        default void f375() {}
        default void f376() {}
        default void f377() {}
        default void f378() {}
        default void f379() {}
        default void f380() {}
        default void f381() {}
        default void f382() {}
        default void f383() {}
        default void f384() {}
        default void f385() {}
        default void f386() {}
    }
    static interface I9 {
        default void f387() {}
        default void f388() {}
        default void f389() {}
        default void f390() {}
        default void f391() {}
        default void f392() {}
        default void f393() {}
        default void f394() {}
        default void f395() {}
        default void f396() {}
        default void f397() {}
        default void f398() {}
        default void f399() {}
        default void f400() {}
        default void f401() {}
        default void f402() {}
        default void f403() {}
        default void f404() {}
        default void f405() {}
        default void f406() {}
        default void f407() {}
        default void f408() {}
        default void f409() {}
        default void f410() {}
        default void f411() {}
        default void f412() {}
        default void f413() {}
        default void f414() {}
        default void f415() {}
        default void f416() {}
        default void f417() {}
        default void f418() {}
        default void f419() {}
        default void f420() {}
        default void f421() {}
        default void f422() {}
        default void f423() {}
        default void f424() {}
        default void f425() {}
        default void f426() {}
        default void f427() {}
        default void f428() {}
        default void f429() {}
    }
    static interface I10 {
        default void f430() {}
        default void f431() {}
        default void f432() {}
        default void f433() {}
        default void f434() {}
        default void f435() {}
        default void f436() {}
        default void f437() {}
        default void f438() {}
        default void f439() {}
        default void f440() {}
        default void f441() {}
        default void f442() {}
        default void f443() {}
        default void f444() {}
        default void f445() {}
        default void f446() {}
        default void f447() {}
        default void f448() {}
        default void f449() {}
        default void f450() {}
        default void f451() {}
        default void f452() {}
        default void f453() {}
        default void f454() {}
        default void f455() {}
        default void f456() {}
        default void f457() {}
        default void f458() {}
        default void f459() {}
        default void f460() {}
        default void f461() {}
        default void f462() {}
        default void f463() {}
        default void f464() {}
        default void f465() {}
        default void f466() {}
        default void f467() {}
        default void f468() {}
        default void f469() {}
        default void f470() {}
        default void f471() {}
        default void f472() {}
    }
    static interface I11 {
        default void f473() {}
        default void f474() {}
        default void f475() {}
        default void f476() {}
        default void f477() {}
        default void f478() {}
        default void f479() {}
        default void f480() {}
        default void f481() {}
        default void f482() {}
        default void f483() {}
        default void f484() {}
        default void f485() {}
        default void f486() {}
        default void f487() {}
        default void f488() {}
        default void f489() {}
        default void f490() {}
        default void f491() {}
        default void f492() {}
        default void f493() {}
        default void f494() {}
        default void f495() {}
        default void f496() {}
        default void f497() {}
        default void f498() {}
        default void f499() {}
        default void f500() {}
        default void f501() {}
        default void f502() {}
        default void f503() {}
        default void f504() {}
        default void f505() {}
        default void f506() {}
        default void f507() {}
        default void f508() {}
        default void f509() {}
        default void f510() {}
        default void f511() {}
        default void f512() {}
        default void f513() {}
        default void f514() {}
        default void f515() {}
    }
    static interface I12 {
        default void f516() {}
        default void f517() {}
        default void f518() {}
        default void f519() {}
        default void f520() {}
        default void f521() {}
        default void f522() {}
        default void f523() {}
        default void f524() {}
        default void f525() {}
        default void f526() {}
        default void f527() {}
        default void f528() {}
        default void f529() {}
        default void f530() {}
        default void f531() {}
        default void f532() {}
        default void f533() {}
        default void f534() {}
        default void f535() {}
        default void f536() {}
        default void f537() {}
        default void f538() {}
        default void f539() {}
        default void f540() {}
        default void f541() {}
        default void f542() {}
        default void f543() {}
        default void f544() {}
        default void f545() {}
        default void f546() {}
        default void f547() {}
        default void f548() {}
        default void f549() {}
        default void f550() {}
        default void f551() {}
        default void f552() {}
        default void f553() {}
        default void f554() {}
        default void f555() {}
        default void f556() {}
        default void f557() {}
        default void f558() {}
    }
    static interface I13 {
        default void f559() {}
        default void f560() {}
        default void f561() {}
        default void f562() {}
        default void f563() {}
        default void f564() {}
        default void f565() {}
        default void f566() {}
        default void f567() {}
        default void f568() {}
        default void f569() {}
        default void f570() {}
        default void f571() {}
        default void f572() {}
        default void f573() {}
        default void f574() {}
        default void f575() {}
        default void f576() {}
        default void f577() {}
        default void f578() {}
        default void f579() {}
        default void f580() {}
        default void f581() {}
        default void f582() {}
        default void f583() {}
        default void f584() {}
        default void f585() {}
        default void f586() {}
        default void f587() {}
        default void f588() {}
        default void f589() {}
        default void f590() {}
        default void f591() {}
        default void f592() {}
        default void f593() {}
        default void f594() {}
        default void f595() {}
        default void f596() {}
        default void f597() {}
        default void f598() {}
        default void f599() {}
        default void f600() {}
        default void f601() {}
    }
    static interface I14 {
        default void f602() {}
        default void f603() {}
        default void f604() {}
        default void f605() {}
        default void f606() {}
        default void f607() {}
        default void f608() {}
        default void f609() {}
        default void f610() {}
        default void f611() {}
        default void f612() {}
        default void f613() {}
        default void f614() {}
        default void f615() {}
        default void f616() {}
        default void f617() {}
        default void f618() {}
        default void f619() {}
        default void f620() {}
        default void f621() {}
        default void f622() {}
        default void f623() {}
        default void f624() {}
        default void f625() {}
        default void f626() {}
        default void f627() {}
        default void f628() {}
        default void f629() {}
        default void f630() {}
        default void f631() {}
        default void f632() {}
        default void f633() {}
        default void f634() {}
        default void f635() {}
        default void f636() {}
        default void f637() {}
        default void f638() {}
        default void f639() {}
        default void f640() {}
        default void f641() {}
        default void f642() {}
        default void f643() {}
        default void f644() {}
    }
    static interface I15 {
        default void f645() {}
        default void f646() {}
        default void f647() {}
        default void f648() {}
        default void f649() {}
        default void f650() {}
        default void f651() {}
        default void f652() {}
        default void f653() {}
        default void f654() {}
        default void f655() {}
        default void f656() {}
        default void f657() {}
        default void f658() {}
        default void f659() {}
        default void f660() {}
        default void f661() {}
        default void f662() {}
        default void f663() {}
        default void f664() {}
        default void f665() {}
        default void f666() {}
        default void f667() {}
        default void f668() {}
        default void f669() {}
        default void f670() {}
        default void f671() {}
        default void f672() {}
        default void f673() {}
        default void f674() {}
        default void f675() {}
        default void f676() {}
        default void f677() {}
        default void f678() {}
        default void f679() {}
        default void f680() {}
        default void f681() {}
        default void f682() {}
        default void f683() {}
        default void f684() {}
        default void f685() {}
        default void f686() {}
        default void f687() {}
    }
    static interface I16 {
        default void f688() {}
        default void f689() {}
        default void f690() {}
        default void f691() {}
        default void f692() {}
        default void f693() {}
        default void f694() {}
        default void f695() {}
        default void f696() {}
        default void f697() {}
        default void f698() {}
        default void f699() {}
        default void f700() {}
        default void f701() {}
        default void f702() {}
        default void f703() {}
        default void f704() {}
        default void f705() {}
        default void f706() {}
        default void f707() {}
        default void f708() {}
        default void f709() {}
        default void f710() {}
        default void f711() {}
        default void f712() {}
        default void f713() {}
        default void f714() {}
        default void f715() {}
        default void f716() {}
        default void f717() {}
        default void f718() {}
        default void f719() {}
        default void f720() {}
        default void f721() {}
        default void f722() {}
        default void f723() {}
        default void f724() {}
        default void f725() {}
        default void f726() {}
        default void f727() {}
        default void f728() {}
        default void f729() {}
        default void f730() {}
    }
    static interface I17 {
        default void f731() {}
        default void f732() {}
        default void f733() {}
        default void f734() {}
        default void f735() {}
        default void f736() {}
        default void f737() {}
        default void f738() {}
        default void f739() {}
        default void f740() {}
        default void f741() {}
        default void f742() {}
        default void f743() {}
        default void f744() {}
        default void f745() {}
        default void f746() {}
        default void f747() {}
        default void f748() {}
        default void f749() {}
        default void f750() {}
        default void f751() {}
        default void f752() {}
        default void f753() {}
        default void f754() {}
        default void f755() {}
        default void f756() {}
        default void f757() {}
        default void f758() {}
        default void f759() {}
        default void f760() {}
        default void f761() {}
        default void f762() {}
        default void f763() {}
        default void f764() {}
        default void f765() {}
        default void f766() {}
        default void f767() {}
        default void f768() {}
        default void f769() {}
        default void f770() {}
        default void f771() {}
        default void f772() {}
        default void f773() {}
    }
    static interface I18 {
        default void f774() {}
        default void f775() {}
        default void f776() {}
        default void f777() {}
        default void f778() {}
        default void f779() {}
        default void f780() {}
        default void f781() {}
        default void f782() {}
        default void f783() {}
        default void f784() {}
        default void f785() {}
        default void f786() {}
        default void f787() {}
        default void f788() {}
        default void f789() {}
        default void f790() {}
        default void f791() {}
        default void f792() {}
        default void f793() {}
        default void f794() {}
        default void f795() {}
        default void f796() {}
        default void f797() {}
        default void f798() {}
        default void f799() {}
        default void f800() {}
        default void f801() {}
        default void f802() {}
        default void f803() {}
        default void f804() {}
        default void f805() {}
        default void f806() {}
        default void f807() {}
        default void f808() {}
        default void f809() {}
        default void f810() {}
        default void f811() {}
        default void f812() {}
        default void f813() {}
        default void f814() {}
        default void f815() {}
        default void f816() {}
    }
    static interface I19 {
        default void f817() {}
        default void f818() {}
        default void f819() {}
        default void f820() {}
        default void f821() {}
        default void f822() {}
        default void f823() {}
        default void f824() {}
        default void f825() {}
        default void f826() {}
        default void f827() {}
        default void f828() {}
        default void f829() {}
        default void f830() {}
        default void f831() {}
        default void f832() {}
        default void f833() {}
        default void f834() {}
        default void f835() {}
        default void f836() {}
        default void f837() {}
        default void f838() {}
        default void f839() {}
        default void f840() {}
        default void f841() {}
        default void f842() {}
        default void f843() {}
        default void f844() {}
        default void f845() {}
        default void f846() {}
        default void f847() {}
        default void f848() {}
        default void f849() {}
        default void f850() {}
        default void f851() {}
        default void f852() {}
        default void f853() {}
        default void f854() {}
        default void f855() {}
        default void f856() {}
        default void f857() {}
        default void f858() {}
        default void f859() {}
    }
}
