/******************************************************************************
 *                       ____    _    _____                                   *
 *                      / ___|  / \  |  ___|    C++                           *
 *                     | |     / _ \ | |_       Actor                         *
 *                     | |___ / ___ \|  _|      Framework                     *
 *                      \____/_/   \_|_|                                      *
 *                                                                            *
 * Copyright 2011-2018 Dominik Charousset                                     *
 *                                                                            *
 * Distributed under the terms and conditions of the BSD 3-Clause License or  *
 * (at your option) under the terms and conditions of the Boost Software      *
 * License 1.0. See accompanying files LICENSE and LICENSE_ALTERNATIVE.       *
 *                                                                            *
 * If you did not receive a copy of the license files, see                    *
 * http://opensource.org/licenses/BSD-3-Clause and                            *
 * http://www.boost.org/LICENSE_1_0.txt.                                      *
 ******************************************************************************/

#pragma once

#include <vector>

#include "caf/config_option.hpp"
#include "caf/fwd.hpp"

namespace caf {

/// Adds config options of the same category to a `config_option_set`.
class config_option_adder {
public:
  // -- constructors, destructors, and assignment operators --------------------

  config_option_adder(config_option_set& target, string_view category);

  // -- properties -------------------------------------------------------------

  /// Adds a config option to the category that synchronizes with `ref`.
  template <class T>
  config_option_adder& add(T& ref, string_view name, string_view description) {
    return add_impl(make_config_option(ref, category_, name, description));
  }

  /// Adds a config option to the category.
  template <class T>
  config_option_adder& add(string_view name, string_view description) {
    return add_impl(make_config_option<T>(category_, name, description));
  }

  /// For backward compatibility only. Do not use for new code!
  /// @private
  config_option_adder& add_neg(bool& ref, string_view name,
                               string_view description);

  /// For backward compatibility only. Do not use for new code!
  /// @private
  config_option_adder& add_us(size_t& ref, string_view name,
                              string_view description);

  /// For backward compatibility only. Do not use for new code!
  /// @private
  config_option_adder& add_ms(size_t& ref, string_view name,
                              string_view description);

private:
  // -- properties -------------------------------------------------------------

  config_option_adder& add_impl(config_option&& opt);

  // -- member variables -------------------------------------------------------

  /// Reference to the target set.
  config_option_set& xs_;

  /// Category for all options generated by this adder.
  string_view category_;
};

} // namespace caf
