!{\src2tex{textfont=tt}}
!!****f* ABINIT/symdij
!! NAME
!! symdij
!!
!! FUNCTION
!! Symmetrize dij quantities (psp strengths)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  indlmn(6,lmnmax,ntypat)=array giving l,m,n,lm,ln,spin for i=lmn (for each atom type)
!!  indsym(4,nsym,natom)=indirect indexing array for atom labels
!!  lmnmax=maximum number of PAW radial wavefunctions
!!  natom=number of atoms in cell
!!  nsym=number of symmetry elements in space group
!!  ntypat=number of types of atoms in unit cell.
!!  paw_ij(natom)%lmn_size=number of (l,m,n) elements for the paw basis
!!  paw_ij(natom)%nspden=number of spin-density components
!!  paw_ij(natom)%dij(lmn2_size,nspden)=non-symetrized paw dij quantities
!!  pawang <type(pawang_type)>=angular mesh discretization and related data
!!  pawprtvol=control print volume and debugging output for PAW
!!  symafm(nsym)=(anti)ferromagnetic part of symmetry operations
!!  symrec(3,3,nsym)=symmetries of group in terms of operations on
!!                   reciprocal space primitive translations
!!  typat(natom)=type for each atom
!!
!! SIDE EFFECTS
!!    paw_ij(natom)%dij(lmn2_size,nspden)=symetrized dij quantities as output
!!
!! PARENTS
!!      respfn,scfcv
!!
!! CHILDREN
!!      leave_new,print_ij,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine symdij(indlmn,indsym,lmnmax,natom,nsym,ntypat,&
&                  paw_ij,pawang,pawprtvol,symafm,symrec,typat)

 use defs_basis
  use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
#endif
!End of the abilint section

 implicit none

!Arguments ---------------------------------------------
!scalars
 integer,intent(in) :: lmnmax,natom,nsym,ntypat,pawprtvol
 type(pawang_type),intent(in) :: pawang
!arrays
 integer,intent(in) :: indlmn(6,lmnmax,ntypat),indsym(4,nsym,natom)
 integer,intent(in) :: symafm(nsym),symrec(3,3,nsym),typat(natom)
 type(paw_ij_type),intent(inout) :: paw_ij(natom)

!Local variables ---------------------------------------
!scalars
 integer :: at_indx,iafm,iatom,il,il0,ilmn,iln,iln0,ilpm,indexi,indexii,indexj
 integer :: indexjj,indexjj0,indexk,irot,ispden,itypat,j0lmn,jj,jl,jl0
 integer :: jlmn,jln,jln0,jlpm,klmn,lmn_size,mi,mj,natinc
 real(dp) :: dijnew
 logical :: antiferro
 character(len=500) :: message
!arrays
 integer :: nsym_used(2)
 integer,allocatable :: idum(:)
 real(dp) :: sumdij(2)
!no_abirules
  type dij_at
   real(dp),pointer :: dij(:,:)
  end type
  type(dij_at) :: tmp(natom)

! *********************************************************************

!DEBUG
!write(6,*)' symdij : enter '
!ENDDEBUG

!Symetrization occurs only when nsym>1
  if (nsym>1) then

!  Have to make a temporary copy of dij
   do iatom=1,natom
    allocate(tmp(iatom)%dij(paw_ij(iatom)%lmn2_size,paw_ij(iatom)%nspden))
    tmp(iatom)%dij(:,:)=paw_ij(iatom)%dij(:,:)
   end do

!  Antiferro case ?
   antiferro=(paw_ij(1)%nspden==2.and.paw_ij(1)%nsppol==1)

!  Loops over atoms and spin components
   do iatom=1,natom
    itypat=typat(iatom)
    lmn_size=paw_ij(iatom)%lmn_size
    do ispden=1,paw_ij(iatom)%nsppol

!    Loops over (il,im) and (jl,jm)
     jl0=-1;jln0=-1;indexj=1
     do jlmn=1,lmn_size
      jl=indlmn(1,jlmn,itypat)
      jlpm=1+jl+indlmn(2,jlmn,itypat)
      jln=indlmn(5,jlmn,itypat)
      if (jln/=jln0) indexj=indexj+2*jl0+1
      j0lmn=jlmn*(jlmn-1)/2
      il0=-1;iln0=-1;indexi=1
      do ilmn=1,jlmn
       il=indlmn(1,ilmn,itypat)
       ilpm=1+il+indlmn(2,ilmn,itypat)
       iln=indlmn(5,ilmn,itypat)
       if (iln/=iln0) indexi=indexi+2*il0+1
       klmn=j0lmn+ilmn

       nsym_used(1:2)=0
       sumdij(1:2)=zero

!      Loop over symmetries
       do irot=1,nsym

        if ((symafm(irot)/=1).and.(.not.antiferro)) cycle
        iafm=1;if ((antiferro).and.(symafm(irot)==-1)) iafm=2        
        
        nsym_used(iafm)=nsym_used(iafm)+1
        at_indx=indsym(4,irot,iatom)

!       Accumulate values over (mi,mj) and symetries
        do mj=1,2*jl+1
         indexjj=indexj+mj;indexjj0=indexjj*(indexjj-1)/2
         do mi=1,2*il+1
          indexii=indexi+mi
          if (indexii<=indexjj) then
           indexk=indexjj0+indexii
          else
           indexk=indexii*(indexii-1)/2+indexjj
          end if
          sumdij(iafm)=sumdij(iafm)+pawang%zarot(mi,ilpm,il+1,irot)&
&                      *pawang%zarot(mj,jlpm,jl+1,irot)&
&                      *tmp(at_indx)%dij(indexk,ispden)
!TEST
!if (klmn==41.and.iatom==1.and.(at_indx==2.or.at_indx==4).and.(mi-il-1==1.and.mj-jl-1==-2)) then
! write(77,'(3i3,3f16.8,2i3,f16.8)') iatom,irot,at_indx,pawang%zarot(mi,ilpm,il+1,irot)&
!&                              ,pawang%zarot(mj,jlpm,jl+1,irot)&
!&                              ,tmp(at_indx)%dij(indexk,ispden),mi-il-1,mj-jl-1&
!&                              ,pawang%zarot(mi,ilpm,il+1,irot)&
!&                      *pawang%zarot(mj,jlpm,jl+1,irot)&
!&                      *tmp(at_indx)%dij(indexk,ispden)
!end if
         end do
        end do
       end do ! End loop over symmetries

!      Store new values of dij
       dijnew=sumdij(1)/nsym_used(1)
       if (abs(dijnew)>tol10) then
        paw_ij(iatom)%dij(klmn,ispden)=dijnew
       else
        paw_ij(iatom)%dij(klmn,ispden)=zero
       end if

!      Antiferromagnetic case: has to fill up "down" component of dij
       if (antiferro.and.nsym_used(2)>0) then
        dijnew=sumdij(2)/nsym_used(2)
        if (abs(dijnew)>tol10) then
         paw_ij(iatom)%dij(klmn,2)=dijnew
        else
         paw_ij(iatom)%dij(klmn,2)=zero
        end if
       end if

       il0=il;iln0=iln  ! End loops over (il,im) and (jl,jm)
      end do
      jl0=jl;jln0=jln
     end do
    end do ! ispden
   end do ! iatom

   do iatom=1,natom
    deallocate(tmp(iatom)%dij)
   end do

  else  ! nsym>1

! *********************************************************************
! If nsym==1, only cut small components of dij
  if(paw_ij(1)%nspden==2.and.paw_ij(1)%nsppol==1) then
   write(message,'(a,a,a)') ' symdij : BUG -',ch10,&
&   ' In the antiferromagnetic case, nsym cannot be 1'
   call wrtout(6,message,'PERS')
   call leave_new('PERS')
  end if
   do iatom=1,natom
    do ispden=1,paw_ij(iatom)%nspden
     do klmn=1,paw_ij(iatom)%lmn2_size
      if (abs(paw_ij(iatom)%dij(klmn,ispden))<=tol10) then
       paw_ij(iatom)%dij(klmn,ispden)=zero
      end if
     end do
    end do
   end do

  end if

!*********************************************************************
!Printing of Dij

  if (pawprtvol>=1) then
   natinc=1;if(natom>1) natinc=natom-1
   do iatom=1,natom,natinc
    write(message, '(4a,i3,a)') ch10," PAW TEST:",ch10,&
&   ' ====== Values of DIJ in symdij (iatom=',iatom,') (Hartree) ======'
    call wrtout(6,message,'COLL')
    do ispden=1,paw_ij(iatom)%nspden
     write(message, '(a,a,i3,a,i1,a)') ch10,&
&    ' *********** Dij (atom ',iatom,', ispden=',ispden,') **********'
     call wrtout(6,message,'COLL')
     call print_ij(paw_ij(iatom)%dij(:,ispden),paw_ij(iatom)%lmn2_size,&
&                  paw_ij(iatom)%lmn_size,1,-1,idum,0,idum,50.d0*dble(3-2*ispden),1)
    end do
   end do
   message=''
   call wrtout(6,message,'COLL')
  end if

!DEBUG
!write(6,*)' symdij : enter '
!ENDDEBUG

end subroutine symdij
!!***
