/*
 *               In the name of Allah
 * This file is part of The Zekr Project. Use is subject to
 * license terms.
 *
 * Author:         Mohsen Saboorian
 * Start Date:     Mar 14, 2008
 */
package net.sf.zekr.engine.search;

/**
 * Some Unicode Arabic characters as <code>public static final</code>.
 * 
 * @author Mohsen Saboorian
 */
public interface ArabicCharacters {
	public static final char WAQF_SALA = 0x6d6;
	public static final char WAQF_QALA = 0x6d7;
	public static final char WAQF_SMALL_MEEM = 0x6d8;
	public static final char WAQF_LA = 0x6d9;
	public static final char WAQF_JEEM = 0x6da;
	public static final char WAQF_THREE_DOT = 0x6db;
	public static final char WAQF_HIGH_SEEN = 0x6dc;

	public static final char SAJDA_PLACE = 0x6e9;
	public static final char RUB_EL_HIZB = 0x6de;

	public static final char SUKUN = 0x652;
	public static final char SHADDA = 0x651;
	public static final char KASRA = 0x650;
	public static final char DAMMA = 0x64f;
	public static final char FATHA = 0x64e;

	public static final char KASRATAN = 0x64d;
	public static final char DAMMATAN = 0x64c;
	public static final char FATHATAN = 0x64b;

	public static final char HAMZA = 0x621;
	public static final char HAMZA_ABOVE = 0x654;
	public static final char HAMZA_BELOW = 0x655;

	public static final char MADDAH_ABOVE = 0x653;
	public static final char SMALL_LOW_SEEN = 0x6e3;
	public static final char SMALL_WAW = 0x6e5;
	public static final char SMALL_YEH = 0x6e6;
	public static final char SMALL_HIGH_MEEM = 0x6e2;

	public static final char MADDA = 0x653;

	public static final char SUPERSCRIPT_ALEF = 0x670;
	public static final char ALEF = 0x627;
	public static final char ALEF_MADDA = 0x622;
	public static final char ALEF_HAMZA_ABOVE = 0x623;
	public static final char ALEF_HAMZA_BELOW = 0x625;
	public static final char ALEF_WASLA = 0x671;

	public static final char SMALL_ROUNDED_ZERO = 0x6df;

	public static final char TATWEEL = 0x640;

	public static final char YEH_HAMZA_ABOVE = 0x626;
	public static final char WAW_HAMZA_ABOVE = 0x624;
	public static final char WAW = 0x648;

	public static final char TEH = 0x62a;
	public static final char TEH_MARBUTA = 0x629;

	public static final char ALEF_MAKSURA = 0x649;
	public static final char FARSI_YEH = 0x6cc;
	public static final char ARABIC_YEH = 0x64a;
	public static final char BARREE_YEH = 0x6d2;

	public static final char ARABIC_KAF = 0x643;
	public static final char FARSI_KEHEH = 0x6a9;
	public static final char SWASH_KEHEH = 0x6aa;

	public static final char ARABIC_QUESION_MARK = 0x61f;

}
