// $Id: visiattr.h 751 2006-03-31 15:43:49Z alex $
/* @@tag:xara-cn@@ DO NOT MODIFY THIS LINE
================================XARAHEADERSTART===========================
 
               Xara LX, a vector drawing and manipulation program.
                    Copyright (C) 1993-2006 Xara Group Ltd.
       Copyright on certain contributions may be held in joint with their
              respective authors. See AUTHORS file for details.

LICENSE TO USE AND MODIFY SOFTWARE
----------------------------------

This file is part of Xara LX.

Xara LX is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License version 2 as published
by the Free Software Foundation.

Xara LX and its component source files are distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with Xara LX (see the file GPL in the root directory of the
distribution); if not, write to the Free Software Foundation, Inc., 51
Franklin St, Fifth Floor, Boston, MA  02110-1301 USA


ADDITIONAL RIGHTS
-----------------

Conditional upon your continuing compliance with the GNU General Public
License described above, Xara Group Ltd grants to you certain additional
rights. 

The additional rights are to use, modify, and distribute the software
together with the wxWidgets library, the wxXtra library, and the "CDraw"
library and any other such library that any version of Xara LX relased
by Xara Group Ltd requires in order to compile and execute, including
the static linking of that library to XaraLX. In the case of the
"CDraw" library, you may satisfy obligation under the GNU General Public
License to provide source code by providing a binary copy of the library
concerned and a copy of the license accompanying it.

Nothing in this section restricts any of the rights you have under
the GNU General Public License.


SCOPE OF LICENSE
----------------

This license applies to this program (XaraLX) and its constituent source
files only, and does not necessarily apply to other Xara products which may
in part share the same code base, and are subject to their own licensing
terms.

This license does not apply to files in the wxXtra directory, which
are built into a separate library, and are subject to the wxWindows
license contained within that directory in the file "WXXTRA-LICENSE".

This license does not apply to the binary libraries (if any) within
the "libs" directory, which are subject to a separate license contained
within that directory in the file "LIBS-LICENSE".


ARRANGEMENTS FOR CONTRIBUTION OF MODIFICATIONS
----------------------------------------------

Subject to the terms of the GNU Public License (see above), you are
free to do whatever you like with your modifications. However, you may
(at your option) wish contribute them to Xara's source tree. You can
find details of how to do this at:
  http://www.xaraxtreme.org/developers/

Prior to contributing your modifications, you will need to complete our
contributor agreement. This can be found at:
  http://www.xaraxtreme.org/developers/contribute/

Please note that Xara will not accept modifications which modify any of
the text between the start and end of this header (marked
XARAHEADERSTART and XARAHEADEREND).


MARKS
-----

Xara, Xara LX, Xara X, Xara X/Xtreme, Xara Xtreme, the Xtreme and Xara
designs are registered or unregistered trademarks, design-marks, and/or
service marks of Xara Group Ltd. All rights in these marks are reserved.


      Xara Group Ltd, Gaddesden Place, Hemel Hempstead, HP2 6EX, UK.
                        http://www.xara.com/

=================================XARAHEADEREND============================
 */

#ifndef INC_VISIATTR
#define INC_VISIATTR

class NodeAttribute;
/**************************************************************************************

>	class VisibleAttribute : public VisibleListItem

	Author:		Colin_Barfoot (Xara Group Ltd) <camelotdev@xara.com>
	Created:	15/10/96

	Purpose:	Provides a user editable attribute (of sorts)

**************************************************************************************/
class VisibleAttribute : public UserInterface
{
	CC_DECLARE_MEMDUMP(VisibleAttribute)
public:
	virtual BOOL Interact(DialogOp& Dialog)			{	return TRUE;	}	// should be in UserInterface
	virtual StringBase& GetText(StringBase& Description) const = 0;
	virtual NodeAttribute*	CreateNewAttribute() = 0;

	BOOL IsNew() const			{	return m_IsNew;		}
	void MarkAsUsed()			{	m_IsNew = FALSE;	}

protected:
	VisibleAttribute() : m_IsNew(TRUE)	{}

private:
	BOOL				m_IsNew;
};


/**************************************************************************************

>	class VisibleUserAttribute : public VisibleAttribute

	Author:		Colin_Barfoot (Xara Group Ltd) <camelotdev@xara.com>
	Created:	15/10/96

	Purpose:	Provides a user editable user attribute

**************************************************************************************/
class VisibleUserAttribute : public VisibleAttribute
{
	CC_DECLARE_MEMDUMP(VisibleUserAttribute)
public:
	VisibleUserAttribute(const StringBase& Key, const StringBase& Value);

//	Pure implementations
	virtual BOOL Display(DialogOp& Dialog);
	virtual BOOL Interact(DialogOp& Dialog);
	virtual void Hide();
	virtual StringBase& GetText(StringBase& Description) const;


// Data Member Access
	void SetLongKey(const StringBase& NewKey);
	void SetValue(const StringBase& NewValue)			{	m_Value = NewValue;	}

	const StringBase& GetKey();
	const StringBase& GetLongKey();
	const StringBase& GetValue();

	virtual NodeAttribute*	CreateNewAttribute();

private:
	String_64			m_Key;
	EditableText		m_LongKey;
	EditableText		m_Value;
};


class WizOp;
/**************************************************************************************

>	class VisibleTemplateAttribute : public VisibleUserAttribute

	Author:		Colin_Barfoot (Xara Group Ltd) <camelotdev@xara.com>
	Created:	15/10/96

	Purpose:	Provides a user editable template attribute

**************************************************************************************/
class VisibleTemplateAttribute : public VisibleUserAttribute
{
	CC_DECLARE_MEMDUMP(VisibleTemplateAttribute)
public:
	VisibleTemplateAttribute(	const WizOp& Handler,
								const StringBase& Question = NullString, 
								const StringBase& Param = NullString);

	virtual StringBase& GetText(StringBase& Description) const;
	virtual BOOL Display(DialogOp& Dialog);
	virtual BOOL Interact(DialogOp& Dialog);
	virtual void Hide();

	virtual NodeAttribute*	CreateNewAttribute();

protected:
// Data Member Access
	const WizOp&	GetWizOp();
	VisibleLabel&	GetParamHint();
	void			SetParamHint(const StringBase& HintToShow);
	
private:
	const WizOp&	m_Handler;
	VisibleLabel	m_ParamHint;
};

class WizOpStyle;
/**************************************************************************************

>	class VisibleStyleReference : public VisibleAttribute

	Author:		Colin_Barfoot (Xara Group Ltd) <camelotdev@xara.com>
	Created:	15/10/96

	Purpose:	Provides a user editable style reference

**************************************************************************************/
class VisibleStyleReference : public VisibleAttribute
{
	CC_DECLARE_MEMDUMP(VisibleStyleReference)

public:
	VisibleStyleReference(const WizOpStyle& Style);


	virtual BOOL Display(DialogOp& Dialog);
	virtual BOOL Interact(DialogOp& Dialog);
	virtual void Hide();

	virtual StringBase& GetText(StringBase& Description) const;
	virtual NodeAttribute*	CreateNewAttribute();

	VisibleLabel&	GetParamHintLabel();
	void			SetParamHintString(const StringBase& HintToShow);

	EditableText&	GetParamText();
	void			SetParamText(const StringBase& ParamToShow);

	const WizOpStyle&	GetStyle();

private:
	const WizOpStyle&	m_Style;
	EditableText		m_Question;
	VisibleLabel		m_ParamHintLabel;
	EditableText		m_Param;
};



#endif // INC_VISIATTR
