#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Beyond Zork: The Coconut of Quendor
# send your bug reports to contact@dotslashplay.it
###

script_version=20240422.3

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='beyond-zork'
GAME_NAME='Beyond Zork: The Coconut of Quendor'

ARCHIVE_BASE_1_NAME='setup_beyond_zork_-_the_coconut_of_quendor_1.0_(28043).exe'
ARCHIVE_BASE_1_MD5='01a92eaa89649bac71115c0599f67e89'
ARCHIVE_BASE_1_SIZE='17236'
ARCHIVE_BASE_1_VERSION='1.0-gog28043'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_zork_anthology'

ARCHIVE_BASE_0_NAME='setup_beyond_zork_2.1.0.17.exe'
ARCHIVE_BASE_0_MD5='8a5168d7340af5b1b4df708f467785c0'
ARCHIVE_BASE_0_SIZE='21000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.1.0.17'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_MAIN_FILES='
data
bzork.exe
frotz.exe
beyondzo.mg1'
CONTENT_DOC_MAIN_FILES='
*.pdf'

USER_PERSISTENT_FILES='
*.SAV'

APP_MAIN_EXE='frotz.exe'
APP_MAIN_OPTIONS='data\\beyondzo.dat'
APP_MAIN_ICON='goggame-1207661533.ico'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

icons_inclusion
content_inclusion_default

# Write launchers

launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
