#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Arrow Patterns
# send your bug reports to contact@dotslashplay.it
###

script_version=20240228.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='arrow-patterns'
GAME_NAME='Arrow Patterns'

ARCHIVE_BASE_0_NAME='setup_arrow_patterns_1.0.0_(67004).exe'
ARCHIVE_BASE_0_MD5='236ff841e84ba5bf09c5e47b517de840'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='21027'
ARCHIVE_BASE_0_VERSION='1.0.0-gog67004'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/arrow_patterns'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
almixer.dll
coronalabs.corona.native.dll
lua.dll
openal32.dll
plugin_hwcursor.dll
pthreads.dll
arrow patterns.exe'
CONTENT_GAME_DATA_FILES='
resources'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/AleC Games/Arrow Patterns
users/${USER}/AppData/Local/AleC Games/Arrow Patterns'

APP_MAIN_EXE='arrow patterns.exe'
APP_MAIN_ICON='resources/icon-win32.ico'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
