#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Daguhh
set -o errexit

###
# Ape Out
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20221203.1

# Set game-specific variables

GAME_ID='ape-out'
GAME_NAME="Ape Out"

ARCHIVE_BASE_0='windows.zip'
ARCHIVE_BASE_0_URL='https://devolverdigital.itch.io/ape-out'
ARCHIVE_BASE_0_MD5='cccf8136c915b46691edd440e7c7f269'
ARCHIVE_BASE_0_VERSION='1.0-itch'
ARCHIVE_BASE_0_SIZE='1100000'
ARCHIVE_BASE_0_TYPE='zip'

ARCHIVE_GAME_BIN_PATH='windows'
ARCHIVE_GAME_BIN_FILES='ApeOut.exe GameAssembly.dll SymbolMap UnityCrashHandler64.exe UnityPlayer.dll'

ARCHIVE_GAME_DATA_PATH='windows'
ARCHIVE_GAME_DATA_FILES='ApeOut_Data'


APP_MAIN_TYPE='wine'
APP_MAIN_EXE='ApeOut.exe'
APP_MAIN_ICON='ApeOut.exe'

# Use a per-session dedicated file for logs
APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Use a per-session dedicated file for logs
mkdir --parents logs
APP_OPTIONS="${APP_OPTIONS} -logFile ./logs/$(date +%F-%R).log"'


PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Load common functions

target_version='2.13'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "${path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"
 
# Extract game data
 
extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout
 
# Extract icons
 
PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Clean up temporary directories

rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Write launchers
 
PKG='PKG_BIN'
launchers_write 'APP_MAIN'
 
# Build package
 
write_metadata
build_pkg
 
# Clean up
 
rm --recursive "$PLAYIT_WORKDIR"
 
# Print instructions
 
print_instructions
 
exit 0
