/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_POWERMANAGEMENTCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_POWERMANAGEMENTCONFORMSTOPROFILEACCESS_H_

#include "PowerManagement_Common.h"

#include "OpenDRIM_PowerManagementConformsToProfile.h"
#include "assocOpenDRIM_PowerManagementConformsToProfile.h"

int PowerManagement_OpenDRIM_PowerManagementConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementConformsToProfile_unload(string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PowerManagementConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_PowerManagementConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PowerManagementConformsToProfile& instance, const char** properties, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementConformsToProfile& newInstance, const OpenDRIM_PowerManagementConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementConformsToProfile& instance, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementConformsToProfile& instance, string& errorMessage);

int PowerManagement_OpenDRIM_PowerManagementConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_PowerManagementConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_PowerManagementConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_PowerManagementConformsToProfile>& OpenDRIM_PowerManagementConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_PowerManagementConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_PowerManagementConformsToProfile>& OpenDRIM_PowerManagementConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_PowerManagementConformsToProfile_populate(OpenDRIM_PowerManagementConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_POWERMANAGEMENTCONFORMSTOPROFILEACCESS_H_*/
