/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_PCICAPABILITIESACCESS_H_
#define OPENDRIM_PCICAPABILITIESACCESS_H_

#include "PCI_Common.h"

#include "OpenDRIM_PCICapabilities.h"
#include "assocOpenDRIM_PCICapabilities.h"

int PCI_OpenDRIM_PCICapabilities_load(const CMPIBroker* broker, string& errorMessage);

int PCI_OpenDRIM_PCICapabilities_unload(string& errorMessage);

int PCI_OpenDRIM_PCICapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PCICapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_PCICapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PCICapabilities& instance, const char** properties, string& errorMessage);

int PCI_OpenDRIM_PCICapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCICapabilities& newInstance, const OpenDRIM_PCICapabilities& oldInstance, const char** properties, string& errorMessage);

int PCI_OpenDRIM_PCICapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCICapabilities& instance, string& errorMessage);

int PCI_OpenDRIM_PCICapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCICapabilities& instance, string& errorMessage);

int PCI_OpenDRIM_PCICapabilities_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_PCICapabilities_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_PCICapabilities_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_PCICapabilities>& OpenDRIM_PCICapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_PCICapabilities_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_PCICapabilities>& OpenDRIM_PCICapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_PCICapabilities_populate(OpenDRIM_PCICapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_PCICAPABILITIESACCESS_H_*/
