#!/bin/bash

################################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_SystemBIOS.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_SystemBIOS provider module";
Name = "BIOS_OpenDRIM_SystemBIOSModule";
Location = "cmpiBIOS_OpenDRIM_SystemBIOSProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_SystemBIOS provider";
Name = "BIOS_OpenDRIM_SystemBIOSProvider";
ProviderModuleName = "BIOS_OpenDRIM_SystemBIOSModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_SystemBIOS provider capabilities";
ProviderModuleName = "BIOS_OpenDRIM_SystemBIOSModule";
ProviderName = "BIOS_OpenDRIM_SystemBIOSProvider";
ClassName = "OpenDRIM_SystemBIOS";
ProviderType = {2, 3};
Namespaces = {"$1"};
SupportedProperties = {"GroupComponent", "PartComponent"};
CapabilityID = "BIOS_OpenDRIM_SystemBIOS";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_SystemBIOS.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_SystemBIOS]   
   provider: BIOS_OpenDRIM_SystemBIOSProvider
   location: cmpiBIOS_OpenDRIM_SystemBIOSProvider
   type: instance association
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_SystemBIOS.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_SystemBIOS-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_SystemBIOS.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
