/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.driver.BasicCellRendererReader;
import org.fest.swing.driver.CellRendererReader;
import org.fest.swing.driver.ModelValueToString;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;

public class BasicJComboBoxCellReader
implements JComboBoxCellReader {
    private static final JList REFERENCE_JLIST = BasicJComboBoxCellReader.newJList();
    private final CellRendererReader rendererReader;

    private static JList newJList() {
        return GuiActionRunner.execute(new GuiQuery<JList>(){

            @Override
            protected JList executeInEDT() {
                return new JList();
            }
        });
    }

    public BasicJComboBoxCellReader() {
        this(new BasicCellRendererReader());
    }

    public BasicJComboBoxCellReader(CellRendererReader rendererReader) {
        if (rendererReader == null) {
            throw new NullPointerException("CellRendererReader should not be null");
        }
        this.rendererReader = rendererReader;
    }

    @RunsInCurrentThread
    public String valueAt(JComboBox comboBox, int index) {
        String value;
        Component c = this.cellRendererComponent(comboBox, index);
        String string = value = c != null ? this.rendererReader.valueFrom(c) : null;
        if (value != null) {
            return value;
        }
        return ModelValueToString.asText(comboBox.getItemAt(index));
    }

    @RunsInCurrentThread
    private Component cellRendererComponent(JComboBox comboBox, int index) {
        Object item = comboBox.getItemAt(index);
        ListCellRenderer renderer = comboBox.getRenderer();
        return renderer.getListCellRendererComponent(REFERENCE_JLIST, item, index, true, true);
    }
}

