/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.algorithmic.compression;

import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticCoder;
import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticCoderI;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;

public final class FastArithmeticCoderPlus
implements FastArithmeticCoderI {
    FastArithmeticCoder[] delegates;
    private int numSymbols;
    private int previousSymbol;
    private OutputBitStream[] outs;
    private FastByteArrayOutputStream[] arrays;
    private int[] lengths;
    private int mostAbundantCount;
    private int mostAbundantSymbol = -1;
    private static final int MOST_ABUNDANT_INDEX = 0;
    private int[] counts;
    private FastArithmeticCoder mostAbundantDelegate;
    private OutputBitStream mostAbundantOut;

    public FastArithmeticCoderPlus(int numSymbols) {
        int numCoders = 2;
        this.delegates = new FastArithmeticCoder[2];
        this.outs = new OutputBitStream[2];
        this.arrays = new FastByteArrayOutputStream[2];
        this.lengths = new int[2];
        this.counts = new int[numSymbols];
        for (int i = 0; i < 2; ++i) {
            this.delegates[i] = new FastArithmeticCoder(numSymbols);
            this.arrays[i] = new FastByteArrayOutputStream();
            this.outs[i] = new OutputBitStream(this.arrays[i]);
        }
        this.mostAbundantDelegate = this.delegates[0];
        this.mostAbundantOut = this.outs[0];
        this.numSymbols = numSymbols;
    }

    @Override
    public void reset() {
        this.previousSymbol = 0;
        for (FastArithmeticCoder delegate : this.delegates) {
            delegate.reset();
        }
    }

    @Override
    public int encode(int x, OutputBitStream obs) throws IOException {
        int result;
        int zeroOrderIndex = 1;
        int previousCount = this.counts[this.previousSymbol];
        if (previousCount > this.mostAbundantCount || this.mostAbundantSymbol == this.previousSymbol) {
            this.mostAbundantSymbol = this.previousSymbol;
            this.mostAbundantCount = previousCount;
            this.lengths[0] = this.lengths[0] + 1;
            result = this.mostAbundantDelegate.encode(x, this.mostAbundantOut);
        } else {
            result = this.delegates[zeroOrderIndex].encode(x, this.outs[zeroOrderIndex]);
            int n = zeroOrderIndex;
            this.lengths[n] = this.lengths[n] + 1;
        }
        this.previousSymbol = x;
        int n = x;
        this.counts[n] = this.counts[n] + 1;
        return result;
    }

    @Override
    public int flush(OutputBitStream obs) throws IOException {
        int bitsWritten = 0;
        int i = 0;
        for (FastArithmeticCoder delegate : this.delegates) {
            int delegateBitsWritten = 0;
            int bitsFlushed = delegate.flush(this.outs[i]);
            long length = this.outs[i].writtenBits();
            this.outs[i].flush();
            delegateBitsWritten += obs.writeNibble(this.lengths[i]);
            delegateBitsWritten = (int)((long)delegateBitsWritten + obs.write(this.arrays[i].array, length));
            ++i;
            bitsWritten += delegateBitsWritten;
        }
        return bitsWritten;
    }
}

