/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import java.util.Arrays;
import java.util.Stack;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ExceptionHandlerFilter;
import proguard.evaluation.BasicBranchUnit;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.Processor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.Variables;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.TracedBranchUnit;
import proguard.optimize.peephole.BranchTargetFinder;

public class PartialEvaluator
extends SimplifiedVisitor
implements AttributeVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_RESULTS = false;
    private static final int MAXIMUM_EVALUATION_COUNT = 5;
    public static final int NONE = -2;
    public static final int AT_METHOD_ENTRY = -1;
    public static final int AT_CATCH_ENTRY = -1;
    private final ValueFactory valueFactory;
    private final InvocationUnit invocationUnit;
    private final boolean evaluateAllCode;
    private final InstructionVisitor extraInstructionVisitor;
    private InstructionOffsetValue[] branchOriginValues = new InstructionOffsetValue[8096];
    private InstructionOffsetValue[] branchTargetValues = new InstructionOffsetValue[8096];
    private TracedVariables[] variablesBefore = new TracedVariables[8096];
    private TracedStack[] stacksBefore = new TracedStack[8096];
    private TracedVariables[] variablesAfter = new TracedVariables[8096];
    private TracedStack[] stacksAfter = new TracedStack[8096];
    private boolean[] generalizedContexts = new boolean[8096];
    private int[] evaluationCounts = new int[8096];
    private boolean evaluateExceptions;
    private int codeLength;
    private final BasicBranchUnit branchUnit;
    private final BranchTargetFinder branchTargetFinder;
    private final Stack callingInstructionBlockStack;
    private final Stack instructionBlockStack = new Stack();

    public PartialEvaluator() {
        this(new BasicValueFactory());
    }

    public PartialEvaluator(ValueFactory valueFactory) {
        this(valueFactory, new BasicInvocationUnit(valueFactory), true);
    }

    public PartialEvaluator(ValueFactory valueFactory, InvocationUnit invocationUnit, boolean bl) {
        this(valueFactory, invocationUnit, bl, null);
    }

    public PartialEvaluator(ValueFactory valueFactory, InvocationUnit invocationUnit, boolean bl, InstructionVisitor instructionVisitor) {
        this(valueFactory, invocationUnit, bl, instructionVisitor, bl ? new BasicBranchUnit() : new TracedBranchUnit(), new BranchTargetFinder(), null);
    }

    private PartialEvaluator(PartialEvaluator partialEvaluator) {
        this(partialEvaluator.valueFactory, partialEvaluator.invocationUnit, partialEvaluator.evaluateAllCode, partialEvaluator.extraInstructionVisitor, partialEvaluator.branchUnit, partialEvaluator.branchTargetFinder, partialEvaluator.instructionBlockStack);
    }

    private PartialEvaluator(ValueFactory valueFactory, InvocationUnit invocationUnit, boolean bl, InstructionVisitor instructionVisitor, BasicBranchUnit basicBranchUnit, BranchTargetFinder branchTargetFinder, Stack stack) {
        this.valueFactory = valueFactory;
        this.invocationUnit = invocationUnit;
        this.evaluateAllCode = bl;
        this.extraInstructionVisitor = instructionVisitor;
        this.branchUnit = basicBranchUnit;
        this.branchTargetFinder = branchTargetFinder;
        this.callingInstructionBlockStack = stack == null ? this.instructionBlockStack : stack;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while performing partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            throw runtimeException;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        TracedVariables tracedVariables = new TracedVariables(codeAttribute.u2maxLocals);
        TracedStack tracedStack = new TracedStack(codeAttribute.u2maxStack);
        this.initializeArrays(codeAttribute);
        this.initializeParameters(clazz, method, codeAttribute, tracedVariables);
        this.instructionBlockStack.clear();
        this.callingInstructionBlockStack.clear();
        codeAttribute.accept(clazz, method, (AttributeVisitor)this.branchTargetFinder);
        this.evaluateInstructionBlockAndExceptionHandlers(clazz, method, codeAttribute, tracedVariables, tracedStack, 0, codeAttribute.u4codeLength);
    }

    public boolean isTraced(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.isTraced(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isTraced(int n) {
        return this.evaluationCounts[n] > 0;
    }

    public boolean isInstruction(int n) {
        return this.branchTargetFinder.isInstruction(n);
    }

    public boolean isTarget(int n) {
        return this.branchTargetFinder.isTarget(n);
    }

    public boolean isBranchOrigin(int n) {
        return this.branchTargetFinder.isBranchOrigin(n);
    }

    public boolean isBranchTarget(int n) {
        return this.branchTargetFinder.isBranchTarget(n);
    }

    public boolean isBranchOrExceptionTarget(int n) {
        return this.branchTargetFinder.isBranchTarget(n) || this.branchTargetFinder.isExceptionHandler(n);
    }

    public boolean isExceptionHandler(int n) {
        return this.branchTargetFinder.isExceptionHandler(n);
    }

    public boolean isSubroutineStart(int n) {
        return this.branchTargetFinder.isSubroutineStart(n);
    }

    public boolean isSubroutineInvocation(int n) {
        return this.branchTargetFinder.isSubroutineInvocation(n);
    }

    public boolean isSubroutine(int n) {
        return this.branchTargetFinder.isSubroutine(n);
    }

    public boolean isSubroutineReturning(int n) {
        return this.branchTargetFinder.isSubroutineReturning(n);
    }

    public int subroutineEnd(int n) {
        return this.branchTargetFinder.subroutineEnd(n);
    }

    public boolean isCreation(int n) {
        return this.branchTargetFinder.isCreation(n);
    }

    public boolean isInitializer(int n) {
        return this.branchTargetFinder.isInitializer(n);
    }

    public TracedVariables getVariablesBefore(int n) {
        return this.variablesBefore[n];
    }

    public TracedVariables getVariablesAfter(int n) {
        return this.variablesAfter[n];
    }

    public TracedStack getStackBefore(int n) {
        return this.stacksBefore[n];
    }

    public TracedStack getStackAfter(int n) {
        return this.stacksAfter[n];
    }

    public InstructionOffsetValue branchOrigins(int n) {
        return this.branchOriginValues[n];
    }

    public InstructionOffsetValue branchTargets(int n) {
        return this.branchTargetValues[n];
    }

    public InstructionVisitor tracedInstructionFilter(InstructionVisitor instructionVisitor) {
        return this.tracedInstructionFilter(true, instructionVisitor);
    }

    public InstructionVisitor tracedInstructionFilter(boolean bl, InstructionVisitor instructionVisitor) {
        return new MyTracedInstructionFilter(bl, instructionVisitor);
    }

    private void pushCallingInstructionBlock(TracedVariables tracedVariables, TracedStack tracedStack, int n) {
        this.callingInstructionBlockStack.push(new MyInstructionBlock(tracedVariables, tracedStack, n));
    }

    private void pushInstructionBlock(TracedVariables tracedVariables, TracedStack tracedStack, int n) {
        this.instructionBlockStack.push(new MyInstructionBlock(tracedVariables, tracedStack, n));
    }

    private void evaluateInstructionBlockAndExceptionHandlers(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables, TracedStack tracedStack, int n, int n2) {
        this.evaluateInstructionBlock(clazz, method, codeAttribute, tracedVariables, tracedStack, n);
        this.evaluateExceptionHandlers(clazz, method, codeAttribute, n, n2);
    }

    private void evaluateInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables, TracedStack tracedStack, int n) {
        this.evaluateSingleInstructionBlock(clazz, method, codeAttribute, tracedVariables, tracedStack, n);
        while (!this.instructionBlockStack.empty()) {
            MyInstructionBlock myInstructionBlock = (MyInstructionBlock)this.instructionBlockStack.pop();
            this.evaluateSingleInstructionBlock(clazz, method, codeAttribute, myInstructionBlock.variables, myInstructionBlock.stack, myInstructionBlock.startOffset);
        }
    }

    private void evaluateSingleInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables, TracedStack tracedStack, int n) {
        block20: {
            Instruction instruction;
            byte[] byArray = codeAttribute.code;
            Processor processor = new Processor(tracedVariables, tracedStack, this.valueFactory, this.branchUnit, this.invocationUnit, this.evaluateAllCode);
            int n2 = n;
            int n3 = n;
            do {
                int n4;
                if (n3 < n2) {
                    n3 = n2;
                }
                if ((n4 = this.evaluationCounts[n2]) == 0) {
                    if (this.variablesBefore[n2] == null) {
                        this.variablesBefore[n2] = new TracedVariables(tracedVariables);
                        this.stacksBefore[n2] = new TracedStack(tracedStack);
                    } else {
                        this.variablesBefore[n2].initialize(tracedVariables);
                        this.stacksBefore[n2].copy(tracedStack);
                    }
                    this.generalizedContexts[n2] = true;
                } else {
                    boolean bl = this.variablesBefore[n2].generalize(tracedVariables, true);
                    boolean bl2 = this.stacksBefore[n2].generalize(tracedStack);
                    if (!bl && !bl2 && this.generalizedContexts[n2]) break block20;
                    if (n4 >= 5) {
                        tracedVariables.generalize(this.variablesBefore[n2], false);
                        tracedStack.generalize(this.stacksBefore[n2]);
                        this.generalizedContexts[n2] = true;
                    } else {
                        this.generalizedContexts[n2] = false;
                    }
                }
                int n5 = n2;
                this.evaluationCounts[n5] = this.evaluationCounts[n5] + 1;
                InstructionOffsetValue instructionOffsetValue = new InstructionOffsetValue(n2);
                tracedVariables.setProducerValue(instructionOffsetValue);
                tracedStack.setProducerValue(instructionOffsetValue);
                instruction = InstructionFactory.create(byArray, n2);
                this.branchUnit.reset();
                if (this.extraInstructionVisitor != null) {
                    instruction.accept(clazz, method, codeAttribute, n2, this.extraInstructionVisitor);
                }
                try {
                    instruction.accept(clazz, method, codeAttribute, n2, processor);
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("Unexpected error while evaluating instruction:");
                    System.err.println("  Class       = [" + clazz.getName() + "]");
                    System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
                    System.err.println("  Instruction = " + instruction.toString(n2));
                    System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
                    throw runtimeException;
                }
                InstructionOffsetValue instructionOffsetValue2 = this.branchUnit.getTraceBranchTargets();
                int n6 = instructionOffsetValue2.instructionOffsetCount();
                if (n4 == 0) {
                    if (this.variablesAfter[n2] == null) {
                        this.variablesAfter[n2] = new TracedVariables(tracedVariables);
                        this.stacksAfter[n2] = new TracedStack(tracedStack);
                    } else {
                        this.variablesAfter[n2].initialize(tracedVariables);
                        this.stacksAfter[n2].copy(tracedStack);
                    }
                } else {
                    this.variablesAfter[n2].generalize(tracedVariables, true);
                    this.stacksAfter[n2].generalize(tracedStack);
                }
                if (this.branchUnit.wasCalled()) {
                    int n7;
                    InstructionOffsetValue instructionOffsetValue3 = this.branchTargetValues[n2] = this.branchTargetValues[n2] == null ? instructionOffsetValue2 : this.branchTargetValues[n2].generalize(instructionOffsetValue2);
                    if (n6 == 0) break block20;
                    InstructionOffsetValue instructionOffsetValue4 = new InstructionOffsetValue(n2);
                    for (n7 = 0; n7 < n6; ++n7) {
                        int n8 = instructionOffsetValue2.instructionOffset(n7);
                        this.branchOriginValues[n8] = this.branchOriginValues[n8] == null ? instructionOffsetValue4 : this.branchOriginValues[n8].generalize(instructionOffsetValue4);
                    }
                    if (n6 > 1) {
                        for (n7 = 0; n7 < n6; ++n7) {
                            this.pushInstructionBlock(new TracedVariables(tracedVariables), new TracedStack(tracedStack), instructionOffsetValue2.instructionOffset(n7));
                        }
                        break block20;
                    }
                    n2 = instructionOffsetValue2.instructionOffset(0);
                } else {
                    n2 += instruction.length(n2);
                }
                if (instruction.opcode != -88 && instruction.opcode != -55) continue;
                this.evaluateSubroutine(clazz, method, codeAttribute, tracedVariables, tracedStack, n2);
                break block20;
            } while (instruction.opcode != -87);
            this.pushCallingInstructionBlock(new TracedVariables(tracedVariables), new TracedStack(tracedStack), n2);
        }
    }

    private void evaluateSubroutine(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables, TracedStack tracedStack, int n) {
        int n2 = this.branchTargetFinder.subroutineEnd(n);
        PartialEvaluator partialEvaluator = new PartialEvaluator(this);
        partialEvaluator.initializeArrays(codeAttribute);
        partialEvaluator.evaluateInstructionBlockAndExceptionHandlers(clazz, method, codeAttribute, tracedVariables, tracedStack, n, n2);
        this.generalize(partialEvaluator, 0, codeAttribute.u4codeLength);
    }

    private void generalize(PartialEvaluator partialEvaluator, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (partialEvaluator.branchOriginValues[i] != null) {
                InstructionOffsetValue instructionOffsetValue = this.branchOriginValues[i] = this.branchOriginValues[i] == null ? partialEvaluator.branchOriginValues[i] : this.branchOriginValues[i].generalize(partialEvaluator.branchOriginValues[i]);
            }
            if (!partialEvaluator.isTraced(i)) continue;
            if (partialEvaluator.branchTargetValues[i] != null) {
                InstructionOffsetValue instructionOffsetValue = this.branchTargetValues[i] = this.branchTargetValues[i] == null ? partialEvaluator.branchTargetValues[i] : this.branchTargetValues[i].generalize(partialEvaluator.branchTargetValues[i]);
            }
            if (this.evaluationCounts[i] == 0) {
                this.variablesBefore[i] = partialEvaluator.variablesBefore[i];
                this.stacksBefore[i] = partialEvaluator.stacksBefore[i];
                this.variablesAfter[i] = partialEvaluator.variablesAfter[i];
                this.stacksAfter[i] = partialEvaluator.stacksAfter[i];
                this.generalizedContexts[i] = partialEvaluator.generalizedContexts[i];
                this.evaluationCounts[i] = partialEvaluator.evaluationCounts[i];
                continue;
            }
            this.variablesBefore[i].generalize(partialEvaluator.variablesBefore[i], false);
            this.stacksBefore[i].generalize(partialEvaluator.stacksBefore[i]);
            this.variablesAfter[i].generalize(partialEvaluator.variablesAfter[i], false);
            this.stacksAfter[i].generalize(partialEvaluator.stacksAfter[i]);
            int n3 = i;
            this.evaluationCounts[n3] = this.evaluationCounts[n3] + partialEvaluator.evaluationCounts[i];
        }
    }

    private void evaluateExceptionHandlers(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2) {
        ExceptionHandlerFilter exceptionHandlerFilter = new ExceptionHandlerFilter(n, n2, this);
        do {
            this.evaluateExceptions = false;
            codeAttribute.exceptionsAccept(clazz, method, n, n2, exceptionHandlerFilter);
        } while (this.evaluateExceptions);
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int n = exceptionInfo.u2startPC;
        int n2 = exceptionInfo.u2endPC;
        if (this.mayThrowExceptions(clazz, method, codeAttribute, n, n2)) {
            int n3 = exceptionInfo.u2handlerPC;
            int n4 = exceptionInfo.u2catchType;
            TracedVariables tracedVariables = new TracedVariables(codeAttribute.u2maxLocals);
            TracedStack tracedStack = new TracedStack(codeAttribute.u2maxStack);
            InstructionOffsetValue instructionOffsetValue = new InstructionOffsetValue(n3 | 0x20000000);
            tracedVariables.setProducerValue(instructionOffsetValue);
            tracedStack.setProducerValue(instructionOffsetValue);
            this.generalizeVariables(n, n2, this.evaluateAllCode, tracedVariables);
            this.invocationUnit.enterExceptionHandler(clazz, method, codeAttribute, n3, n4, tracedStack);
            int n5 = this.evaluationCounts[n3];
            this.evaluateInstructionBlock(clazz, method, codeAttribute, tracedVariables, tracedStack, n3);
            if (!this.evaluateExceptions) {
                this.evaluateExceptions = n5 < this.evaluationCounts[n3];
            }
        }
    }

    private void initializeArrays(CodeAttribute codeAttribute) {
        int n = codeAttribute.u4codeLength;
        if (this.branchOriginValues.length < n) {
            this.branchOriginValues = new InstructionOffsetValue[n];
            this.branchTargetValues = new InstructionOffsetValue[n];
            this.variablesBefore = new TracedVariables[n];
            this.stacksBefore = new TracedStack[n];
            this.variablesAfter = new TracedVariables[n];
            this.stacksAfter = new TracedStack[n];
            this.generalizedContexts = new boolean[n];
            this.evaluationCounts = new int[n];
        } else {
            int n2;
            Arrays.fill(this.branchOriginValues, 0, this.codeLength, null);
            Arrays.fill(this.branchTargetValues, 0, this.codeLength, null);
            Arrays.fill(this.generalizedContexts, 0, this.codeLength, false);
            Arrays.fill(this.evaluationCounts, 0, this.codeLength, 0);
            for (n2 = 0; n2 < n; ++n2) {
                if (this.variablesBefore[n2] != null) {
                    this.variablesBefore[n2].reset(codeAttribute.u2maxLocals);
                }
                if (this.stacksBefore[n2] != null) {
                    this.stacksBefore[n2].reset(codeAttribute.u2maxStack);
                }
                if (this.variablesAfter[n2] != null) {
                    this.variablesAfter[n2].reset(codeAttribute.u2maxLocals);
                }
                if (this.stacksAfter[n2] == null) continue;
                this.stacksAfter[n2].reset(codeAttribute.u2maxStack);
            }
            for (n2 = n; n2 < this.codeLength; ++n2) {
                if (this.variablesBefore[n2] != null) {
                    this.variablesBefore[n2].reset(0);
                }
                if (this.stacksBefore[n2] != null) {
                    this.stacksBefore[n2].reset(0);
                }
                if (this.variablesAfter[n2] != null) {
                    this.variablesAfter[n2].reset(0);
                }
                if (this.stacksAfter[n2] == null) continue;
                this.stacksAfter[n2].reset(0);
            }
        }
        this.codeLength = n;
    }

    private void initializeParameters(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables) {
        Variables variables = new Variables(codeAttribute.u2maxLocals);
        this.invocationUnit.enterMethod(clazz, method, variables);
        tracedVariables.initialize(variables);
        for (int i = 0; i < variables.size(); ++i) {
            InstructionOffsetValue instructionOffsetValue = new InstructionOffsetValue(i | 0x1000000);
            tracedVariables.setProducerValue(i, instructionOffsetValue);
        }
    }

    private boolean mayThrowExceptions(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.isTraced(i) || !this.evaluateAllCode && !InstructionFactory.create(codeAttribute.code, i).mayThrowExceptions()) continue;
            return true;
        }
        return false;
    }

    private void generalizeVariables(int n, int n2, boolean bl, TracedVariables tracedVariables) {
        boolean bl2 = true;
        int n3 = -1;
        for (int i = n; i < n2; ++i) {
            if (!this.isTraced(i)) continue;
            TracedVariables tracedVariables2 = this.variablesBefore[i];
            if (bl2) {
                tracedVariables.initialize(tracedVariables2);
                bl2 = false;
            } else {
                tracedVariables.generalize(tracedVariables2, false);
            }
            n3 = i;
        }
        if (bl && n3 >= 0) {
            TracedVariables tracedVariables3 = this.variablesAfter[n3];
            if (bl2) {
                tracedVariables.initialize(tracedVariables3);
            } else {
                tracedVariables.generalize(tracedVariables3, false);
            }
        }
        if (bl2) {
            tracedVariables.reset(tracedVariables.size());
        }
    }

    private class MyTracedInstructionFilter
    implements InstructionVisitor {
        private final boolean traced;
        private final InstructionVisitor instructionVisitor;

        public MyTracedInstructionFilter(boolean bl, InstructionVisitor instructionVisitor) {
            this.traced = bl;
            this.instructionVisitor = instructionVisitor;
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            if (this.shouldVisit(n)) {
                this.instructionVisitor.visitSimpleInstruction(clazz, method, codeAttribute, n, simpleInstruction);
            }
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
            if (this.shouldVisit(n)) {
                this.instructionVisitor.visitVariableInstruction(clazz, method, codeAttribute, n, variableInstruction);
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            if (this.shouldVisit(n)) {
                this.instructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, n, constantInstruction);
            }
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
            if (this.shouldVisit(n)) {
                this.instructionVisitor.visitBranchInstruction(clazz, method, codeAttribute, n, branchInstruction);
            }
        }

        @Override
        public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, TableSwitchInstruction tableSwitchInstruction) {
            if (this.shouldVisit(n)) {
                this.instructionVisitor.visitTableSwitchInstruction(clazz, method, codeAttribute, n, tableSwitchInstruction);
            }
        }

        @Override
        public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
            if (this.shouldVisit(n)) {
                this.instructionVisitor.visitLookUpSwitchInstruction(clazz, method, codeAttribute, n, lookUpSwitchInstruction);
            }
        }

        private boolean shouldVisit(int n) {
            return PartialEvaluator.this.isTraced(n) == this.traced;
        }
    }

    private static class MyInstructionBlock {
        private TracedVariables variables;
        private TracedStack stack;
        private int startOffset;

        private MyInstructionBlock(TracedVariables tracedVariables, TracedStack tracedStack, int n) {
            this.variables = tracedVariables;
            this.stack = tracedStack;
            this.startOffset = n;
        }
    }
}

