/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import proguard.Configuration;
import proguard.backport.DefaultInterfaceMethodConverter;
import proguard.backport.LambdaExpressionConverter;
import proguard.backport.StaticInterfaceMethodConverter;
import proguard.backport.StringConcatenationConverter;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeToClassVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.BootstrapMethodsAttributeShrinker;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionCounter;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVersionSetter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.optimize.peephole.InstructionSequencesReplacer;
import proguard.optimize.peephole.PeepholeOptimizer;
import proguard.util.MultiValueMap;

public class Backporter {
    private final Configuration configuration;

    public Backporter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2, MultiValueMap<String, String> multiValueMap) {
        SimplifiedVisitor simplifiedVisitor;
        Object object;
        Instruction[][][] instructionArray;
        Object object2;
        int n = this.configuration.targetClassVersion;
        if (this.configuration.verbose) {
            System.out.println("Backporting class files...");
        }
        classPool.classesAccept(new ClassCleaner());
        classPool2.classesAccept(new ClassCleaner());
        InstructionCounter instructionCounter = new InstructionCounter();
        ClassCounter classCounter = new ClassCounter();
        MemberCounter memberCounter = new MemberCounter();
        MemberCounter memberCounter2 = new MemberCounter();
        InstructionCounter instructionCounter2 = new InstructionCounter();
        if (n < 0x350000) {
            object2 = new CodeAttributeEditor(true, true);
            classPool.classesAccept(new ClassVersionFilter(0x350000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AttributeToClassVisitor(new MultiClassVisitor(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeOptimizer((CodeAttributeEditor)object2, new StringConcatenationConverter(instructionCounter, (CodeAttributeEditor)object2)))), new BootstrapMethodsAttributeShrinker(), new ClassReferenceInitializer(classPool, classPool2)))))));
        }
        if (n < 0x340000) {
            object2 = new ClassPool();
            classPool.classesAccept(new ClassVersionFilter(0x340000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AttributeToClassVisitor(new ClassPoolFiller((ClassPool)object2))))));
            ((ClassPool)object2).classesAccept(new MultiClassVisitor(new LambdaExpressionConverter(classPool, classPool2, multiValueMap, classCounter), new BootstrapMethodsAttributeShrinker(), new ClassReferenceInitializer(classPool, classPool2)));
            instructionArray = new ClassPool();
            classPool.classesAccept(new ClassVersionFilter(0x340000, new ClassAccessFilter(512, 0, new ClassPoolFiller((ClassPool)instructionArray))));
            object = new ClassPool();
            simplifiedVisitor = new ClassPoolFiller((ClassPool)object);
            instructionArray.classesAccept(new MultiClassVisitor(new StaticInterfaceMethodConverter(classPool, classPool2, multiValueMap, (ClassVisitor)((Object)simplifiedVisitor), memberCounter), new DefaultInterfaceMethodConverter((ClassVisitor)((Object)simplifiedVisitor), memberCounter2)));
            ((ClassPool)object).classesAccept(new ClassReferenceInitializer(classPool, classPool2));
        }
        if (n < 0x330000) {
            object2 = new InstructionSequenceBuilder(classPool, classPool2);
            instructionArray = new Instruction[][][]{{((InstructionSequenceBuilder)object2).invokestatic("java/util/Objects", "requireNonNull", "(Ljava/lang/Object;)Ljava/lang/Object;").__(), ((InstructionSequenceBuilder)object2).dup().invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;").pop().__()}, {((InstructionSequenceBuilder)object2).invokevirtual("java/util/Throwable", "addSuppressed", "(Ljava/lang/Throwable;)V").__(), ((InstructionSequenceBuilder)object2).pop().pop().__()}};
            object = ((InstructionSequenceBuilder)object2).constants();
            simplifiedVisitor = new CodeAttributeEditor();
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeOptimizer(null, (CodeAttributeEditor)simplifiedVisitor, new InstructionSequencesReplacer((Constant[])object, instructionArray, null, (CodeAttributeEditor)simplifiedVisitor, (InstructionVisitor)instructionCounter2)))));
        }
        if (n != 0) {
            classPool.classesAccept(new ClassVersionSetter(n));
        }
        if (this.configuration.verbose) {
            System.out.println("  Number of converted string concatenations:     " + instructionCounter.getCount());
            System.out.println("  Number of converted lambda expressions:        " + classCounter.getCount());
            System.out.println("  Number of converted static interface methods:  " + memberCounter.getCount());
            System.out.println("  Number of converted default interface methods: " + memberCounter2.getCount());
            System.out.println("  Number of replaced Java 7+ method calls:       " + instructionCounter2.getCount());
        }
    }
}

