/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broad.tribble.TribbleException;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineCount;
import org.broadinstitute.variant.vcf.VCFHeaderLineTranslator;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;
import org.broadinstitute.variant.vcf.VCFIDHeaderLine;

public abstract class VCFCompoundHeaderLine
extends VCFHeaderLine
implements VCFIDHeaderLine {
    private String name;
    private int count = -1;
    private VCFHeaderLineCount countType;
    private String description;
    private VCFHeaderLineType type;
    private final SupportedHeaderLineType lineType;

    @Override
    public String getID() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public VCFHeaderLineType getType() {
        return this.type;
    }

    public VCFHeaderLineCount getCountType() {
        return this.countType;
    }

    public boolean isFixedCount() {
        return this.countType == VCFHeaderLineCount.INTEGER;
    }

    public int getCount() {
        if (!this.isFixedCount()) {
            throw new TribbleException("Asking for header line count when type is not an integer");
        }
        return this.count;
    }

    public int getCount(VariantContext vc) {
        switch (this.countType) {
            case INTEGER: {
                return this.count;
            }
            case UNBOUNDED: {
                return -1;
            }
            case A: {
                return vc.getNAlleles() - 1;
            }
            case G: {
                int ploidy = vc.getMaxPloidy(2);
                return GenotypeLikelihoods.numLikelihoods(vc.getNAlleles(), ploidy);
            }
        }
        throw new TribbleException("Unknown count type: " + (Object)((Object)this.countType));
    }

    public void setNumberToUnbounded() {
        this.countType = VCFHeaderLineCount.UNBOUNDED;
        this.count = -1;
    }

    protected VCFCompoundHeaderLine(String name, int count, VCFHeaderLineType type, String description, SupportedHeaderLineType lineType) {
        super(lineType.toString(), "");
        this.name = name;
        this.countType = VCFHeaderLineCount.INTEGER;
        this.count = count;
        this.type = type;
        this.description = description;
        this.lineType = lineType;
        this.validate();
    }

    protected VCFCompoundHeaderLine(String name, VCFHeaderLineCount count, VCFHeaderLineType type, String description, SupportedHeaderLineType lineType) {
        super(lineType.toString(), "");
        this.name = name;
        this.countType = count;
        this.type = type;
        this.description = description;
        this.lineType = lineType;
        this.validate();
    }

    protected VCFCompoundHeaderLine(String line, VCFHeaderVersion version, SupportedHeaderLineType lineType) {
        super(lineType.toString(), "");
        Map<String, String> mapping = VCFHeaderLineTranslator.parseLine(version, line, Arrays.asList("ID", "Number", "Type", "Description"));
        this.name = mapping.get("ID");
        this.count = -1;
        String numberStr = mapping.get("Number");
        if (numberStr.equals("A")) {
            this.countType = VCFHeaderLineCount.A;
        } else if (numberStr.equals("G")) {
            this.countType = VCFHeaderLineCount.G;
        } else if ((version == VCFHeaderVersion.VCF4_0 || version == VCFHeaderVersion.VCF4_1) && numberStr.equals(".") || (version == VCFHeaderVersion.VCF3_2 || version == VCFHeaderVersion.VCF3_3) && numberStr.equals("-1")) {
            this.countType = VCFHeaderLineCount.UNBOUNDED;
        } else {
            this.countType = VCFHeaderLineCount.INTEGER;
            this.count = Integer.valueOf(numberStr);
        }
        if (this.count < 0 && this.countType == VCFHeaderLineCount.INTEGER) {
            throw new TribbleException.InvalidHeader("Count < 0 for fixed size VCF header field " + this.name);
        }
        try {
            this.type = VCFHeaderLineType.valueOf(mapping.get("Type"));
        }
        catch (Exception e) {
            throw new TribbleException(mapping.get("Type") + " is not a valid type in the VCF specification (note that types are case-sensitive)");
        }
        if (this.type == VCFHeaderLineType.Flag && !this.allowFlagValues()) {
            throw new IllegalArgumentException("Flag is an unsupported type for this kind of field");
        }
        this.description = mapping.get("Description");
        if (this.description == null) {
            this.description = "Not provided in original VCF header";
        }
        this.lineType = lineType;
        this.validate();
    }

    private void validate() {
        if (this.name == null || this.type == null || this.description == null || this.lineType == null) {
            throw new IllegalArgumentException(String.format("Invalid VCFCompoundHeaderLine: key=%s name=%s type=%s desc=%s lineType=%s", new Object[]{super.getKey(), this.name, this.type, this.description, this.lineType}));
        }
        if (this.name.contains("<") || this.name.contains(">")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain angle brackets");
        }
        if (this.name.contains("=")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain an equals sign");
        }
        if (this.type == VCFHeaderLineType.Flag && this.count != 0) {
            this.count = 0;
        }
    }

    @Override
    protected String toStringEncoding() {
        Object number;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("ID", this.name);
        switch (this.countType) {
            case A: {
                number = "A";
                break;
            }
            case G: {
                number = "G";
                break;
            }
            case UNBOUNDED: {
                number = ".";
                break;
            }
            default: {
                number = this.count;
            }
        }
        map.put("Number", number);
        map.put("Type", (Object)this.type);
        map.put("Description", this.description);
        return this.lineType.toString() + "=" + VCFHeaderLine.toStringEncoding(map);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof VCFCompoundHeaderLine)) {
            return false;
        }
        VCFCompoundHeaderLine other = (VCFCompoundHeaderLine)o;
        return this.equalsExcludingDescription(other) && this.description.equals(other.description);
    }

    public boolean equalsExcludingDescription(VCFCompoundHeaderLine other) {
        return this.count == other.count && this.countType == other.countType && this.type == other.type && this.lineType == other.lineType && this.name.equals(other.name);
    }

    public boolean sameLineTypeAndName(VCFCompoundHeaderLine other) {
        return this.lineType == other.lineType && this.name.equals(other.name);
    }

    abstract boolean allowFlagValues();

    public static enum SupportedHeaderLineType {
        INFO(true),
        FORMAT(false);

        public final boolean allowFlagValues;

        private SupportedHeaderLineType(boolean flagValues) {
            this.allowFlagValues = flagValues;
        }
    }
}

