/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.InstanceProfileAddRoleRequest;
import com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMInstanceProfileAddRoleDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMInstanceProfileAddRoleDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof InstanceProfileAddRoleRequest) {
            InstanceProfileAddRoleRequest addRequest = (InstanceProfileAddRoleRequest)request;
            LOG.debug((Object)("Associating IAM role to Instance Profile: " + addRequest));
            if (addRequest.getInstanceProfileName() == null) {
                Utils.exit(1, "no Instance Profile name has been passed in.", null);
            }
            if (addRequest.getRoleName() == null) {
                Utils.exit(1, "no role name has been passed in.", null);
            }
            AddRoleToInstanceProfileRequest roleAddRequest = new AddRoleToInstanceProfileRequest();
            roleAddRequest.setInstanceProfileName(addRequest.getInstanceProfileName());
            roleAddRequest.setRoleName(addRequest.getRoleName());
            this.getClient().addRoleToInstanceProfile(roleAddRequest);
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

