/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class SuppliedParameterReference
extends Expression {
    int slotNumber;
    SequenceType type;

    public SuppliedParameterReference(int slot) {
        this.slotNumber = slot;
    }

    public void setSuppliedType(SequenceType type) {
        this.type = type;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.type != null) {
            return this.type.getPrimaryType();
        }
        return AnyItemType.getInstance();
    }

    public int getIntrinsicDependencies() {
        return 128;
    }

    public int computeCardinality() {
        if (this.type != null) {
            return this.type.getCardinality();
        }
        return 57344;
    }

    public Expression copy() {
        return new SuppliedParameterReference(this.slotNumber);
    }

    public ValueRepresentation evaluateVariable(XPathContext c) throws XPathException {
        try {
            return c.evaluateLocalVariable(this.slotNumber);
        }
        catch (AssertionError e) {
            StandardErrorListener.printStackTrace(System.err, c);
            throw new AssertionError((Object)(((Throwable)((Object)e)).getMessage() + ". No value has been set for parameter " + this.slotNumber));
        }
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        try {
            return Value.getIterator(c.evaluateLocalVariable(this.slotNumber));
        }
        catch (AssertionError e) {
            StandardErrorListener.printStackTrace(System.err, c);
            throw new AssertionError((Object)(((Throwable)((Object)e)).getMessage() + ". No value has been set for parameter " + this.slotNumber));
        }
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        ValueRepresentation actual = context.evaluateLocalVariable(this.slotNumber);
        return Value.asItem(actual);
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("suppliedParam");
        destination.emitAttribute("slot", this.slotNumber + "");
        destination.endElement();
    }

    public String toString() {
        return "suppliedParam(" + this.slotNumber + ")";
    }
}

