#!/bin/sh

#  A shell to show a block in a html format using the retblock program
#  and unix shell commands. 
#  Usage showblock.sh blocks_file_name block_accession.
#  The block header, sequence weights and end string ("//") are removed.

RETBLOCK=./blimps-bin/retblock

if [ $# -ne 2 ]
then
   cat << EOM
Content-type: text/html

<HTML>
<TITLE>Extract block error</TITLE>
<H3>Extract block error</H3>
Wrong number of arguments given. There should be two arguments: the blocks file name and the accession code of the required block(s).
</HTML>
EOM
   exit 1
else
cat << EOM
Content-type: text/html

<HTML>
<TITLE>Block(s) $2</TITLE>
<PRE>
EOM
fi

DB=$1
BLKNAME=$2

# extract block. remove header lines (except for the block accession), the last 3 chars in each remaining line (the sequence weights) and the "\\" string with "--".
$RETBLOCK $DB $BLKNAME -n | grep -v "ID   " | grep -v "DE   " | grep -v "BL   "| sed -e 's|^AC   |<B>|' -e 's|...$||g' -e 's|; distance.*$|</B>|' -e 's|//$||'

#>>> $status is set by csh, but apparently not by sh
#if [ $status -ne 0 ]
#then
#cat << EOM
#</PRE>
#Could not extract block $2. Sorry.
#</HTML>
#EOM
#   exit 1
#else
cat << EOM
</PRE>
</HTML>
EOM
#fi

exit 0

