#!/bin/sh
#		cobbler.sh <file of blocks>
#
blocks=""
if [ $# -gt 0 -a -f "$1" ]
then
      blocks=`cat $1`
fi
#  From the <HTML> to </HTML> is ~blocks/www/cobbler.html
#	with the blocks TEXTAREA modified to insert $blocks

cat << EOM
Content-type: text/html



<HTML>
<TITLE>Cobbler Sequence</TITLE>
<H1><IMG ALIGN=MIDDLE SRC="/blocks/icons/blocks.xbm">Cobbler Sequence</H1>

<FORM METHOD="POST" ACTION="/blocks-bin/cobbler.pl">

<P>

<A HREF="help/about_cobbler.html">COBBLER </A>
aligns a set of Blocks with a protein sequence
and embeds a consensus representation of the Blocks in
the sequence, which can then be used to search sequence
databases using 
<A HREF="http://www.ncbi.nlm.nih.gov/BLAST/">BLAST</A>,
and other sequence searching programs.
<A HREF="blocks/make_blocks.html">Block Maker</A> makes a
COBBLER sequence automatically, but this page can be used
if you want to embed your blocks in a different sequence.
If you need to convert another multiple alignment to
<A HREF="help/blocks_format.html">BLOCKS format</A>, use the
<A HREF="process_blocks.html">Multiple Alignment Processor</A> or the
<A HREF="block_formatter.html">Block Formatter</A>.
<P>

Enter your Blocks in 
<A HREF="help/blocks_format.html">BLOCKS format</A>:<BR>
<TEXTAREA NAME="blocks" ROWS=10 COLS=70>$blocks</TEXTAREA>
<P>
Enter your protein sequence in 
<A HREF="http://www.ncbi.nlm.nih.gov/BLAST/fasta.html">FASTA format</A>:<BR>
<TEXTAREA NAME="sequence" ROWS=10 COLS=70></TEXTAREA>

<HR>
<INPUT TYPE=submit VALUE="Embed">
<INPUT TYPE=reset>
<BR>

<HR>
<A HREF="/blocks">Blocks home</A>
<HR>
<A href="contact.html">Contact us</A> <P>
Page last modified on <MODIFICATION_DATE>Dec 1999</MODIFICATION_DATE>
</HTML>





EOM
