#!/bin/sh

blocks=blocks

# If a first argument passed to the shell it should be a valid block name in
# the Blocks Database (BL#####[@], 3 is a digit and @ a letter). It will be
# placed in the DB_query_block text box. 
# If a second argument is passed to the shell it should be a name of a file
# with correctly formatted block(s). The content of the file will be read into
# the User_query_block text area.
# The shell should either receive no arguments, one argument only 
# (for example in links from get_block pages), or two arguments where the
# first one is empty (for example in links from make_block output page).

# check to see if a second argument has been passed and if its a file that
# could be read

if [ "$1" = "" ]
then
  # there is no block number given
  if [ $# > 1 -a -f "$2" -a -r "$2" ]
  then
    query=`cat $2`
  else
    query=""
  fi

else
  # There is a block number given
  query=`./extblock_stdout ./blocks.dat $1`
fi



#####
##
##  Common HTML text
##
#####

cat << EOM
Content-type: text/html

<TITLE>LAMA Search</TITLE>
<H1><A HREF="/$blocks/LAMA_YWK.html">
<IMG ALIGN=MIDDLE SRC="/$blocks/llama.2.gif"></A>
Block vs Block Searcher using LAMA</H1>
<H3>(Local Alignment of Multiple Alignments) 
<A HREF="/$blocks/help/LAMA_help.html">?</A></H3>
<P>at the 
<A HREF="http://www.fhcrc.org/">Fred Hutchinson Cancer Research Center</A> Blocks WWW server.
<HR>
Search a block against a
<A HREF="/$blocks/help/about_blocks.html">database of blocks</A>
or compare pairs of blocks.<BR>
<P>

<FORM METHOD="POST" ACTION="/${blocks}-bin/LAMA_search">

Enter your email address if you want the results through email:<P>
<INPUT SIZE=50 NAME="address"><P>

<HR>
After filling in the rest of the form below you can 
<INPUT TYPE=submit VALUE="Perform the Search">. 
<INPUT TYPE=reset VALUE="Reset & Clear"> form.
<P>
Depending on the server usage, the delay for the answer may vary from
one request to another one.<BR>
Please be patient.<BR>
<HR>

EOM




#####
##
##  User specified target data section
##
#####

if [ "$0" = "`pwd`/LAMA_search_userdb.sh" ]
then
#####
##  User target data HTML text
#####

  # This is the script that the user uses to input their own target data

  cat << EOM
<STRONG>Additional options</STRONG><BR>
<A HREF="/$blocks/help/LAMA_help.html#OUTPUT">Output Level</A>
<SELECT NAME="debug_level">
<OPTION SELECTED VALUE="0">Standard (default)
<OPTION VALUE="3"> and column contributions
<OPTION VALUE="6"> and block matrices
</SELECT>
<BR>
<A HREF="/$blocks/help/LAMA_help.html#CUTOFF">Score Cutoff Level</A>
(0 = default) <INPUT NAME="score_cutoff_level" SIZE=3 VALUE="0"></INPUT>
<HR>

Enter block(s) target data (use the 
<A HREF="/$blocks/blocks_format.html">BLOCK format</A>; 
reformat multiple sequence alignments 
<A HREF="/$blocks/block_formatter.html">here</A>)<BR>
or search the available <A HREF="LAMA_search.sh?$1+$2">databases of blocks</A>:
<BR>
<TEXTAREA NAME="User_target_block" ROWS=20 COLS=70></TEXTAREA>

<HR>
<INPUT NAME = "database" VALUE = "no-db" TYPE=hidden CHECKED>
EOM

else
#####
##  Database as target data HTML text
#####
  # This is the script that the user uses to use the given databases

cat << EOM

Select the database to search:<BR>
<A HREF="/$blocks/help/about_blocks.html#blocks">Blocks Database</A>
<INPUT NAME="database" VALUE="blocks-db" TYPE=radio CHECKED>  or
<A HREF="/$blocks/help/about_blocks.html#prints">Prints Database</A>
<INPUT NAME = "database" VALUE = "prints-db" TYPE=radio>
or Supply your own target data 
<A HREF="LAMA_search_userdb.sh?$1+$2"><STRONG>O</STRONG></A>.
<P>

EOM

fi




#####
##
##  Common HTML text
##
#####

cat << EOM

Enter block(s) query (use the  
<A HREF="/$blocks/blocks_format.html">BLOCK format</A>; 
reformat multiple sequence alignments 
<A HREF="/$blocks/block_formatter.html">here</A>):
<BR>
<TEXTAREA NAME="User_query_block" ROWS=20 COLS=70>$query</TEXTAREA>

<HR>

<INPUT TYPE=submit VALUE="Perform Search">
<INPUT TYPE=reset VALUE="Reset & Clear">
<P>
Depending on the server usage, the delay for the answer may vary from
one request to another one.<BR>
Please be patient.<BR>
<HR>
</FORM>

<p>


<A HREF="/$blocks/help/LAMA_help.html">LAMA Searcher Help</A>
<P>
<!-- Note, these go to the BLOCKS pages, not the test pages -->
<A HREF="/">[Blocks home]</A> 
<A HREF="/blocks_search.html">[Block Searcher]</A>
<A HREF="/blocks/make_blocks.html">[Block Maker]</A>
<A HREF="/blocks-bin/getblock.sh">[Get Blocks]</A>
<A HREF="/block_formatter.html">[format a block]</A>
<A HREF="/blocks/biassed_blocks.html">[check for biassed blocks]</A>
<A HREF="/blocks-bin/LAMA_search.sh">[LAMA Searcher]</A>

<HR>
Page last modified <MODIFICATION_DATE>August 1996</MODIFICATION_DATE>
<Address>
<A HREF="/~pietro">Shmuel Pietrokovski</A> &ltpietro@sparky.fhcrc.org&gt
</Address>

EOM
