# Ubuntu Pro Client development

This section contains developer documentation for the Ubuntu Pro Client project.

## Getting started

* [Get started developing for Ubuntu Pro Client](dev-docs/tutorial/getting-started.md)
* [How to contribute documentation](dev-docs/tutorial/contribute_docs.md)

## How-to guides

* [Run the code formatting tools](dev-docs/how-to/code_formatting.md)
* [How to spellcheck messages](dev-docs/how-to/spellcheck.md)
* [Release a new version](dev-docs/how-to/release_a_new_version.md)
* [Release a hotfix](dev-docs/how-to/release_a_hotfix.md)
* [Use the contract staging environment](dev-docs/how-to/use_staging_environment.md)
* [Use the magic attach endpoints](dev-docs/how-to/magic_attach_endpoints.md)
* [Permanently detach Pro instances](dev-docs/how-to/detach_pro_instances.md)
* [Troubleshoot security confinement](dev-docs/how-to/troubleshoot_security_confinement.md)
* [Troubleshoot APT news security confinement](dev-docs/how-to/troubleshoot_apt_news_security_confinement.md)
* [Set up a Windows machine for WSL testing](dev-docs/how-to/wsl_testing_setup.md)
* [Run unit tests](dev-docs/how-to/unit_testing.md)
* [Run integration tests](dev-docs/how-to/integration_testing.md)
* [Run dep8 tests](dev-docs/how-to/run_dep8_tests.md)

## Reference

* [Version string formatting](dev-docs/reference/version_string_formatting.md)
* [Our documentation style guide](dev-docs/reference/styleguide.md)

## Explanation

* [PR review policy](dev-docs/explanation/pr_review_policy.md)
* [Early review sign-off](dev-docs/explanation/early_review_signoff.md)
* [Translations](dev-docs/explanation/translations.md)
* [Policy on string changes](dev-docs/explanation/string_changes_policy.md)
* [Auto-attach mechanisms](dev-docs/explanation/autoattach_mechanisms.md)
* [How auto-attach works](dev-docs/explanation/how_auto_attach_works.md)
* [What happens during attach](dev-docs/explanation/what_happens_during_attach.md)
