/* SavedSearchDBTable.c generated by valac 0.40.4, the Vala compiler
 * generated from SavedSearchDBTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include <gee.h>
#include <sqlite3.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SAVED_SEARCH_ID (saved_search_id_get_type ())
typedef struct _SavedSearchID SavedSearchID;

#define TYPE_SAVED_SEARCH_ROW (saved_search_row_get_type ())
#define SAVED_SEARCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH_ROW, SavedSearchRow))
#define SAVED_SEARCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH_ROW, SavedSearchRowClass))
#define IS_SAVED_SEARCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH_ROW))
#define IS_SAVED_SEARCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH_ROW))
#define SAVED_SEARCH_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH_ROW, SavedSearchRowClass))

typedef struct _SavedSearchRow SavedSearchRow;
typedef struct _SavedSearchRowClass SavedSearchRowClass;
typedef struct _SavedSearchRowPrivate SavedSearchRowPrivate;

#define TYPE_SEARCH_OPERATOR (search_operator_get_type ())

#define TYPE_SEARCH_CONDITION (search_condition_get_type ())
#define SEARCH_CONDITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION, SearchCondition))
#define SEARCH_CONDITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION, SearchConditionClass))
#define IS_SEARCH_CONDITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION))
#define IS_SEARCH_CONDITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION))
#define SEARCH_CONDITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION, SearchConditionClass))

typedef struct _SearchCondition SearchCondition;
typedef struct _SearchConditionClass SearchConditionClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecSavedSearchRow ParamSpecSavedSearchRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_SAVED_SEARCH_DB_TABLE (saved_search_db_table_get_type ())
#define SAVED_SEARCH_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTable))
#define SAVED_SEARCH_DB_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTableClass))
#define IS_SAVED_SEARCH_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH_DB_TABLE))
#define IS_SAVED_SEARCH_DB_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH_DB_TABLE))
#define SAVED_SEARCH_DB_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTableClass))

typedef struct _SavedSearchDBTable SavedSearchDBTable;
typedef struct _SavedSearchDBTableClass SavedSearchDBTableClass;
typedef struct _SavedSearchDBTablePrivate SavedSearchDBTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _search_condition_unref0(var) ((var == NULL) ? NULL : (var = (search_condition_unref (var), NULL)))
#define _saved_search_row_unref0(var) ((var == NULL) ? NULL : (var = (saved_search_row_unref (var), NULL)))

#define TYPE_SEARCH_CONDITION_TEXT (search_condition_text_get_type ())
#define SEARCH_CONDITION_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_TEXT, SearchConditionText))
#define SEARCH_CONDITION_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_TEXT, SearchConditionTextClass))
#define IS_SEARCH_CONDITION_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_TEXT))
#define IS_SEARCH_CONDITION_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_TEXT))
#define SEARCH_CONDITION_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_TEXT, SearchConditionTextClass))

typedef struct _SearchConditionText SearchConditionText;
typedef struct _SearchConditionTextClass SearchConditionTextClass;

#define SEARCH_CONDITION_TYPE_SEARCH_TYPE (search_condition_search_type_get_type ())

#define SEARCH_CONDITION_TEXT_TYPE_CONTEXT (search_condition_text_context_get_type ())

#define TYPE_SEARCH_CONDITION_MEDIA_TYPE (search_condition_media_type_get_type ())
#define SEARCH_CONDITION_MEDIA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaType))
#define SEARCH_CONDITION_MEDIA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaTypeClass))
#define IS_SEARCH_CONDITION_MEDIA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE))
#define IS_SEARCH_CONDITION_MEDIA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_MEDIA_TYPE))
#define SEARCH_CONDITION_MEDIA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaTypeClass))

typedef struct _SearchConditionMediaType SearchConditionMediaType;
typedef struct _SearchConditionMediaTypeClass SearchConditionMediaTypeClass;

#define SEARCH_CONDITION_MEDIA_TYPE_TYPE_CONTEXT (search_condition_media_type_context_get_type ())

#define SEARCH_CONDITION_MEDIA_TYPE_TYPE_MEDIA_TYPE (search_condition_media_type_media_type_get_type ())

#define TYPE_SEARCH_CONDITION_FLAGGED (search_condition_flagged_get_type ())
#define SEARCH_CONDITION_FLAGGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlagged))
#define SEARCH_CONDITION_FLAGGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlaggedClass))
#define IS_SEARCH_CONDITION_FLAGGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_FLAGGED))
#define IS_SEARCH_CONDITION_FLAGGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_FLAGGED))
#define SEARCH_CONDITION_FLAGGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlaggedClass))

typedef struct _SearchConditionFlagged SearchConditionFlagged;
typedef struct _SearchConditionFlaggedClass SearchConditionFlaggedClass;

#define SEARCH_CONDITION_FLAGGED_TYPE_STATE (search_condition_flagged_state_get_type ())

#define TYPE_SEARCH_CONDITION_MODIFIED (search_condition_modified_get_type ())
#define SEARCH_CONDITION_MODIFIED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModified))
#define SEARCH_CONDITION_MODIFIED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModifiedClass))
#define IS_SEARCH_CONDITION_MODIFIED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_MODIFIED))
#define IS_SEARCH_CONDITION_MODIFIED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_MODIFIED))
#define SEARCH_CONDITION_MODIFIED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModifiedClass))

typedef struct _SearchConditionModified SearchConditionModified;
typedef struct _SearchConditionModifiedClass SearchConditionModifiedClass;

#define SEARCH_CONDITION_MODIFIED_TYPE_CONTEXT (search_condition_modified_context_get_type ())

#define SEARCH_CONDITION_MODIFIED_TYPE_STATE (search_condition_modified_state_get_type ())

#define TYPE_SEARCH_CONDITION_RATING (search_condition_rating_get_type ())
#define SEARCH_CONDITION_RATING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_RATING, SearchConditionRating))
#define SEARCH_CONDITION_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_RATING, SearchConditionRatingClass))
#define IS_SEARCH_CONDITION_RATING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_RATING))
#define IS_SEARCH_CONDITION_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_RATING))
#define SEARCH_CONDITION_RATING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_RATING, SearchConditionRatingClass))

typedef struct _SearchConditionRating SearchConditionRating;
typedef struct _SearchConditionRatingClass SearchConditionRatingClass;

#define TYPE_RATING (rating_get_type ())

#define SEARCH_CONDITION_RATING_TYPE_CONTEXT (search_condition_rating_context_get_type ())

#define TYPE_SEARCH_CONDITION_DATE (search_condition_date_get_type ())
#define SEARCH_CONDITION_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_DATE, SearchConditionDate))
#define SEARCH_CONDITION_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_DATE, SearchConditionDateClass))
#define IS_SEARCH_CONDITION_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_DATE))
#define IS_SEARCH_CONDITION_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_DATE))
#define SEARCH_CONDITION_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_DATE, SearchConditionDateClass))

typedef struct _SearchConditionDate SearchConditionDate;
typedef struct _SearchConditionDateClass SearchConditionDateClass;

#define SEARCH_CONDITION_DATE_TYPE_CONTEXT (search_condition_date_context_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SavedSearchID {
	gint64 id;
};

typedef enum  {
	SEARCH_OPERATOR_ANY = 0,
	SEARCH_OPERATOR_ALL,
	SEARCH_OPERATOR_NONE
} SearchOperator;

struct _SavedSearchRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SavedSearchRowPrivate * priv;
	SavedSearchID search_id;
	gchar* name;
	SearchOperator operator;
	GeeList* conditions;
};

struct _SavedSearchRowClass {
	GTypeClass parent_class;
	void (*finalize) (SavedSearchRow *self);
};

struct _ParamSpecSavedSearchRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _SavedSearchDBTable {
	DatabaseTable parent_instance;
	SavedSearchDBTablePrivate * priv;
};

struct _SavedSearchDBTableClass {
	DatabaseTableClass parent_class;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
typedef enum  {
	SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT = 0,
	SEARCH_CONDITION_SEARCH_TYPE_TITLE,
	SEARCH_CONDITION_SEARCH_TYPE_TAG,
	SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME,
	SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME,
	SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE,
	SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE,
	SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE,
	SEARCH_CONDITION_SEARCH_TYPE_RATING,
	SEARCH_CONDITION_SEARCH_TYPE_COMMENT,
	SEARCH_CONDITION_SEARCH_TYPE_DATE
} SearchConditionSearchType;

typedef enum  {
	SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS = 0,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY,
	SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH,
	SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH,
	SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_SET
} SearchConditionTextContext;

typedef enum  {
	SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS = 0,
	SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT
} SearchConditionMediaTypeContext;

typedef enum  {
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL = 0,
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW,
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO
} SearchConditionMediaTypeMediaType;

typedef enum  {
	SEARCH_CONDITION_FLAGGED_STATE_FLAGGED = 0,
	SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED
} SearchConditionFlaggedState;

typedef enum  {
	SEARCH_CONDITION_MODIFIED_CONTEXT_HAS = 0,
	SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO
} SearchConditionModifiedContext;

typedef enum  {
	SEARCH_CONDITION_MODIFIED_STATE_MODIFIED = 0,
	SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES,
	SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES
} SearchConditionModifiedState;

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

typedef enum  {
	SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER = 0,
	SEARCH_CONDITION_RATING_CONTEXT_ONLY,
	SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER
} SearchConditionRatingContext;

typedef enum  {
	SEARCH_CONDITION_DATE_CONTEXT_EXACT = 0,
	SEARCH_CONDITION_DATE_CONTEXT_AFTER,
	SEARCH_CONDITION_DATE_CONTEXT_BEFORE,
	SEARCH_CONDITION_DATE_CONTEXT_BETWEEN,
	SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET
} SearchConditionDateContext;


static gpointer saved_search_row_parent_class = NULL;
static gpointer saved_search_db_table_parent_class = NULL;
static SavedSearchDBTable* saved_search_db_table_instance;
static SavedSearchDBTable* saved_search_db_table_instance = NULL;
extern sqlite3* database_table_db;

GType saved_search_id_get_type (void) G_GNUC_CONST;
SavedSearchID* saved_search_id_dup (const SavedSearchID* self);
void saved_search_id_free (SavedSearchID* self);
#define SAVED_SEARCH_ID_INVALID ((gint64) -1)
void saved_search_id_init (SavedSearchID *self,
                           gint64 id);
gboolean saved_search_id_is_invalid (SavedSearchID *self);
gboolean saved_search_id_is_valid (SavedSearchID *self);
gpointer saved_search_row_ref (gpointer instance);
void saved_search_row_unref (gpointer instance);
GParamSpec* param_spec_saved_search_row (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_saved_search_row (GValue* value,
                                 gpointer v_object);
void value_take_saved_search_row (GValue* value,
                                  gpointer v_object);
gpointer value_get_saved_search_row (const GValue* value);
GType saved_search_row_get_type (void) G_GNUC_CONST;
GType search_operator_get_type (void) G_GNUC_CONST;
gpointer search_condition_ref (gpointer instance);
void search_condition_unref (gpointer instance);
GParamSpec* param_spec_search_condition (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_search_condition (GValue* value,
                                 gpointer v_object);
void value_take_search_condition (GValue* value,
                                  gpointer v_object);
gpointer value_get_search_condition (const GValue* value);
GType search_condition_get_type (void) G_GNUC_CONST;
SavedSearchRow* saved_search_row_new (void);
SavedSearchRow* saved_search_row_construct (GType object_type);
static void saved_search_row_finalize (SavedSearchRow * obj);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_database_table (GValue* value,
                               gpointer v_object);
void value_take_database_table (GValue* value,
                                gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType saved_search_db_table_get_type (void) G_GNUC_CONST;
static SavedSearchDBTable* saved_search_db_table_new (void);
static SavedSearchDBTable* saved_search_db_table_construct (GType object_type);
DatabaseTable* database_table_construct (GType object_type);
void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
void database_table_fatal (const gchar* op,
                           gint res);
SavedSearchDBTable* saved_search_db_table_get_instance (void);
GQuark database_error_quark (void);
SavedSearchRow* saved_search_db_table_add (SavedSearchDBTable* self,
                                           const gchar* name,
                                           SearchOperator operator,
                                           GeeArrayList* conditions,
                                           GError** error);
gchar* search_operator_to_string (SearchOperator self);
void database_table_throw_error (const gchar* method,
                                 gint res,
                                 GError** error);
static void saved_search_db_table_add_condition (SavedSearchDBTable* self,
                                          SavedSearchID* id,
                                          SearchCondition* condition,
                                          GError** error);
GType search_condition_text_get_type (void) G_GNUC_CONST;
GType search_condition_search_type_get_type (void) G_GNUC_CONST;
SearchConditionSearchType search_condition_get_search_type (SearchCondition* self);
gchar* search_condition_search_type_to_string (SearchConditionSearchType self);
GType search_condition_text_context_get_type (void) G_GNUC_CONST;
SearchConditionTextContext search_condition_text_get_context (SearchConditionText* self);
gchar* search_condition_text_context_to_string (SearchConditionTextContext self);
const gchar* search_condition_text_get_text (SearchConditionText* self);
GType search_condition_media_type_get_type (void) G_GNUC_CONST;
GType search_condition_media_type_context_get_type (void) G_GNUC_CONST;
SearchConditionMediaTypeContext search_condition_media_type_get_context (SearchConditionMediaType* self);
gchar* search_condition_media_type_context_to_string (SearchConditionMediaTypeContext self);
GType search_condition_media_type_media_type_get_type (void) G_GNUC_CONST;
SearchConditionMediaTypeMediaType search_condition_media_type_get_media_type (SearchConditionMediaType* self);
gchar* search_condition_media_type_media_type_to_string (SearchConditionMediaTypeMediaType self);
GType search_condition_flagged_get_type (void) G_GNUC_CONST;
GType search_condition_flagged_state_get_type (void) G_GNUC_CONST;
SearchConditionFlaggedState search_condition_flagged_get_state (SearchConditionFlagged* self);
gchar* search_condition_flagged_state_to_string (SearchConditionFlaggedState self);
GType search_condition_modified_get_type (void) G_GNUC_CONST;
GType search_condition_modified_context_get_type (void) G_GNUC_CONST;
SearchConditionModifiedContext search_condition_modified_get_context (SearchConditionModified* self);
gchar* search_condition_modified_context_to_string (SearchConditionModifiedContext self);
GType search_condition_modified_state_get_type (void) G_GNUC_CONST;
SearchConditionModifiedState search_condition_modified_get_state (SearchConditionModified* self);
gchar* search_condition_modified_state_to_string (SearchConditionModifiedState self);
GType search_condition_rating_get_type (void) G_GNUC_CONST;
GType rating_get_type (void) G_GNUC_CONST;
Rating search_condition_rating_get_rating (SearchConditionRating* self);
gint rating_serialize (Rating self);
GType search_condition_rating_context_get_type (void) G_GNUC_CONST;
SearchConditionRatingContext search_condition_rating_get_context (SearchConditionRating* self);
gchar* search_condition_rating_context_to_string (SearchConditionRatingContext self);
GType search_condition_date_get_type (void) G_GNUC_CONST;
GType search_condition_date_context_get_type (void) G_GNUC_CONST;
SearchConditionDateContext search_condition_date_get_context (SearchConditionDate* self);
gchar* search_condition_date_context_to_string (SearchConditionDateContext self);
GDateTime* search_condition_date_get_date_one (SearchConditionDate* self);
GDateTime* search_condition_date_get_date_two (SearchConditionDate* self);
static void saved_search_db_table_remove_conditions_for_search_id (SavedSearchDBTable* self,
                                                            SavedSearchID* search_id,
                                                            GError** error);
static void saved_search_db_table_remove_conditions_for_table (SavedSearchDBTable* self,
                                                        const gchar* table_name,
                                                        SavedSearchID* search_id,
                                                        GError** error);
static GeeList* saved_search_db_table_get_conditions_for_id (SavedSearchDBTable* self,
                                                      SavedSearchID* search_id,
                                                      GError** error);
SearchConditionSearchType search_condition_search_type_from_string (const gchar* str);
SearchConditionTextContext search_condition_text_context_from_string (const gchar* str);
SearchConditionText* search_condition_text_new (SearchConditionSearchType search_type,
                                                const gchar* text,
                                                SearchConditionTextContext context);
SearchConditionText* search_condition_text_construct (GType object_type,
                                                      SearchConditionSearchType search_type,
                                                      const gchar* text,
                                                      SearchConditionTextContext context);
SearchConditionMediaTypeContext search_condition_media_type_context_from_string (const gchar* str);
SearchConditionMediaTypeMediaType search_condition_media_type_media_type_from_string (const gchar* str);
SearchConditionMediaType* search_condition_media_type_new (SearchConditionSearchType search_type,
                                                           SearchConditionMediaTypeContext context,
                                                           SearchConditionMediaTypeMediaType media_type);
SearchConditionMediaType* search_condition_media_type_construct (GType object_type,
                                                                 SearchConditionSearchType search_type,
                                                                 SearchConditionMediaTypeContext context,
                                                                 SearchConditionMediaTypeMediaType media_type);
SearchConditionFlaggedState search_condition_flagged_state_from_string (const gchar* str);
SearchConditionFlagged* search_condition_flagged_new (SearchConditionSearchType search_type,
                                                      SearchConditionFlaggedState state);
SearchConditionFlagged* search_condition_flagged_construct (GType object_type,
                                                            SearchConditionSearchType search_type,
                                                            SearchConditionFlaggedState state);
SearchConditionModifiedContext search_condition_modified_context_from_string (const gchar* str);
SearchConditionModifiedState search_condition_modified_state_from_string (const gchar* str);
SearchConditionModified* search_condition_modified_new (SearchConditionSearchType search_type,
                                                        SearchConditionModifiedContext context,
                                                        SearchConditionModifiedState state);
SearchConditionModified* search_condition_modified_construct (GType object_type,
                                                              SearchConditionSearchType search_type,
                                                              SearchConditionModifiedContext context,
                                                              SearchConditionModifiedState state);
Rating rating_unserialize (gint value);
SearchConditionRatingContext search_condition_rating_context_from_string (const gchar* str);
SearchConditionRating* search_condition_rating_new (SearchConditionSearchType search_type,
                                                    Rating rating,
                                                    SearchConditionRatingContext context);
SearchConditionRating* search_condition_rating_construct (GType object_type,
                                                          SearchConditionSearchType search_type,
                                                          Rating rating,
                                                          SearchConditionRatingContext context);
SearchConditionDateContext search_condition_date_context_from_string (const gchar* str);
SearchConditionDate* search_condition_date_new (SearchConditionSearchType search_type,
                                                SearchConditionDateContext context,
                                                GDateTime* date_one,
                                                GDateTime* date_two);
SearchConditionDate* search_condition_date_construct (GType object_type,
                                                      SearchConditionSearchType search_type,
                                                      SearchConditionDateContext context,
                                                      GDateTime* date_one,
                                                      GDateTime* date_two);
void saved_search_db_table_create_from_row (SavedSearchDBTable* self,
                                            SavedSearchRow* row,
                                            SavedSearchID* result,
                                            GError** error);
void saved_search_db_table_remove (SavedSearchDBTable* self,
                                   SavedSearchID* search_id,
                                   GError** error);
void database_table_delete_by_id (DatabaseTable* self,
                                  gint64 id,
                                  GError** error);
SavedSearchRow* saved_search_db_table_get_row (SavedSearchDBTable* self,
                                               SavedSearchID* search_id,
                                               GError** error);
SearchOperator search_operator_from_string (const gchar* str);
GeeList* saved_search_db_table_get_all_rows (SavedSearchDBTable* self,
                                             GError** error);
void saved_search_db_table_rename (SavedSearchDBTable* self,
                                   SavedSearchID* search_id,
                                   const gchar* new_name,
                                   GError** error);
void database_table_update_text_by_id_2 (DatabaseTable* self,
                                         gint64 id,
                                         const gchar* column,
                                         const gchar* text,
                                         GError** error);
static void saved_search_db_table_finalize (DatabaseTable * obj);


void
saved_search_id_init (SavedSearchID *self,
                      gint64 id)
{
#line 12 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	memset (self, 0, sizeof (SavedSearchID));
#line 13 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	(*self).id = id;
#line 513 "SavedSearchDBTable.c"
}


gboolean
saved_search_id_is_invalid (SavedSearchID *self)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
#line 17 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = (*self).id;
#line 17 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = _tmp0_ == SAVED_SEARCH_ID_INVALID;
#line 17 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 528 "SavedSearchDBTable.c"
}


gboolean
saved_search_id_is_valid (SavedSearchID *self)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
#line 21 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = (*self).id;
#line 21 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = _tmp0_ != SAVED_SEARCH_ID_INVALID;
#line 21 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 543 "SavedSearchDBTable.c"
}


SavedSearchID*
saved_search_id_dup (const SavedSearchID* self)
{
	SavedSearchID* dup;
#line 7 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	dup = g_new0 (SavedSearchID, 1);
#line 7 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	memcpy (dup, self, sizeof (SavedSearchID));
#line 7 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return dup;
#line 557 "SavedSearchDBTable.c"
}


void
saved_search_id_free (SavedSearchID* self)
{
#line 7 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_free (self);
#line 566 "SavedSearchDBTable.c"
}


GType
saved_search_id_get_type (void)
{
	static volatile gsize saved_search_id_type_id__volatile = 0;
	if (g_once_init_enter (&saved_search_id_type_id__volatile)) {
		GType saved_search_id_type_id;
		saved_search_id_type_id = g_boxed_type_register_static ("SavedSearchID", (GBoxedCopyFunc) saved_search_id_dup, (GBoxedFreeFunc) saved_search_id_free);
		g_once_init_leave (&saved_search_id_type_id__volatile, saved_search_id_type_id);
	}
	return saved_search_id_type_id__volatile;
}


SavedSearchRow*
saved_search_row_construct (GType object_type)
{
	SavedSearchRow* self = NULL;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	self = (SavedSearchRow*) g_type_create_instance (object_type);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return self;
#line 591 "SavedSearchDBTable.c"
}


SavedSearchRow*
saved_search_row_new (void)
{
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return saved_search_row_construct (TYPE_SAVED_SEARCH_ROW);
#line 600 "SavedSearchDBTable.c"
}


static void
value_saved_search_row_init (GValue* value)
{
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	value->data[0].v_pointer = NULL;
#line 609 "SavedSearchDBTable.c"
}


static void
value_saved_search_row_free_value (GValue* value)
{
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		saved_search_row_unref (value->data[0].v_pointer);
#line 620 "SavedSearchDBTable.c"
	}
}


static void
value_saved_search_row_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (src_value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		dest_value->data[0].v_pointer = saved_search_row_ref (src_value->data[0].v_pointer);
#line 633 "SavedSearchDBTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 637 "SavedSearchDBTable.c"
	}
}


static gpointer
value_saved_search_row_peek_pointer (const GValue* value)
{
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return value->data[0].v_pointer;
#line 647 "SavedSearchDBTable.c"
}


static gchar*
value_saved_search_row_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (collect_values[0].v_pointer) {
#line 659 "SavedSearchDBTable.c"
		SavedSearchRow * object;
		object = collect_values[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 666 "SavedSearchDBTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 670 "SavedSearchDBTable.c"
		}
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		value->data[0].v_pointer = saved_search_row_ref (object);
#line 674 "SavedSearchDBTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		value->data[0].v_pointer = NULL;
#line 678 "SavedSearchDBTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return NULL;
#line 682 "SavedSearchDBTable.c"
}


static gchar*
value_saved_search_row_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	SavedSearchRow ** object_p;
	object_p = collect_values[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (!object_p) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 698 "SavedSearchDBTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (!value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		*object_p = NULL;
#line 704 "SavedSearchDBTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		*object_p = value->data[0].v_pointer;
#line 708 "SavedSearchDBTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		*object_p = saved_search_row_ref (value->data[0].v_pointer);
#line 712 "SavedSearchDBTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return NULL;
#line 716 "SavedSearchDBTable.c"
}


GParamSpec*
param_spec_saved_search_row (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecSavedSearchRow* spec;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SAVED_SEARCH_ROW), NULL);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return G_PARAM_SPEC (spec);
#line 736 "SavedSearchDBTable.c"
}


gpointer
value_get_saved_search_row (const GValue* value)
{
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_ROW), NULL);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return value->data[0].v_pointer;
#line 747 "SavedSearchDBTable.c"
}


void
value_set_saved_search_row (GValue* value,
                            gpointer v_object)
{
	SavedSearchRow * old;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	old = value->data[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (v_object) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		value->data[0].v_pointer = v_object;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		saved_search_row_ref (value->data[0].v_pointer);
#line 770 "SavedSearchDBTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		value->data[0].v_pointer = NULL;
#line 774 "SavedSearchDBTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (old) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		saved_search_row_unref (old);
#line 780 "SavedSearchDBTable.c"
	}
}


void
value_take_saved_search_row (GValue* value,
                             gpointer v_object)
{
	SavedSearchRow * old;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	old = value->data[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (v_object) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		value->data[0].v_pointer = v_object;
#line 802 "SavedSearchDBTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		value->data[0].v_pointer = NULL;
#line 806 "SavedSearchDBTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (old) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		saved_search_row_unref (old);
#line 812 "SavedSearchDBTable.c"
	}
}


static void
saved_search_row_class_init (SavedSearchRowClass * klass)
{
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_row_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	((SavedSearchRowClass *) klass)->finalize = saved_search_row_finalize;
#line 824 "SavedSearchDBTable.c"
}


static void
saved_search_row_instance_init (SavedSearchRow * self)
{
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	self->ref_count = 1;
#line 833 "SavedSearchDBTable.c"
}


static void
saved_search_row_finalize (SavedSearchRow * obj)
{
	SavedSearchRow * self;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH_ROW, SavedSearchRow);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_signal_handlers_destroy (self);
#line 28 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_g_free0 (self->name);
#line 30 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_g_object_unref0 (self->conditions);
#line 849 "SavedSearchDBTable.c"
}


GType
saved_search_row_get_type (void)
{
	static volatile gsize saved_search_row_type_id__volatile = 0;
	if (g_once_init_enter (&saved_search_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_saved_search_row_init, value_saved_search_row_free_value, value_saved_search_row_copy_value, value_saved_search_row_peek_pointer, "p", value_saved_search_row_collect_value, "p", value_saved_search_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SavedSearchRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearchRow), 0, (GInstanceInitFunc) saved_search_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType saved_search_row_type_id;
		saved_search_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SavedSearchRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&saved_search_row_type_id__volatile, saved_search_row_type_id);
	}
	return saved_search_row_type_id__volatile;
}


gpointer
saved_search_row_ref (gpointer instance)
{
	SavedSearchRow * self;
	self = instance;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return instance;
#line 878 "SavedSearchDBTable.c"
}


void
saved_search_row_unref (gpointer instance)
{
	SavedSearchRow * self;
	self = instance;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		SAVED_SEARCH_ROW_GET_CLASS (self)->finalize (self);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 893 "SavedSearchDBTable.c"
	}
}


static SavedSearchDBTable*
saved_search_db_table_construct (GType object_type)
{
	SavedSearchDBTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint _tmp5_;
	sqlite3* _tmp7_;
	sqlite3_stmt* _tmp8_ = NULL;
	gint _tmp9_;
	gint _tmp10_;
	sqlite3_stmt* _tmp11_;
	gint _tmp12_;
	sqlite3* _tmp14_;
	sqlite3_stmt* _tmp15_ = NULL;
	gint _tmp16_;
	gint _tmp17_;
	sqlite3_stmt* _tmp18_;
	gint _tmp19_;
	sqlite3* _tmp21_;
	sqlite3_stmt* _tmp22_ = NULL;
	gint _tmp23_;
	gint _tmp24_;
	sqlite3_stmt* _tmp25_;
	gint _tmp26_;
	sqlite3* _tmp28_;
	sqlite3_stmt* _tmp29_ = NULL;
	gint _tmp30_;
	gint _tmp31_;
	sqlite3_stmt* _tmp32_;
	gint _tmp33_;
	sqlite3* _tmp35_;
	sqlite3_stmt* _tmp36_ = NULL;
	gint _tmp37_;
	gint _tmp38_;
	sqlite3_stmt* _tmp39_;
	gint _tmp40_;
	sqlite3* _tmp42_;
	sqlite3_stmt* _tmp43_ = NULL;
	gint _tmp44_;
	gint _tmp45_;
	sqlite3_stmt* _tmp46_;
	gint _tmp47_;
	sqlite3* _tmp49_;
	sqlite3_stmt* _tmp50_ = NULL;
	gint _tmp51_;
	gint _tmp52_;
	sqlite3_stmt* _tmp53_;
	gint _tmp54_;
	sqlite3* _tmp56_;
	sqlite3_stmt* _tmp57_ = NULL;
	gint _tmp58_;
	gint _tmp59_;
	sqlite3_stmt* _tmp60_;
	gint _tmp61_;
	sqlite3* _tmp63_;
	sqlite3_stmt* _tmp64_ = NULL;
	gint _tmp65_;
	gint _tmp66_;
	sqlite3_stmt* _tmp67_;
	gint _tmp68_;
	sqlite3* _tmp70_;
	sqlite3_stmt* _tmp71_ = NULL;
	gint _tmp72_;
	gint _tmp73_;
	sqlite3_stmt* _tmp74_;
	gint _tmp75_;
	sqlite3* _tmp77_;
	sqlite3_stmt* _tmp78_ = NULL;
	gint _tmp79_;
	gint _tmp80_;
	sqlite3_stmt* _tmp81_;
	gint _tmp82_;
	sqlite3* _tmp84_;
	sqlite3_stmt* _tmp85_ = NULL;
	gint _tmp86_;
	gint _tmp87_;
	sqlite3_stmt* _tmp88_;
	gint _tmp89_;
#line 36 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	self = (SavedSearchDBTable*) database_table_construct (object_type);
#line 37 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "SavedSearchDBTable");
#line 41 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = database_table_db;
#line 41 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable " "(" "id INTEGER PRIMARY KEY, " "name TEXT UNIQUE NOT NULL, " "operator TEXT NOT NULL" ")", -1, &_tmp1_, NULL);
#line 41 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 41 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp1_;
#line 41 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp2_;
#line 48 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = res;
#line 48 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 50 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = stmt;
#line 50 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp4_);
#line 51 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = res;
#line 51 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp5_ != SQLITE_DONE) {
#line 1008 "SavedSearchDBTable.c"
		gint _tmp6_;
#line 52 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp6_ = res;
#line 52 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable", _tmp6_);
#line 1014 "SavedSearchDBTable.c"
	}
#line 55 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp7_ = database_table_db;
#line 55 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp9_ = sqlite3_prepare_v2 (_tmp7_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Text " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "text TEXT" ")", -1, &_tmp8_, NULL);
#line 55 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 55 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp8_;
#line 55 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp9_;
#line 64 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp10_ = res;
#line 64 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp10_ == SQLITE_OK, "res == Sqlite.OK");
#line 66 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp11_ = stmt;
#line 66 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp11_);
#line 67 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp12_ = res;
#line 67 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp12_ != SQLITE_DONE) {
#line 1038 "SavedSearchDBTable.c"
		gint _tmp13_;
#line 68 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp13_ = res;
#line 68 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Text", _tmp13_);
#line 1044 "SavedSearchDBTable.c"
	}
#line 71 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp14_ = database_table_db;
#line 71 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp16_ = sqlite3_prepare_v2 (_tmp14_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_MediaType " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "type TEXT NOT_NULL" ")", -1, &_tmp15_, NULL);
#line 71 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 71 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp15_;
#line 71 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp16_;
#line 80 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp17_ = res;
#line 80 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp17_ == SQLITE_OK, "res == Sqlite.OK");
#line 82 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp18_ = stmt;
#line 82 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp18_);
#line 83 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp19_ = res;
#line 83 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp19_ != SQLITE_DONE) {
#line 1068 "SavedSearchDBTable.c"
		gint _tmp20_;
#line 84 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp20_ = res;
#line 84 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_MediaType", _tmp20_);
#line 1074 "SavedSearchDBTable.c"
	}
#line 87 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp21_ = database_table_db;
#line 87 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp23_ = sqlite3_prepare_v2 (_tmp21_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Flagged " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "flag_state TEXT NOT NULL" ")", -1, &_tmp22_, NULL);
#line 87 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 87 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp22_;
#line 87 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp23_;
#line 95 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp24_ = res;
#line 95 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp24_ == SQLITE_OK, "res == Sqlite.OK");
#line 97 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp25_ = stmt;
#line 97 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp25_);
#line 98 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp26_ = res;
#line 98 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp26_ != SQLITE_DONE) {
#line 1098 "SavedSearchDBTable.c"
		gint _tmp27_;
#line 99 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp27_ = res;
#line 99 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Flagged", _tmp27_);
#line 1104 "SavedSearchDBTable.c"
	}
#line 102 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp28_ = database_table_db;
#line 102 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp30_ = sqlite3_prepare_v2 (_tmp28_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Modified " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "modified_state TEXT NOT NULL" ")", -1, &_tmp29_, NULL);
#line 102 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 102 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp29_;
#line 102 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp30_;
#line 111 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp31_ = res;
#line 111 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp31_ == SQLITE_OK, "res == Sqlite.OK");
#line 113 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp32_ = stmt;
#line 113 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp32_);
#line 114 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp33_ = res;
#line 114 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp33_ != SQLITE_DONE) {
#line 1128 "SavedSearchDBTable.c"
		gint _tmp34_;
#line 115 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp34_ = res;
#line 115 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Modified", _tmp34_);
#line 1134 "SavedSearchDBTable.c"
	}
#line 118 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp35_ = database_table_db;
#line 118 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp37_ = sqlite3_prepare_v2 (_tmp35_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Rating " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "rating INTEGER NOT_NULL, " "context TEXT NOT NULL" ")", -1, &_tmp36_, NULL);
#line 118 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 118 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp36_;
#line 118 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp37_;
#line 127 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp38_ = res;
#line 127 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp38_ == SQLITE_OK, "res == Sqlite.OK");
#line 129 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp39_ = stmt;
#line 129 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp39_);
#line 130 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp40_ = res;
#line 130 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp40_ != SQLITE_DONE) {
#line 1158 "SavedSearchDBTable.c"
		gint _tmp41_;
#line 131 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp41_ = res;
#line 131 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Rating", _tmp41_);
#line 1164 "SavedSearchDBTable.c"
	}
#line 134 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp42_ = database_table_db;
#line 134 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp44_ = sqlite3_prepare_v2 (_tmp42_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Date " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "date_one INTEGER NOT_NULL, " "date_two INTEGER NOT_NULL" ")", -1, &_tmp43_, NULL);
#line 134 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 134 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp43_;
#line 134 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp44_;
#line 144 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp45_ = res;
#line 144 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp45_ == SQLITE_OK, "res == Sqlite.OK");
#line 146 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp46_ = stmt;
#line 146 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp46_);
#line 147 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp47_ = res;
#line 147 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp47_ != SQLITE_DONE) {
#line 1188 "SavedSearchDBTable.c"
		gint _tmp48_;
#line 148 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp48_ = res;
#line 148 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Rating", _tmp48_);
#line 1194 "SavedSearchDBTable.c"
	}
#line 151 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp49_ = database_table_db;
#line 151 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp51_ = sqlite3_prepare_v2 (_tmp49_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Text_Index " "ON SavedSearchDBTable_Text(search_id)", -1, &_tmp50_, NULL);
#line 151 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 151 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp50_;
#line 151 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp51_;
#line 154 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp52_ = res;
#line 154 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp52_ == SQLITE_OK, "res == Sqlite.OK");
#line 155 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp53_ = stmt;
#line 155 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp53_);
#line 156 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp54_ = res;
#line 156 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp54_ != SQLITE_DONE) {
#line 1218 "SavedSearchDBTable.c"
		gint _tmp55_;
#line 157 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp55_ = res;
#line 157 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Text_Index", _tmp55_);
#line 1224 "SavedSearchDBTable.c"
	}
#line 159 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp56_ = database_table_db;
#line 159 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp58_ = sqlite3_prepare_v2 (_tmp56_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_MediaType_Index " "ON SavedSearchDBTable_MediaType(search_id)", -1, &_tmp57_, NULL);
#line 159 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 159 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp57_;
#line 159 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp58_;
#line 162 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp59_ = res;
#line 162 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp59_ == SQLITE_OK, "res == Sqlite.OK");
#line 163 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp60_ = stmt;
#line 163 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp60_);
#line 164 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp61_ = res;
#line 164 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp61_ != SQLITE_DONE) {
#line 1248 "SavedSearchDBTable.c"
		gint _tmp62_;
#line 165 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp62_ = res;
#line 165 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_MediaType_Index", _tmp62_);
#line 1254 "SavedSearchDBTable.c"
	}
#line 167 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp63_ = database_table_db;
#line 167 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp65_ = sqlite3_prepare_v2 (_tmp63_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Flagged_Index " "ON SavedSearchDBTable_Flagged(search_id)", -1, &_tmp64_, NULL);
#line 167 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 167 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp64_;
#line 167 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp65_;
#line 170 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp66_ = res;
#line 170 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp66_ == SQLITE_OK, "res == Sqlite.OK");
#line 171 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp67_ = stmt;
#line 171 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp67_);
#line 172 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp68_ = res;
#line 172 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp68_ != SQLITE_DONE) {
#line 1278 "SavedSearchDBTable.c"
		gint _tmp69_;
#line 173 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp69_ = res;
#line 173 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Flagged_Index", _tmp69_);
#line 1284 "SavedSearchDBTable.c"
	}
#line 175 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp70_ = database_table_db;
#line 175 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp72_ = sqlite3_prepare_v2 (_tmp70_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Modified_Index " "ON SavedSearchDBTable_Modified(search_id)", -1, &_tmp71_, NULL);
#line 175 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 175 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp71_;
#line 175 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp72_;
#line 178 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp73_ = res;
#line 178 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp73_ == SQLITE_OK, "res == Sqlite.OK");
#line 179 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp74_ = stmt;
#line 179 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp74_);
#line 180 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp75_ = res;
#line 180 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp75_ != SQLITE_DONE) {
#line 1308 "SavedSearchDBTable.c"
		gint _tmp76_;
#line 181 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp76_ = res;
#line 181 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Modified_Index", _tmp76_);
#line 1314 "SavedSearchDBTable.c"
	}
#line 183 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp77_ = database_table_db;
#line 183 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp79_ = sqlite3_prepare_v2 (_tmp77_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Rating_Index " "ON SavedSearchDBTable_Rating(search_id)", -1, &_tmp78_, NULL);
#line 183 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 183 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp78_;
#line 183 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp79_;
#line 186 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp80_ = res;
#line 186 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp80_ == SQLITE_OK, "res == Sqlite.OK");
#line 187 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp81_ = stmt;
#line 187 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp81_);
#line 188 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp82_ = res;
#line 188 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp82_ != SQLITE_DONE) {
#line 1338 "SavedSearchDBTable.c"
		gint _tmp83_;
#line 189 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp83_ = res;
#line 189 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Rating_Index", _tmp83_);
#line 1344 "SavedSearchDBTable.c"
	}
#line 191 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp84_ = database_table_db;
#line 191 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp86_ = sqlite3_prepare_v2 (_tmp84_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Date_Index " "ON SavedSearchDBTable_Date(search_id)", -1, &_tmp85_, NULL);
#line 191 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 191 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp85_;
#line 191 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp86_;
#line 194 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp87_ = res;
#line 194 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp87_ == SQLITE_OK, "res == Sqlite.OK");
#line 195 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp88_ = stmt;
#line 195 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp88_);
#line 196 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp89_ = res;
#line 196 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp89_ != SQLITE_DONE) {
#line 1368 "SavedSearchDBTable.c"
		gint _tmp90_;
#line 197 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp90_ = res;
#line 197 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Date_Index", _tmp90_);
#line 1374 "SavedSearchDBTable.c"
	}
#line 36 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 36 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return self;
#line 1380 "SavedSearchDBTable.c"
}


static SavedSearchDBTable*
saved_search_db_table_new (void)
{
#line 36 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return saved_search_db_table_construct (TYPE_SAVED_SEARCH_DB_TABLE);
#line 1389 "SavedSearchDBTable.c"
}


static gpointer
_database_table_ref0 (gpointer self)
{
#line 204 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return self ? database_table_ref (self) : NULL;
#line 1398 "SavedSearchDBTable.c"
}


SavedSearchDBTable*
saved_search_db_table_get_instance (void)
{
	SavedSearchDBTable* result = NULL;
	SavedSearchDBTable* _tmp0_;
	SavedSearchDBTable* _tmp2_;
	SavedSearchDBTable* _tmp3_;
#line 201 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = saved_search_db_table_instance;
#line 201 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp0_ == NULL) {
#line 1413 "SavedSearchDBTable.c"
		SavedSearchDBTable* _tmp1_;
#line 202 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp1_ = saved_search_db_table_new ();
#line 202 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_database_table_unref0 (saved_search_db_table_instance);
#line 202 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		saved_search_db_table_instance = _tmp1_;
#line 1421 "SavedSearchDBTable.c"
	}
#line 204 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = saved_search_db_table_instance;
#line 204 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 204 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = _tmp3_;
#line 204 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 1431 "SavedSearchDBTable.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 227 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return self ? g_object_ref (self) : NULL;
#line 1440 "SavedSearchDBTable.c"
}


SavedSearchRow*
saved_search_db_table_add (SavedSearchDBTable* self,
                           const gchar* name,
                           SearchOperator operator,
                           GeeArrayList* conditions,
                           GError** error)
{
	SavedSearchRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	gchar* _tmp9_;
	GDestroyNotify _tmp10_;
	gint _tmp11_;
	sqlite3_stmt* _tmp12_;
	gint _tmp13_;
	SavedSearchRow* row = NULL;
	SavedSearchRow* _tmp15_;
	SavedSearchRow* _tmp16_;
	sqlite3* _tmp17_;
	SavedSearchRow* _tmp18_;
	gchar* _tmp19_;
	SavedSearchRow* _tmp20_;
	SavedSearchRow* _tmp21_;
	GeeList* _tmp22_;
	GError * _inner_error_ = NULL;
#line 207 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_DB_TABLE (self), NULL);
#line 207 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 207 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (GEE_IS_ARRAY_LIST (conditions), NULL);
#line 210 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = database_table_db;
#line 210 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO SavedSearchDBTable (name, operator) VALUES (?, ?)", -1, &_tmp1_, NULL);
#line 210 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 210 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp1_;
#line 210 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp2_;
#line 212 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = res;
#line 212 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 214 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = stmt;
#line 214 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = g_strdup (name);
#line 214 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp6_ = g_free;
#line 214 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_bind_text (_tmp4_, 1, _tmp5_, -1, _tmp6_);
#line 215 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp7_ = res;
#line 215 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 216 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp8_ = stmt;
#line 216 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp9_ = search_operator_to_string (operator);
#line 216 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp10_ = g_free;
#line 216 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_bind_text (_tmp8_, 2, _tmp9_, -1, _tmp10_);
#line 217 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp11_ = res;
#line 217 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 219 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp12_ = stmt;
#line 219 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp12_);
#line 220 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp13_ = res;
#line 220 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp13_ != SQLITE_DONE) {
#line 1530 "SavedSearchDBTable.c"
		gint _tmp14_;
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp14_ = res;
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_throw_error ("SavedSearchDBTable.add", _tmp14_, &_inner_error_);
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_propagate_error (error, _inner_error_);
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				return NULL;
#line 1546 "SavedSearchDBTable.c"
			} else {
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_clear_error (&_inner_error_);
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				return NULL;
#line 1556 "SavedSearchDBTable.c"
			}
		}
	}
#line 223 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp15_ = saved_search_row_new ();
#line 223 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	row = _tmp15_;
#line 224 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp16_ = row;
#line 224 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp17_ = database_table_db;
#line 224 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_id_init (&_tmp16_->search_id, sqlite3_last_insert_rowid (_tmp17_));
#line 225 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp18_ = row;
#line 225 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp19_ = g_strdup (name);
#line 225 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_g_free0 (_tmp18_->name);
#line 225 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp18_->name = _tmp19_;
#line 226 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp20_ = row;
#line 226 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp20_->operator = operator;
#line 227 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp21_ = row;
#line 227 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (conditions, GEE_TYPE_LIST, GeeList));
#line 227 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_g_object_unref0 (_tmp21_->conditions);
#line 227 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp21_->conditions = _tmp22_;
#line 1590 "SavedSearchDBTable.c"
	{
		GeeArrayList* _sc_list = NULL;
		GeeArrayList* _tmp23_;
		gint _sc_size = 0;
		GeeArrayList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _sc_index = 0;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp23_ = _g_object_ref0 (conditions);
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sc_list = _tmp23_;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp24_ = _sc_list;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp25_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp26_ = _tmp25_;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sc_size = _tmp26_;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sc_index = -1;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 1615 "SavedSearchDBTable.c"
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			SearchCondition* sc = NULL;
			GeeArrayList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			SavedSearchRow* _tmp33_;
			SavedSearchID _tmp34_;
			SearchCondition* _tmp35_;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp27_ = _sc_index;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_sc_index = _tmp27_ + 1;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp28_ = _sc_index;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp29_ = _sc_size;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!(_tmp28_ < _tmp29_)) {
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 1638 "SavedSearchDBTable.c"
			}
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp30_ = _sc_list;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp31_ = _sc_index;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp32_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp31_);
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			sc = (SearchCondition*) _tmp32_;
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp33_ = row;
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp34_ = _tmp33_->search_id;
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp35_ = sc;
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			saved_search_db_table_add_condition (self, &_tmp34_, _tmp35_, &_inner_error_);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_propagate_error (error, _inner_error_);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (sc);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_g_object_unref0 (_sc_list);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_saved_search_row_unref0 (row);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return NULL;
#line 1672 "SavedSearchDBTable.c"
				} else {
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (sc);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_g_object_unref0 (_sc_list);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_saved_search_row_unref0 (row);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_clear_error (&_inner_error_);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return NULL;
#line 1688 "SavedSearchDBTable.c"
				}
			}
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (sc);
#line 1693 "SavedSearchDBTable.c"
		}
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_g_object_unref0 (_sc_list);
#line 1697 "SavedSearchDBTable.c"
	}
#line 233 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = row;
#line 233 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 233 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 1705 "SavedSearchDBTable.c"
}


static gpointer
_search_condition_ref0 (gpointer self)
{
#line 238 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return self ? search_condition_ref (self) : NULL;
#line 1714 "SavedSearchDBTable.c"
}


static void
saved_search_db_table_add_condition (SavedSearchDBTable* self,
                                     SavedSearchID* id,
                                     SearchCondition* condition,
                                     GError** error)
{
	GError * _inner_error_ = NULL;
#line 236 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
#line 236 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (id != NULL);
#line 236 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SEARCH_CONDITION (condition));
#line 237 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (condition, TYPE_SEARCH_CONDITION_TEXT)) {
#line 1733 "SavedSearchDBTable.c"
		SearchConditionText* text = NULL;
		SearchConditionText* _tmp0_;
		sqlite3_stmt* stmt = NULL;
		gint res = 0;
		sqlite3* _tmp1_;
		sqlite3_stmt* _tmp2_ = NULL;
		gint _tmp3_;
		gint _tmp4_;
		sqlite3_stmt* _tmp5_;
		SavedSearchID _tmp6_;
		gint64 _tmp7_;
		gint _tmp8_;
		sqlite3_stmt* _tmp9_;
		SearchConditionText* _tmp10_;
		SearchConditionSearchType _tmp11_;
		SearchConditionSearchType _tmp12_;
		gchar* _tmp13_;
		GDestroyNotify _tmp14_;
		gint _tmp15_;
		sqlite3_stmt* _tmp16_;
		SearchConditionText* _tmp17_;
		SearchConditionTextContext _tmp18_;
		SearchConditionTextContext _tmp19_;
		gchar* _tmp20_;
		GDestroyNotify _tmp21_;
		gint _tmp22_;
		sqlite3_stmt* _tmp23_;
		SearchConditionText* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		GDestroyNotify _tmp28_;
		gint _tmp29_;
		sqlite3_stmt* _tmp30_;
		gint _tmp31_;
#line 238 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp0_ = _search_condition_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, TYPE_SEARCH_CONDITION_TEXT) ? ((SearchConditionText*) condition) : NULL);
#line 238 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		text = _tmp0_;
#line 240 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp1_ = database_table_db;
#line 240 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp3_ = sqlite3_prepare_v2 (_tmp1_, "INSERT INTO SavedSearchDBTable_Text (search_id, search_type, context, " "text) VALUES (?, ?, ?, ?)", -1, &_tmp2_, NULL);
#line 240 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sqlite3_finalize0 (stmt);
#line 240 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		stmt = _tmp2_;
#line 240 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		res = _tmp3_;
#line 243 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp4_ = res;
#line 243 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_vala_assert (_tmp4_ == SQLITE_OK, "res == Sqlite.OK");
#line 245 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp5_ = stmt;
#line 245 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp6_ = *id;
#line 245 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp7_ = _tmp6_.id;
#line 245 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		res = sqlite3_bind_int64 (_tmp5_, 1, _tmp7_);
#line 246 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp8_ = res;
#line 246 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp9_ = stmt;
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp10_ = text;
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp11_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp12_ = _tmp11_;
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp13_ = search_condition_search_type_to_string (_tmp12_);
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp14_ = g_free;
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		res = sqlite3_bind_text (_tmp9_, 2, _tmp13_, -1, _tmp14_);
#line 249 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp15_ = res;
#line 249 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_vala_assert (_tmp15_ == SQLITE_OK, "res == Sqlite.OK");
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp16_ = stmt;
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp17_ = text;
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp18_ = search_condition_text_get_context (_tmp17_);
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp19_ = _tmp18_;
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp20_ = search_condition_text_context_to_string (_tmp19_);
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp21_ = g_free;
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		res = sqlite3_bind_text (_tmp16_, 3, _tmp20_, -1, _tmp21_);
#line 252 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp22_ = res;
#line 252 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_vala_assert (_tmp22_ == SQLITE_OK, "res == Sqlite.OK");
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp23_ = stmt;
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp24_ = text;
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp25_ = search_condition_text_get_text (_tmp24_);
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp26_ = _tmp25_;
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp27_ = g_strdup (_tmp26_);
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp28_ = g_free;
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		res = sqlite3_bind_text (_tmp23_, 4, _tmp27_, -1, _tmp28_);
#line 255 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp29_ = res;
#line 255 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_vala_assert (_tmp29_ == SQLITE_OK, "res == Sqlite.OK");
#line 257 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp30_ = stmt;
#line 257 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		res = sqlite3_step (_tmp30_);
#line 258 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp31_ = res;
#line 258 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_tmp31_ != SQLITE_DONE) {
#line 1861 "SavedSearchDBTable.c"
			gint _tmp32_;
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp32_ = res;
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			database_table_throw_error ("SavedSearchDBTable_Text.add", _tmp32_, &_inner_error_);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_propagate_error (error, _inner_error_);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (text);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return;
#line 1879 "SavedSearchDBTable.c"
				} else {
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (text);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_clear_error (&_inner_error_);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return;
#line 1891 "SavedSearchDBTable.c"
				}
			}
		}
#line 237 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sqlite3_finalize0 (stmt);
#line 237 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_search_condition_unref0 (text);
#line 1899 "SavedSearchDBTable.c"
	} else {
#line 260 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (condition, TYPE_SEARCH_CONDITION_MEDIA_TYPE)) {
#line 1903 "SavedSearchDBTable.c"
			SearchConditionMediaType* media_type = NULL;
			SearchConditionMediaType* _tmp33_;
			sqlite3_stmt* stmt = NULL;
			gint res = 0;
			sqlite3* _tmp34_;
			sqlite3_stmt* _tmp35_ = NULL;
			gint _tmp36_;
			gint _tmp37_;
			sqlite3_stmt* _tmp38_;
			SavedSearchID _tmp39_;
			gint64 _tmp40_;
			gint _tmp41_;
			sqlite3_stmt* _tmp42_;
			SearchConditionMediaType* _tmp43_;
			SearchConditionSearchType _tmp44_;
			SearchConditionSearchType _tmp45_;
			gchar* _tmp46_;
			GDestroyNotify _tmp47_;
			gint _tmp48_;
			sqlite3_stmt* _tmp49_;
			SearchConditionMediaType* _tmp50_;
			SearchConditionMediaTypeContext _tmp51_;
			SearchConditionMediaTypeContext _tmp52_;
			gchar* _tmp53_;
			GDestroyNotify _tmp54_;
			gint _tmp55_;
			sqlite3_stmt* _tmp56_;
			SearchConditionMediaType* _tmp57_;
			SearchConditionMediaTypeMediaType _tmp58_;
			SearchConditionMediaTypeMediaType _tmp59_;
			gchar* _tmp60_;
			GDestroyNotify _tmp61_;
			gint _tmp62_;
			sqlite3_stmt* _tmp63_;
			gint _tmp64_;
#line 261 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp33_ = _search_condition_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, TYPE_SEARCH_CONDITION_MEDIA_TYPE) ? ((SearchConditionMediaType*) condition) : NULL);
#line 261 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			media_type = _tmp33_;
#line 263 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp34_ = database_table_db;
#line 263 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp36_ = sqlite3_prepare_v2 (_tmp34_, "INSERT INTO SavedSearchDBTable_MediaType (search_id, search_type, cont" \
"ext, " "type) VALUES (?, ?, ?, ?)", -1, &_tmp35_, NULL);
#line 263 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_sqlite3_finalize0 (stmt);
#line 263 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			stmt = _tmp35_;
#line 263 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp36_;
#line 266 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp37_ = res;
#line 266 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_vala_assert (_tmp37_ == SQLITE_OK, "res == Sqlite.OK");
#line 268 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp38_ = stmt;
#line 268 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp39_ = *id;
#line 268 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp40_ = _tmp39_.id;
#line 268 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = sqlite3_bind_int64 (_tmp38_, 1, _tmp40_);
#line 269 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp41_ = res;
#line 269 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_vala_assert (_tmp41_ == SQLITE_OK, "res == Sqlite.OK");
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp42_ = stmt;
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp43_ = media_type;
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp44_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp45_ = _tmp44_;
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp46_ = search_condition_search_type_to_string (_tmp45_);
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp47_ = g_free;
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = sqlite3_bind_text (_tmp42_, 2, _tmp46_, -1, _tmp47_);
#line 272 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp48_ = res;
#line 272 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_vala_assert (_tmp48_ == SQLITE_OK, "res == Sqlite.OK");
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp49_ = stmt;
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp50_ = media_type;
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp51_ = search_condition_media_type_get_context (_tmp50_);
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp52_ = _tmp51_;
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp53_ = search_condition_media_type_context_to_string (_tmp52_);
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp54_ = g_free;
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = sqlite3_bind_text (_tmp49_, 3, _tmp53_, -1, _tmp54_);
#line 275 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp55_ = res;
#line 275 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_vala_assert (_tmp55_ == SQLITE_OK, "res == Sqlite.OK");
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp56_ = stmt;
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp57_ = media_type;
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp58_ = search_condition_media_type_get_media_type (_tmp57_);
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp59_ = _tmp58_;
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp60_ = search_condition_media_type_media_type_to_string (_tmp59_);
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp61_ = g_free;
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = sqlite3_bind_text (_tmp56_, 4, _tmp60_, -1, _tmp61_);
#line 278 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp62_ = res;
#line 278 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_vala_assert (_tmp62_ == SQLITE_OK, "res == Sqlite.OK");
#line 280 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp63_ = stmt;
#line 280 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = sqlite3_step (_tmp63_);
#line 281 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp64_ = res;
#line 281 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp64_ != SQLITE_DONE) {
#line 2031 "SavedSearchDBTable.c"
				gint _tmp65_;
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp65_ = res;
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				database_table_throw_error ("SavedSearchDBTable_MediaType.add", _tmp65_, &_inner_error_);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						g_propagate_error (error, _inner_error_);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_sqlite3_finalize0 (stmt);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_search_condition_unref0 (media_type);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						return;
#line 2049 "SavedSearchDBTable.c"
					} else {
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_sqlite3_finalize0 (stmt);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_search_condition_unref0 (media_type);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						g_clear_error (&_inner_error_);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						return;
#line 2061 "SavedSearchDBTable.c"
					}
				}
			}
#line 260 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_sqlite3_finalize0 (stmt);
#line 260 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (media_type);
#line 2069 "SavedSearchDBTable.c"
		} else {
#line 283 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (condition, TYPE_SEARCH_CONDITION_FLAGGED)) {
#line 2073 "SavedSearchDBTable.c"
				SearchConditionFlagged* flag_state = NULL;
				SearchConditionFlagged* _tmp66_;
				sqlite3_stmt* stmt = NULL;
				gint res = 0;
				sqlite3* _tmp67_;
				sqlite3_stmt* _tmp68_ = NULL;
				gint _tmp69_;
				gint _tmp70_;
				sqlite3_stmt* _tmp71_;
				SavedSearchID _tmp72_;
				gint64 _tmp73_;
				gint _tmp74_;
				sqlite3_stmt* _tmp75_;
				SearchConditionFlagged* _tmp76_;
				SearchConditionSearchType _tmp77_;
				SearchConditionSearchType _tmp78_;
				gchar* _tmp79_;
				GDestroyNotify _tmp80_;
				gint _tmp81_;
				sqlite3_stmt* _tmp82_;
				SearchConditionFlagged* _tmp83_;
				SearchConditionFlaggedState _tmp84_;
				SearchConditionFlaggedState _tmp85_;
				gchar* _tmp86_;
				GDestroyNotify _tmp87_;
				gint _tmp88_;
				sqlite3_stmt* _tmp89_;
				gint _tmp90_;
#line 284 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp66_ = _search_condition_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, TYPE_SEARCH_CONDITION_FLAGGED) ? ((SearchConditionFlagged*) condition) : NULL);
#line 284 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				flag_state = _tmp66_;
#line 286 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp67_ = database_table_db;
#line 286 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp69_ = sqlite3_prepare_v2 (_tmp67_, "INSERT INTO SavedSearchDBTable_Flagged (search_id, search_type, " "flag_state) VALUES (?, ?, ?)", -1, &_tmp68_, NULL);
#line 286 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 286 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				stmt = _tmp68_;
#line 286 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				res = _tmp69_;
#line 289 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp70_ = res;
#line 289 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_vala_assert (_tmp70_ == SQLITE_OK, "res == Sqlite.OK");
#line 291 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp71_ = stmt;
#line 291 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp72_ = *id;
#line 291 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp73_ = _tmp72_.id;
#line 291 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				res = sqlite3_bind_int64 (_tmp71_, 1, _tmp73_);
#line 292 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp74_ = res;
#line 292 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_vala_assert (_tmp74_ == SQLITE_OK, "res == Sqlite.OK");
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp75_ = stmt;
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp76_ = flag_state;
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp77_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp78_ = _tmp77_;
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp79_ = search_condition_search_type_to_string (_tmp78_);
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp80_ = g_free;
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				res = sqlite3_bind_text (_tmp75_, 2, _tmp79_, -1, _tmp80_);
#line 295 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp81_ = res;
#line 295 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_vala_assert (_tmp81_ == SQLITE_OK, "res == Sqlite.OK");
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp82_ = stmt;
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp83_ = flag_state;
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp84_ = search_condition_flagged_get_state (_tmp83_);
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp85_ = _tmp84_;
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp86_ = search_condition_flagged_state_to_string (_tmp85_);
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp87_ = g_free;
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				res = sqlite3_bind_text (_tmp82_, 3, _tmp86_, -1, _tmp87_);
#line 298 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp88_ = res;
#line 298 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_vala_assert (_tmp88_ == SQLITE_OK, "res == Sqlite.OK");
#line 300 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp89_ = stmt;
#line 300 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				res = sqlite3_step (_tmp89_);
#line 301 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp90_ = res;
#line 301 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp90_ != SQLITE_DONE) {
#line 2176 "SavedSearchDBTable.c"
					gint _tmp91_;
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp91_ = res;
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_Flagged.add", _tmp91_, &_inner_error_);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_search_condition_unref0 (flag_state);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return;
#line 2194 "SavedSearchDBTable.c"
						} else {
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_search_condition_unref0 (flag_state);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return;
#line 2206 "SavedSearchDBTable.c"
						}
					}
				}
#line 283 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 283 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_search_condition_unref0 (flag_state);
#line 2214 "SavedSearchDBTable.c"
			} else {
#line 303 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (condition, TYPE_SEARCH_CONDITION_MODIFIED)) {
#line 2218 "SavedSearchDBTable.c"
					SearchConditionModified* modified_state = NULL;
					SearchConditionModified* _tmp92_;
					sqlite3_stmt* stmt = NULL;
					gint res = 0;
					sqlite3* _tmp93_;
					sqlite3_stmt* _tmp94_ = NULL;
					gint _tmp95_;
					gint _tmp96_;
					sqlite3_stmt* _tmp97_;
					SavedSearchID _tmp98_;
					gint64 _tmp99_;
					gint _tmp100_;
					sqlite3_stmt* _tmp101_;
					SearchConditionModified* _tmp102_;
					SearchConditionSearchType _tmp103_;
					SearchConditionSearchType _tmp104_;
					gchar* _tmp105_;
					GDestroyNotify _tmp106_;
					gint _tmp107_;
					sqlite3_stmt* _tmp108_;
					SearchConditionModified* _tmp109_;
					SearchConditionModifiedContext _tmp110_;
					SearchConditionModifiedContext _tmp111_;
					gchar* _tmp112_;
					GDestroyNotify _tmp113_;
					gint _tmp114_;
					sqlite3_stmt* _tmp115_;
					SearchConditionModified* _tmp116_;
					SearchConditionModifiedState _tmp117_;
					SearchConditionModifiedState _tmp118_;
					gchar* _tmp119_;
					GDestroyNotify _tmp120_;
					gint _tmp121_;
					sqlite3_stmt* _tmp122_;
					gint _tmp123_;
#line 304 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp92_ = _search_condition_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, TYPE_SEARCH_CONDITION_MODIFIED) ? ((SearchConditionModified*) condition) : NULL);
#line 304 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					modified_state = _tmp92_;
#line 306 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp93_ = database_table_db;
#line 306 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp95_ = sqlite3_prepare_v2 (_tmp93_, "INSERT INTO SavedSearchDBTable_Modified (search_id, search_type, conte" \
"xt, " "modified_state) VALUES (?, ?, ?, ?)", -1, &_tmp94_, NULL);
#line 306 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 306 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					stmt = _tmp94_;
#line 306 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					res = _tmp95_;
#line 309 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp96_ = res;
#line 309 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_vala_assert (_tmp96_ == SQLITE_OK, "res == Sqlite.OK");
#line 311 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp97_ = stmt;
#line 311 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp98_ = *id;
#line 311 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp99_ = _tmp98_.id;
#line 311 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					res = sqlite3_bind_int64 (_tmp97_, 1, _tmp99_);
#line 312 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp100_ = res;
#line 312 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_vala_assert (_tmp100_ == SQLITE_OK, "res == Sqlite.OK");
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp101_ = stmt;
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp102_ = modified_state;
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp103_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp104_ = _tmp103_;
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp105_ = search_condition_search_type_to_string (_tmp104_);
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp106_ = g_free;
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					res = sqlite3_bind_text (_tmp101_, 2, _tmp105_, -1, _tmp106_);
#line 315 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp107_ = res;
#line 315 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_vala_assert (_tmp107_ == SQLITE_OK, "res == Sqlite.OK");
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp108_ = stmt;
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp109_ = modified_state;
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp110_ = search_condition_modified_get_context (_tmp109_);
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp111_ = _tmp110_;
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp112_ = search_condition_modified_context_to_string (_tmp111_);
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp113_ = g_free;
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					res = sqlite3_bind_text (_tmp108_, 3, _tmp112_, -1, _tmp113_);
#line 318 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp114_ = res;
#line 318 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_vala_assert (_tmp114_ == SQLITE_OK, "res == Sqlite.OK");
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp115_ = stmt;
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp116_ = modified_state;
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp117_ = search_condition_modified_get_state (_tmp116_);
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp118_ = _tmp117_;
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp119_ = search_condition_modified_state_to_string (_tmp118_);
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp120_ = g_free;
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					res = sqlite3_bind_text (_tmp115_, 4, _tmp119_, -1, _tmp120_);
#line 321 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp121_ = res;
#line 321 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_vala_assert (_tmp121_ == SQLITE_OK, "res == Sqlite.OK");
#line 323 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp122_ = stmt;
#line 323 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					res = sqlite3_step (_tmp122_);
#line 324 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp123_ = res;
#line 324 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (_tmp123_ != SQLITE_DONE) {
#line 2346 "SavedSearchDBTable.c"
						gint _tmp124_;
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp124_ = res;
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						database_table_throw_error ("SavedSearchDBTable_Modified.add", _tmp124_, &_inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							if (_inner_error_->domain == DATABASE_ERROR) {
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								g_propagate_error (error, _inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								_sqlite3_finalize0 (stmt);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								_search_condition_unref0 (modified_state);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								return;
#line 2364 "SavedSearchDBTable.c"
							} else {
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								_sqlite3_finalize0 (stmt);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								_search_condition_unref0 (modified_state);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								g_clear_error (&_inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								return;
#line 2376 "SavedSearchDBTable.c"
							}
						}
					}
#line 303 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 303 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (modified_state);
#line 2384 "SavedSearchDBTable.c"
				} else {
#line 326 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (condition, TYPE_SEARCH_CONDITION_RATING)) {
#line 2388 "SavedSearchDBTable.c"
						SearchConditionRating* rating = NULL;
						SearchConditionRating* _tmp125_;
						sqlite3_stmt* stmt = NULL;
						gint res = 0;
						sqlite3* _tmp126_;
						sqlite3_stmt* _tmp127_ = NULL;
						gint _tmp128_;
						gint _tmp129_;
						sqlite3_stmt* _tmp130_;
						SavedSearchID _tmp131_;
						gint64 _tmp132_;
						gint _tmp133_;
						sqlite3_stmt* _tmp134_;
						SearchConditionRating* _tmp135_;
						SearchConditionSearchType _tmp136_;
						SearchConditionSearchType _tmp137_;
						gchar* _tmp138_;
						GDestroyNotify _tmp139_;
						gint _tmp140_;
						sqlite3_stmt* _tmp141_;
						SearchConditionRating* _tmp142_;
						Rating _tmp143_;
						Rating _tmp144_;
						gint _tmp145_;
						sqlite3_stmt* _tmp146_;
						SearchConditionRating* _tmp147_;
						SearchConditionRatingContext _tmp148_;
						SearchConditionRatingContext _tmp149_;
						gchar* _tmp150_;
						GDestroyNotify _tmp151_;
						gint _tmp152_;
						sqlite3_stmt* _tmp153_;
						gint _tmp154_;
#line 327 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp125_ = _search_condition_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, TYPE_SEARCH_CONDITION_RATING) ? ((SearchConditionRating*) condition) : NULL);
#line 327 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						rating = _tmp125_;
#line 329 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp126_ = database_table_db;
#line 329 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp128_ = sqlite3_prepare_v2 (_tmp126_, "INSERT INTO SavedSearchDBTable_Rating (search_id, search_type, rating," \
" " "context) VALUES (?, ?, ?, ?)", -1, &_tmp127_, NULL);
#line 329 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_sqlite3_finalize0 (stmt);
#line 329 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						stmt = _tmp127_;
#line 329 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						res = _tmp128_;
#line 332 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp129_ = res;
#line 332 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_vala_assert (_tmp129_ == SQLITE_OK, "res == Sqlite.OK");
#line 334 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp130_ = stmt;
#line 334 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp131_ = *id;
#line 334 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp132_ = _tmp131_.id;
#line 334 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						res = sqlite3_bind_int64 (_tmp130_, 1, _tmp132_);
#line 335 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp133_ = res;
#line 335 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_vala_assert (_tmp133_ == SQLITE_OK, "res == Sqlite.OK");
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp134_ = stmt;
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp135_ = rating;
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp136_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp135_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp137_ = _tmp136_;
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp138_ = search_condition_search_type_to_string (_tmp137_);
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp139_ = g_free;
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						res = sqlite3_bind_text (_tmp134_, 2, _tmp138_, -1, _tmp139_);
#line 338 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp140_ = res;
#line 338 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_vala_assert (_tmp140_ == SQLITE_OK, "res == Sqlite.OK");
#line 340 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp141_ = stmt;
#line 340 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp142_ = rating;
#line 340 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp143_ = search_condition_rating_get_rating (_tmp142_);
#line 340 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp144_ = _tmp143_;
#line 340 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						res = sqlite3_bind_int (_tmp141_, 3, rating_serialize (_tmp144_));
#line 341 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp145_ = res;
#line 341 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_vala_assert (_tmp145_ == SQLITE_OK, "res == Sqlite.OK");
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp146_ = stmt;
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp147_ = rating;
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp148_ = search_condition_rating_get_context (_tmp147_);
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp149_ = _tmp148_;
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp150_ = search_condition_rating_context_to_string (_tmp149_);
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp151_ = g_free;
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						res = sqlite3_bind_text (_tmp146_, 4, _tmp150_, -1, _tmp151_);
#line 344 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp152_ = res;
#line 344 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_vala_assert (_tmp152_ == SQLITE_OK, "res == Sqlite.OK");
#line 346 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp153_ = stmt;
#line 346 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						res = sqlite3_step (_tmp153_);
#line 347 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp154_ = res;
#line 347 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_tmp154_ != SQLITE_DONE) {
#line 2510 "SavedSearchDBTable.c"
							gint _tmp155_;
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp155_ = res;
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							database_table_throw_error ("SavedSearchDBTable_Rating.add", _tmp155_, &_inner_error_);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								if (_inner_error_->domain == DATABASE_ERROR) {
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									g_propagate_error (error, _inner_error_);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									_sqlite3_finalize0 (stmt);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									_search_condition_unref0 (rating);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									return;
#line 2528 "SavedSearchDBTable.c"
								} else {
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									_sqlite3_finalize0 (stmt);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									_search_condition_unref0 (rating);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									g_clear_error (&_inner_error_);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									return;
#line 2540 "SavedSearchDBTable.c"
								}
							}
						}
#line 326 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_sqlite3_finalize0 (stmt);
#line 326 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_search_condition_unref0 (rating);
#line 2548 "SavedSearchDBTable.c"
					} else {
#line 349 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (G_TYPE_CHECK_INSTANCE_TYPE (condition, TYPE_SEARCH_CONDITION_DATE)) {
#line 2552 "SavedSearchDBTable.c"
							SearchConditionDate* date = NULL;
							SearchConditionDate* _tmp156_;
							sqlite3_stmt* stmt = NULL;
							gint res = 0;
							sqlite3* _tmp157_;
							sqlite3_stmt* _tmp158_ = NULL;
							gint _tmp159_;
							gint _tmp160_;
							sqlite3_stmt* _tmp161_;
							SavedSearchID _tmp162_;
							gint64 _tmp163_;
							gint _tmp164_;
							sqlite3_stmt* _tmp165_;
							SearchConditionDate* _tmp166_;
							SearchConditionSearchType _tmp167_;
							SearchConditionSearchType _tmp168_;
							gchar* _tmp169_;
							GDestroyNotify _tmp170_;
							gint _tmp171_;
							sqlite3_stmt* _tmp172_;
							SearchConditionDate* _tmp173_;
							SearchConditionDateContext _tmp174_;
							SearchConditionDateContext _tmp175_;
							gchar* _tmp176_;
							GDestroyNotify _tmp177_;
							gint _tmp178_;
							sqlite3_stmt* _tmp179_;
							SearchConditionDate* _tmp180_;
							GDateTime* _tmp181_;
							GDateTime* _tmp182_;
							gint _tmp183_;
							sqlite3_stmt* _tmp184_;
							SearchConditionDate* _tmp185_;
							GDateTime* _tmp186_;
							GDateTime* _tmp187_;
							gint _tmp188_;
							sqlite3_stmt* _tmp189_;
							gint _tmp190_;
#line 350 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp156_ = _search_condition_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, TYPE_SEARCH_CONDITION_DATE) ? ((SearchConditionDate*) condition) : NULL);
#line 350 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							date = _tmp156_;
#line 352 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp157_ = database_table_db;
#line 352 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp159_ = sqlite3_prepare_v2 (_tmp157_, "INSERT INTO SavedSearchDBTable_Date (search_id, search_type, " "context, date_one, date_two) VALUES (?, ?, ?, ?, ?)", -1, &_tmp158_, NULL);
#line 352 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 352 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							stmt = _tmp158_;
#line 352 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = _tmp159_;
#line 355 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp160_ = res;
#line 355 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_vala_assert (_tmp160_ == SQLITE_OK, "res == Sqlite.OK");
#line 357 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp161_ = stmt;
#line 357 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp162_ = *id;
#line 357 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp163_ = _tmp162_.id;
#line 357 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = sqlite3_bind_int64 (_tmp161_, 1, _tmp163_);
#line 358 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp164_ = res;
#line 358 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_vala_assert (_tmp164_ == SQLITE_OK, "res == Sqlite.OK");
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp165_ = stmt;
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp166_ = date;
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp167_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp166_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp168_ = _tmp167_;
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp169_ = search_condition_search_type_to_string (_tmp168_);
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp170_ = g_free;
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = sqlite3_bind_text (_tmp165_, 2, _tmp169_, -1, _tmp170_);
#line 361 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp171_ = res;
#line 361 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_vala_assert (_tmp171_ == SQLITE_OK, "res == Sqlite.OK");
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp172_ = stmt;
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp173_ = date;
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp174_ = search_condition_date_get_context (_tmp173_);
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp175_ = _tmp174_;
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp176_ = search_condition_date_context_to_string (_tmp175_);
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp177_ = g_free;
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = sqlite3_bind_text (_tmp172_, 3, _tmp176_, -1, _tmp177_);
#line 364 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp178_ = res;
#line 364 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_vala_assert (_tmp178_ == SQLITE_OK, "res == Sqlite.OK");
#line 366 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp179_ = stmt;
#line 366 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp180_ = date;
#line 366 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp181_ = search_condition_date_get_date_one (_tmp180_);
#line 366 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp182_ = _tmp181_;
#line 366 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = sqlite3_bind_int64 (_tmp179_, 4, g_date_time_to_unix (_tmp182_));
#line 367 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp183_ = res;
#line 367 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_vala_assert (_tmp183_ == SQLITE_OK, "res == Sqlite.OK");
#line 369 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp184_ = stmt;
#line 369 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp185_ = date;
#line 369 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp186_ = search_condition_date_get_date_two (_tmp185_);
#line 369 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp187_ = _tmp186_;
#line 369 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = sqlite3_bind_int64 (_tmp184_, 5, g_date_time_to_unix (_tmp187_));
#line 370 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp188_ = res;
#line 370 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_vala_assert (_tmp188_ == SQLITE_OK, "res == Sqlite.OK");
#line 372 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp189_ = stmt;
#line 372 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = sqlite3_step (_tmp189_);
#line 373 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp190_ = res;
#line 373 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							if (_tmp190_ != SQLITE_DONE) {
#line 2693 "SavedSearchDBTable.c"
								gint _tmp191_;
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								_tmp191_ = res;
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								database_table_throw_error ("SavedSearchDBTable_Date.add", _tmp191_, &_inner_error_);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									if (_inner_error_->domain == DATABASE_ERROR) {
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										g_propagate_error (error, _inner_error_);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										_sqlite3_finalize0 (stmt);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										_search_condition_unref0 (date);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										return;
#line 2711 "SavedSearchDBTable.c"
									} else {
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										_sqlite3_finalize0 (stmt);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										_search_condition_unref0 (date);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										g_clear_error (&_inner_error_);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										return;
#line 2723 "SavedSearchDBTable.c"
									}
								}
							}
#line 349 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 349 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_search_condition_unref0 (date);
#line 2731 "SavedSearchDBTable.c"
						} else {
#line 376 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_assert_not_reached ();
#line 2735 "SavedSearchDBTable.c"
						}
					}
				}
			}
		}
	}
}


static void
saved_search_db_table_remove_conditions_for_search_id (SavedSearchDBTable* self,
                                                       SavedSearchID* search_id,
                                                       GError** error)
{
	SavedSearchID _tmp0_;
	SavedSearchID _tmp1_;
	SavedSearchID _tmp2_;
	SavedSearchID _tmp3_;
	SavedSearchID _tmp4_;
	SavedSearchID _tmp5_;
	GError * _inner_error_ = NULL;
#line 381 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
#line 381 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (search_id != NULL);
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = *search_id;
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Text", &_tmp0_, &_inner_error_);
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2773 "SavedSearchDBTable.c"
		} else {
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2781 "SavedSearchDBTable.c"
		}
	}
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp1_ = *search_id;
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_MediaType", &_tmp1_, &_inner_error_);
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2796 "SavedSearchDBTable.c"
		} else {
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2804 "SavedSearchDBTable.c"
		}
	}
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = *search_id;
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Flagged", &_tmp2_, &_inner_error_);
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2819 "SavedSearchDBTable.c"
		} else {
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2827 "SavedSearchDBTable.c"
		}
	}
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = *search_id;
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Modified", &_tmp3_, &_inner_error_);
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2842 "SavedSearchDBTable.c"
		} else {
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2850 "SavedSearchDBTable.c"
		}
	}
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = *search_id;
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Rating", &_tmp4_, &_inner_error_);
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2865 "SavedSearchDBTable.c"
		} else {
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2873 "SavedSearchDBTable.c"
		}
	}
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = *search_id;
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Date", &_tmp5_, &_inner_error_);
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2888 "SavedSearchDBTable.c"
		} else {
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2896 "SavedSearchDBTable.c"
		}
	}
}


static void
saved_search_db_table_remove_conditions_for_table (SavedSearchDBTable* self,
                                                   const gchar* table_name,
                                                   SavedSearchID* search_id,
                                                   GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	sqlite3_stmt* _tmp7_;
	SavedSearchID _tmp8_;
	gint64 _tmp9_;
	gint _tmp10_;
	sqlite3_stmt* _tmp11_;
	gint _tmp12_;
	GError * _inner_error_ = NULL;
#line 390 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
#line 390 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (table_name != NULL);
#line 390 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (search_id != NULL);
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = database_table_db;
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp1_ = g_strdup_printf ("DELETE FROM %s WHERE search_id=?", table_name);
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = _tmp1_;
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = sqlite3_prepare_v2 (_tmp0_, _tmp2_, -1, &_tmp3_, NULL);
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp3_;
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = _tmp4_;
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_g_free0 (_tmp2_);
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp5_;
#line 394 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp6_ = res;
#line 394 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 396 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp7_ = stmt;
#line 396 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp8_ = *search_id;
#line 396 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp9_ = _tmp8_.id;
#line 396 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_bind_int64 (_tmp7_, 1, _tmp9_);
#line 397 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp10_ = res;
#line 397 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp10_ == SQLITE_OK, "res == Sqlite.OK");
#line 399 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp11_ = stmt;
#line 399 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp11_);
#line 400 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp12_ = res;
#line 400 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp12_ != SQLITE_DONE) {
#line 2972 "SavedSearchDBTable.c"
		gchar* _tmp13_;
		gchar* _tmp14_;
		gint _tmp15_;
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp13_ = g_strdup_printf ("%s.remove", table_name);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp14_ = _tmp13_;
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp15_ = res;
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_throw_error (_tmp14_, _tmp15_, &_inner_error_);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_g_free0 (_tmp14_);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_propagate_error (error, _inner_error_);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				return;
#line 2996 "SavedSearchDBTable.c"
			} else {
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_clear_error (&_inner_error_);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				return;
#line 3006 "SavedSearchDBTable.c"
			}
		}
	}
#line 390 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 3012 "SavedSearchDBTable.c"
}


static GeeList*
saved_search_db_table_get_conditions_for_id (SavedSearchDBTable* self,
                                             SavedSearchID* search_id,
                                             GError** error)
{
	GeeList* result = NULL;
	GeeList* list = NULL;
	GeeArrayList* _tmp0_;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_;
	gint _tmp4_;
	sqlite3_stmt* _tmp5_;
	SavedSearchID _tmp6_;
	gint64 _tmp7_;
	gint _tmp8_;
	sqlite3* _tmp23_;
	sqlite3_stmt* _tmp24_ = NULL;
	gint _tmp25_;
	gint _tmp26_;
	sqlite3_stmt* _tmp27_;
	SavedSearchID _tmp28_;
	gint64 _tmp29_;
	gint _tmp30_;
	sqlite3* _tmp45_;
	sqlite3_stmt* _tmp46_ = NULL;
	gint _tmp47_;
	gint _tmp48_;
	sqlite3_stmt* _tmp49_;
	SavedSearchID _tmp50_;
	gint64 _tmp51_;
	gint _tmp52_;
	sqlite3* _tmp65_;
	sqlite3_stmt* _tmp66_ = NULL;
	gint _tmp67_;
	gint _tmp68_;
	sqlite3_stmt* _tmp69_;
	SavedSearchID _tmp70_;
	gint64 _tmp71_;
	gint _tmp72_;
	sqlite3* _tmp87_;
	sqlite3_stmt* _tmp88_ = NULL;
	gint _tmp89_;
	gint _tmp90_;
	sqlite3_stmt* _tmp91_;
	SavedSearchID _tmp92_;
	gint64 _tmp93_;
	gint _tmp94_;
	sqlite3* _tmp108_;
	sqlite3_stmt* _tmp109_ = NULL;
	gint _tmp110_;
	gint _tmp111_;
	sqlite3_stmt* _tmp112_;
	SavedSearchID _tmp113_;
	gint64 _tmp114_;
	gint _tmp115_;
	GError * _inner_error_ = NULL;
#line 405 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_DB_TABLE (self), NULL);
#line 405 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (search_id != NULL, NULL);
#line 407 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = gee_array_list_new (TYPE_SEARCH_CONDITION, (GBoxedCopyFunc) search_condition_ref, (GDestroyNotify) search_condition_unref, NULL, NULL, NULL);
#line 407 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
#line 412 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp1_ = database_table_db;
#line 412 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = sqlite3_prepare_v2 (_tmp1_, "SELECT search_type, context, text FROM SavedSearchDBTable_Text " "WHERE search_id=?", -1, &_tmp2_, NULL);
#line 412 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 412 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp2_;
#line 412 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp3_;
#line 415 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = res;
#line 415 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp4_ == SQLITE_OK, "res == Sqlite.OK");
#line 417 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = stmt;
#line 417 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp6_ = *search_id;
#line 417 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp7_ = _tmp6_.id;
#line 417 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_bind_int64 (_tmp5_, 1, _tmp7_);
#line 418 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp8_ = res;
#line 418 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 3109 "SavedSearchDBTable.c"
	{
		gboolean _tmp9_ = FALSE;
#line 420 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp9_ = TRUE;
#line 420 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 3116 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp10_;
			gint _tmp11_;
			SearchConditionText* condition = NULL;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_;
			sqlite3_stmt* _tmp16_;
			const gchar* _tmp17_;
			sqlite3_stmt* _tmp18_;
			const gchar* _tmp19_;
			SearchConditionText* _tmp20_;
			GeeList* _tmp21_;
			SearchConditionText* _tmp22_;
#line 420 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp9_) {
#line 3131 "SavedSearchDBTable.c"
			}
#line 420 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp9_ = FALSE;
#line 421 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp10_ = stmt;
#line 421 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = sqlite3_step (_tmp10_);
#line 422 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp11_ = res;
#line 422 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp11_ == SQLITE_DONE) {
#line 423 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 3145 "SavedSearchDBTable.c"
			} else {
				gint _tmp12_;
#line 424 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp12_ = res;
#line 424 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp12_ != SQLITE_ROW) {
#line 3152 "SavedSearchDBTable.c"
					gint _tmp13_;
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp13_ = res;
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_Text.get_all_rows", _tmp13_, &_inner_error_);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3170 "SavedSearchDBTable.c"
						} else {
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3182 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp14_ = stmt;
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp15_ = sqlite3_column_text (_tmp14_, 0);
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp16_ = stmt;
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp17_ = sqlite3_column_text (_tmp16_, 2);
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp18_ = stmt;
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp19_ = sqlite3_column_text (_tmp18_, 1);
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp20_ = search_condition_text_new (search_condition_search_type_from_string (_tmp15_), _tmp17_, search_condition_text_context_from_string (_tmp19_));
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			condition = _tmp20_;
#line 432 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp21_ = list;
#line 432 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp22_ = condition;
#line 432 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 420 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (condition);
#line 3211 "SavedSearchDBTable.c"
		}
	}
#line 436 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp23_ = database_table_db;
#line 436 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp25_ = sqlite3_prepare_v2 (_tmp23_, "SELECT search_type, context, type FROM SavedSearchDBTable_MediaType " "WHERE search_id=?", -1, &_tmp24_, NULL);
#line 436 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 436 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp24_;
#line 436 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp25_;
#line 439 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp26_ = res;
#line 439 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp26_ == SQLITE_OK, "res == Sqlite.OK");
#line 441 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp27_ = stmt;
#line 441 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp28_ = *search_id;
#line 441 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp29_ = _tmp28_.id;
#line 441 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_bind_int64 (_tmp27_, 1, _tmp29_);
#line 442 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp30_ = res;
#line 442 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp30_ == SQLITE_OK, "res == Sqlite.OK");
#line 3240 "SavedSearchDBTable.c"
	{
		gboolean _tmp31_ = FALSE;
#line 444 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp31_ = TRUE;
#line 444 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 3247 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp32_;
			gint _tmp33_;
			SearchConditionMediaType* condition = NULL;
			sqlite3_stmt* _tmp36_;
			const gchar* _tmp37_;
			sqlite3_stmt* _tmp38_;
			const gchar* _tmp39_;
			sqlite3_stmt* _tmp40_;
			const gchar* _tmp41_;
			SearchConditionMediaType* _tmp42_;
			GeeList* _tmp43_;
			SearchConditionMediaType* _tmp44_;
#line 444 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp31_) {
#line 3262 "SavedSearchDBTable.c"
			}
#line 444 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp31_ = FALSE;
#line 445 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp32_ = stmt;
#line 445 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = sqlite3_step (_tmp32_);
#line 446 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp33_ = res;
#line 446 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp33_ == SQLITE_DONE) {
#line 447 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 3276 "SavedSearchDBTable.c"
			} else {
				gint _tmp34_;
#line 448 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp34_ = res;
#line 448 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp34_ != SQLITE_ROW) {
#line 3283 "SavedSearchDBTable.c"
					gint _tmp35_;
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp35_ = res;
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_MediaType.get_all_rows", _tmp35_, &_inner_error_);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3301 "SavedSearchDBTable.c"
						} else {
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3313 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp36_ = stmt;
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp37_ = sqlite3_column_text (_tmp36_, 0);
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp38_ = stmt;
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp39_ = sqlite3_column_text (_tmp38_, 1);
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp40_ = stmt;
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp41_ = sqlite3_column_text (_tmp40_, 2);
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp42_ = search_condition_media_type_new (search_condition_search_type_from_string (_tmp37_), search_condition_media_type_context_from_string (_tmp39_), search_condition_media_type_media_type_from_string (_tmp41_));
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			condition = _tmp42_;
#line 456 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp43_ = list;
#line 456 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp44_ = condition;
#line 456 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 444 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (condition);
#line 3342 "SavedSearchDBTable.c"
		}
	}
#line 460 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp45_ = database_table_db;
#line 460 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp47_ = sqlite3_prepare_v2 (_tmp45_, "SELECT search_type, flag_state FROM SavedSearchDBTable_Flagged " "WHERE search_id=?", -1, &_tmp46_, NULL);
#line 460 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 460 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp46_;
#line 460 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp47_;
#line 463 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp48_ = res;
#line 463 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp48_ == SQLITE_OK, "res == Sqlite.OK");
#line 465 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp49_ = stmt;
#line 465 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp50_ = *search_id;
#line 465 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp51_ = _tmp50_.id;
#line 465 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_bind_int64 (_tmp49_, 1, _tmp51_);
#line 466 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp52_ = res;
#line 466 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp52_ == SQLITE_OK, "res == Sqlite.OK");
#line 3371 "SavedSearchDBTable.c"
	{
		gboolean _tmp53_ = FALSE;
#line 468 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp53_ = TRUE;
#line 468 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 3378 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp54_;
			gint _tmp55_;
			SearchConditionFlagged* condition = NULL;
			sqlite3_stmt* _tmp58_;
			const gchar* _tmp59_;
			sqlite3_stmt* _tmp60_;
			const gchar* _tmp61_;
			SearchConditionFlagged* _tmp62_;
			GeeList* _tmp63_;
			SearchConditionFlagged* _tmp64_;
#line 468 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp53_) {
#line 3391 "SavedSearchDBTable.c"
			}
#line 468 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp53_ = FALSE;
#line 469 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp54_ = stmt;
#line 469 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = sqlite3_step (_tmp54_);
#line 470 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp55_ = res;
#line 470 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp55_ == SQLITE_DONE) {
#line 471 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 3405 "SavedSearchDBTable.c"
			} else {
				gint _tmp56_;
#line 472 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp56_ = res;
#line 472 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp56_ != SQLITE_ROW) {
#line 3412 "SavedSearchDBTable.c"
					gint _tmp57_;
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp57_ = res;
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_Flagged.get_all_rows", _tmp57_, &_inner_error_);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3430 "SavedSearchDBTable.c"
						} else {
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3442 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp58_ = stmt;
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp59_ = sqlite3_column_text (_tmp58_, 0);
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp60_ = stmt;
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp61_ = sqlite3_column_text (_tmp60_, 1);
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp62_ = search_condition_flagged_new (search_condition_search_type_from_string (_tmp59_), search_condition_flagged_state_from_string (_tmp61_));
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			condition = _tmp62_;
#line 479 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp63_ = list;
#line 479 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp64_ = condition;
#line 479 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 468 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (condition);
#line 3467 "SavedSearchDBTable.c"
		}
	}
#line 483 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp65_ = database_table_db;
#line 483 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp67_ = sqlite3_prepare_v2 (_tmp65_, "SELECT search_type, context, modified_state FROM SavedSearchDBTable_Mo" \
"dified " "WHERE search_id=?", -1, &_tmp66_, NULL);
#line 483 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 483 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp66_;
#line 483 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp67_;
#line 486 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp68_ = res;
#line 486 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp68_ == SQLITE_OK, "res == Sqlite.OK");
#line 488 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp69_ = stmt;
#line 488 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp70_ = *search_id;
#line 488 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp71_ = _tmp70_.id;
#line 488 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_bind_int64 (_tmp69_, 1, _tmp71_);
#line 489 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp72_ = res;
#line 489 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp72_ == SQLITE_OK, "res == Sqlite.OK");
#line 3496 "SavedSearchDBTable.c"
	{
		gboolean _tmp73_ = FALSE;
#line 491 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp73_ = TRUE;
#line 491 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 3503 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp74_;
			gint _tmp75_;
			SearchConditionModified* condition = NULL;
			sqlite3_stmt* _tmp78_;
			const gchar* _tmp79_;
			sqlite3_stmt* _tmp80_;
			const gchar* _tmp81_;
			sqlite3_stmt* _tmp82_;
			const gchar* _tmp83_;
			SearchConditionModified* _tmp84_;
			GeeList* _tmp85_;
			SearchConditionModified* _tmp86_;
#line 491 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp73_) {
#line 3518 "SavedSearchDBTable.c"
			}
#line 491 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp73_ = FALSE;
#line 492 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp74_ = stmt;
#line 492 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = sqlite3_step (_tmp74_);
#line 493 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp75_ = res;
#line 493 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp75_ == SQLITE_DONE) {
#line 494 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 3532 "SavedSearchDBTable.c"
			} else {
				gint _tmp76_;
#line 495 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp76_ = res;
#line 495 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp76_ != SQLITE_ROW) {
#line 3539 "SavedSearchDBTable.c"
					gint _tmp77_;
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp77_ = res;
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_Modified.get_all_rows", _tmp77_, &_inner_error_);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3557 "SavedSearchDBTable.c"
						} else {
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3569 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp78_ = stmt;
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp79_ = sqlite3_column_text (_tmp78_, 0);
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp80_ = stmt;
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp81_ = sqlite3_column_text (_tmp80_, 1);
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp82_ = stmt;
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp83_ = sqlite3_column_text (_tmp82_, 2);
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp84_ = search_condition_modified_new (search_condition_search_type_from_string (_tmp79_), search_condition_modified_context_from_string (_tmp81_), search_condition_modified_state_from_string (_tmp83_));
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			condition = _tmp84_;
#line 503 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp85_ = list;
#line 503 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp86_ = condition;
#line 503 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 491 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (condition);
#line 3598 "SavedSearchDBTable.c"
		}
	}
#line 507 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp87_ = database_table_db;
#line 507 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp89_ = sqlite3_prepare_v2 (_tmp87_, "SELECT search_type, rating, context FROM SavedSearchDBTable_Rating " "WHERE search_id=?", -1, &_tmp88_, NULL);
#line 507 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 507 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp88_;
#line 507 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp89_;
#line 510 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp90_ = res;
#line 510 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp90_ == SQLITE_OK, "res == Sqlite.OK");
#line 512 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp91_ = stmt;
#line 512 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp92_ = *search_id;
#line 512 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp93_ = _tmp92_.id;
#line 512 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_bind_int64 (_tmp91_, 1, _tmp93_);
#line 513 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp94_ = res;
#line 513 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp94_ == SQLITE_OK, "res == Sqlite.OK");
#line 3627 "SavedSearchDBTable.c"
	{
		gboolean _tmp95_ = FALSE;
#line 515 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp95_ = TRUE;
#line 515 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 3634 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp96_;
			gint _tmp97_;
			SearchConditionRating* condition = NULL;
			sqlite3_stmt* _tmp100_;
			const gchar* _tmp101_;
			sqlite3_stmt* _tmp102_;
			sqlite3_stmt* _tmp103_;
			const gchar* _tmp104_;
			SearchConditionRating* _tmp105_;
			GeeList* _tmp106_;
			SearchConditionRating* _tmp107_;
#line 515 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp95_) {
#line 3648 "SavedSearchDBTable.c"
			}
#line 515 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp95_ = FALSE;
#line 516 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp96_ = stmt;
#line 516 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = sqlite3_step (_tmp96_);
#line 517 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp97_ = res;
#line 517 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp97_ == SQLITE_DONE) {
#line 518 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 3662 "SavedSearchDBTable.c"
			} else {
				gint _tmp98_;
#line 519 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp98_ = res;
#line 519 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp98_ != SQLITE_ROW) {
#line 3669 "SavedSearchDBTable.c"
					gint _tmp99_;
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp99_ = res;
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_Rating.get_all_rows", _tmp99_, &_inner_error_);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3687 "SavedSearchDBTable.c"
						} else {
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3699 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp100_ = stmt;
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp101_ = sqlite3_column_text (_tmp100_, 0);
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp102_ = stmt;
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp103_ = stmt;
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp104_ = sqlite3_column_text (_tmp103_, 2);
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp105_ = search_condition_rating_new (search_condition_search_type_from_string (_tmp101_), rating_unserialize (sqlite3_column_int (_tmp102_, 1)), search_condition_rating_context_from_string (_tmp104_));
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			condition = _tmp105_;
#line 527 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp106_ = list;
#line 527 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp107_ = condition;
#line 527 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 515 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (condition);
#line 3726 "SavedSearchDBTable.c"
		}
	}
#line 531 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp108_ = database_table_db;
#line 531 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp110_ = sqlite3_prepare_v2 (_tmp108_, "SELECT search_type, context, date_one, date_two FROM SavedSearchDBTabl" \
"e_Date " "WHERE search_id=?", -1, &_tmp109_, NULL);
#line 531 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 531 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp109_;
#line 531 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp110_;
#line 534 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp111_ = res;
#line 534 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp111_ == SQLITE_OK, "res == Sqlite.OK");
#line 536 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp112_ = stmt;
#line 536 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp113_ = *search_id;
#line 536 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp114_ = _tmp113_.id;
#line 536 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_bind_int64 (_tmp112_, 1, _tmp114_);
#line 537 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp115_ = res;
#line 537 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp115_ == SQLITE_OK, "res == Sqlite.OK");
#line 3755 "SavedSearchDBTable.c"
	{
		gboolean _tmp116_ = FALSE;
#line 539 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp116_ = TRUE;
#line 539 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 3762 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp117_;
			gint _tmp118_;
			SearchConditionDate* condition = NULL;
			sqlite3_stmt* _tmp121_;
			const gchar* _tmp122_;
			sqlite3_stmt* _tmp123_;
			const gchar* _tmp124_;
			sqlite3_stmt* _tmp125_;
			GDateTime* _tmp126_;
			GDateTime* _tmp127_;
			sqlite3_stmt* _tmp128_;
			GDateTime* _tmp129_;
			GDateTime* _tmp130_;
			SearchConditionDate* _tmp131_;
			SearchConditionDate* _tmp132_;
			GeeList* _tmp133_;
			SearchConditionDate* _tmp134_;
#line 539 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp116_) {
#line 3782 "SavedSearchDBTable.c"
			}
#line 539 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp116_ = FALSE;
#line 540 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp117_ = stmt;
#line 540 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = sqlite3_step (_tmp117_);
#line 541 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp118_ = res;
#line 541 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp118_ == SQLITE_DONE) {
#line 542 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 3796 "SavedSearchDBTable.c"
			} else {
				gint _tmp119_;
#line 543 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp119_ = res;
#line 543 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp119_ != SQLITE_ROW) {
#line 3803 "SavedSearchDBTable.c"
					gint _tmp120_;
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp120_ = res;
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_Date.get_all_rows", _tmp120_, &_inner_error_);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3821 "SavedSearchDBTable.c"
						} else {
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3833 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp121_ = stmt;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp122_ = sqlite3_column_text (_tmp121_, 0);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp123_ = stmt;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp124_ = sqlite3_column_text (_tmp123_, 1);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp125_ = stmt;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp126_ = g_date_time_new_from_unix_local (sqlite3_column_int64 (_tmp125_, 2));
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp127_ = _tmp126_;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp128_ = stmt;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp129_ = g_date_time_new_from_unix_local (sqlite3_column_int64 (_tmp128_, 3));
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp130_ = _tmp129_;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp131_ = search_condition_date_new (search_condition_search_type_from_string (_tmp122_), search_condition_date_context_from_string (_tmp124_), _tmp127_, _tmp130_);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp132_ = _tmp131_;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_g_date_time_unref0 (_tmp130_);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_g_date_time_unref0 (_tmp127_);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			condition = _tmp132_;
#line 551 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp133_ = list;
#line 551 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp134_ = condition;
#line 551 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 539 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (condition);
#line 3876 "SavedSearchDBTable.c"
		}
	}
#line 554 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = list;
#line 554 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 554 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 3885 "SavedSearchDBTable.c"
}


void
saved_search_db_table_create_from_row (SavedSearchDBTable* self,
                                       SavedSearchRow* row,
                                       SavedSearchID* result,
                                       GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GDestroyNotify _tmp7_;
	gint _tmp8_;
	sqlite3_stmt* _tmp9_;
	SearchOperator _tmp10_;
	gchar* _tmp11_;
	GDestroyNotify _tmp12_;
	gint _tmp13_;
	sqlite3_stmt* _tmp14_;
	gint _tmp15_;
	SavedSearchID search_id = {0};
	sqlite3* _tmp17_;
	GError * _inner_error_ = NULL;
#line 558 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
#line 558 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_ROW (row));
#line 560 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = database_table_db;
#line 560 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO SavedSearchDBTable (name, operator) VALUES (?, ?)", -1, &_tmp1_, NULL);
#line 560 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 560 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp1_;
#line 560 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp2_;
#line 562 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = res;
#line 562 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 564 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = stmt;
#line 564 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = row->name;
#line 564 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 564 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp7_ = g_free;
#line 564 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_bind_text (_tmp4_, 1, _tmp6_, -1, _tmp7_);
#line 565 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp8_ = res;
#line 565 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 566 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp9_ = stmt;
#line 566 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp10_ = row->operator;
#line 566 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp11_ = search_operator_to_string (_tmp10_);
#line 566 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp12_ = g_free;
#line 566 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_bind_text (_tmp9_, 2, _tmp11_, -1, _tmp12_);
#line 567 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp13_ = res;
#line 567 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp13_ == SQLITE_OK, "res == Sqlite.OK");
#line 569 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp14_ = stmt;
#line 569 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp14_);
#line 570 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp15_ = res;
#line 570 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp15_ != SQLITE_DONE) {
#line 3970 "SavedSearchDBTable.c"
		gint _tmp16_;
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp16_ = res;
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_throw_error ("SavedSearchDBTable.create_from_row", _tmp16_, &_inner_error_);
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_propagate_error (error, _inner_error_);
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				return;
#line 3986 "SavedSearchDBTable.c"
			} else {
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_clear_error (&_inner_error_);
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				return;
#line 3996 "SavedSearchDBTable.c"
			}
		}
	}
#line 573 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp17_ = database_table_db;
#line 573 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_id_init (&search_id, sqlite3_last_insert_rowid (_tmp17_));
#line 4004 "SavedSearchDBTable.c"
	{
		GeeList* _sc_list = NULL;
		GeeList* _tmp18_;
		GeeList* _tmp19_;
		gint _sc_size = 0;
		GeeList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _sc_index = 0;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp18_ = row->conditions;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sc_list = _tmp19_;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp20_ = _sc_list;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp21_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp22_ = _tmp21_;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sc_size = _tmp22_;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sc_index = -1;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 4032 "SavedSearchDBTable.c"
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			SearchCondition* sc = NULL;
			GeeList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_;
			SavedSearchID _tmp29_;
			SearchCondition* _tmp30_;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp23_ = _sc_index;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_sc_index = _tmp23_ + 1;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp24_ = _sc_index;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp25_ = _sc_size;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!(_tmp24_ < _tmp25_)) {
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 4054 "SavedSearchDBTable.c"
			}
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp26_ = _sc_list;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp27_ = _sc_index;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp28_ = gee_list_get (_tmp26_, _tmp27_);
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			sc = (SearchCondition*) _tmp28_;
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp29_ = search_id;
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp30_ = sc;
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			saved_search_db_table_add_condition (self, &_tmp29_, _tmp30_, &_inner_error_);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_propagate_error (error, _inner_error_);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (sc);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_g_object_unref0 (_sc_list);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return;
#line 4084 "SavedSearchDBTable.c"
				} else {
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (sc);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_g_object_unref0 (_sc_list);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_clear_error (&_inner_error_);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return;
#line 4098 "SavedSearchDBTable.c"
				}
			}
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (sc);
#line 4103 "SavedSearchDBTable.c"
		}
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_g_object_unref0 (_sc_list);
#line 4107 "SavedSearchDBTable.c"
	}
#line 579 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	*result = search_id;
#line 579 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 579 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return;
#line 4115 "SavedSearchDBTable.c"
}


void
saved_search_db_table_remove (SavedSearchDBTable* self,
                              SavedSearchID* search_id,
                              GError** error)
{
	SavedSearchID _tmp0_;
	SavedSearchID _tmp1_;
	gint64 _tmp2_;
	GError * _inner_error_ = NULL;
#line 582 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
#line 582 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (search_id != NULL);
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = *search_id;
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_search_id (self, &_tmp0_, &_inner_error_);
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 4144 "SavedSearchDBTable.c"
		} else {
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 4152 "SavedSearchDBTable.c"
		}
	}
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp1_ = *search_id;
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = _tmp1_.id;
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp2_, &_inner_error_);
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 4169 "SavedSearchDBTable.c"
		} else {
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 4177 "SavedSearchDBTable.c"
		}
	}
}


SavedSearchRow*
saved_search_db_table_get_row (SavedSearchDBTable* self,
                               SavedSearchID* search_id,
                               GError** error)
{
	SavedSearchRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	SavedSearchID _tmp5_;
	gint64 _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_;
	SavedSearchRow* row = NULL;
	SavedSearchRow* _tmp12_;
	SavedSearchRow* _tmp13_;
	SavedSearchID _tmp14_;
	SavedSearchRow* _tmp15_;
	sqlite3_stmt* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	SavedSearchRow* _tmp19_;
	sqlite3_stmt* _tmp20_;
	const gchar* _tmp21_;
	GError * _inner_error_ = NULL;
#line 587 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_DB_TABLE (self), NULL);
#line 587 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (search_id != NULL, NULL);
#line 589 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = database_table_db;
#line 589 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT name, operator FROM SavedSearchDBTable WHERE id=?", -1, &_tmp1_, NULL);
#line 589 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 589 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp1_;
#line 589 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp2_;
#line 591 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = res;
#line 591 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 593 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = stmt;
#line 593 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = *search_id;
#line 593 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp6_ = _tmp5_.id;
#line 593 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 594 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp7_ = res;
#line 594 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 596 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp8_ = stmt;
#line 596 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = sqlite3_step (_tmp8_);
#line 597 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp9_ = res;
#line 597 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp9_ == SQLITE_DONE) {
#line 598 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		result = NULL;
#line 598 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sqlite3_finalize0 (stmt);
#line 598 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		return result;
#line 4257 "SavedSearchDBTable.c"
	} else {
		gint _tmp10_;
#line 599 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp10_ = res;
#line 599 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_tmp10_ != SQLITE_ROW) {
#line 4264 "SavedSearchDBTable.c"
			gint _tmp11_;
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp11_ = res;
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			database_table_throw_error ("SavedSearchDBTable.get_row", _tmp11_, &_inner_error_);
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_propagate_error (error, _inner_error_);
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return NULL;
#line 4280 "SavedSearchDBTable.c"
				} else {
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_clear_error (&_inner_error_);
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return NULL;
#line 4290 "SavedSearchDBTable.c"
				}
			}
		}
	}
#line 602 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp12_ = saved_search_row_new ();
#line 602 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	row = _tmp12_;
#line 603 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp13_ = row;
#line 603 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp14_ = *search_id;
#line 603 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp13_->search_id = _tmp14_;
#line 604 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp15_ = row;
#line 604 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp16_ = stmt;
#line 604 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp17_ = sqlite3_column_text (_tmp16_, 0);
#line 604 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp18_ = g_strdup (_tmp17_);
#line 604 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_g_free0 (_tmp15_->name);
#line 604 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp15_->name = _tmp18_;
#line 605 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp19_ = row;
#line 605 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp20_ = stmt;
#line 605 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp21_ = sqlite3_column_text (_tmp20_, 1);
#line 605 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp19_->operator = search_operator_from_string (_tmp21_);
#line 607 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = row;
#line 607 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 607 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 4331 "SavedSearchDBTable.c"
}


GeeList*
saved_search_db_table_get_all_rows (SavedSearchDBTable* self,
                                    GError** error)
{
	GeeList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	GeeList* rows = NULL;
	GeeArrayList* _tmp4_;
	GError * _inner_error_ = NULL;
#line 610 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_DB_TABLE (self), NULL);
#line 612 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = database_table_db;
#line 612 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, name, operator FROM SavedSearchDBTable", -1, &_tmp1_, NULL);
#line 612 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 612 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp1_;
#line 612 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp2_;
#line 614 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = res;
#line 614 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 616 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = gee_array_list_new (TYPE_SAVED_SEARCH_ROW, (GBoxedCopyFunc) saved_search_row_ref, (GDestroyNotify) saved_search_row_unref, NULL, NULL, NULL);
#line 616 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	rows = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_LIST, GeeList);
#line 4369 "SavedSearchDBTable.c"
	{
		gboolean _tmp5_ = FALSE;
#line 618 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp5_ = TRUE;
#line 618 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 4376 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp6_;
			gint _tmp7_;
			SavedSearchRow* row = NULL;
			SavedSearchRow* _tmp10_;
			SavedSearchRow* _tmp11_;
			sqlite3_stmt* _tmp12_;
			SavedSearchRow* _tmp13_;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			SavedSearchRow* _tmp17_;
			sqlite3_stmt* _tmp18_;
			const gchar* _tmp19_;
			GeeList* _tmp20_ = NULL;
			SavedSearchRow* _tmp21_;
			SavedSearchID _tmp22_;
			GeeList* _tmp23_;
			SavedSearchRow* _tmp24_;
			GeeList* _tmp25_;
			GeeList* _tmp26_;
			SavedSearchRow* _tmp27_;
#line 618 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp5_) {
#line 4400 "SavedSearchDBTable.c"
			}
#line 618 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp5_ = FALSE;
#line 619 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp6_ = stmt;
#line 619 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = sqlite3_step (_tmp6_);
#line 620 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp7_ = res;
#line 620 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp7_ == SQLITE_DONE) {
#line 621 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 4414 "SavedSearchDBTable.c"
			} else {
				gint _tmp8_;
#line 622 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp8_ = res;
#line 622 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp8_ != SQLITE_ROW) {
#line 4421 "SavedSearchDBTable.c"
					gint _tmp9_;
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp9_ = res;
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable.get_all_rows", _tmp9_, &_inner_error_);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (rows);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 4439 "SavedSearchDBTable.c"
						} else {
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (rows);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 4451 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 625 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp10_ = saved_search_row_new ();
#line 625 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			row = _tmp10_;
#line 626 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp11_ = row;
#line 626 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp12_ = stmt;
#line 626 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			saved_search_id_init (&_tmp11_->search_id, sqlite3_column_int64 (_tmp12_, 0));
#line 627 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp13_ = row;
#line 627 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp14_ = stmt;
#line 627 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp15_ = sqlite3_column_text (_tmp14_, 1);
#line 627 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp16_ = g_strdup (_tmp15_);
#line 627 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_g_free0 (_tmp13_->name);
#line 627 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp13_->name = _tmp16_;
#line 628 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp17_ = row;
#line 628 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp18_ = stmt;
#line 628 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp19_ = sqlite3_column_text (_tmp18_, 2);
#line 628 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp17_->operator = search_operator_from_string (_tmp19_);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp21_ = row;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp22_ = _tmp21_->search_id;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp23_ = saved_search_db_table_get_conditions_for_id (self, &_tmp22_, &_inner_error_);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp20_ = _tmp23_;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_propagate_error (error, _inner_error_);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_saved_search_row_unref0 (row);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_g_object_unref0 (rows);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return NULL;
#line 4508 "SavedSearchDBTable.c"
				} else {
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_saved_search_row_unref0 (row);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_g_object_unref0 (rows);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_clear_error (&_inner_error_);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return NULL;
#line 4522 "SavedSearchDBTable.c"
				}
			}
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp24_ = row;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp25_ = _tmp20_;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp20_ = NULL;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_g_object_unref0 (_tmp24_->conditions);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp24_->conditions = _tmp25_;
#line 631 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp26_ = rows;
#line 631 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp27_ = row;
#line 631 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection), _tmp27_);
#line 618 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_g_object_unref0 (_tmp20_);
#line 618 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_saved_search_row_unref0 (row);
#line 4545 "SavedSearchDBTable.c"
		}
	}
#line 634 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = rows;
#line 634 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 634 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 4554 "SavedSearchDBTable.c"
}


void
saved_search_db_table_rename (SavedSearchDBTable* self,
                              SavedSearchID* search_id,
                              const gchar* new_name,
                              GError** error)
{
	SavedSearchID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 637 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
#line 637 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (search_id != NULL);
#line 637 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (new_name != NULL);
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = *search_id;
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp1_ = _tmp0_.id;
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "name", new_name, &_inner_error_);
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 4587 "SavedSearchDBTable.c"
		} else {
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 4595 "SavedSearchDBTable.c"
		}
	}
}


static void
saved_search_db_table_class_init (SavedSearchDBTableClass * klass)
{
#line 33 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	((DatabaseTableClass *) klass)->finalize = saved_search_db_table_finalize;
#line 4608 "SavedSearchDBTable.c"
}


static void
saved_search_db_table_instance_init (SavedSearchDBTable * self)
{
}


static void
saved_search_db_table_finalize (DatabaseTable * obj)
{
	SavedSearchDBTable * self;
#line 33 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTable);
#line 33 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	DATABASE_TABLE_CLASS (saved_search_db_table_parent_class)->finalize (obj);
#line 4626 "SavedSearchDBTable.c"
}


GType
saved_search_db_table_get_type (void)
{
	static volatile gsize saved_search_db_table_type_id__volatile = 0;
	if (g_once_init_enter (&saved_search_db_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SavedSearchDBTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_db_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearchDBTable), 0, (GInstanceInitFunc) saved_search_db_table_instance_init, NULL };
		GType saved_search_db_table_type_id;
		saved_search_db_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "SavedSearchDBTable", &g_define_type_info, 0);
		g_once_init_leave (&saved_search_db_table_type_id__volatile, saved_search_db_table_type_id);
	}
	return saved_search_db_table_type_id__volatile;
}



