/* Printing.c generated by valac 0.40.4, the Vala compiler
 * generated from Printing.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <langinfo.h>
#include <gee.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CONTENT_LAYOUT (content_layout_get_type ())

#define TYPE_PRINT_SETTINGS (print_settings_get_type ())
#define PRINT_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_SETTINGS, PrintSettings))
#define PRINT_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_SETTINGS, PrintSettingsClass))
#define IS_PRINT_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_SETTINGS))
#define IS_PRINT_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_SETTINGS))
#define PRINT_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_SETTINGS, PrintSettingsClass))

typedef struct _PrintSettings PrintSettings;
typedef struct _PrintSettingsClass PrintSettingsClass;
typedef struct _PrintSettingsPrivate PrintSettingsPrivate;

#define TYPE_MEASUREMENT (measurement_get_type ())

#define TYPE_MEASUREMENT_UNIT (measurement_unit_get_type ())
typedef struct _Measurement Measurement;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PRINT_MANAGER (print_manager_get_type ())
#define PRINT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_MANAGER, PrintManager))
#define PRINT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_MANAGER, PrintManagerClass))
#define IS_PRINT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_MANAGER))
#define IS_PRINT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_MANAGER))
#define PRINT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_MANAGER, PrintManagerClass))

typedef struct _PrintManager PrintManager;
typedef struct _PrintManagerClass PrintManagerClass;

#define TYPE_STANDARD_PRINT_SIZE (standard_print_size_get_type ())
#define STANDARD_PRINT_SIZE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STANDARD_PRINT_SIZE, StandardPrintSize))
#define STANDARD_PRINT_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STANDARD_PRINT_SIZE, StandardPrintSizeClass))
#define IS_STANDARD_PRINT_SIZE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STANDARD_PRINT_SIZE))
#define IS_STANDARD_PRINT_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STANDARD_PRINT_SIZE))
#define STANDARD_PRINT_SIZE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STANDARD_PRINT_SIZE, StandardPrintSizeClass))

typedef struct _StandardPrintSize StandardPrintSize;
typedef struct _StandardPrintSizeClass StandardPrintSizeClass;
typedef struct _StandardPrintSizePrivate StandardPrintSizePrivate;
#define _print_manager_unref0(var) ((var == NULL) ? NULL : (var = (print_manager_unref (var), NULL)))
typedef struct _ParamSpecPrintSettings ParamSpecPrintSettings;

#define TYPE_PRINT_LAYOUT (print_layout_get_type ())

#define TYPE_CUSTOM_PRINT_TAB (custom_print_tab_get_type ())
#define CUSTOM_PRINT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_PRINT_TAB, CustomPrintTab))
#define CUSTOM_PRINT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_PRINT_TAB, CustomPrintTabClass))
#define IS_CUSTOM_PRINT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_PRINT_TAB))
#define IS_CUSTOM_PRINT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_PRINT_TAB))
#define CUSTOM_PRINT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_PRINT_TAB, CustomPrintTabClass))

typedef struct _CustomPrintTab CustomPrintTab;
typedef struct _CustomPrintTabClass CustomPrintTabClass;
typedef struct _CustomPrintTabPrivate CustomPrintTabPrivate;

#define TYPE_PRINT_JOB (print_job_get_type ())
#define PRINT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_JOB, PrintJob))
#define PRINT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_JOB, PrintJobClass))
#define IS_PRINT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_JOB))
#define IS_PRINT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_JOB))
#define PRINT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_JOB, PrintJobClass))

typedef struct _PrintJob PrintJob;
typedef struct _PrintJobClass PrintJobClass;
enum  {
	CUSTOM_PRINT_TAB_0_PROPERTY,
	CUSTOM_PRINT_TAB_NUM_PROPERTIES
};
static GParamSpec* custom_print_tab_properties[CUSTOM_PRINT_TAB_NUM_PROPERTIES];
#define _standard_print_size_unref0(var) ((var == NULL) ? NULL : (var = (standard_print_size_unref (var), NULL)))

#define RESOURCES_TYPE_UNIT_SYSTEM (resources_unit_system_get_type ())
#define _print_settings_unref0(var) ((var == NULL) ? NULL : (var = (print_settings_unref (var), NULL)))
typedef struct _PrintJobPrivate PrintJobPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
enum  {
	PRINT_JOB_0_PROPERTY,
	PRINT_JOB_NUM_PROPERTIES
};
static GParamSpec* print_job_properties[PRINT_JOB_NUM_PROPERTIES];

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _ParamSpecStandardPrintSize ParamSpecStandardPrintSize;
typedef struct _PrintManagerPrivate PrintManagerPrivate;

#define TYPE_PROGRESS_DIALOG (progress_dialog_get_type ())
#define PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_DIALOG, ProgressDialog))
#define PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_DIALOG, ProgressDialogClass))
#define IS_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_DIALOG))
#define IS_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_DIALOG))
#define PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_DIALOG, ProgressDialogClass))

typedef struct _ProgressDialog ProgressDialog;
typedef struct _ProgressDialogClass ProgressDialogClass;

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _ParamSpecPrintManager ParamSpecPrintManager;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	CONTENT_LAYOUT_STANDARD_SIZE,
	CONTENT_LAYOUT_CUSTOM_SIZE,
	CONTENT_LAYOUT_IMAGE_PER_PAGE
} ContentLayout;

struct _PrintSettings {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PrintSettingsPrivate * priv;
};

struct _PrintSettingsClass {
	GTypeClass parent_class;
	void (*finalize) (PrintSettings *self);
};

typedef enum  {
	MEASUREMENT_UNIT_INCHES,
	MEASUREMENT_UNIT_CENTIMETERS
} MeasurementUnit;

struct _Measurement {
	gdouble value;
	MeasurementUnit unit;
};

struct _PrintSettingsPrivate {
	ContentLayout content_layout;
	Measurement content_width;
	Measurement content_height;
	gint content_ppi;
	gint image_per_page_selection;
	gint size_selection;
	gboolean match_aspect_ratio;
	gboolean print_titles;
	gchar* print_titles_font;
};

struct _StandardPrintSize {
	GTypeInstance parent_instance;
	volatile int ref_count;
	StandardPrintSizePrivate * priv;
	gchar* name;
	Measurement width;
	Measurement height;
};

struct _StandardPrintSizeClass {
	GTypeClass parent_class;
	void (*finalize) (StandardPrintSize *self);
};

struct _ParamSpecPrintSettings {
	GParamSpec parent_instance;
};

typedef enum  {
	PRINT_LAYOUT_ENTIRE_PAGE,
	PRINT_LAYOUT_TWO_PER_PAGE,
	PRINT_LAYOUT_FOUR_PER_PAGE,
	PRINT_LAYOUT_SIX_PER_PAGE,
	PRINT_LAYOUT_EIGHT_PER_PAGE,
	PRINT_LAYOUT_SIXTEEN_PER_PAGE,
	PRINT_LAYOUT_THIRTY_TWO_PER_PAGE
} PrintLayout;

struct _CustomPrintTab {
	GtkBox parent_instance;
	CustomPrintTabPrivate * priv;
};

struct _CustomPrintTabClass {
	GtkBoxClass parent_class;
};

struct _CustomPrintTabPrivate {
	GtkRadioButton* standard_size_radio;
	GtkRadioButton* custom_size_radio;
	GtkRadioButton* image_per_page_radio;
	GtkComboBoxText* image_per_page_combo;
	GtkComboBoxText* standard_sizes_combo;
	GtkComboBoxText* units_combo;
	GtkEntry* custom_width_entry;
	GtkEntry* custom_height_entry;
	GtkEntry* ppi_entry;
	GtkCheckButton* aspect_ratio_check;
	GtkCheckButton* title_print_check;
	GtkFontButton* title_print_font;
	Measurement local_content_width;
	Measurement local_content_height;
	gint local_content_ppi;
	gboolean is_text_insertion_in_progress;
	PrintJob* source_job;
};

typedef enum  {
	RESOURCES_UNIT_SYSTEM_IMPERIAL,
	RESOURCES_UNIT_SYSTEM_METRIC,
	RESOURCES_UNIT_SYSTEM_UNKNOWN
} ResourcesUnitSystem;

struct _PrintJob {
	GtkPrintOperation parent_instance;
	PrintJobPrivate * priv;
};

struct _PrintJobClass {
	GtkPrintOperationClass parent_class;
};

struct _PrintJobPrivate {
	PrintSettings* settings;
	GeeArrayList* photos;
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

struct _Dimensions {
	gint width;
	gint height;
};

struct _ParamSpecStandardPrintSize {
	GParamSpec parent_instance;
};

struct _PrintManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PrintManagerPrivate * priv;
};

struct _PrintManagerClass {
	GTypeClass parent_class;
	void (*finalize) (PrintManager *self);
};

struct _PrintManagerPrivate {
	PrintSettings* settings;
	GtkPageSetup* user_page_setup;
	CustomPrintTab* custom_tab;
	ProgressDialog* progress_dialog;
	GCancellable* cancellable;
	StandardPrintSize** standard_sizes;
	gint standard_sizes_length1;
	gint _standard_sizes_size_;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ParamSpecPrintManager {
	GParamSpec parent_instance;
};


static gpointer print_settings_parent_class = NULL;
static gpointer custom_print_tab_parent_class = NULL;
static gpointer print_job_parent_class = NULL;
static gpointer standard_print_size_parent_class = NULL;
static gpointer print_manager_parent_class = NULL;
static PrintManager* print_manager_instance;
static PrintManager* print_manager_instance = NULL;

GType content_layout_get_type (void) G_GNUC_CONST;
gpointer print_settings_ref (gpointer instance);
void print_settings_unref (gpointer instance);
GParamSpec* param_spec_print_settings (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_print_settings (GValue* value,
                               gpointer v_object);
void value_take_print_settings (GValue* value,
                                gpointer v_object);
gpointer value_get_print_settings (const GValue* value);
GType print_settings_get_type (void) G_GNUC_CONST;
GType measurement_get_type (void) G_GNUC_CONST;
GType measurement_unit_get_type (void) G_GNUC_CONST;
Measurement* measurement_dup (const Measurement* self);
void measurement_free (Measurement* self);
#define PRINT_SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRINT_SETTINGS, PrintSettingsPrivate))
#define PRINT_SETTINGS_MIN_CONTENT_PPI 72
#define PRINT_SETTINGS_MAX_CONTENT_PPI 1200
PrintSettings* print_settings_new (void);
PrintSettings* print_settings_construct (GType object_type);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gint configuration_facade_get_printing_content_units (ConfigurationFacade* self);
gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self);
void measurement_init (Measurement *self,
                       gdouble value,
                       MeasurementUnit unit);
gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self);
gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self);
gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self);
gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self);
gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self);
gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self);
gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self);
gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self);
void print_settings_save (PrintSettings* self);
void configuration_facade_set_printing_content_units (ConfigurationFacade* self,
                                                      gint units_code);
void configuration_facade_set_printing_content_width (ConfigurationFacade* self,
                                                      gdouble content_width);
void configuration_facade_set_printing_content_height (ConfigurationFacade* self,
                                                       gdouble content_height);
void configuration_facade_set_printing_size_selection (ConfigurationFacade* self,
                                                       gint size_code);
void configuration_facade_set_printing_content_layout (ConfigurationFacade* self,
                                                       gint layout_code);
void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self,
                                                           gboolean match_aspect_ratio);
void configuration_facade_set_printing_print_titles (ConfigurationFacade* self,
                                                     gboolean print_titles);
void configuration_facade_set_printing_titles_font (ConfigurationFacade* self,
                                                    const gchar* font_name);
void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self,
                                                        gint images_per_page_code);
void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self,
                                                    gint content_ppi);
void print_settings_get_content_width (PrintSettings* self,
                                       Measurement* result);
ContentLayout print_settings_get_content_layout (PrintSettings* self);
gpointer print_manager_ref (gpointer instance);
void print_manager_unref (gpointer instance);
GParamSpec* param_spec_print_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void value_set_print_manager (GValue* value,
                              gpointer v_object);
void value_take_print_manager (GValue* value,
                               gpointer v_object);
gpointer value_get_print_manager (const GValue* value);
GType print_manager_get_type (void) G_GNUC_CONST;
PrintManager* print_manager_get_instance (void);
gpointer standard_print_size_ref (gpointer instance);
void standard_print_size_unref (gpointer instance);
GParamSpec* param_spec_standard_print_size (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_standard_print_size (GValue* value,
                                    gpointer v_object);
void value_take_standard_print_size (GValue* value,
                                     gpointer v_object);
gpointer value_get_standard_print_size (const GValue* value);
GType standard_print_size_get_type (void) G_GNUC_CONST;
StandardPrintSize** print_manager_get_standard_sizes (PrintManager* self,
                                                      int* result_length1);
gint print_settings_get_size_selection (PrintSettings* self);
void print_settings_get_content_height (PrintSettings* self,
                                        Measurement* result);
void print_settings_get_minimum_content_dimension (PrintSettings* self,
                                                   Measurement* result);
void print_settings_get_maximum_content_dimension (PrintSettings* self,
                                                   Measurement* result);
gboolean print_settings_is_match_aspect_ratio_enabled (PrintSettings* self);
gboolean print_settings_is_print_titles_enabled (PrintSettings* self);
gint print_settings_get_content_ppi (PrintSettings* self);
gint print_settings_get_image_per_page_selection (PrintSettings* self);
void print_settings_set_content_layout (PrintSettings* self,
                                        ContentLayout content_layout);
void print_settings_set_content_width (PrintSettings* self,
                                       Measurement* content_width);
void print_settings_set_content_height (PrintSettings* self,
                                        Measurement* content_height);
void print_settings_set_content_ppi (PrintSettings* self,
                                     gint content_ppi);
void print_settings_set_image_per_page_selection (PrintSettings* self,
                                                  gint image_per_page_selection);
void print_settings_set_size_selection (PrintSettings* self,
                                        gint size_selection);
void print_settings_set_match_aspect_ratio_enabled (PrintSettings* self,
                                                    gboolean enable_state);
void print_settings_set_print_titles_enabled (PrintSettings* self,
                                              gboolean print_titles);
void print_settings_set_print_titles_font (PrintSettings* self,
                                           const gchar* fontname);
gchar* print_settings_get_print_titles_font (PrintSettings* self);
static void print_settings_finalize (PrintSettings * obj);
#define MEASUREMENT_CENTIMETERS_PER_INCH 2.54
#define MEASUREMENT_INCHES_PER_CENTIMETER (1.0 / 2.54)
void measurement_convert_to (Measurement *self,
                             MeasurementUnit to_unit,
                             Measurement* result);
gboolean measurement_is_less_than (Measurement *self,
                                   Measurement* rhs);
gboolean measurement_is_greater_than (Measurement *self,
                                      Measurement* rhs);
GType print_layout_get_type (void) G_GNUC_CONST;
PrintLayout* print_layout_get_all (int* result_length1);
gint print_layout_get_per_page (PrintLayout self);
gint print_layout_get_x (PrintLayout self);
gint print_layout_get_y (PrintLayout self);
gchar* print_layout_to_string (PrintLayout self);
GType custom_print_tab_get_type (void) G_GNUC_CONST;
GType print_job_get_type (void) G_GNUC_CONST;
#define CUSTOM_PRINT_TAB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CUSTOM_PRINT_TAB, CustomPrintTabPrivate))
#define CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE 0
#define CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE 1
CustomPrintTab* custom_print_tab_new (PrintJob* source_job);
CustomPrintTab* custom_print_tab_construct (GType object_type,
                                            PrintJob* source_job);
static void custom_print_tab_on_radio_group_click (CustomPrintTab* self,
                                            GtkButton* b);
static void _custom_print_tab_on_radio_group_click_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static gboolean custom_print_tab_standard_sizes_combo_separator_func (GtkTreeModel* model,
                                                               GtkTreeIter* iter);
static gboolean _custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model,
                                                                                                 GtkTreeIter* iter,
                                                                                                 gpointer self);
GType resources_unit_system_get_type (void) G_GNUC_CONST;
ResourcesUnitSystem resources_get_default_measurement_unit (void);
static void custom_print_tab_on_entry_insert_text (CustomPrintTab* self,
                                            GtkEditable* editable,
                                            const gchar* text,
                                            gint length,
                                            gint* position);
static void _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                      const gchar* new_text,
                                                                      gint new_text_length,
                                                                      gint* position,
                                                                      gpointer self);
static gboolean custom_print_tab_on_width_entry_focus_out (CustomPrintTab* self,
                                                    GdkEventFocus* event);
static gboolean _custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                GdkEventFocus* event,
                                                                                gpointer self);
static gboolean custom_print_tab_on_height_entry_focus_out (CustomPrintTab* self,
                                                     GdkEventFocus* event);
static gboolean _custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                 GdkEventFocus* event,
                                                                                 gpointer self);
static void custom_print_tab_on_units_combo_changed (CustomPrintTab* self);
static void _custom_print_tab_on_units_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                     gpointer self);
static void custom_print_tab_on_ppi_entry_insert_text (CustomPrintTab* self,
                                                GtkEditable* editable,
                                                const gchar* text,
                                                gint length,
                                                gint* position);
static void _custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                          const gchar* new_text,
                                                                          gint new_text_length,
                                                                          gint* position,
                                                                          gpointer self);
static gboolean custom_print_tab_on_ppi_entry_focus_out (CustomPrintTab* self,
                                                  GdkEventFocus* event);
static gboolean _custom_print_tab_on_ppi_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                              GdkEventFocus* event,
                                                                              gpointer self);
static void custom_print_tab_sync_state_from_job (CustomPrintTab* self,
                                           PrintJob* job);
static void custom_print_tab_on_aspect_ratio_check_clicked (CustomPrintTab* self);
static void _custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self);
gdouble print_job_get_source_aspect_ratio (PrintJob* self);
static gchar* custom_print_tab_format_measurement (CustomPrintTab* self,
                                            Measurement* measurement);
static gchar* custom_print_tab_format_measurement_as (CustomPrintTab* self,
                                               Measurement* measurement,
                                               MeasurementUnit to_unit);
static MeasurementUnit custom_print_tab_get_user_unit_choice (CustomPrintTab* self);
static void custom_print_tab_get_width_entry_value (CustomPrintTab* self,
                                             Measurement* result);
PrintSettings* print_job_get_local_settings (PrintJob* self);
static gboolean custom_print_tab_is_match_aspect_ratio_enabled (CustomPrintTab* self);
static void custom_print_tab_set_content_ppi (CustomPrintTab* self,
                                       gint content_ppi);
static void custom_print_tab_get_height_entry_value (CustomPrintTab* self,
                                              Measurement* result);
static void custom_print_tab_set_user_unit_choice (CustomPrintTab* self,
                                            MeasurementUnit unit);
static void custom_print_tab_set_content_width (CustomPrintTab* self,
                                         Measurement* content_width);
static void custom_print_tab_set_content_height (CustomPrintTab* self,
                                          Measurement* content_height);
static void custom_print_tab_set_content_layout (CustomPrintTab* self,
                                          ContentLayout content_layout);
static void custom_print_tab_set_image_per_page_selection (CustomPrintTab* self,
                                                    gint image_per_page);
static void custom_print_tab_set_size_selection (CustomPrintTab* self,
                                          gint size_selection);
static void custom_print_tab_set_match_aspect_ratio_enabled (CustomPrintTab* self,
                                                      gboolean enable_state);
static void custom_print_tab_set_print_titles_enabled (CustomPrintTab* self,
                                                gboolean print_titles);
static void custom_print_tab_set_print_titles_font (CustomPrintTab* self,
                                             const gchar* fontname);
static void custom_print_tab_set_content_layout_control_state (CustomPrintTab* self,
                                                        ContentLayout layout);
static ContentLayout custom_print_tab_get_content_layout (CustomPrintTab* self);
static void custom_print_tab_get_content_width (CustomPrintTab* self,
                                         Measurement* result);
static void custom_print_tab_get_content_height (CustomPrintTab* self,
                                          Measurement* result);
static gint custom_print_tab_get_content_ppi (CustomPrintTab* self);
static gint custom_print_tab_get_image_per_page_selection (CustomPrintTab* self);
static gint custom_print_tab_get_size_selection (CustomPrintTab* self);
static gboolean custom_print_tab_is_print_titles_enabled (CustomPrintTab* self);
static gchar* custom_print_tab_get_print_titles_font (CustomPrintTab* self);
PrintJob* custom_print_tab_get_source_job (CustomPrintTab* self);
PrintSettings* custom_print_tab_get_local_settings (CustomPrintTab* self);
static void custom_print_tab_finalize (GObject * obj);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
#define PRINT_JOB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRINT_JOB, PrintJobPrivate))
PrintJob* print_job_new (GeeCollection* to_print);
PrintJob* print_job_construct (GType object_type,
                               GeeCollection* to_print);
PrintSettings* print_manager_get_global_settings (PrintManager* self);
GType photo_exception_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
gdouble dimensions_get_aspect_ratio (Dimensions *self);
GeeList* print_job_get_photos (PrintJob* self);
Photo* print_job_get_source_photo (PrintJob* self);
void print_job_set_local_settings (PrintJob* self,
                                   PrintSettings* settings);
static void print_job_finalize (GObject * obj);
StandardPrintSize* standard_print_size_new (const gchar* name,
                                            Measurement* width,
                                            Measurement* height);
StandardPrintSize* standard_print_size_construct (GType object_type,
                                                  const gchar* name,
                                                  Measurement* width,
                                                  Measurement* height);
static void standard_print_size_finalize (StandardPrintSize * obj);
GType progress_dialog_get_type (void) G_GNUC_CONST;
#define PRINT_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRINT_MANAGER, PrintManagerPrivate))
#define PRINT_MANAGER_IMAGE_DISTANCE 0.24
static PrintManager* print_manager_new (void);
static PrintManager* print_manager_construct (GType object_type);
static void _vala_array_add112 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add113 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add114 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add115 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add116 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add117 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add118 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add119 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add120 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add121 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add122 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add123 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add124 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add125 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
static void _vala_array_add126 (StandardPrintSize** * array,
                         int* length,
                         int* size,
                         StandardPrintSize* value);
void print_manager_spool_photo (PrintManager* self,
                                GeeCollection* to_print);
gchar* data_object_get_name (DataObject* self);
static void print_manager_on_begin_print (PrintManager* self,
                                   GtkPrintOperation* emitting_object,
                                   GtkPrintContext* job_context);
static void _print_manager_on_begin_print_gtk_print_operation_begin_print (GtkPrintOperation* _sender,
                                                                    GtkPrintContext* context,
                                                                    gpointer self);
static void print_manager_on_draw_page (PrintManager* self,
                                 GtkPrintOperation* emitting_object,
                                 GtkPrintContext* job_context,
                                 gint page_num);
static void _print_manager_on_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender,
                                                                GtkPrintContext* context,
                                                                gint page_nr,
                                                                gpointer self);
static GObject* print_manager_on_create_custom_widget (PrintManager* self,
                                                GtkPrintOperation* emitting_object);
static GObject* _print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget (GtkPrintOperation* _sender,
                                                                                          gpointer self);
static void print_manager_on_status_changed (PrintManager* self,
                                      GtkPrintOperation* job);
static void _print_manager_on_status_changed_gtk_print_operation_status_changed (GtkPrintOperation* _sender,
                                                                          gpointer self);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
void page_window_set_busy_cursor (PageWindow* self);
ProgressDialog* progress_dialog_new (GtkWindow* owner,
                                     const gchar* text,
                                     GCancellable* cancellable);
ProgressDialog* progress_dialog_construct (GType object_type,
                                           GtkWindow* owner,
                                           const gchar* text,
                                           GCancellable* cancellable);
void progress_dialog_close (ProgressDialog* self);
void page_window_set_normal_cursor (PageWindow* self);
void app_window_error_message (const gchar* message,
                               GtkWindow* parent);
void spin_event_loop (void);
void progress_dialog_set_status (ProgressDialog* self,
                                 const gchar* text);
static void print_manager_fit_image_to_canvas (PrintManager* self,
                                        Photo* photo,
                                        gdouble x,
                                        gdouble y,
                                        gdouble canvas_width,
                                        gdouble canvas_height,
                                        gboolean crop,
                                        PrintJob* job,
                                        GtkPrintContext* job_context);
static void print_manager_add_title_to_canvas (PrintManager* self,
                                        gdouble x,
                                        gdouble y,
                                        const gchar* title,
                                        PrintJob* job,
                                        GtkPrintContext* job_context);
gboolean progress_dialog_monitor (ProgressDialog* self,
                                  guint64 count,
                                  guint64 total,
                                  gboolean do_event_loop);
static void print_manager_on_custom_widget_apply (PrintManager* self,
                                           GtkWidget* custom_widget);
static void _print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply (GtkPrintOperation* _sender,
                                                                                    GtkWidget* widget,
                                                                                    gpointer self);
void print_manager_set_global_settings (PrintManager* self,
                                        PrintSettings* settings);
void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
static gboolean print_manager_are_approximately_equal (PrintManager* self,
                                                gdouble val1,
                                                gdouble val2);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
void scaling_to_fill_viewport (Dimensions* viewport,
                               Scaling* result);
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self,
                                    Scaling* scaling,
                                    GError** error);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self,
                                      GdkPixbuf* pixbuf,
                                      GdkInterpType interp,
                                      gboolean scale_up);
void scaling_for_viewport (Dimensions* viewport,
                           gboolean scale_up,
                           Scaling* result);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void print_manager_finalize (PrintManager * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


GType
content_layout_get_type (void)
{
	static volatile gsize content_layout_type_id__volatile = 0;
	if (g_once_init_enter (&content_layout_type_id__volatile)) {
		static const GEnumValue values[] = {{CONTENT_LAYOUT_STANDARD_SIZE, "CONTENT_LAYOUT_STANDARD_SIZE", "standard-size"}, {CONTENT_LAYOUT_CUSTOM_SIZE, "CONTENT_LAYOUT_CUSTOM_SIZE", "custom-size"}, {CONTENT_LAYOUT_IMAGE_PER_PAGE, "CONTENT_LAYOUT_IMAGE_PER_PAGE", "image-per-page"}, {0, NULL, NULL}};
		GType content_layout_type_id;
		content_layout_type_id = g_enum_register_static ("ContentLayout", values);
		g_once_init_leave (&content_layout_type_id__volatile, content_layout_type_id);
	}
	return content_layout_type_id__volatile;
}


PrintSettings*
print_settings_construct (GType object_type)
{
	PrintSettings* self = NULL;
	ConfigFacade* config = NULL;
	ConfigFacade* _tmp0_;
	MeasurementUnit units = 0;
	gchar* _tmp1_;
#line 30 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (PrintSettings*) g_type_create_instance (object_type);
#line 31 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = config_facade_get_instance ();
#line 31 "/home/jens/Source/shotwell/src/Printing.vala"
	config = _tmp0_;
#line 33 "/home/jens/Source/shotwell/src/Printing.vala"
	units = (MeasurementUnit) configuration_facade_get_printing_content_units (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 35 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&self->priv->content_width, configuration_facade_get_printing_content_width (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade)), units);
#line 36 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&self->priv->content_height, configuration_facade_get_printing_content_height (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade)), units);
#line 37 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->size_selection = configuration_facade_get_printing_size_selection (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 38 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_layout = (ContentLayout) configuration_facade_get_printing_content_layout (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 39 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->match_aspect_ratio = configuration_facade_get_printing_match_aspect_ratio (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 40 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->print_titles = configuration_facade_get_printing_print_titles (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 41 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = configuration_facade_get_printing_titles_font (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 41 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->priv->print_titles_font);
#line 41 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->print_titles_font = _tmp1_;
#line 42 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->image_per_page_selection = configuration_facade_get_printing_images_per_page (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 43 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_ppi = configuration_facade_get_printing_content_ppi (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 30 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (config);
#line 30 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 931 "Printing.c"
}


PrintSettings*
print_settings_new (void)
{
#line 30 "/home/jens/Source/shotwell/src/Printing.vala"
	return print_settings_construct (TYPE_PRINT_SETTINGS);
#line 940 "Printing.c"
}


void
print_settings_save (PrintSettings* self)
{
	ConfigFacade* config = NULL;
	ConfigFacade* _tmp0_;
	Measurement _tmp1_;
	MeasurementUnit _tmp2_;
	Measurement _tmp3_;
	gdouble _tmp4_;
	Measurement _tmp5_;
	gdouble _tmp6_;
	gint _tmp7_;
	ContentLayout _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
#line 46 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 47 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = config_facade_get_instance ();
#line 47 "/home/jens/Source/shotwell/src/Printing.vala"
	config = _tmp0_;
#line 49 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->content_width;
#line 49 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _tmp1_.unit;
#line 49 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_units (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), (gint) _tmp2_);
#line 50 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->content_width;
#line 50 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_.value;
#line 50 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_width (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp4_);
#line 51 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = self->priv->content_height;
#line 51 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = _tmp5_.value;
#line 51 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_height (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp6_);
#line 52 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = self->priv->size_selection;
#line 52 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_size_selection (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp7_);
#line 53 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = self->priv->content_layout;
#line 53 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_layout (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), (gint) _tmp8_);
#line 54 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = self->priv->match_aspect_ratio;
#line 54 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_match_aspect_ratio (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp9_);
#line 55 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = self->priv->print_titles;
#line 55 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_print_titles (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp10_);
#line 56 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = self->priv->print_titles_font;
#line 56 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_titles_font (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp11_);
#line 57 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = self->priv->image_per_page_selection;
#line 57 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_images_per_page (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp12_);
#line 58 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = self->priv->content_ppi;
#line 58 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_ppi (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp13_);
#line 46 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (config);
#line 1016 "Printing.c"
}


void
print_settings_get_content_width (PrintSettings* self,
                                  Measurement* result)
{
#line 62 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (print_settings_get_content_layout (self)) {
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 1032 "Printing.c"
		{
			PrintManager* _tmp0_;
			PrintManager* _tmp1_;
			gint _tmp2_;
			StandardPrintSize** _tmp3_;
			StandardPrintSize* _tmp4_;
			Measurement _tmp5_;
			Measurement _tmp6_;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp0_ = print_manager_get_instance ();
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp1_ = _tmp0_;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp3_ = print_manager_get_standard_sizes (_tmp1_, &_tmp2_);
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp4_ = _tmp3_[print_settings_get_size_selection (self)];
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5_ = _tmp4_->width;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp6_ = _tmp5_;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_print_manager_unref0 (_tmp1_);
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp6_;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 1059 "Printing.c"
		}
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 1063 "Printing.c"
		{
			Measurement _tmp7_;
#line 70 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp7_ = self->priv->content_width;
#line 70 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp7_;
#line 70 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 1072 "Printing.c"
		}
		default:
		{
#line 73 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:73: unknown ContentLayout enumeration value");
#line 1078 "Printing.c"
		}
	}
}


void
print_settings_get_content_height (PrintSettings* self,
                                   Measurement* result)
{
#line 77 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (print_settings_get_content_layout (self)) {
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 1096 "Printing.c"
		{
			PrintManager* _tmp0_;
			PrintManager* _tmp1_;
			gint _tmp2_;
			StandardPrintSize** _tmp3_;
			StandardPrintSize* _tmp4_;
			Measurement _tmp5_;
			Measurement _tmp6_;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp0_ = print_manager_get_instance ();
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp1_ = _tmp0_;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp3_ = print_manager_get_standard_sizes (_tmp1_, &_tmp2_);
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp4_ = _tmp3_[print_settings_get_size_selection (self)];
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5_ = _tmp4_->height;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp6_ = _tmp5_;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_print_manager_unref0 (_tmp1_);
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp6_;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 1123 "Printing.c"
		}
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 1127 "Printing.c"
		{
			Measurement _tmp7_;
#line 85 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp7_ = self->priv->content_height;
#line 85 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp7_;
#line 85 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 1136 "Printing.c"
		}
		default:
		{
#line 88 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:88: unknown ContentLayout enumeration value");
#line 1142 "Printing.c"
		}
	}
}


void
print_settings_get_minimum_content_dimension (PrintSettings* self,
                                              Measurement* result)
{
	Measurement _tmp0_ = {0};
#line 92 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 93 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp0_, 0.5, MEASUREMENT_UNIT_INCHES);
#line 93 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp0_;
#line 93 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 1161 "Printing.c"
}


void
print_settings_get_maximum_content_dimension (PrintSettings* self,
                                              Measurement* result)
{
	Measurement _tmp0_ = {0};
#line 96 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 97 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp0_, (gdouble) 30, MEASUREMENT_UNIT_INCHES);
#line 97 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp0_;
#line 97 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 1178 "Printing.c"
}


gboolean
print_settings_is_match_aspect_ratio_enabled (PrintSettings* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 100 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), FALSE);
#line 101 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->match_aspect_ratio;
#line 101 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 101 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1195 "Printing.c"
}


gboolean
print_settings_is_print_titles_enabled (PrintSettings* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 104 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), FALSE);
#line 105 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->print_titles;
#line 105 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 105 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1212 "Printing.c"
}


gint
print_settings_get_content_ppi (PrintSettings* self)
{
	gint result = 0;
	gint _tmp0_;
#line 108 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
#line 109 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->content_ppi;
#line 109 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 109 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1229 "Printing.c"
}


gint
print_settings_get_image_per_page_selection (PrintSettings* self)
{
	gint result = 0;
	gint _tmp0_;
#line 112 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
#line 113 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->image_per_page_selection;
#line 113 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 113 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1246 "Printing.c"
}


gint
print_settings_get_size_selection (PrintSettings* self)
{
	gint result = 0;
	gint _tmp0_;
#line 116 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
#line 117 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->size_selection;
#line 117 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 117 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1263 "Printing.c"
}


ContentLayout
print_settings_get_content_layout (PrintSettings* self)
{
	ContentLayout result = 0;
	ContentLayout _tmp0_;
#line 120 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
#line 121 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->content_layout;
#line 121 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 121 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1280 "Printing.c"
}


void
print_settings_set_content_layout (PrintSettings* self,
                                   ContentLayout content_layout)
{
#line 124 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 125 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_layout = content_layout;
#line 1292 "Printing.c"
}


void
print_settings_set_content_width (PrintSettings* self,
                                  Measurement* content_width)
{
	Measurement _tmp0_;
#line 128 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 128 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (content_width != NULL);
#line 129 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *content_width;
#line 129 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_width = _tmp0_;
#line 1309 "Printing.c"
}


void
print_settings_set_content_height (PrintSettings* self,
                                   Measurement* content_height)
{
	Measurement _tmp0_;
#line 132 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 132 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (content_height != NULL);
#line 133 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *content_height;
#line 133 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_height = _tmp0_;
#line 1326 "Printing.c"
}


void
print_settings_set_content_ppi (PrintSettings* self,
                                gint content_ppi)
{
#line 136 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 137 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_ppi = content_ppi;
#line 1338 "Printing.c"
}


void
print_settings_set_image_per_page_selection (PrintSettings* self,
                                             gint image_per_page_selection)
{
#line 140 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 141 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->image_per_page_selection = image_per_page_selection;
#line 1350 "Printing.c"
}


void
print_settings_set_size_selection (PrintSettings* self,
                                   gint size_selection)
{
#line 144 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 145 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->size_selection = size_selection;
#line 1362 "Printing.c"
}


void
print_settings_set_match_aspect_ratio_enabled (PrintSettings* self,
                                               gboolean enable_state)
{
#line 148 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 149 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->match_aspect_ratio = enable_state;
#line 1374 "Printing.c"
}


void
print_settings_set_print_titles_enabled (PrintSettings* self,
                                         gboolean print_titles)
{
#line 152 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 153 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->print_titles = print_titles;
#line 1386 "Printing.c"
}


void
print_settings_set_print_titles_font (PrintSettings* self,
                                      const gchar* fontname)
{
	gchar* _tmp0_;
#line 156 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 156 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (fontname != NULL);
#line 157 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_strdup (fontname);
#line 157 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->priv->print_titles_font);
#line 157 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->print_titles_font = _tmp0_;
#line 1405 "Printing.c"
}


gchar*
print_settings_get_print_titles_font (PrintSettings* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 160 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), NULL);
#line 161 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->print_titles_font;
#line 161 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 161 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 161 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1425 "Printing.c"
}


static void
value_print_settings_init (GValue* value)
{
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	value->data[0].v_pointer = NULL;
#line 1434 "Printing.c"
}


static void
value_print_settings_free_value (GValue* value)
{
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (value->data[0].v_pointer) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_unref (value->data[0].v_pointer);
#line 1445 "Printing.c"
	}
}


static void
value_print_settings_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (src_value->data[0].v_pointer) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = print_settings_ref (src_value->data[0].v_pointer);
#line 1458 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1462 "Printing.c"
	}
}


static gpointer
value_print_settings_peek_pointer (const GValue* value)
{
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 1472 "Printing.c"
}


static gchar*
value_print_settings_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (collect_values[0].v_pointer) {
#line 1484 "Printing.c"
		PrintSettings * object;
		object = collect_values[0].v_pointer;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		if (object->parent_instance.g_class == NULL) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1491 "Printing.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1495 "Printing.c"
		}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = print_settings_ref (object);
#line 1499 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 1503 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 1507 "Printing.c"
}


static gchar*
value_print_settings_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	PrintSettings ** object_p;
	object_p = collect_values[0].v_pointer;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!object_p) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1523 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!value->data[0].v_pointer) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = NULL;
#line 1529 "Printing.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = value->data[0].v_pointer;
#line 1533 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = print_settings_ref (value->data[0].v_pointer);
#line 1537 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 1541 "Printing.c"
}


GParamSpec*
param_spec_print_settings (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecPrintSettings* spec;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PRINT_SETTINGS), NULL);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return G_PARAM_SPEC (spec);
#line 1561 "Printing.c"
}


gpointer
value_get_print_settings (const GValue* value)
{
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS), NULL);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 1572 "Printing.c"
}


void
value_set_print_settings (GValue* value,
                          gpointer v_object)
{
	PrintSettings * old;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_SETTINGS));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_ref (value->data[0].v_pointer);
#line 1595 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 1599 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_unref (old);
#line 1605 "Printing.c"
	}
}


void
value_take_print_settings (GValue* value,
                           gpointer v_object)
{
	PrintSettings * old;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_SETTINGS));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 1627 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 1631 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_unref (old);
#line 1637 "Printing.c"
	}
}


static void
print_settings_class_init (PrintSettingsClass * klass)
{
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	((PrintSettingsClass *) klass)->finalize = print_settings_finalize;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_type_class_add_private (klass, sizeof (PrintSettingsPrivate));
#line 1651 "Printing.c"
}


static void
print_settings_instance_init (PrintSettings * self)
{
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv = PRINT_SETTINGS_GET_PRIVATE (self);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	self->ref_count = 1;
#line 1662 "Printing.c"
}


static void
print_settings_finalize (PrintSettings * obj)
{
	PrintSettings * self;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_SETTINGS, PrintSettings);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_handlers_destroy (self);
#line 28 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->priv->print_titles_font);
#line 1676 "Printing.c"
}


GType
print_settings_get_type (void)
{
	static volatile gsize print_settings_type_id__volatile = 0;
	if (g_once_init_enter (&print_settings_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_print_settings_init, value_print_settings_free_value, value_print_settings_copy_value, value_print_settings_peek_pointer, "p", value_print_settings_collect_value, "p", value_print_settings_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PrintSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintSettings), 0, (GInstanceInitFunc) print_settings_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType print_settings_type_id;
		print_settings_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PrintSettings", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&print_settings_type_id__volatile, print_settings_type_id);
	}
	return print_settings_type_id__volatile;
}


gpointer
print_settings_ref (gpointer instance)
{
	PrintSettings * self;
	self = instance;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_atomic_int_inc (&self->ref_count);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return instance;
#line 1705 "Printing.c"
}


void
print_settings_unref (gpointer instance)
{
	PrintSettings * self;
	self = instance;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		PRINT_SETTINGS_GET_CLASS (self)->finalize (self);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1720 "Printing.c"
	}
}


GType
measurement_unit_get_type (void)
{
	static volatile gsize measurement_unit_type_id__volatile = 0;
	if (g_once_init_enter (&measurement_unit_type_id__volatile)) {
		static const GEnumValue values[] = {{MEASUREMENT_UNIT_INCHES, "MEASUREMENT_UNIT_INCHES", "inches"}, {MEASUREMENT_UNIT_CENTIMETERS, "MEASUREMENT_UNIT_CENTIMETERS", "centimeters"}, {0, NULL, NULL}};
		GType measurement_unit_type_id;
		measurement_unit_type_id = g_enum_register_static ("MeasurementUnit", values);
		g_once_init_leave (&measurement_unit_type_id__volatile, measurement_unit_type_id);
	}
	return measurement_unit_type_id__volatile;
}


void
measurement_init (Measurement *self,
                  gdouble value,
                  MeasurementUnit unit)
{
#line 185 "/home/jens/Source/shotwell/src/Printing.vala"
	memset (self, 0, sizeof (Measurement));
#line 186 "/home/jens/Source/shotwell/src/Printing.vala"
	(*self).value = value;
#line 187 "/home/jens/Source/shotwell/src/Printing.vala"
	(*self).unit = unit;
#line 1750 "Printing.c"
}


void
measurement_convert_to (Measurement *self,
                        MeasurementUnit to_unit,
                        Measurement* result)
{
	MeasurementUnit _tmp0_;
#line 191 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = (*self).unit;
#line 191 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp0_ == to_unit) {
#line 192 "/home/jens/Source/shotwell/src/Printing.vala"
		*result = (*self);
#line 192 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 1768 "Printing.c"
	}
#line 194 "/home/jens/Source/shotwell/src/Printing.vala"
	if (to_unit == MEASUREMENT_UNIT_INCHES) {
#line 1772 "Printing.c"
		gdouble _tmp1_;
		Measurement _tmp2_ = {0};
#line 195 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = (*self).value;
#line 195 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp2_, _tmp1_ * MEASUREMENT_INCHES_PER_CENTIMETER, MEASUREMENT_UNIT_INCHES);
#line 195 "/home/jens/Source/shotwell/src/Printing.vala"
		*result = _tmp2_;
#line 195 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 1783 "Printing.c"
	} else {
#line 196 "/home/jens/Source/shotwell/src/Printing.vala"
		if (to_unit == MEASUREMENT_UNIT_CENTIMETERS) {
#line 1787 "Printing.c"
			gdouble _tmp3_;
			Measurement _tmp4_ = {0};
#line 197 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp3_ = (*self).value;
#line 197 "/home/jens/Source/shotwell/src/Printing.vala"
			measurement_init (&_tmp4_, _tmp3_ * MEASUREMENT_CENTIMETERS_PER_INCH, MEASUREMENT_UNIT_CENTIMETERS);
#line 197 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp4_;
#line 197 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 1798 "Printing.c"
		} else {
#line 199 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:199: unrecognized unit");
#line 1802 "Printing.c"
		}
	}
}


gboolean
measurement_is_less_than (Measurement *self,
                          Measurement* rhs)
{
	gboolean result = FALSE;
	Measurement _tmp0_ = {0};
	MeasurementUnit _tmp1_;
	Measurement _tmp2_;
	MeasurementUnit _tmp3_;
	Measurement converted_rhs = {0};
	gdouble _tmp7_;
	Measurement _tmp8_;
	gdouble _tmp9_;
#line 203 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (rhs != NULL, FALSE);
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = (*self).unit;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = *rhs;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ == _tmp3_) {
#line 1831 "Printing.c"
		Measurement _tmp4_;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *rhs;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp4_;
#line 1837 "Printing.c"
	} else {
		MeasurementUnit _tmp5_;
		Measurement _tmp6_ = {0};
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = (*self).unit;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (rhs, _tmp5_, &_tmp6_);
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp6_;
#line 1847 "Printing.c"
	}
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	converted_rhs = _tmp0_;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = (*self).value;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = converted_rhs;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_.value;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp7_ < _tmp9_;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1861 "Printing.c"
}


gboolean
measurement_is_greater_than (Measurement *self,
                             Measurement* rhs)
{
	gboolean result = FALSE;
	Measurement _tmp0_ = {0};
	MeasurementUnit _tmp1_;
	Measurement _tmp2_;
	MeasurementUnit _tmp3_;
	Measurement converted_rhs = {0};
	gdouble _tmp7_;
	Measurement _tmp8_;
	gdouble _tmp9_;
#line 208 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (rhs != NULL, FALSE);
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = (*self).unit;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = *rhs;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ == _tmp3_) {
#line 1888 "Printing.c"
		Measurement _tmp4_;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *rhs;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp4_;
#line 1894 "Printing.c"
	} else {
		MeasurementUnit _tmp5_;
		Measurement _tmp6_ = {0};
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = (*self).unit;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (rhs, _tmp5_, &_tmp6_);
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp6_;
#line 1904 "Printing.c"
	}
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	converted_rhs = _tmp0_;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = (*self).value;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = converted_rhs;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_.value;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp7_ > _tmp9_;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1918 "Printing.c"
}


Measurement*
measurement_dup (const Measurement* self)
{
	Measurement* dup;
#line 178 "/home/jens/Source/shotwell/src/Printing.vala"
	dup = g_new0 (Measurement, 1);
#line 178 "/home/jens/Source/shotwell/src/Printing.vala"
	memcpy (dup, self, sizeof (Measurement));
#line 178 "/home/jens/Source/shotwell/src/Printing.vala"
	return dup;
#line 1932 "Printing.c"
}


void
measurement_free (Measurement* self)
{
#line 178 "/home/jens/Source/shotwell/src/Printing.vala"
	g_free (self);
#line 1941 "Printing.c"
}


GType
measurement_get_type (void)
{
	static volatile gsize measurement_type_id__volatile = 0;
	if (g_once_init_enter (&measurement_type_id__volatile)) {
		GType measurement_type_id;
		measurement_type_id = g_boxed_type_register_static ("Measurement", (GBoxedCopyFunc) measurement_dup, (GBoxedFreeFunc) measurement_free);
		g_once_init_leave (&measurement_type_id__volatile, measurement_type_id);
	}
	return measurement_type_id__volatile;
}


PrintLayout*
print_layout_get_all (int* result_length1)
{
	PrintLayout* result = NULL;
	PrintLayout* _tmp0_;
	PrintLayout* _tmp1_;
	gint _tmp1__length1;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (PrintLayout, 7);
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[0] = PRINT_LAYOUT_ENTIRE_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[1] = PRINT_LAYOUT_TWO_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[2] = PRINT_LAYOUT_FOUR_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[3] = PRINT_LAYOUT_SIX_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[4] = PRINT_LAYOUT_EIGHT_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[5] = PRINT_LAYOUT_SIXTEEN_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[6] = PRINT_LAYOUT_THIRTY_TWO_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1__length1 = 7;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	if (result_length1) {
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
		*result_length1 = _tmp1__length1;
#line 1989 "Printing.c"
	}
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1995 "Printing.c"
}


gint
print_layout_get_per_page (PrintLayout self)
{
	gint result = 0;
	gint* per_page = NULL;
	gint* _tmp0_;
	gint per_page_length1;
	gint _per_page_size_;
	gint _tmp1_;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (gint, 7);
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[0] = 1;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[1] = 2;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[2] = 4;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[3] = 6;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[4] = 8;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[5] = 16;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[6] = 32;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	per_page = _tmp0_;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	per_page_length1 = 7;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_per_page_size_ = per_page_length1;
#line 238 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = per_page[self];
#line 238 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 238 "/home/jens/Source/shotwell/src/Printing.vala"
	per_page = (g_free (per_page), NULL);
#line 238 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2038 "Printing.c"
}


gint
print_layout_get_x (PrintLayout self)
{
	gint result = 0;
	gint* x = NULL;
	gint* _tmp0_;
	gint x_length1;
	gint _x_size_;
	gint _tmp1_;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (gint, 7);
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[0] = 1;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[1] = 1;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[2] = 2;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[3] = 2;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[4] = 2;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[5] = 4;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[6] = 4;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	x = _tmp0_;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	x_length1 = 7;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_x_size_ = x_length1;
#line 244 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = x[self];
#line 244 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 244 "/home/jens/Source/shotwell/src/Printing.vala"
	x = (g_free (x), NULL);
#line 244 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2081 "Printing.c"
}


gint
print_layout_get_y (PrintLayout self)
{
	gint result = 0;
	gint* y = NULL;
	gint* _tmp0_;
	gint y_length1;
	gint _y_size_;
	gint _tmp1_;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (gint, 7);
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[0] = 1;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[1] = 2;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[2] = 2;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[3] = 3;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[4] = 4;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[5] = 4;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[6] = 8;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	y = _tmp0_;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	y_length1 = 7;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_y_size_ = y_length1;
#line 250 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = y[self];
#line 250 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 250 "/home/jens/Source/shotwell/src/Printing.vala"
	y = (g_free (y), NULL);
#line 250 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2124 "Printing.c"
}


gchar*
print_layout_to_string (PrintLayout self)
{
	gchar* result = NULL;
	gchar** labels = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint labels_length1;
	gint _labels_size_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_strdup (_ ("Fill the entire page"));
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = g_strdup (_ ("2 images per page"));
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = g_strdup (_ ("4 images per page"));
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = g_strdup (_ ("6 images per page"));
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = g_strdup (_ ("8 images per page"));
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = g_strdup (_ ("16 images per page"));
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = g_strdup (_ ("32 images per page"));
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = g_new0 (gchar*, 7 + 1);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_[0] = _tmp0_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_[1] = _tmp1_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_[2] = _tmp2_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_[3] = _tmp3_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_[4] = _tmp4_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_[5] = _tmp5_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_[6] = _tmp6_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	labels = _tmp7_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	labels_length1 = 7;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_labels_size_ = labels_length1;
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = labels[self];
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp9_;
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	labels = (_vala_array_free (labels, labels_length1, (GDestroyNotify) g_free), NULL);
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2191 "Printing.c"
}


GType
print_layout_get_type (void)
{
	static volatile gsize print_layout_type_id__volatile = 0;
	if (g_once_init_enter (&print_layout_type_id__volatile)) {
		static const GEnumValue values[] = {{PRINT_LAYOUT_ENTIRE_PAGE, "PRINT_LAYOUT_ENTIRE_PAGE", "entire-page"}, {PRINT_LAYOUT_TWO_PER_PAGE, "PRINT_LAYOUT_TWO_PER_PAGE", "two-per-page"}, {PRINT_LAYOUT_FOUR_PER_PAGE, "PRINT_LAYOUT_FOUR_PER_PAGE", "four-per-page"}, {PRINT_LAYOUT_SIX_PER_PAGE, "PRINT_LAYOUT_SIX_PER_PAGE", "six-per-page"}, {PRINT_LAYOUT_EIGHT_PER_PAGE, "PRINT_LAYOUT_EIGHT_PER_PAGE", "eight-per-page"}, {PRINT_LAYOUT_SIXTEEN_PER_PAGE, "PRINT_LAYOUT_SIXTEEN_PER_PAGE", "sixteen-per-page"}, {PRINT_LAYOUT_THIRTY_TWO_PER_PAGE, "PRINT_LAYOUT_THIRTY_TWO_PER_PAGE", "thirty-two-per-page"}, {0, NULL, NULL}};
		GType print_layout_type_id;
		print_layout_type_id = g_enum_register_static ("PrintLayout", values);
		g_once_init_leave (&print_layout_type_id__volatile, print_layout_type_id);
	}
	return print_layout_type_id__volatile;
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 305 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? g_object_ref (self) : NULL;
#line 2214 "Printing.c"
}


static void
_custom_print_tab_on_radio_group_click_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
#line 307 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_radio_group_click ((CustomPrintTab*) self, _sender);
#line 2224 "Printing.c"
}


static gboolean
_custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model,
                                                                                        GtkTreeIter* iter,
                                                                                        gpointer self)
{
	gboolean result;
	result = custom_print_tab_standard_sizes_combo_separator_func (model, iter);
#line 316 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2237 "Printing.c"
}


static gpointer
_standard_print_size_ref0 (gpointer self)
{
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? standard_print_size_ref (self) : NULL;
#line 2246 "Printing.c"
}


static void
_custom_print_tab_on_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                 const gchar* new_text,
                                                                 gint new_text_length,
                                                                 gint* position,
                                                                 gpointer self)
{
#line 323 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_entry_insert_text ((CustomPrintTab*) self, _sender, new_text, new_text_length, position);
#line 2259 "Printing.c"
}


static gboolean
_custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                       GdkEventFocus* event,
                                                                       gpointer self)
{
	gboolean result;
	result = custom_print_tab_on_width_entry_focus_out ((CustomPrintTab*) self, event);
#line 324 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2272 "Printing.c"
}


static gboolean
_custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                        GdkEventFocus* event,
                                                                        gpointer self)
{
	gboolean result;
	result = custom_print_tab_on_height_entry_focus_out ((CustomPrintTab*) self, event);
#line 327 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2285 "Printing.c"
}


static void
_custom_print_tab_on_units_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                gpointer self)
{
#line 329 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_units_combo_changed ((CustomPrintTab*) self);
#line 2295 "Printing.c"
}


static void
_custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                     const gchar* new_text,
                                                                     gint new_text_length,
                                                                     gint* position,
                                                                     gpointer self)
{
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_ppi_entry_insert_text ((CustomPrintTab*) self, _sender, new_text, new_text_length, position);
#line 2308 "Printing.c"
}


static gboolean
_custom_print_tab_on_ppi_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                     GdkEventFocus* event,
                                                                     gpointer self)
{
	gboolean result;
	result = custom_print_tab_on_ppi_entry_focus_out ((CustomPrintTab*) self, event);
#line 333 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2321 "Printing.c"
}


static void
_custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self)
{
#line 340 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_aspect_ratio_check_clicked ((CustomPrintTab*) self);
#line 2331 "Printing.c"
}


CustomPrintTab*
custom_print_tab_construct (GType object_type,
                            PrintJob* source_job)
{
	CustomPrintTab * self = NULL;
	PrintJob* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
	GtkRadioButton* _tmp3_;
	gint _tmp4_;
	PrintLayout* _tmp5_;
	StandardPrintSize** standard_sizes = NULL;
	PrintManager* _tmp10_;
	PrintManager* _tmp11_;
	gint _tmp12_;
	StandardPrintSize** _tmp13_;
	StandardPrintSize** _tmp14_;
	gint _tmp14__length1;
	gint standard_sizes_length1;
	gint _standard_sizes_size_;
	GtkComboBoxText* _tmp15_;
	StandardPrintSize** _tmp16_;
	gint _tmp16__length1;
	GtkComboBoxText* _tmp21_;
	GtkEntry* _tmp22_;
	GtkEntry* _tmp23_;
	GtkEntry* _tmp24_;
	GtkEntry* _tmp25_;
	GtkComboBoxText* _tmp26_;
	GtkComboBoxText* _tmp27_;
	GtkEntry* _tmp28_;
	GtkEntry* _tmp29_;
	GtkCheckButton* _tmp30_;
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (source_job), NULL);
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (CustomPrintTab*) g_object_new (object_type, NULL);
#line 305 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = _g_object_ref0 (source_job);
#line 305 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->source_job);
#line 305 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->source_job = _tmp0_;
#line 307 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->standard_size_radio;
#line 307 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
#line 308 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->custom_size_radio;
#line 308 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
#line 309 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->image_per_page_radio;
#line 309 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = print_layout_get_all (&_tmp4_);
#line 2392 "Printing.c"
	{
		PrintLayout* layout_collection = NULL;
		gint layout_collection_length1 = 0;
		gint _layout_collection_size_ = 0;
		gint layout_it = 0;
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
		layout_collection = _tmp5_;
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
		layout_collection_length1 = _tmp4_;
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
		for (layout_it = 0; layout_it < _tmp4_; layout_it = layout_it + 1) {
#line 2404 "Printing.c"
			PrintLayout layout = 0;
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
			layout = layout_collection[layout_it];
#line 2408 "Printing.c"
			{
				GtkComboBoxText* _tmp6_;
				PrintLayout _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
#line 312 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp6_ = self->priv->image_per_page_combo;
#line 312 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp7_ = layout;
#line 312 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp8_ = print_layout_to_string (_tmp7_);
#line 312 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp9_ = _tmp8_;
#line 312 "/home/jens/Source/shotwell/src/Printing.vala"
				gtk_combo_box_text_append_text (_tmp6_, _tmp9_);
#line 312 "/home/jens/Source/shotwell/src/Printing.vala"
				_g_free0 (_tmp9_);
#line 2426 "Printing.c"
			}
		}
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
		layout_collection = (g_free (layout_collection), NULL);
#line 2431 "Printing.c"
	}
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = print_manager_get_instance ();
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = _tmp10_;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = print_manager_get_standard_sizes (_tmp11_, &_tmp12_);
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = _tmp13_;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14__length1 = _tmp12_;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_manager_unref0 (_tmp11_);
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	standard_sizes = _tmp14_;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	standard_sizes_length1 = _tmp14__length1;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_standard_sizes_size_ = standard_sizes_length1;
#line 316 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = self->priv->standard_sizes_combo;
#line 316 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_row_separator_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_combo_box_get_type (), GtkComboBox), _custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func, NULL, NULL);
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = standard_sizes;
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16__length1 = standard_sizes_length1;
#line 2459 "Printing.c"
	{
		StandardPrintSize** size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
		size_collection = _tmp16_;
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
		size_collection_length1 = _tmp16__length1;
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
		for (size_it = 0; size_it < _tmp16__length1; size_it = size_it + 1) {
#line 2471 "Printing.c"
			StandardPrintSize* _tmp17_;
			StandardPrintSize* size = NULL;
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp17_ = _standard_print_size_ref0 (size_collection[size_it]);
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
			size = _tmp17_;
#line 2478 "Printing.c"
			{
				GtkComboBoxText* _tmp18_;
				StandardPrintSize* _tmp19_;
				const gchar* _tmp20_;
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp18_ = self->priv->standard_sizes_combo;
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp19_ = size;
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp20_ = _tmp19_->name;
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				gtk_combo_box_text_append_text (_tmp18_, _tmp20_);
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
				_standard_print_size_unref0 (size);
#line 2493 "Printing.c"
			}
		}
	}
#line 321 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp21_ = self->priv->standard_sizes_combo;
#line 321 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_combo_box_get_type (), GtkComboBox), 9 * resources_get_default_measurement_unit ());
#line 323 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp22_ = self->priv->custom_width_entry;
#line 323 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_editable_get_type (), GtkEditable), "insert-text", (GCallback) _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text, self, 0);
#line 324 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp23_ = self->priv->custom_width_entry;
#line 324 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event, self, 0);
#line 326 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp24_ = self->priv->custom_height_entry;
#line 326 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_editable_get_type (), GtkEditable), "insert-text", (GCallback) _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text, self, 0);
#line 327 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp25_ = self->priv->custom_height_entry;
#line 327 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event, self, 0);
#line 329 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp26_ = self->priv->units_combo;
#line 329 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _custom_print_tab_on_units_combo_changed_gtk_combo_box_changed, self, 0);
#line 330 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = self->priv->units_combo;
#line 330 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_combo_box_get_type (), GtkComboBox), (gint) resources_get_default_measurement_unit ());
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp28_ = self->priv->ppi_entry;
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_editable_get_type (), GtkEditable), "insert-text", (GCallback) _custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text, self, 0);
#line 333 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp29_ = self->priv->ppi_entry;
#line 333 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _custom_print_tab_on_ppi_entry_focus_out_gtk_widget_focus_out_event, self, 0);
#line 335 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_sync_state_from_job (self, source_job);
#line 337 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 340 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp30_ = self->priv->aspect_ratio_check;
#line 340 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked, self, 0);
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 2543 "Printing.c"
}


CustomPrintTab*
custom_print_tab_new (PrintJob* source_job)
{
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	return custom_print_tab_construct (TYPE_CUSTOM_PRINT_TAB, source_job);
#line 2552 "Printing.c"
}


static void
custom_print_tab_on_aspect_ratio_check_clicked (CustomPrintTab* self)
{
	GtkCheckButton* _tmp0_;
#line 343 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 344 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->aspect_ratio_check;
#line 344 "/home/jens/Source/shotwell/src/Printing.vala"
	if (gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton))) {
#line 2566 "Printing.c"
		Measurement _tmp1_;
		gdouble _tmp2_;
		PrintJob* _tmp3_;
		Measurement _tmp4_;
		MeasurementUnit _tmp5_;
		GtkEntry* _tmp6_;
		Measurement _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = self->priv->local_content_height;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = _tmp1_.value;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = self->priv->source_job;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = self->priv->local_content_height;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = _tmp4_.unit;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&self->priv->local_content_width, _tmp2_ * print_job_get_source_aspect_ratio (_tmp3_), _tmp5_);
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = self->priv->custom_width_entry;
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7_ = self->priv->local_content_width;
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp8_ = custom_print_tab_format_measurement (self, &_tmp7_);
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp9_ = _tmp8_;
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp6_, _tmp9_);
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp9_);
#line 2600 "Printing.c"
	}
}


static gboolean
custom_print_tab_on_width_entry_focus_out (CustomPrintTab* self,
                                           GdkEventFocus* event)
{
	gboolean result = FALSE;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	Measurement _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	Measurement new_width = {0};
	Measurement _tmp6_ = {0};
	Measurement min_width = {0};
	PrintJob* _tmp7_;
	PrintSettings* _tmp8_;
	PrintSettings* _tmp9_;
	Measurement _tmp10_ = {0};
	Measurement _tmp11_;
	Measurement max_width = {0};
	PrintJob* _tmp12_;
	PrintSettings* _tmp13_;
	PrintSettings* _tmp14_;
	Measurement _tmp15_ = {0};
	Measurement _tmp16_;
	gboolean _tmp17_ = FALSE;
	Measurement _tmp18_;
	Measurement _tmp34_;
	GtkEntry* _tmp35_;
	Measurement _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
#line 352 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 352 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_width_entry;
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->local_content_width;
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_format_measurement_as (self, &_tmp2_, custom_print_tab_get_user_unit_choice (self));
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_;
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = g_strcmp0 (_tmp1_, _tmp4_) == 0;
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp4_);
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp5_) {
#line 355 "/home/jens/Source/shotwell/src/Printing.vala"
		result = FALSE;
#line 355 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 2661 "Printing.c"
	}
#line 357 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_get_width_entry_value (self, &_tmp6_);
#line 357 "/home/jens/Source/shotwell/src/Printing.vala"
	new_width = _tmp6_;
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = self->priv->source_job;
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = print_job_get_local_settings (_tmp7_);
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_;
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_minimum_content_dimension (_tmp9_, &_tmp10_);
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = _tmp10_;
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp9_);
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	min_width = _tmp11_;
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = self->priv->source_job;
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = print_job_get_local_settings (_tmp12_);
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = _tmp13_;
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_maximum_content_dimension (_tmp14_, &_tmp15_);
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = _tmp15_;
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp14_);
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	max_width = _tmp16_;
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp18_ = min_width;
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
	if (measurement_is_less_than (&new_width, &_tmp18_)) {
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17_ = TRUE;
#line 2701 "Printing.c"
	} else {
		Measurement _tmp19_;
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp19_ = max_width;
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17_ = measurement_is_greater_than (&new_width, &_tmp19_);
#line 2708 "Printing.c"
	}
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp17_) {
#line 2712 "Printing.c"
		GtkEntry* _tmp20_;
		Measurement _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
#line 362 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp20_ = self->priv->custom_width_entry;
#line 362 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = self->priv->local_content_width;
#line 362 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = custom_print_tab_format_measurement (self, &_tmp21_);
#line 362 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = _tmp22_;
#line 362 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp20_, _tmp23_);
#line 362 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp23_);
#line 363 "/home/jens/Source/shotwell/src/Printing.vala"
		result = FALSE;
#line 363 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 2733 "Printing.c"
	}
#line 366 "/home/jens/Source/shotwell/src/Printing.vala"
	if (custom_print_tab_is_match_aspect_ratio_enabled (self)) {
#line 2737 "Printing.c"
		Measurement new_height = {0};
		Measurement _tmp24_;
		gdouble _tmp25_;
		PrintJob* _tmp26_;
		Measurement _tmp27_;
		MeasurementUnit _tmp28_;
		Measurement _tmp29_;
		GtkEntry* _tmp30_;
		Measurement _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = new_width;
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = _tmp24_.value;
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = self->priv->source_job;
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27_ = new_width;
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = _tmp27_.unit;
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&new_height, _tmp25_ / print_job_get_source_aspect_ratio (_tmp26_), _tmp28_);
#line 370 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = new_height;
#line 370 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->local_content_height = _tmp29_;
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30_ = self->priv->custom_height_entry;
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp31_ = new_height;
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp32_ = custom_print_tab_format_measurement (self, &_tmp31_);
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp33_ = _tmp32_;
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp30_, _tmp33_);
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp33_);
#line 2777 "Printing.c"
	}
#line 374 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp34_ = new_width;
#line 374 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_width = _tmp34_;
#line 375 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp35_ = self->priv->custom_width_entry;
#line 375 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp36_ = new_width;
#line 375 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp37_ = custom_print_tab_format_measurement (self, &_tmp36_);
#line 375 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp38_ = _tmp37_;
#line 375 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp35_, _tmp38_);
#line 375 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp38_);
#line 376 "/home/jens/Source/shotwell/src/Printing.vala"
	result = FALSE;
#line 376 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2799 "Printing.c"
}


static gchar*
custom_print_tab_format_measurement (CustomPrintTab* self,
                                     Measurement* measurement)
{
	gchar* result = NULL;
	Measurement _tmp0_;
	gdouble _tmp1_;
	gchar* _tmp2_;
#line 379 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 379 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (measurement != NULL, NULL);
#line 380 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *measurement;
#line 380 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_.value;
#line 380 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = g_strdup_printf ("%.2f", _tmp1_);
#line 380 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp2_;
#line 380 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2825 "Printing.c"
}


static gchar*
custom_print_tab_format_measurement_as (CustomPrintTab* self,
                                        Measurement* measurement,
                                        MeasurementUnit to_unit)
{
	gchar* result = NULL;
	Measurement _tmp0_ = {0};
	Measurement _tmp1_;
	MeasurementUnit _tmp2_;
	Measurement converted_measurement = {0};
	Measurement _tmp5_;
	gchar* _tmp6_;
#line 383 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 383 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (measurement != NULL, NULL);
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = *measurement;
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _tmp1_.unit;
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_ == to_unit) {
#line 2851 "Printing.c"
		Measurement _tmp3_;
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = *measurement;
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp3_;
#line 2857 "Printing.c"
	} else {
		Measurement _tmp4_ = {0};
#line 385 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (measurement, to_unit, &_tmp4_);
#line 385 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp4_;
#line 2864 "Printing.c"
	}
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
	converted_measurement = _tmp0_;
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = converted_measurement;
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = custom_print_tab_format_measurement (self, &_tmp5_);
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp6_;
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2876 "Printing.c"
}


static gboolean
custom_print_tab_on_ppi_entry_focus_out (CustomPrintTab* self,
                                         GdkEventFocus* event)
{
	gboolean result = FALSE;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
#line 389 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 389 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->ppi_entry;
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_ppi (self, atoi (_tmp1_));
#line 391 "/home/jens/Source/shotwell/src/Printing.vala"
	result = FALSE;
#line 391 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2901 "Printing.c"
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1124 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 2919 "Printing.c"
}


static void
custom_print_tab_on_ppi_entry_insert_text (CustomPrintTab* self,
                                           GtkEditable* editable,
                                           const gchar* text,
                                           gint length,
                                           gint* position)
{
	GtkEntry* sender = NULL;
	GtkEntry* _tmp0_;
	gboolean _tmp1_;
	gchar* new_text = NULL;
	gchar* _tmp4_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GtkEntry* _tmp22_;
#line 394 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 394 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_EDITABLE (editable));
#line 394 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (text != NULL);
#line 396 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (editable, gtk_entry_get_type (), GtkEntry));
#line 396 "/home/jens/Source/shotwell/src/Printing.vala"
	sender = _tmp0_;
#line 398 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->is_text_insertion_in_progress;
#line 398 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_) {
#line 399 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (sender);
#line 399 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 2957 "Printing.c"
	}
#line 401 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = TRUE;
#line 403 "/home/jens/Source/shotwell/src/Printing.vala"
	if (length == -1) {
#line 2963 "Printing.c"
		gint _tmp2_;
		gint _tmp3_;
#line 404 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = strlen (text);
#line 404 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = _tmp2_;
#line 404 "/home/jens/Source/shotwell/src/Printing.vala"
		length = (gint) _tmp3_;
#line 2972 "Printing.c"
	}
#line 406 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = g_strdup ("");
#line 406 "/home/jens/Source/shotwell/src/Printing.vala"
	new_text = _tmp4_;
#line 2978 "Printing.c"
	{
		gint ctr = 0;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
		ctr = 0;
#line 2983 "Printing.c"
		{
			gboolean _tmp5_ = FALSE;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5_ = TRUE;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
			while (TRUE) {
#line 2990 "Printing.c"
				gint _tmp7_;
				gint _tmp8_;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
				if (!_tmp5_) {
#line 2995 "Printing.c"
					gint _tmp6_;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp6_ = ctr;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
					ctr = _tmp6_ + 1;
#line 3001 "Printing.c"
				}
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp5_ = FALSE;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp7_ = ctr;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
				if (!(_tmp7_ < length)) {
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
					break;
#line 3011 "Printing.c"
				}
#line 408 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp8_ = ctr;
#line 408 "/home/jens/Source/shotwell/src/Printing.vala"
				if (g_ascii_isdigit (string_get (text, (glong) _tmp8_))) {
#line 3017 "Printing.c"
					const gchar* _tmp9_;
					gint _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp9_ = new_text;
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp10_ = ctr;
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp11_ = g_strdup_printf ("%c", (gchar) string_get (text, (glong) _tmp10_));
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp12_ = _tmp11_;
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (new_text);
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					new_text = _tmp13_;
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (_tmp12_);
#line 3039 "Printing.c"
				}
			}
		}
	}
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = new_text;
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = strlen (_tmp14_);
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = _tmp15_;
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp16_ > 0) {
#line 3052 "Printing.c"
		GtkEntry* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17_ = sender;
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = new_text;
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp19_ = new_text;
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp20_ = strlen (_tmp19_);
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = _tmp20_;
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_editable_get_type (), GtkEditable), "insert-text", _tmp18_, (gint) _tmp21_, position);
#line 3070 "Printing.c"
	}
#line 415 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp22_ = sender;
#line 415 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_stop_emission_by_name (_tmp22_, "insert-text");
#line 417 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = FALSE;
#line 394 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (new_text);
#line 394 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (sender);
#line 3082 "Printing.c"
}


static gboolean
custom_print_tab_on_height_entry_focus_out (CustomPrintTab* self,
                                            GdkEventFocus* event)
{
	gboolean result = FALSE;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	Measurement _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	Measurement new_height = {0};
	Measurement _tmp6_ = {0};
	Measurement min_height = {0};
	PrintJob* _tmp7_;
	PrintSettings* _tmp8_;
	PrintSettings* _tmp9_;
	Measurement _tmp10_ = {0};
	Measurement _tmp11_;
	Measurement max_height = {0};
	PrintJob* _tmp12_;
	PrintSettings* _tmp13_;
	PrintSettings* _tmp14_;
	Measurement _tmp15_ = {0};
	Measurement _tmp16_;
	gboolean _tmp17_ = FALSE;
	Measurement _tmp18_;
	Measurement _tmp34_;
	GtkEntry* _tmp35_;
	Measurement _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
#line 420 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 420 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_height_entry;
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->local_content_height;
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_format_measurement_as (self, &_tmp2_, custom_print_tab_get_user_unit_choice (self));
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_;
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = g_strcmp0 (_tmp1_, _tmp4_) == 0;
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp4_);
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp5_) {
#line 423 "/home/jens/Source/shotwell/src/Printing.vala"
		result = FALSE;
#line 423 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 3142 "Printing.c"
	}
#line 425 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_get_height_entry_value (self, &_tmp6_);
#line 425 "/home/jens/Source/shotwell/src/Printing.vala"
	new_height = _tmp6_;
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = self->priv->source_job;
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = print_job_get_local_settings (_tmp7_);
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_;
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_minimum_content_dimension (_tmp9_, &_tmp10_);
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = _tmp10_;
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp9_);
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	min_height = _tmp11_;
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = self->priv->source_job;
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = print_job_get_local_settings (_tmp12_);
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = _tmp13_;
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_maximum_content_dimension (_tmp14_, &_tmp15_);
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = _tmp15_;
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp14_);
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	max_height = _tmp16_;
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp18_ = min_height;
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
	if (measurement_is_less_than (&new_height, &_tmp18_)) {
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17_ = TRUE;
#line 3182 "Printing.c"
	} else {
		Measurement _tmp19_;
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp19_ = max_height;
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17_ = measurement_is_greater_than (&new_height, &_tmp19_);
#line 3189 "Printing.c"
	}
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp17_) {
#line 3193 "Printing.c"
		GtkEntry* _tmp20_;
		Measurement _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
#line 430 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp20_ = self->priv->custom_height_entry;
#line 430 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = self->priv->local_content_height;
#line 430 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = custom_print_tab_format_measurement (self, &_tmp21_);
#line 430 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = _tmp22_;
#line 430 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp20_, _tmp23_);
#line 430 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp23_);
#line 431 "/home/jens/Source/shotwell/src/Printing.vala"
		result = FALSE;
#line 431 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 3214 "Printing.c"
	}
#line 434 "/home/jens/Source/shotwell/src/Printing.vala"
	if (custom_print_tab_is_match_aspect_ratio_enabled (self)) {
#line 3218 "Printing.c"
		Measurement new_width = {0};
		Measurement _tmp24_;
		gdouble _tmp25_;
		PrintJob* _tmp26_;
		Measurement _tmp27_;
		MeasurementUnit _tmp28_;
		Measurement _tmp29_;
		GtkEntry* _tmp30_;
		Measurement _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = new_height;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = _tmp24_.value;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = self->priv->source_job;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27_ = new_height;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = _tmp27_.unit;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&new_width, _tmp25_ * print_job_get_source_aspect_ratio (_tmp26_), _tmp28_);
#line 438 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = new_width;
#line 438 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->local_content_width = _tmp29_;
#line 439 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30_ = self->priv->custom_width_entry;
#line 439 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp31_ = new_width;
#line 439 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp32_ = custom_print_tab_format_measurement (self, &_tmp31_);
#line 439 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp33_ = _tmp32_;
#line 439 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp30_, _tmp33_);
#line 439 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp33_);
#line 3258 "Printing.c"
	}
#line 442 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp34_ = new_height;
#line 442 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_height = _tmp34_;
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp35_ = self->priv->custom_height_entry;
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp36_ = new_height;
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp37_ = custom_print_tab_format_measurement (self, &_tmp36_);
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp38_ = _tmp37_;
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp35_, _tmp38_);
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp38_);
#line 444 "/home/jens/Source/shotwell/src/Printing.vala"
	result = FALSE;
#line 444 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 3280 "Printing.c"
}


static MeasurementUnit
custom_print_tab_get_user_unit_choice (CustomPrintTab* self)
{
	MeasurementUnit result = 0;
	GtkComboBoxText* _tmp0_;
#line 447 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 448 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->units_combo;
#line 448 "/home/jens/Source/shotwell/src/Printing.vala"
	if (gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox)) == CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE) {
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
		result = MEASUREMENT_UNIT_INCHES;
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 3299 "Printing.c"
	} else {
		GtkComboBoxText* _tmp1_;
#line 450 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = self->priv->units_combo;
#line 450 "/home/jens/Source/shotwell/src/Printing.vala"
		if (gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_combo_box_get_type (), GtkComboBox)) == CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE) {
#line 451 "/home/jens/Source/shotwell/src/Printing.vala"
			result = MEASUREMENT_UNIT_CENTIMETERS;
#line 451 "/home/jens/Source/shotwell/src/Printing.vala"
			return result;
#line 3310 "Printing.c"
		} else {
#line 453 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:453: unknown unit combo box choice");
#line 3314 "Printing.c"
		}
	}
}


static void
custom_print_tab_set_user_unit_choice (CustomPrintTab* self,
                                       MeasurementUnit unit)
{
#line 457 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 458 "/home/jens/Source/shotwell/src/Printing.vala"
	if (unit == MEASUREMENT_UNIT_INCHES) {
#line 3328 "Printing.c"
		GtkComboBoxText* _tmp0_;
#line 459 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = self->priv->units_combo;
#line 459 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox), CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE);
#line 3334 "Printing.c"
	} else {
#line 460 "/home/jens/Source/shotwell/src/Printing.vala"
		if (unit == MEASUREMENT_UNIT_CENTIMETERS) {
#line 3338 "Printing.c"
			GtkComboBoxText* _tmp1_;
#line 461 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp1_ = self->priv->units_combo;
#line 461 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_combo_box_get_type (), GtkComboBox), CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE);
#line 3344 "Printing.c"
		} else {
#line 463 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:463: unknown MeasurementUnit enumeration");
#line 3348 "Printing.c"
		}
	}
}


static gdouble
double_parse (const gchar* str)
{
	gdouble result = 0.0;
	gdouble _tmp0_;
#line 889 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 890 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_ascii_strtod (str, NULL);
#line 890 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 890 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 3367 "Printing.c"
}


static void
custom_print_tab_get_width_entry_value (CustomPrintTab* self,
                                        Measurement* result)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	Measurement _tmp2_ = {0};
#line 467 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 468 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_width_entry;
#line 468 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 468 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp2_, double_parse (_tmp1_), custom_print_tab_get_user_unit_choice (self));
#line 468 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp2_;
#line 468 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 3390 "Printing.c"
}


static void
custom_print_tab_get_height_entry_value (CustomPrintTab* self,
                                         Measurement* result)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	Measurement _tmp2_ = {0};
#line 471 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_height_entry;
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp2_, double_parse (_tmp1_), custom_print_tab_get_user_unit_choice (self));
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp2_;
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 3413 "Printing.c"
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
#line 1417 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1417 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 3433 "Printing.c"
}


static void
custom_print_tab_on_entry_insert_text (CustomPrintTab* self,
                                       GtkEditable* editable,
                                       const gchar* text,
                                       gint length,
                                       gint* position)
{
	GtkEntry* sender = NULL;
	GtkEntry* _tmp0_;
	gboolean _tmp1_;
	const gchar* decimal_point = NULL;
	const gchar* _tmp4_;
	gboolean contains_decimal_point = FALSE;
	GtkEntry* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* new_text = NULL;
	gchar* _tmp8_;
	const gchar* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GtkEntry* _tmp35_;
#line 475 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 475 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_EDITABLE (editable));
#line 475 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (text != NULL);
#line 478 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (editable, gtk_entry_get_type (), GtkEntry));
#line 478 "/home/jens/Source/shotwell/src/Printing.vala"
	sender = _tmp0_;
#line 480 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->is_text_insertion_in_progress;
#line 480 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_) {
#line 481 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (sender);
#line 481 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 3477 "Printing.c"
	}
#line 483 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = TRUE;
#line 485 "/home/jens/Source/shotwell/src/Printing.vala"
	if (length == -1) {
#line 3483 "Printing.c"
		gint _tmp2_;
		gint _tmp3_;
#line 486 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = strlen (text);
#line 486 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = _tmp2_;
#line 486 "/home/jens/Source/shotwell/src/Printing.vala"
		length = (gint) _tmp3_;
#line 3492 "Printing.c"
	}
#line 488 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = nl_langinfo (RADIXCHAR);
#line 488 "/home/jens/Source/shotwell/src/Printing.vala"
	decimal_point = _tmp4_;
#line 490 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = sender;
#line 490 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = gtk_entry_get_text (_tmp5_);
#line 490 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = decimal_point;
#line 490 "/home/jens/Source/shotwell/src/Printing.vala"
	contains_decimal_point = string_contains (_tmp6_, _tmp7_);
#line 492 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = g_strdup ("");
#line 492 "/home/jens/Source/shotwell/src/Printing.vala"
	new_text = _tmp8_;
#line 3510 "Printing.c"
	{
		gint ctr = 0;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
		ctr = 0;
#line 3515 "Printing.c"
		{
			gboolean _tmp9_ = FALSE;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp9_ = TRUE;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
			while (TRUE) {
#line 3522 "Printing.c"
				gint _tmp11_;
				gint _tmp12_;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
				if (!_tmp9_) {
#line 3527 "Printing.c"
					gint _tmp10_;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp10_ = ctr;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
					ctr = _tmp10_ + 1;
#line 3533 "Printing.c"
				}
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp9_ = FALSE;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp11_ = ctr;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
				if (!(_tmp11_ < length)) {
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
					break;
#line 3543 "Printing.c"
				}
#line 494 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp12_ = ctr;
#line 494 "/home/jens/Source/shotwell/src/Printing.vala"
				if (g_ascii_isdigit (string_get (text, (glong) _tmp12_))) {
#line 3549 "Printing.c"
					const gchar* _tmp13_;
					gint _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp13_ = new_text;
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp14_ = ctr;
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp15_ = g_strdup_printf ("%c", (gchar) string_get (text, (glong) _tmp14_));
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp16_ = _tmp15_;
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (new_text);
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					new_text = _tmp17_;
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (_tmp16_);
#line 3571 "Printing.c"
				} else {
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_;
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp19_ = contains_decimal_point;
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
					if (!_tmp19_) {
#line 3579 "Printing.c"
						gint _tmp20_;
						const gchar* _tmp21_;
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp20_ = ctr;
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp21_ = decimal_point;
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp18_ = string_get (text, (glong) _tmp20_) == string_get (_tmp21_, (glong) 0);
#line 3588 "Printing.c"
					} else {
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp18_ = FALSE;
#line 3592 "Printing.c"
					}
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
					if (_tmp18_) {
#line 3596 "Printing.c"
						const gchar* _tmp22_;
						gint _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp22_ = new_text;
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp23_ = ctr;
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp24_ = g_strdup_printf ("%c", (gchar) string_get (text, (glong) _tmp23_));
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp25_ = _tmp24_;
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp26_ = g_strconcat (_tmp22_, _tmp25_, NULL);
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_g_free0 (new_text);
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						new_text = _tmp26_;
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_g_free0 (_tmp25_);
#line 3618 "Printing.c"
					}
				}
			}
		}
	}
#line 501 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = new_text;
#line 501 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp28_ = strlen (_tmp27_);
#line 501 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp29_ = _tmp28_;
#line 501 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp29_ > 0) {
#line 3632 "Printing.c"
		GtkEntry* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
#line 502 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30_ = sender;
#line 502 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp31_ = new_text;
#line 502 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp32_ = new_text;
#line 502 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp33_ = strlen (_tmp32_);
#line 502 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp34_ = _tmp33_;
#line 502 "/home/jens/Source/shotwell/src/Printing.vala"
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_editable_get_type (), GtkEditable), "insert-text", _tmp31_, (gint) _tmp34_, position);
#line 3650 "Printing.c"
	}
#line 504 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp35_ = sender;
#line 504 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_stop_emission_by_name (_tmp35_, "insert-text");
#line 506 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = FALSE;
#line 475 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (new_text);
#line 475 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (sender);
#line 3662 "Printing.c"
}


static void
custom_print_tab_sync_state_from_job (CustomPrintTab* self,
                                      PrintJob* job)
{
	PrintSettings* _tmp0_;
	PrintSettings* _tmp1_;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_;
	PrintSettings* _tmp4_;
	PrintSettings* _tmp5_;
	Measurement _tmp6_ = {0};
	MeasurementUnit _tmp7_;
	Measurement constrained_width = {0};
	PrintSettings* _tmp8_;
	PrintSettings* _tmp9_;
	Measurement _tmp10_ = {0};
	Measurement _tmp11_;
	PrintSettings* _tmp12_;
	PrintSettings* _tmp13_;
	gboolean _tmp14_;
	Measurement _tmp23_;
	PrintSettings* _tmp24_;
	PrintSettings* _tmp25_;
	Measurement _tmp26_ = {0};
	PrintSettings* _tmp27_;
	PrintSettings* _tmp28_;
	PrintSettings* _tmp29_;
	PrintSettings* _tmp30_;
	PrintSettings* _tmp31_;
	PrintSettings* _tmp32_;
	PrintSettings* _tmp33_;
	PrintSettings* _tmp34_;
	PrintSettings* _tmp35_;
	PrintSettings* _tmp36_;
	PrintSettings* _tmp37_;
	PrintSettings* _tmp38_;
	PrintSettings* _tmp39_;
	PrintSettings* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
#line 509 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 509 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_JOB (job));
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_job_get_local_settings (job);
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_;
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_content_width (_tmp1_, &_tmp2_);
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = print_job_get_local_settings (job);
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_content_height (_tmp5_, &_tmp6_);
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = _tmp6_.unit;
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_assert (_tmp3_ == _tmp7_, "job.get_local_settings().get_content_width().unit ==             job.get_local_settings().get_content_height().unit");
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp5_);
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp1_);
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = print_job_get_local_settings (job);
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_;
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_content_width (_tmp9_, &_tmp10_);
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = _tmp10_;
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp9_);
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	constrained_width = _tmp11_;
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = print_job_get_local_settings (job);
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = _tmp12_;
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = print_settings_is_match_aspect_ratio_enabled (_tmp13_);
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp13_);
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp14_) {
#line 3754 "Printing.c"
		PrintSettings* _tmp15_;
		PrintSettings* _tmp16_;
		Measurement _tmp17_ = {0};
		gdouble _tmp18_;
		PrintSettings* _tmp19_;
		PrintSettings* _tmp20_;
		Measurement _tmp21_ = {0};
		MeasurementUnit _tmp22_;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp15_ = print_job_get_local_settings (job);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp16_ = _tmp15_;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_get_content_height (_tmp16_, &_tmp17_);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = _tmp17_.value;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp19_ = print_job_get_local_settings (job);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp20_ = _tmp19_;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_get_content_height (_tmp20_, &_tmp21_);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = _tmp21_.unit;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&constrained_width, _tmp18_ * print_job_get_source_aspect_ratio (job), _tmp22_);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_print_settings_unref0 (_tmp20_);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_print_settings_unref0 (_tmp16_);
#line 3785 "Printing.c"
	}
#line 517 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp23_ = constrained_width;
#line 517 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_width (self, &_tmp23_);
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp24_ = print_job_get_local_settings (job);
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp25_ = _tmp24_;
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_content_height (_tmp25_, &_tmp26_);
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_height (self, &_tmp26_);
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp25_);
#line 519 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = print_job_get_local_settings (job);
#line 519 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp28_ = _tmp27_;
#line 519 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_layout (self, print_settings_get_content_layout (_tmp28_));
#line 519 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp28_);
#line 520 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp29_ = print_job_get_local_settings (job);
#line 520 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp30_ = _tmp29_;
#line 520 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_ppi (self, print_settings_get_content_ppi (_tmp30_));
#line 520 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp30_);
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp31_ = print_job_get_local_settings (job);
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp32_ = _tmp31_;
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_image_per_page_selection (self, print_settings_get_image_per_page_selection (_tmp32_));
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp32_);
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp33_ = print_job_get_local_settings (job);
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp34_ = _tmp33_;
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_size_selection (self, print_settings_get_size_selection (_tmp34_));
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp34_);
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp35_ = print_job_get_local_settings (job);
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp36_ = _tmp35_;
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_match_aspect_ratio_enabled (self, print_settings_is_match_aspect_ratio_enabled (_tmp36_));
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp36_);
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp37_ = print_job_get_local_settings (job);
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp38_ = _tmp37_;
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_print_titles_enabled (self, print_settings_is_print_titles_enabled (_tmp38_));
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp38_);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp39_ = print_job_get_local_settings (job);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp40_ = _tmp39_;
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp41_ = print_settings_get_print_titles_font (_tmp40_);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp42_ = _tmp41_;
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_print_titles_font (self, _tmp42_);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp42_);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp40_);
#line 3863 "Printing.c"
}


static void
custom_print_tab_on_radio_group_click (CustomPrintTab* self,
                                       GtkButton* b)
{
	GtkRadioButton* sender = NULL;
	GtkRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
#line 528 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 528 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_BUTTON (b));
#line 529 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, gtk_radio_button_get_type (), GtkRadioButton));
#line 529 "/home/jens/Source/shotwell/src/Printing.vala"
	sender = _tmp0_;
#line 531 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = sender;
#line 531 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->standard_size_radio;
#line 531 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ == _tmp2_) {
#line 3889 "Printing.c"
		GtkComboBoxText* _tmp3_;
#line 532 "/home/jens/Source/shotwell/src/Printing.vala"
		custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_STANDARD_SIZE);
#line 533 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = self->priv->standard_sizes_combo;
#line 533 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
#line 3897 "Printing.c"
	} else {
		GtkRadioButton* _tmp4_;
		GtkRadioButton* _tmp5_;
#line 534 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = sender;
#line 534 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = self->priv->custom_size_radio;
#line 534 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp4_ == _tmp5_) {
#line 3907 "Printing.c"
			GtkEntry* _tmp6_;
#line 535 "/home/jens/Source/shotwell/src/Printing.vala"
			custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_CUSTOM_SIZE);
#line 536 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp6_ = self->priv->custom_height_entry;
#line 536 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
#line 3915 "Printing.c"
		} else {
			GtkRadioButton* _tmp7_;
			GtkRadioButton* _tmp8_;
#line 537 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp7_ = sender;
#line 537 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = self->priv->image_per_page_radio;
#line 537 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp7_ == _tmp8_) {
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
				custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_IMAGE_PER_PAGE);
#line 3927 "Printing.c"
			}
		}
	}
#line 528 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (sender);
#line 3933 "Printing.c"
}


static void
custom_print_tab_on_units_combo_changed (CustomPrintTab* self)
{
	GtkEntry* _tmp0_;
	Measurement _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkEntry* _tmp4_;
	Measurement _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
#line 542 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_height_entry;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->local_content_height;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = custom_print_tab_format_measurement_as (self, &_tmp1_, custom_print_tab_get_user_unit_choice (self));
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp0_, _tmp3_);
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp3_);
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = self->priv->custom_width_entry;
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = self->priv->local_content_width;
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = custom_print_tab_format_measurement_as (self, &_tmp5_, custom_print_tab_get_user_unit_choice (self));
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = _tmp6_;
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp4_, _tmp7_);
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp7_);
#line 3974 "Printing.c"
}


static void
custom_print_tab_set_content_layout_control_state (CustomPrintTab* self,
                                                   ContentLayout layout)
{
#line 549 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (layout) {
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 3988 "Printing.c"
		{
			GtkComboBoxText* _tmp0_;
			GtkComboBoxText* _tmp1_;
			GtkEntry* _tmp2_;
			GtkEntry* _tmp3_;
			GtkCheckButton* _tmp4_;
			GtkComboBoxText* _tmp5_;
#line 552 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp0_ = self->priv->standard_sizes_combo;
#line 552 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 553 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp1_ = self->priv->units_combo;
#line 553 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 554 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp2_ = self->priv->custom_width_entry;
#line 554 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 555 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp3_ = self->priv->custom_height_entry;
#line 555 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 556 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp4_ = self->priv->aspect_ratio_check;
#line 556 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 557 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5_ = self->priv->image_per_page_combo;
#line 557 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 558 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4022 "Printing.c"
		}
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 4026 "Printing.c"
		{
			GtkComboBoxText* _tmp6_;
			GtkComboBoxText* _tmp7_;
			GtkEntry* _tmp8_;
			GtkEntry* _tmp9_;
			GtkCheckButton* _tmp10_;
			GtkComboBoxText* _tmp11_;
#line 561 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp6_ = self->priv->standard_sizes_combo;
#line 561 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 562 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp7_ = self->priv->units_combo;
#line 562 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 563 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = self->priv->custom_width_entry;
#line 563 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 564 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp9_ = self->priv->custom_height_entry;
#line 564 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 565 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp10_ = self->priv->aspect_ratio_check;
#line 565 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 566 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp11_ = self->priv->image_per_page_combo;
#line 566 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 567 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4060 "Printing.c"
		}
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 4064 "Printing.c"
		{
			GtkComboBoxText* _tmp12_;
			GtkComboBoxText* _tmp13_;
			GtkEntry* _tmp14_;
			GtkEntry* _tmp15_;
			GtkCheckButton* _tmp16_;
			GtkComboBoxText* _tmp17_;
#line 570 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp12_ = self->priv->standard_sizes_combo;
#line 570 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 571 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp13_ = self->priv->units_combo;
#line 571 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 572 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp14_ = self->priv->custom_width_entry;
#line 572 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 573 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp15_ = self->priv->custom_height_entry;
#line 573 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 574 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp16_ = self->priv->aspect_ratio_check;
#line 574 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 575 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp17_ = self->priv->image_per_page_combo;
#line 575 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 576 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4098 "Printing.c"
		}
		default:
		{
#line 579 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:579: unknown ContentLayout enumeration value");
#line 4104 "Printing.c"
		}
	}
}


static gboolean
custom_print_tab_standard_sizes_combo_separator_func (GtkTreeModel* model,
                                                      GtkTreeIter* iter)
{
	gboolean result = FALSE;
	GValue val = {0};
	GtkTreeIter _tmp0_;
	GValue _tmp1_ = {0};
	const gchar* _tmp2_;
#line 583 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (model), FALSE);
#line 583 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 586 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *iter;
#line 586 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_tree_model_get_value (model, &_tmp0_, 0, &_tmp1_);
#line 586 "/home/jens/Source/shotwell/src/Printing.vala"
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
#line 586 "/home/jens/Source/shotwell/src/Printing.vala"
	val = _tmp1_;
#line 588 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = g_value_get_string (&val);
#line 588 "/home/jens/Source/shotwell/src/Printing.vala"
	result = g_strcmp0 (_tmp2_, "-") == 0;
#line 588 "/home/jens/Source/shotwell/src/Printing.vala"
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
#line 588 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4139 "Printing.c"
}


static void
custom_print_tab_set_content_layout (CustomPrintTab* self,
                                     ContentLayout content_layout)
{
#line 591 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 592 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_layout_control_state (self, content_layout);
#line 593 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (content_layout) {
#line 593 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 4155 "Printing.c"
		{
			GtkRadioButton* _tmp0_;
#line 595 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp0_ = self->priv->standard_size_radio;
#line 595 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 596 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4164 "Printing.c"
		}
#line 593 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 4168 "Printing.c"
		{
			GtkRadioButton* _tmp1_;
#line 599 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp1_ = self->priv->custom_size_radio;
#line 599 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 600 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4177 "Printing.c"
		}
#line 593 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 4181 "Printing.c"
		{
			GtkRadioButton* _tmp2_;
#line 603 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp2_ = self->priv->image_per_page_radio;
#line 603 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 604 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4190 "Printing.c"
		}
		default:
		{
#line 607 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:607: unknown ContentLayout enumeration value");
#line 4196 "Printing.c"
		}
	}
}


static ContentLayout
custom_print_tab_get_content_layout (CustomPrintTab* self)
{
	ContentLayout result = 0;
	GtkRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
#line 611 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 612 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->standard_size_radio;
#line 612 "/home/jens/Source/shotwell/src/Printing.vala"
	if (gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton))) {
#line 613 "/home/jens/Source/shotwell/src/Printing.vala"
		result = CONTENT_LAYOUT_STANDARD_SIZE;
#line 613 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 4219 "Printing.c"
	}
#line 614 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->custom_size_radio;
#line 614 "/home/jens/Source/shotwell/src/Printing.vala"
	if (gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_toggle_button_get_type (), GtkToggleButton))) {
#line 615 "/home/jens/Source/shotwell/src/Printing.vala"
		result = CONTENT_LAYOUT_CUSTOM_SIZE;
#line 615 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 4229 "Printing.c"
	}
#line 616 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->image_per_page_radio;
#line 616 "/home/jens/Source/shotwell/src/Printing.vala"
	if (gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_toggle_button_get_type (), GtkToggleButton))) {
#line 617 "/home/jens/Source/shotwell/src/Printing.vala"
		result = CONTENT_LAYOUT_IMAGE_PER_PAGE;
#line 617 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 4239 "Printing.c"
	}
#line 619 "/home/jens/Source/shotwell/src/Printing.vala"
	g_error ("Printing.vala:619: inconsistent content layout radio button group stat" \
"e");
#line 4243 "Printing.c"
}


static void
custom_print_tab_set_content_width (CustomPrintTab* self,
                                    Measurement* content_width)
{
	Measurement _tmp0_;
	MeasurementUnit _tmp1_;
	Measurement _tmp2_;
	MeasurementUnit _tmp3_;
	Measurement _tmp13_;
	GtkEntry* _tmp14_;
	Measurement _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
#line 622 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 622 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (content_width != NULL);
#line 623 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *content_width;
#line 623 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_.unit;
#line 623 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->local_content_height;
#line 623 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 623 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ != _tmp3_) {
#line 4274 "Printing.c"
		Measurement _tmp4_;
		MeasurementUnit _tmp5_;
		Measurement _tmp6_;
		MeasurementUnit _tmp7_;
		Measurement _tmp8_ = {0};
		GtkEntry* _tmp9_;
		Measurement _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
#line 624 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *content_width;
#line 624 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = _tmp4_.unit;
#line 624 "/home/jens/Source/shotwell/src/Printing.vala"
		custom_print_tab_set_user_unit_choice (self, _tmp5_);
#line 625 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = *content_width;
#line 625 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7_ = _tmp6_.unit;
#line 625 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (&self->priv->local_content_height, _tmp7_, &_tmp8_);
#line 625 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->local_content_height = _tmp8_;
#line 626 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp9_ = self->priv->custom_height_entry;
#line 626 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp10_ = self->priv->local_content_height;
#line 626 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp11_ = custom_print_tab_format_measurement (self, &_tmp10_);
#line 626 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp12_ = _tmp11_;
#line 626 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp9_, _tmp12_);
#line 626 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp12_);
#line 4310 "Printing.c"
	}
#line 628 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = *content_width;
#line 628 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_width = _tmp13_;
#line 629 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = self->priv->custom_width_entry;
#line 629 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = *content_width;
#line 629 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = custom_print_tab_format_measurement (self, &_tmp15_);
#line 629 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _tmp16_;
#line 629 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp14_, _tmp17_);
#line 629 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp17_);
#line 4328 "Printing.c"
}


static void
custom_print_tab_get_content_width (CustomPrintTab* self,
                                    Measurement* result)
{
	Measurement _tmp0_;
#line 632 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 633 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->local_content_width;
#line 633 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp0_;
#line 633 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 4345 "Printing.c"
}


static void
custom_print_tab_set_content_height (CustomPrintTab* self,
                                     Measurement* content_height)
{
	Measurement _tmp0_;
	MeasurementUnit _tmp1_;
	Measurement _tmp2_;
	MeasurementUnit _tmp3_;
	Measurement _tmp13_;
	GtkEntry* _tmp14_;
	Measurement _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
#line 636 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 636 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (content_height != NULL);
#line 637 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *content_height;
#line 637 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_.unit;
#line 637 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->local_content_width;
#line 637 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 637 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ != _tmp3_) {
#line 4376 "Printing.c"
		Measurement _tmp4_;
		MeasurementUnit _tmp5_;
		Measurement _tmp6_;
		MeasurementUnit _tmp7_;
		Measurement _tmp8_ = {0};
		GtkEntry* _tmp9_;
		Measurement _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
#line 638 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *content_height;
#line 638 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = _tmp4_.unit;
#line 638 "/home/jens/Source/shotwell/src/Printing.vala"
		custom_print_tab_set_user_unit_choice (self, _tmp5_);
#line 639 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = *content_height;
#line 639 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7_ = _tmp6_.unit;
#line 639 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (&self->priv->local_content_width, _tmp7_, &_tmp8_);
#line 639 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->local_content_width = _tmp8_;
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp9_ = self->priv->custom_width_entry;
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp10_ = self->priv->local_content_width;
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp11_ = custom_print_tab_format_measurement (self, &_tmp10_);
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp12_ = _tmp11_;
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp9_, _tmp12_);
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp12_);
#line 4412 "Printing.c"
	}
#line 642 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = *content_height;
#line 642 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_height = _tmp13_;
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = self->priv->custom_height_entry;
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = *content_height;
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = custom_print_tab_format_measurement (self, &_tmp15_);
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _tmp16_;
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp14_, _tmp17_);
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp17_);
#line 4430 "Printing.c"
}


static void
custom_print_tab_get_content_height (CustomPrintTab* self,
                                     Measurement* result)
{
	Measurement _tmp0_;
#line 646 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 647 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->local_content_height;
#line 647 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp0_;
#line 647 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 4447 "Printing.c"
}


static void
custom_print_tab_set_content_ppi (CustomPrintTab* self,
                                  gint content_ppi)
{
	GtkEntry* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 650 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 651 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_ppi = CLAMP (content_ppi, PRINT_SETTINGS_MIN_CONTENT_PPI, PRINT_SETTINGS_MAX_CONTENT_PPI);
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->ppi_entry;
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->local_content_ppi;
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = g_strdup_printf ("%d", _tmp1_);
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_;
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp0_, _tmp3_);
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp3_);
#line 4475 "Printing.c"
}


static gint
custom_print_tab_get_content_ppi (CustomPrintTab* self)
{
	gint result = 0;
	gint _tmp0_;
#line 657 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 658 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->local_content_ppi;
#line 658 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 658 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4492 "Printing.c"
}


static void
custom_print_tab_set_image_per_page_selection (CustomPrintTab* self,
                                               gint image_per_page)
{
	GtkComboBoxText* _tmp0_;
#line 661 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 662 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->image_per_page_combo;
#line 662 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox), image_per_page);
#line 4507 "Printing.c"
}


static gint
custom_print_tab_get_image_per_page_selection (CustomPrintTab* self)
{
	gint result = 0;
	GtkComboBoxText* _tmp0_;
#line 665 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 666 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->image_per_page_combo;
#line 666 "/home/jens/Source/shotwell/src/Printing.vala"
	result = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox));
#line 666 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4524 "Printing.c"
}


static void
custom_print_tab_set_size_selection (CustomPrintTab* self,
                                     gint size_selection)
{
	GtkComboBoxText* _tmp0_;
#line 669 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 670 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->standard_sizes_combo;
#line 670 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox), size_selection);
#line 4539 "Printing.c"
}


static gint
custom_print_tab_get_size_selection (CustomPrintTab* self)
{
	gint result = 0;
	GtkComboBoxText* _tmp0_;
#line 673 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 674 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->standard_sizes_combo;
#line 674 "/home/jens/Source/shotwell/src/Printing.vala"
	result = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox));
#line 674 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4556 "Printing.c"
}


static void
custom_print_tab_set_match_aspect_ratio_enabled (CustomPrintTab* self,
                                                 gboolean enable_state)
{
	GtkCheckButton* _tmp0_;
#line 677 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 678 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->aspect_ratio_check;
#line 678 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), enable_state);
#line 4571 "Printing.c"
}


static void
custom_print_tab_set_print_titles_enabled (CustomPrintTab* self,
                                           gboolean print_titles)
{
	GtkCheckButton* _tmp0_;
#line 681 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 682 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->title_print_check;
#line 682 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), print_titles);
#line 4586 "Printing.c"
}


static void
custom_print_tab_set_print_titles_font (CustomPrintTab* self,
                                        const gchar* fontname)
{
	GtkFontButton* _tmp0_;
#line 685 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 685 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (fontname != NULL);
#line 686 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->title_print_font;
#line 686 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_font_button_set_font_name (_tmp0_, fontname);
#line 4603 "Printing.c"
}


static gboolean
custom_print_tab_is_match_aspect_ratio_enabled (CustomPrintTab* self)
{
	gboolean result = FALSE;
	GtkCheckButton* _tmp0_;
#line 690 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 691 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->aspect_ratio_check;
#line 691 "/home/jens/Source/shotwell/src/Printing.vala"
	result = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 691 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4620 "Printing.c"
}


static gboolean
custom_print_tab_is_print_titles_enabled (CustomPrintTab* self)
{
	gboolean result = FALSE;
	GtkCheckButton* _tmp0_;
#line 694 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 695 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->title_print_check;
#line 695 "/home/jens/Source/shotwell/src/Printing.vala"
	result = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 695 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4637 "Printing.c"
}


static gchar*
custom_print_tab_get_print_titles_font (CustomPrintTab* self)
{
	gchar* result = NULL;
	GtkFontButton* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 698 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 699 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->title_print_font;
#line 699 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_font_button_get_font_name (_tmp0_);
#line 699 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 699 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp2_;
#line 699 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4660 "Printing.c"
}


PrintJob*
custom_print_tab_get_source_job (CustomPrintTab* self)
{
	PrintJob* result = NULL;
	PrintJob* _tmp0_;
	PrintJob* _tmp1_;
#line 702 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 703 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->source_job;
#line 703 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 703 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 703 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4680 "Printing.c"
}


PrintSettings*
custom_print_tab_get_local_settings (CustomPrintTab* self)
{
	PrintSettings* result = NULL;
	PrintSettings* _result_ = NULL;
	PrintSettings* _tmp0_;
	Measurement _tmp1_ = {0};
	Measurement _tmp2_ = {0};
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 706 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 707 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_settings_new ();
#line 707 "/home/jens/Source/shotwell/src/Printing.vala"
	_result_ = _tmp0_;
#line 709 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_get_content_width (self, &_tmp1_);
#line 709 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_content_width (_result_, &_tmp1_);
#line 710 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_get_content_height (self, &_tmp2_);
#line 710 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_content_height (_result_, &_tmp2_);
#line 711 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_content_layout (_result_, custom_print_tab_get_content_layout (self));
#line 712 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_content_ppi (_result_, custom_print_tab_get_content_ppi (self));
#line 713 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_image_per_page_selection (_result_, custom_print_tab_get_image_per_page_selection (self));
#line 714 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_size_selection (_result_, custom_print_tab_get_size_selection (self));
#line 715 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_match_aspect_ratio_enabled (_result_, custom_print_tab_is_match_aspect_ratio_enabled (self));
#line 716 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_print_titles_enabled (_result_, custom_print_tab_is_print_titles_enabled (self));
#line 717 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_get_print_titles_font (self);
#line 717 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_;
#line 717 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_print_titles_font (_result_, _tmp4_);
#line 717 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp4_);
#line 719 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _result_;
#line 719 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4732 "Printing.c"
}


static void
custom_print_tab_class_init (CustomPrintTabClass * klass)
{
	gint CustomPrintTab_private_offset;
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_parent_class = g_type_class_peek_parent (klass);
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	g_type_class_add_private (klass, sizeof (CustomPrintTabPrivate));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	G_OBJECT_CLASS (klass)->finalize = custom_print_tab_finalize;
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	CustomPrintTab_private_offset = g_type_class_get_instance_private_offset (klass);
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Shotwell/ui/printing_widget.ui");
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "standard_size_radio", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, standard_size_radio));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_size_radio", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, custom_size_radio));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_per_page_radio", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, image_per_page_radio));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_per_page_combo", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, image_per_page_combo));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "standard_sizes_combo", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, standard_sizes_combo));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "units_combo", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, units_combo));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_width_entry", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, custom_width_entry));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_height_entry", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, custom_height_entry));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "ppi_entry", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, ppi_entry));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "aspect_ratio_check", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, aspect_ratio_check));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_print_check", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, title_print_check));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_print_font", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, title_print_font));
#line 4774 "Printing.c"
}


static void
custom_print_tab_instance_init (CustomPrintTab * self)
{
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv = CUSTOM_PRINT_TAB_GET_PRIVATE (self);
#line 298 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&self->priv->local_content_width, 5.0, MEASUREMENT_UNIT_INCHES);
#line 299 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&self->priv->local_content_height, 5.0, MEASUREMENT_UNIT_INCHES);
#line 301 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = FALSE;
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 4791 "Printing.c"
}


static void
custom_print_tab_finalize (GObject * obj)
{
	CustomPrintTab * self;
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab);
#line 274 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->standard_size_radio);
#line 276 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_size_radio);
#line 278 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->image_per_page_radio);
#line 280 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->image_per_page_combo);
#line 282 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->standard_sizes_combo);
#line 284 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->units_combo);
#line 286 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_width_entry);
#line 288 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_height_entry);
#line 290 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->ppi_entry);
#line 292 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->aspect_ratio_check);
#line 294 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->title_print_check);
#line 296 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->title_print_font);
#line 302 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->source_job);
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	G_OBJECT_CLASS (custom_print_tab_parent_class)->finalize (obj);
#line 4829 "Printing.c"
}


GType
custom_print_tab_get_type (void)
{
	static volatile gsize custom_print_tab_type_id__volatile = 0;
	if (g_once_init_enter (&custom_print_tab_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CustomPrintTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) custom_print_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CustomPrintTab), 0, (GInstanceInitFunc) custom_print_tab_instance_init, NULL };
		GType custom_print_tab_type_id;
		custom_print_tab_type_id = g_type_register_static (gtk_box_get_type (), "CustomPrintTab", &g_define_type_info, 0);
		g_once_init_leave (&custom_print_tab_type_id__volatile, custom_print_tab_type_id);
	}
	return custom_print_tab_type_id__volatile;
}


PrintJob*
print_job_construct (GType object_type,
                     GeeCollection* to_print)
{
	PrintJob * self = NULL;
	PrintManager* _tmp0_;
	PrintManager* _tmp1_;
	PrintSettings* _tmp2_;
	GeeArrayList* _tmp3_;
	gdouble photo_aspect_ratio = 0.0;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	Photo* _tmp6_;
	Dimensions _tmp7_ = {0};
	gdouble _tmp8_;
	gdouble _tmp9_;
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (to_print), NULL);
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (PrintJob*) g_object_new (object_type, NULL);
#line 728 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_manager_get_instance ();
#line 728 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_;
#line 728 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = print_manager_get_global_settings (_tmp1_);
#line 728 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 728 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->settings = _tmp2_;
#line 728 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_manager_unref0 (_tmp1_);
#line 729 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->photos;
#line 729 "/home/jens/Source/shotwell/src/Printing.vala"
	gee_array_list_add_all (_tmp3_, to_print);
#line 731 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_embed_page_setup (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_print_operation_get_type (), GtkPrintOperation), TRUE);
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = self->priv->photos;
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = (Photo*) _tmp5_;
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp7_);
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = dimensions_get_aspect_ratio (&_tmp7_);
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp6_);
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	photo_aspect_ratio = _tmp8_;
#line 733 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = photo_aspect_ratio;
#line 733 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp9_ < 1.0) {
#line 4903 "Printing.c"
		gdouble _tmp10_;
#line 734 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp10_ = photo_aspect_ratio;
#line 734 "/home/jens/Source/shotwell/src/Printing.vala"
		photo_aspect_ratio = 1.0 / _tmp10_;
#line 4909 "Printing.c"
	}
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 4913 "Printing.c"
}


PrintJob*
print_job_new (GeeCollection* to_print)
{
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	return print_job_construct (TYPE_PRINT_JOB, to_print);
#line 4922 "Printing.c"
}


GeeList*
print_job_get_photos (PrintJob* self)
{
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
#line 737 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (self), NULL);
#line 738 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->photos;
#line 738 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList));
#line 738 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 738 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4942 "Printing.c"
}


Photo*
print_job_get_source_photo (PrintJob* self)
{
	Photo* result = NULL;
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
#line 741 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (self), NULL);
#line 742 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->photos;
#line 742 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 742 "/home/jens/Source/shotwell/src/Printing.vala"
	result = (Photo*) _tmp1_;
#line 742 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4962 "Printing.c"
}


gdouble
print_job_get_source_aspect_ratio (PrintJob* self)
{
	gdouble result = 0.0;
	gdouble aspect_ratio = 0.0;
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	Photo* _tmp2_;
	Dimensions _tmp3_ = {0};
	gdouble _tmp4_;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_;
#line 745 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (self), 0.0);
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->photos;
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = (Photo*) _tmp1_;
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp3_);
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = dimensions_get_aspect_ratio (&_tmp3_);
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp2_);
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	aspect_ratio = _tmp4_;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = aspect_ratio;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp6_ < 1.0) {
#line 4998 "Printing.c"
		gdouble _tmp7_;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7_ = aspect_ratio;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = 1.0 / _tmp7_;
#line 5004 "Printing.c"
	} else {
		gdouble _tmp8_;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp8_ = aspect_ratio;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = _tmp8_;
#line 5011 "Printing.c"
	}
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp5_;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 5017 "Printing.c"
}


static gpointer
_print_settings_ref0 (gpointer self)
{
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? print_settings_ref (self) : NULL;
#line 5026 "Printing.c"
}


PrintSettings*
print_job_get_local_settings (PrintJob* self)
{
	PrintSettings* result = NULL;
	PrintSettings* _tmp0_;
	PrintSettings* _tmp1_;
#line 750 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (self), NULL);
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->settings;
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _print_settings_ref0 (_tmp0_);
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 5046 "Printing.c"
}


void
print_job_set_local_settings (PrintJob* self,
                              PrintSettings* settings)
{
	PrintSettings* _tmp0_;
#line 754 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_JOB (self));
#line 754 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (settings));
#line 755 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = _print_settings_ref0 (settings);
#line 755 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 755 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->settings = _tmp0_;
#line 5065 "Printing.c"
}


static void
print_job_class_init (PrintJobClass * klass)
{
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	print_job_parent_class = g_type_class_peek_parent (klass);
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	g_type_class_add_private (klass, sizeof (PrintJobPrivate));
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	G_OBJECT_CLASS (klass)->finalize = print_job_finalize;
#line 5078 "Printing.c"
}


static void
print_job_instance_init (PrintJob * self)
{
	GeeArrayList* _tmp0_;
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv = PRINT_JOB_GET_PRIVATE (self);
#line 725 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = gee_array_list_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 725 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->photos = _tmp0_;
#line 5092 "Printing.c"
}


static void
print_job_finalize (GObject * obj)
{
	PrintJob * self;
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_JOB, PrintJob);
#line 724 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 725 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->photos);
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	G_OBJECT_CLASS (print_job_parent_class)->finalize (obj);
#line 5108 "Printing.c"
}


GType
print_job_get_type (void)
{
	static volatile gsize print_job_type_id__volatile = 0;
	if (g_once_init_enter (&print_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PrintJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintJob), 0, (GInstanceInitFunc) print_job_instance_init, NULL };
		GType print_job_type_id;
		print_job_type_id = g_type_register_static (gtk_print_operation_get_type (), "PrintJob", &g_define_type_info, 0);
		g_once_init_leave (&print_job_type_id__volatile, print_job_type_id);
	}
	return print_job_type_id__volatile;
}


StandardPrintSize*
standard_print_size_construct (GType object_type,
                               const gchar* name,
                               Measurement* width,
                               Measurement* height)
{
	StandardPrintSize* self = NULL;
	gchar* _tmp0_;
	Measurement _tmp1_;
	Measurement _tmp2_;
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (width != NULL, NULL);
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (height != NULL, NULL);
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (StandardPrintSize*) g_type_create_instance (object_type);
#line 761 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_strdup (name);
#line 761 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->name);
#line 761 "/home/jens/Source/shotwell/src/Printing.vala"
	self->name = _tmp0_;
#line 762 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = *width;
#line 762 "/home/jens/Source/shotwell/src/Printing.vala"
	self->width = _tmp1_;
#line 763 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = *height;
#line 763 "/home/jens/Source/shotwell/src/Printing.vala"
	self->height = _tmp2_;
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 5160 "Printing.c"
}


StandardPrintSize*
standard_print_size_new (const gchar* name,
                         Measurement* width,
                         Measurement* height)
{
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	return standard_print_size_construct (TYPE_STANDARD_PRINT_SIZE, name, width, height);
#line 5171 "Printing.c"
}


static void
value_standard_print_size_init (GValue* value)
{
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	value->data[0].v_pointer = NULL;
#line 5180 "Printing.c"
}


static void
value_standard_print_size_free_value (GValue* value)
{
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (value->data[0].v_pointer) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		standard_print_size_unref (value->data[0].v_pointer);
#line 5191 "Printing.c"
	}
}


static void
value_standard_print_size_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (src_value->data[0].v_pointer) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = standard_print_size_ref (src_value->data[0].v_pointer);
#line 5204 "Printing.c"
	} else {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5208 "Printing.c"
	}
}


static gpointer
value_standard_print_size_peek_pointer (const GValue* value)
{
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 5218 "Printing.c"
}


static gchar*
value_standard_print_size_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (collect_values[0].v_pointer) {
#line 5230 "Printing.c"
		StandardPrintSize * object;
		object = collect_values[0].v_pointer;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		if (object->parent_instance.g_class == NULL) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5237 "Printing.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5241 "Printing.c"
		}
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = standard_print_size_ref (object);
#line 5245 "Printing.c"
	} else {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 5249 "Printing.c"
	}
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 5253 "Printing.c"
}


static gchar*
value_standard_print_size_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	StandardPrintSize ** object_p;
	object_p = collect_values[0].v_pointer;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!object_p) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5269 "Printing.c"
	}
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!value->data[0].v_pointer) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = NULL;
#line 5275 "Printing.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = value->data[0].v_pointer;
#line 5279 "Printing.c"
	} else {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = standard_print_size_ref (value->data[0].v_pointer);
#line 5283 "Printing.c"
	}
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 5287 "Printing.c"
}


GParamSpec*
param_spec_standard_print_size (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecStandardPrintSize* spec;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_STANDARD_PRINT_SIZE), NULL);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	return G_PARAM_SPEC (spec);
#line 5307 "Printing.c"
}


gpointer
value_get_standard_print_size (const GValue* value)
{
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE), NULL);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 5318 "Printing.c"
}


void
value_set_standard_print_size (GValue* value,
                               gpointer v_object)
{
	StandardPrintSize * old;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE));
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STANDARD_PRINT_SIZE));
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		standard_print_size_ref (value->data[0].v_pointer);
#line 5341 "Printing.c"
	} else {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 5345 "Printing.c"
	}
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		standard_print_size_unref (old);
#line 5351 "Printing.c"
	}
}


void
value_take_standard_print_size (GValue* value,
                                gpointer v_object)
{
	StandardPrintSize * old;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE));
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STANDARD_PRINT_SIZE));
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 5373 "Printing.c"
	} else {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 5377 "Printing.c"
	}
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		standard_print_size_unref (old);
#line 5383 "Printing.c"
	}
}


static void
standard_print_size_class_init (StandardPrintSizeClass * klass)
{
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	standard_print_size_parent_class = g_type_class_peek_parent (klass);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	((StandardPrintSizeClass *) klass)->finalize = standard_print_size_finalize;
#line 5395 "Printing.c"
}


static void
standard_print_size_instance_init (StandardPrintSize * self)
{
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	self->ref_count = 1;
#line 5404 "Printing.c"
}


static void
standard_print_size_finalize (StandardPrintSize * obj)
{
	StandardPrintSize * self;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STANDARD_PRINT_SIZE, StandardPrintSize);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_handlers_destroy (self);
#line 766 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->name);
#line 5418 "Printing.c"
}


GType
standard_print_size_get_type (void)
{
	static volatile gsize standard_print_size_type_id__volatile = 0;
	if (g_once_init_enter (&standard_print_size_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_standard_print_size_init, value_standard_print_size_free_value, value_standard_print_size_copy_value, value_standard_print_size_peek_pointer, "p", value_standard_print_size_collect_value, "p", value_standard_print_size_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (StandardPrintSizeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) standard_print_size_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StandardPrintSize), 0, (GInstanceInitFunc) standard_print_size_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType standard_print_size_type_id;
		standard_print_size_type_id = g_type_register_fundamental (g_type_fundamental_next (), "StandardPrintSize", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&standard_print_size_type_id__volatile, standard_print_size_type_id);
	}
	return standard_print_size_type_id__volatile;
}


gpointer
standard_print_size_ref (gpointer instance)
{
	StandardPrintSize * self;
	self = instance;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	g_atomic_int_inc (&self->ref_count);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	return instance;
#line 5447 "Printing.c"
}


void
standard_print_size_unref (gpointer instance)
{
	StandardPrintSize * self;
	self = instance;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		STANDARD_PRINT_SIZE_GET_CLASS (self)->finalize (self);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5462 "Printing.c"
	}
}


static PrintManager*
print_manager_construct (GType object_type)
{
	PrintManager* self = NULL;
	GtkPageSetup* _tmp0_;
	PrintSettings* _tmp1_;
#line 783 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (PrintManager*) g_type_create_instance (object_type);
#line 784 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = gtk_page_setup_new ();
#line 784 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->user_page_setup);
#line 784 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->user_page_setup = _tmp0_;
#line 785 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = print_settings_new ();
#line 785 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 785 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->settings = _tmp1_;
#line 783 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 5489 "Printing.c"
}


static PrintManager*
print_manager_new (void)
{
#line 783 "/home/jens/Source/shotwell/src/Printing.vala"
	return print_manager_construct (TYPE_PRINT_MANAGER);
#line 5498 "Printing.c"
}


static void
_vala_array_add112 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5514 "Printing.c"
	}
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5520 "Printing.c"
}


static void
_vala_array_add113 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5536 "Printing.c"
	}
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5542 "Printing.c"
}


static void
_vala_array_add114 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5558 "Printing.c"
	}
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5564 "Printing.c"
}


static void
_vala_array_add115 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5580 "Printing.c"
	}
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5586 "Printing.c"
}


static void
_vala_array_add116 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5602 "Printing.c"
	}
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5608 "Printing.c"
}


static void
_vala_array_add117 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5624 "Printing.c"
	}
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5630 "Printing.c"
}


static void
_vala_array_add118 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5646 "Printing.c"
	}
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5652 "Printing.c"
}


static void
_vala_array_add119 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5668 "Printing.c"
	}
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5674 "Printing.c"
}


static void
_vala_array_add120 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5690 "Printing.c"
	}
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5696 "Printing.c"
}


static void
_vala_array_add121 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5712 "Printing.c"
	}
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5718 "Printing.c"
}


static void
_vala_array_add122 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5734 "Printing.c"
	}
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5740 "Printing.c"
}


static void
_vala_array_add123 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5756 "Printing.c"
	}
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5762 "Printing.c"
}


static void
_vala_array_add124 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5778 "Printing.c"
	}
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5784 "Printing.c"
}


static void
_vala_array_add125 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5800 "Printing.c"
	}
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5806 "Printing.c"
}


static void
_vala_array_add126 (StandardPrintSize** * array,
                    int* length,
                    int* size,
                    StandardPrintSize* value)
{
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5822 "Printing.c"
	}
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5828 "Printing.c"
}


StandardPrintSize**
print_manager_get_standard_sizes (PrintManager* self,
                                  int* result_length1)
{
	StandardPrintSize** result = NULL;
	StandardPrintSize** _tmp0_;
	gint _tmp0__length1;
	StandardPrintSize** _tmp62_;
	gint _tmp62__length1;
	StandardPrintSize** _tmp63_;
	gint _tmp63__length1;
#line 788 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_MANAGER (self), NULL);
#line 789 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->standard_sizes;
#line 789 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0__length1 = self->priv->standard_sizes_length1;
#line 789 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp0_ == NULL) {
#line 5851 "Printing.c"
		StandardPrintSize** _tmp1_;
		StandardPrintSize** _tmp2_;
		gint _tmp2__length1;
		Measurement _tmp3_ = {0};
		Measurement _tmp4_ = {0};
		StandardPrintSize* _tmp5_;
		StandardPrintSize** _tmp6_;
		gint _tmp6__length1;
		Measurement _tmp7_ = {0};
		Measurement _tmp8_ = {0};
		StandardPrintSize* _tmp9_;
		StandardPrintSize** _tmp10_;
		gint _tmp10__length1;
		Measurement _tmp11_ = {0};
		Measurement _tmp12_ = {0};
		StandardPrintSize* _tmp13_;
		StandardPrintSize** _tmp14_;
		gint _tmp14__length1;
		Measurement _tmp15_ = {0};
		Measurement _tmp16_ = {0};
		StandardPrintSize* _tmp17_;
		StandardPrintSize** _tmp18_;
		gint _tmp18__length1;
		Measurement _tmp19_ = {0};
		Measurement _tmp20_ = {0};
		StandardPrintSize* _tmp21_;
		StandardPrintSize** _tmp22_;
		gint _tmp22__length1;
		Measurement _tmp23_ = {0};
		Measurement _tmp24_ = {0};
		StandardPrintSize* _tmp25_;
		StandardPrintSize** _tmp26_;
		gint _tmp26__length1;
		Measurement _tmp27_ = {0};
		Measurement _tmp28_ = {0};
		StandardPrintSize* _tmp29_;
		StandardPrintSize** _tmp30_;
		gint _tmp30__length1;
		Measurement _tmp31_ = {0};
		Measurement _tmp32_ = {0};
		StandardPrintSize* _tmp33_;
		StandardPrintSize** _tmp34_;
		gint _tmp34__length1;
		Measurement _tmp35_ = {0};
		Measurement _tmp36_ = {0};
		StandardPrintSize* _tmp37_;
		StandardPrintSize** _tmp38_;
		gint _tmp38__length1;
		Measurement _tmp39_ = {0};
		Measurement _tmp40_ = {0};
		StandardPrintSize* _tmp41_;
		StandardPrintSize** _tmp42_;
		gint _tmp42__length1;
		Measurement _tmp43_ = {0};
		Measurement _tmp44_ = {0};
		StandardPrintSize* _tmp45_;
		StandardPrintSize** _tmp46_;
		gint _tmp46__length1;
		Measurement _tmp47_ = {0};
		Measurement _tmp48_ = {0};
		StandardPrintSize* _tmp49_;
		StandardPrintSize** _tmp50_;
		gint _tmp50__length1;
		Measurement _tmp51_ = {0};
		Measurement _tmp52_ = {0};
		StandardPrintSize* _tmp53_;
		StandardPrintSize** _tmp54_;
		gint _tmp54__length1;
		Measurement _tmp55_ = {0};
		Measurement _tmp56_ = {0};
		StandardPrintSize* _tmp57_;
		StandardPrintSize** _tmp58_;
		gint _tmp58__length1;
		Measurement _tmp59_ = {0};
		Measurement _tmp60_ = {0};
		StandardPrintSize* _tmp61_;
#line 790 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = g_new0 (StandardPrintSize*, 0 + 1);
#line 790 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->standard_sizes = (_vala_array_free (self->priv->standard_sizes, self->priv->standard_sizes_length1, (GDestroyNotify) standard_print_size_unref), NULL);
#line 790 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->standard_sizes = _tmp1_;
#line 790 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->standard_sizes_length1 = 0;
#line 790 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->_standard_sizes_size_ = self->priv->standard_sizes_length1;
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = self->priv->standard_sizes;
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2__length1 = self->priv->standard_sizes_length1;
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp3_, (gdouble) 3, MEASUREMENT_UNIT_INCHES);
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp4_, (gdouble) 2, MEASUREMENT_UNIT_INCHES);
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = standard_print_size_new (_ ("Wallet (2 × 3 in.)"), &_tmp3_, &_tmp4_);
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add112 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp5_);
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = self->priv->standard_sizes;
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6__length1 = self->priv->standard_sizes_length1;
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp7_, (gdouble) 5, MEASUREMENT_UNIT_INCHES);
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp8_, (gdouble) 3, MEASUREMENT_UNIT_INCHES);
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp9_ = standard_print_size_new (_ ("Notecard (3 × 5 in.)"), &_tmp7_, &_tmp8_);
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add113 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp9_);
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp10_ = self->priv->standard_sizes;
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp10__length1 = self->priv->standard_sizes_length1;
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp11_, (gdouble) 6, MEASUREMENT_UNIT_INCHES);
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp12_, (gdouble) 4, MEASUREMENT_UNIT_INCHES);
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp13_ = standard_print_size_new (_ ("4 × 6 in."), &_tmp11_, &_tmp12_);
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add114 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp13_);
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp14_ = self->priv->standard_sizes;
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp14__length1 = self->priv->standard_sizes_length1;
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp15_, (gdouble) 7, MEASUREMENT_UNIT_INCHES);
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp16_, (gdouble) 5, MEASUREMENT_UNIT_INCHES);
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17_ = standard_print_size_new (_ ("5 × 7 in."), &_tmp15_, &_tmp16_);
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add115 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp17_);
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = self->priv->standard_sizes;
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18__length1 = self->priv->standard_sizes_length1;
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp19_, (gdouble) 10, MEASUREMENT_UNIT_INCHES);
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp20_, (gdouble) 8, MEASUREMENT_UNIT_INCHES);
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = standard_print_size_new (_ ("8 × 10 in."), &_tmp19_, &_tmp20_);
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add116 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp21_);
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = self->priv->standard_sizes;
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22__length1 = self->priv->standard_sizes_length1;
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp23_, (gdouble) 14, MEASUREMENT_UNIT_INCHES);
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp24_, (gdouble) 11, MEASUREMENT_UNIT_INCHES);
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = standard_print_size_new (_ ("11 × 14 in."), &_tmp23_, &_tmp24_);
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add117 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp25_);
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = self->priv->standard_sizes;
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26__length1 = self->priv->standard_sizes_length1;
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp27_, (gdouble) 20, MEASUREMENT_UNIT_INCHES);
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp28_, (gdouble) 16, MEASUREMENT_UNIT_INCHES);
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = standard_print_size_new (_ ("16 × 20 in."), &_tmp27_, &_tmp28_);
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add118 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp29_);
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30_ = self->priv->standard_sizes;
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30__length1 = self->priv->standard_sizes_length1;
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp31_, (gdouble) 0, MEASUREMENT_UNIT_INCHES);
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp32_, (gdouble) 0, MEASUREMENT_UNIT_INCHES);
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp33_ = standard_print_size_new ("-", &_tmp31_, &_tmp32_);
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add119 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp33_);
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp34_ = self->priv->standard_sizes;
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp34__length1 = self->priv->standard_sizes_length1;
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp35_, (gdouble) 13, MEASUREMENT_UNIT_CENTIMETERS);
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp36_, (gdouble) 9, MEASUREMENT_UNIT_CENTIMETERS);
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp37_ = standard_print_size_new (_ ("Metric Wallet (9 × 13 cm)"), &_tmp35_, &_tmp36_);
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add120 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp37_);
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp38_ = self->priv->standard_sizes;
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp38__length1 = self->priv->standard_sizes_length1;
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp39_, (gdouble) 15, MEASUREMENT_UNIT_CENTIMETERS);
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp40_, (gdouble) 10, MEASUREMENT_UNIT_CENTIMETERS);
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp41_ = standard_print_size_new (_ ("Postcard (10 × 15 cm)"), &_tmp39_, &_tmp40_);
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add121 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp41_);
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp42_ = self->priv->standard_sizes;
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp42__length1 = self->priv->standard_sizes_length1;
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp43_, (gdouble) 18, MEASUREMENT_UNIT_CENTIMETERS);
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp44_, (gdouble) 13, MEASUREMENT_UNIT_CENTIMETERS);
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp45_ = standard_print_size_new (_ ("13 × 18 cm"), &_tmp43_, &_tmp44_);
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add122 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp45_);
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp46_ = self->priv->standard_sizes;
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp46__length1 = self->priv->standard_sizes_length1;
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp47_, (gdouble) 24, MEASUREMENT_UNIT_CENTIMETERS);
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp48_, (gdouble) 18, MEASUREMENT_UNIT_CENTIMETERS);
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp49_ = standard_print_size_new (_ ("18 × 24 cm"), &_tmp47_, &_tmp48_);
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add123 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp49_);
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp50_ = self->priv->standard_sizes;
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp50__length1 = self->priv->standard_sizes_length1;
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp51_, (gdouble) 30, MEASUREMENT_UNIT_CENTIMETERS);
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp52_, (gdouble) 20, MEASUREMENT_UNIT_CENTIMETERS);
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp53_ = standard_print_size_new (_ ("20 × 30 cm"), &_tmp51_, &_tmp52_);
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add124 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp53_);
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp54_ = self->priv->standard_sizes;
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp54__length1 = self->priv->standard_sizes_length1;
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp55_, (gdouble) 40, MEASUREMENT_UNIT_CENTIMETERS);
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp56_, (gdouble) 24, MEASUREMENT_UNIT_CENTIMETERS);
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp57_ = standard_print_size_new (_ ("24 × 40 cm"), &_tmp55_, &_tmp56_);
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add125 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp57_);
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp58_ = self->priv->standard_sizes;
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp58__length1 = self->priv->standard_sizes_length1;
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp59_, (gdouble) 40, MEASUREMENT_UNIT_CENTIMETERS);
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp60_, (gdouble) 30, MEASUREMENT_UNIT_CENTIMETERS);
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp61_ = standard_print_size_new (_ ("30 × 40 cm"), &_tmp59_, &_tmp60_);
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add126 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp61_);
#line 6118 "Printing.c"
	}
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp62_ = self->priv->standard_sizes;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp62__length1 = self->priv->standard_sizes_length1;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp63_ = _tmp62_;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp63__length1 = _tmp62__length1;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	if (result_length1) {
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
		*result_length1 = _tmp63__length1;
#line 6132 "Printing.c"
	}
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp63_;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 6138 "Printing.c"
}


static gpointer
_print_manager_ref0 (gpointer self)
{
#line 846 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? print_manager_ref (self) : NULL;
#line 6147 "Printing.c"
}


PrintManager*
print_manager_get_instance (void)
{
	PrintManager* result = NULL;
	PrintManager* _tmp0_;
	PrintManager* _tmp2_;
	PrintManager* _tmp3_;
#line 843 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_manager_instance;
#line 843 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp0_ == NULL) {
#line 6162 "Printing.c"
		PrintManager* _tmp1_;
#line 844 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = print_manager_new ();
#line 844 "/home/jens/Source/shotwell/src/Printing.vala"
		_print_manager_unref0 (print_manager_instance);
#line 844 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_instance = _tmp1_;
#line 6170 "Printing.c"
	}
#line 846 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = print_manager_instance;
#line 846 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _print_manager_ref0 (_tmp2_);
#line 846 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp3_;
#line 846 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 6180 "Printing.c"
}


static void
_print_manager_on_begin_print_gtk_print_operation_begin_print (GtkPrintOperation* _sender,
                                                               GtkPrintContext* context,
                                                               gpointer self)
{
#line 856 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_on_begin_print ((PrintManager*) self, _sender, context);
#line 6191 "Printing.c"
}


static void
_print_manager_on_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender,
                                                           GtkPrintContext* context,
                                                           gint page_nr,
                                                           gpointer self)
{
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_on_draw_page ((PrintManager*) self, _sender, context, page_nr);
#line 6203 "Printing.c"
}


static GObject*
_print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget (GtkPrintOperation* _sender,
                                                                                 gpointer self)
{
	GObject* result;
	result = print_manager_on_create_custom_widget ((PrintManager*) self, _sender);
#line 858 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 6215 "Printing.c"
}


static void
_print_manager_on_status_changed_gtk_print_operation_status_changed (GtkPrintOperation* _sender,
                                                                     gpointer self)
{
#line 859 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_on_status_changed ((PrintManager*) self, _sender);
#line 6225 "Printing.c"
}


void
print_manager_spool_photo (PrintManager* self,
                           GeeCollection* to_print)
{
	PrintJob* job = NULL;
	PrintJob* _tmp0_;
	Photo* _tmp1_;
	Photo* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkPageSetup* _tmp5_;
	AppWindow* _tmp6_;
	AppWindow* _tmp7_;
	GCancellable* _tmp8_;
	AppWindow* _tmp9_;
	AppWindow* _tmp10_;
	GCancellable* _tmp11_;
	ProgressDialog* _tmp12_;
	gchar* err_msg = NULL;
	ProgressDialog* _tmp21_;
	AppWindow* _tmp22_;
	AppWindow* _tmp23_;
	const gchar* _tmp24_;
	GError * _inner_error_ = NULL;
#line 849 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 849 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GEE_IS_COLLECTION (to_print));
#line 850 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_job_new (to_print);
#line 850 "/home/jens/Source/shotwell/src/Printing.vala"
	job = _tmp0_;
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_custom_tab_label (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), _ ("Image Settings"));
#line 852 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_unit (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), GTK_UNIT_INCH);
#line 853 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_n_pages (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), 1);
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = print_job_get_source_photo (job);
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _tmp1_;
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_OBJECT, DataObject));
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_;
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_job_name (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), _tmp4_);
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp4_);
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp2_);
#line 855 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = self->priv->user_page_setup;
#line 855 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_default_page_setup (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), _tmp5_);
#line 856 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "begin-print", (GCallback) _print_manager_on_begin_print_gtk_print_operation_begin_print, self);
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "draw-page", (GCallback) _print_manager_on_draw_page_gtk_print_operation_draw_page, self);
#line 858 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "create-custom-widget", (GCallback) _print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget, self);
#line 859 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "status-changed", (GCallback) _print_manager_on_status_changed_gtk_print_operation_status_changed, self);
#line 861 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = app_window_get_instance ();
#line 861 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = _tmp6_;
#line 861 "/home/jens/Source/shotwell/src/Printing.vala"
	page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PAGE_WINDOW, PageWindow));
#line 861 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp7_);
#line 863 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = g_cancellable_new ();
#line 863 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 863 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->cancellable = _tmp8_;
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = app_window_get_instance ();
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = self->priv->cancellable;
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = progress_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow), _ ("Printing…"), _tmp11_);
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	g_object_ref_sink (_tmp12_);
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->progress_dialog = _tmp12_;
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp10_);
#line 866 "/home/jens/Source/shotwell/src/Printing.vala"
	err_msg = NULL;
#line 6325 "Printing.c"
	{
		GtkPrintOperationResult _result_ = 0;
		AppWindow* _tmp13_;
		AppWindow* _tmp14_;
		GtkPrintOperationResult _tmp15_;
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp13_ = app_window_get_instance ();
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp14_ = _tmp13_;
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp15_ = gtk_print_operation_run (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_window_get_type (), GtkWindow), &_inner_error_);
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (_tmp14_);
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		_result_ = _tmp15_;
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6343 "Printing.c"
			goto __catch478_g_error;
		}
#line 870 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_result_ == GTK_PRINT_OPERATION_RESULT_APPLY) {
#line 6348 "Printing.c"
			GtkPageSetup* _tmp16_;
			GtkPageSetup* _tmp17_;
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp16_ = gtk_print_operation_get_default_page_setup (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation));
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp17_ = _g_object_ref0 (_tmp16_);
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (self->priv->user_page_setup);
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
			self->priv->user_page_setup = _tmp17_;
#line 6359 "Printing.c"
		}
	}
	goto __finally478;
	__catch478_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		e = _inner_error_;
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		_inner_error_ = NULL;
#line 873 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation));
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = e;
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp19_ = _tmp18_->message;
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp20_ = g_strdup (_tmp19_);
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (err_msg);
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
		err_msg = _tmp20_;
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_error_free0 (e);
#line 6387 "Printing.c"
	}
	__finally478:
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (err_msg);
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (job);
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		g_clear_error (&_inner_error_);
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 6402 "Printing.c"
	}
#line 877 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp21_ = self->priv->progress_dialog;
#line 877 "/home/jens/Source/shotwell/src/Printing.vala"
	progress_dialog_close (_tmp21_);
#line 878 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 878 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->progress_dialog = NULL;
#line 879 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 879 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->cancellable = NULL;
#line 881 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp22_ = app_window_get_instance ();
#line 881 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp23_ = _tmp22_;
#line 881 "/home/jens/Source/shotwell/src/Printing.vala"
	page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_PAGE_WINDOW, PageWindow));
#line 881 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp23_);
#line 883 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp24_ = err_msg;
#line 883 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp24_ != NULL) {
#line 6428 "Printing.c"
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = err_msg;
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = g_strdup_printf (_ ("Unable to print photo:\n\n%s"), _tmp25_);
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27_ = _tmp26_;
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
		app_window_error_message (_tmp27_, NULL);
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp27_);
#line 6442 "Printing.c"
	}
#line 849 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (err_msg);
#line 849 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (job);
#line 6448 "Printing.c"
}


static void
print_manager_on_begin_print (PrintManager* self,
                              GtkPrintOperation* emitting_object,
                              GtkPrintContext* job_context)
{
	PrintJob* job = NULL;
	PrintJob* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GCancellable* _tmp2_;
	GeeList* photos = NULL;
	PrintJob* _tmp5_;
	GeeList* _tmp6_;
	PrintJob* _tmp7_;
	PrintSettings* _tmp8_;
	PrintSettings* _tmp9_;
	gboolean _tmp10_;
#line 887 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 887 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_OPERATION (emitting_object));
#line 887 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_CONTEXT (job_context));
#line 888 "/home/jens/Source/shotwell/src/Printing.vala"
	g_debug ("Printing.vala:888: on_begin_print");
#line 890 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (emitting_object, TYPE_PRINT_JOB, PrintJob));
#line 890 "/home/jens/Source/shotwell/src/Printing.vala"
	job = _tmp0_;
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->cancellable;
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_ != NULL) {
#line 6484 "Printing.c"
		GCancellable* _tmp3_;
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = self->priv->cancellable;
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = g_cancellable_is_cancelled (_tmp3_);
#line 6490 "Printing.c"
	} else {
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = FALSE;
#line 6494 "Printing.c"
	}
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_) {
#line 6498 "Printing.c"
		PrintJob* _tmp4_;
#line 894 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = job;
#line 894 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_print_operation_get_type (), GtkPrintOperation));
#line 896 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (job);
#line 896 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 6508 "Printing.c"
	}
#line 899 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = job;
#line 899 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = print_job_get_photos (_tmp5_);
#line 899 "/home/jens/Source/shotwell/src/Printing.vala"
	photos = _tmp6_;
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = job;
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = print_job_get_local_settings (_tmp7_);
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_;
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = print_settings_get_content_layout (_tmp9_) == CONTENT_LAYOUT_IMAGE_PER_PAGE;
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp9_);
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp10_) {
#line 6528 "Printing.c"
		PrintLayout layout = 0;
		PrintJob* _tmp11_;
		PrintSettings* _tmp12_;
		PrintSettings* _tmp13_;
		PrintLayout _tmp14_;
		PrintJob* _tmp15_;
		GeeList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		PrintLayout _tmp19_;
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp11_ = job;
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp12_ = print_job_get_local_settings (_tmp11_);
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp13_ = _tmp12_;
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp14_ = (PrintLayout) print_settings_get_image_per_page_selection (_tmp13_);
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		_print_settings_unref0 (_tmp13_);
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		layout = _tmp14_;
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp15_ = job;
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp16_ = photos;
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_COLLECTION, GeeCollection));
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = _tmp17_;
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp19_ = layout;
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_set_n_pages (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_print_operation_get_type (), GtkPrintOperation), (gint) ceil (((gdouble) _tmp18_) / ((gdouble) print_layout_get_per_page (_tmp19_))));
#line 6563 "Printing.c"
	} else {
		PrintJob* _tmp20_;
		GeeList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
#line 904 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp20_ = job;
#line 904 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = photos;
#line 904 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
#line 904 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = _tmp22_;
#line 904 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_set_n_pages (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_print_operation_get_type (), GtkPrintOperation), _tmp23_);
#line 6579 "Printing.c"
	}
#line 907 "/home/jens/Source/shotwell/src/Printing.vala"
	spin_event_loop ();
#line 887 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (photos);
#line 887 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (job);
#line 6587 "Printing.c"
}


static void
print_manager_on_status_changed (PrintManager* self,
                                 GtkPrintOperation* job)
{
	const gchar* _tmp0_;
	ProgressDialog* _tmp1_;
#line 910 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 910 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_OPERATION (job));
#line 911 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = gtk_print_operation_get_status_string (job);
#line 911 "/home/jens/Source/shotwell/src/Printing.vala"
	g_debug ("Printing.vala:911: on_status_changed: %s", _tmp0_);
#line 913 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->progress_dialog;
#line 913 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ != NULL) {
#line 6609 "Printing.c"
		ProgressDialog* _tmp2_;
		const gchar* _tmp3_;
#line 914 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = self->priv->progress_dialog;
#line 914 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = gtk_print_operation_get_status_string (job);
#line 914 "/home/jens/Source/shotwell/src/Printing.vala"
		progress_dialog_set_status (_tmp2_, _tmp3_);
#line 915 "/home/jens/Source/shotwell/src/Printing.vala"
		spin_event_loop ();
#line 6620 "Printing.c"
	}
}


static gpointer
_cairo_reference0 (gpointer self)
{
#line 940 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? cairo_reference (self) : NULL;
#line 6630 "Printing.c"
}


static void
print_manager_on_draw_page (PrintManager* self,
                            GtkPrintOperation* emitting_object,
                            GtkPrintContext* job_context,
                            gint page_num)
{
	PrintJob* job = NULL;
	PrintJob* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GCancellable* _tmp2_;
	GtkPageSetup* page_setup = NULL;
	GtkPageSetup* _tmp5_;
	GtkPageSetup* _tmp6_;
	gdouble page_width = 0.0;
	GtkPageSetup* _tmp7_;
	gdouble page_height = 0.0;
	GtkPageSetup* _tmp8_;
	gdouble dpi = 0.0;
	PrintJob* _tmp9_;
	PrintSettings* _tmp10_;
	PrintSettings* _tmp11_;
	gdouble _tmp12_;
	gdouble inv_dpi = 0.0;
	gdouble _tmp13_;
	cairo_t* dc = NULL;
	cairo_t* _tmp14_;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	GeeList* photos = NULL;
	PrintJob* _tmp19_;
	GeeList* _tmp20_;
	ContentLayout content_layout = 0;
	PrintJob* _tmp21_;
	PrintSettings* _tmp22_;
	PrintSettings* _tmp23_;
	ContentLayout _tmp24_;
	ContentLayout _tmp25_;
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_OPERATION (emitting_object));
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_CONTEXT (job_context));
#line 921 "/home/jens/Source/shotwell/src/Printing.vala"
	g_debug ("Printing.vala:921: on_draw_page");
#line 923 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (emitting_object, TYPE_PRINT_JOB, PrintJob));
#line 923 "/home/jens/Source/shotwell/src/Printing.vala"
	job = _tmp0_;
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->cancellable;
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_ != NULL) {
#line 6689 "Printing.c"
		GCancellable* _tmp3_;
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = self->priv->cancellable;
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = g_cancellable_is_cancelled (_tmp3_);
#line 6695 "Printing.c"
	} else {
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = FALSE;
#line 6699 "Printing.c"
	}
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_) {
#line 6703 "Printing.c"
		PrintJob* _tmp4_;
#line 927 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = job;
#line 927 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_print_operation_get_type (), GtkPrintOperation));
#line 929 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (job);
#line 929 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 6713 "Printing.c"
	}
#line 932 "/home/jens/Source/shotwell/src/Printing.vala"
	spin_event_loop ();
#line 934 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = gtk_print_context_get_page_setup (job_context);
#line 934 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 934 "/home/jens/Source/shotwell/src/Printing.vala"
	page_setup = _tmp6_;
#line 935 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = page_setup;
#line 935 "/home/jens/Source/shotwell/src/Printing.vala"
	page_width = gtk_page_setup_get_page_width (_tmp7_, GTK_UNIT_INCH);
#line 936 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = page_setup;
#line 936 "/home/jens/Source/shotwell/src/Printing.vala"
	page_height = gtk_page_setup_get_page_height (_tmp8_, GTK_UNIT_INCH);
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = job;
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = print_job_get_local_settings (_tmp9_);
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = _tmp10_;
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = (gdouble) print_settings_get_content_ppi (_tmp11_);
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp11_);
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	dpi = _tmp12_;
#line 939 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = dpi;
#line 939 "/home/jens/Source/shotwell/src/Printing.vala"
	inv_dpi = 1.0 / _tmp13_;
#line 940 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = gtk_print_context_get_cairo_context (job_context);
#line 940 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = _cairo_reference0 (_tmp14_);
#line 940 "/home/jens/Source/shotwell/src/Printing.vala"
	dc = _tmp15_;
#line 941 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = dc;
#line 941 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = inv_dpi;
#line 941 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp18_ = inv_dpi;
#line 941 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_scale (_tmp16_, _tmp17_, _tmp18_);
#line 942 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp19_ = job;
#line 942 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp20_ = print_job_get_photos (_tmp19_);
#line 942 "/home/jens/Source/shotwell/src/Printing.vala"
	photos = _tmp20_;
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp21_ = job;
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp22_ = print_job_get_local_settings (_tmp21_);
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp23_ = _tmp22_;
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp24_ = print_settings_get_content_layout (_tmp23_);
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp23_);
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	content_layout = _tmp24_;
#line 945 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp25_ = content_layout;
#line 945 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (_tmp25_) {
#line 945 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 945 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 6787 "Printing.c"
		{
			gdouble canvas_width = 0.0;
			gdouble canvas_height = 0.0;
			ContentLayout _tmp26_;
			GeeList* _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			ProgressDialog* _tmp95_;
#line 949 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp26_ = content_layout;
#line 949 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp26_ == CONTENT_LAYOUT_STANDARD_SIZE) {
#line 6800 "Printing.c"
				gint _tmp27_;
				StandardPrintSize** _tmp28_;
				PrintJob* _tmp29_;
				PrintSettings* _tmp30_;
				PrintSettings* _tmp31_;
				StandardPrintSize* _tmp32_;
				Measurement _tmp33_ = {0};
				gdouble _tmp34_;
				gint _tmp35_;
				StandardPrintSize** _tmp36_;
				PrintJob* _tmp37_;
				PrintSettings* _tmp38_;
				PrintSettings* _tmp39_;
				StandardPrintSize* _tmp40_;
				Measurement _tmp41_ = {0};
				gdouble _tmp42_;
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp28_ = print_manager_get_standard_sizes (self, &_tmp27_);
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp29_ = job;
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp30_ = print_job_get_local_settings (_tmp29_);
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp31_ = _tmp30_;
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp32_ = _tmp28_[print_settings_get_size_selection (_tmp31_)];
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				measurement_convert_to (&_tmp32_->width, MEASUREMENT_UNIT_INCHES, &_tmp33_);
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp34_ = _tmp33_.value;
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_width = _tmp34_;
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp31_);
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp36_ = print_manager_get_standard_sizes (self, &_tmp35_);
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp37_ = job;
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp38_ = print_job_get_local_settings (_tmp37_);
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp39_ = _tmp38_;
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp40_ = _tmp36_[print_settings_get_size_selection (_tmp39_)];
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				measurement_convert_to (&_tmp40_->height, MEASUREMENT_UNIT_INCHES, &_tmp41_);
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp42_ = _tmp41_.value;
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_height = _tmp42_;
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp39_);
#line 6853 "Printing.c"
			} else {
				ContentLayout _tmp43_;
				PrintJob* _tmp44_;
				PrintSettings* _tmp45_;
				PrintSettings* _tmp46_;
				Measurement _tmp47_ = {0};
				Measurement _tmp48_ = {0};
				gdouble _tmp49_;
				PrintJob* _tmp50_;
				PrintSettings* _tmp51_;
				PrintSettings* _tmp52_;
				Measurement _tmp53_ = {0};
				Measurement _tmp54_ = {0};
				gdouble _tmp55_;
#line 955 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp43_ = content_layout;
#line 955 "/home/jens/Source/shotwell/src/Printing.vala"
				_vala_assert (_tmp43_ == CONTENT_LAYOUT_CUSTOM_SIZE, "content_layout == ContentLayout.CUSTOM_SIZE");
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp44_ = job;
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp45_ = print_job_get_local_settings (_tmp44_);
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp46_ = _tmp45_;
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				print_settings_get_content_width (_tmp46_, &_tmp47_);
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				measurement_convert_to (&_tmp47_, MEASUREMENT_UNIT_INCHES, &_tmp48_);
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp49_ = _tmp48_.value;
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_width = _tmp49_;
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp46_);
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp50_ = job;
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp51_ = print_job_get_local_settings (_tmp50_);
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp52_ = _tmp51_;
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				print_settings_get_content_height (_tmp52_, &_tmp53_);
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				measurement_convert_to (&_tmp53_, MEASUREMENT_UNIT_INCHES, &_tmp54_);
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp55_ = _tmp54_.value;
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_height = _tmp55_;
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp52_);
#line 6904 "Printing.c"
			}
#line 962 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp56_ = photos;
#line 962 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp57_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_COLLECTION, GeeCollection));
#line 962 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp58_ = _tmp57_;
#line 962 "/home/jens/Source/shotwell/src/Printing.vala"
			if (page_num < _tmp58_) {
#line 6914 "Printing.c"
				Dimensions photo_dimensions = {0};
				GeeList* _tmp59_;
				gpointer _tmp60_;
				Photo* _tmp61_;
				Dimensions _tmp62_ = {0};
				Dimensions _tmp63_;
				gdouble photo_aspect_ratio = 0.0;
				gdouble canvas_aspect_ratio = 0.0;
				gdouble _tmp64_;
				gdouble _tmp65_;
				gdouble _tmp66_;
				gdouble _tmp67_;
				gdouble dx = 0.0;
				gdouble _tmp71_;
				gdouble _tmp72_;
				gdouble dy = 0.0;
				gdouble _tmp73_;
				gdouble _tmp74_;
				GeeList* _tmp75_;
				gpointer _tmp76_;
				Photo* _tmp77_;
				gdouble _tmp78_;
				gdouble _tmp79_;
				gdouble _tmp80_;
				gdouble _tmp81_;
				PrintJob* _tmp82_;
				PrintJob* _tmp83_;
				PrintSettings* _tmp84_;
				PrintSettings* _tmp85_;
				gboolean _tmp86_;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp59_ = photos;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp60_ = gee_list_get (_tmp59_, page_num);
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp61_ = (Photo*) _tmp60_;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp62_);
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp63_ = _tmp62_;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				_g_object_unref0 (_tmp61_);
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				photo_dimensions = _tmp63_;
#line 964 "/home/jens/Source/shotwell/src/Printing.vala"
				photo_aspect_ratio = dimensions_get_aspect_ratio (&photo_dimensions);
#line 965 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp64_ = canvas_width;
#line 965 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp65_ = canvas_height;
#line 965 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_aspect_ratio = ((gdouble) _tmp64_) / _tmp65_;
#line 966 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp66_ = canvas_aspect_ratio;
#line 966 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp67_ = photo_aspect_ratio;
#line 966 "/home/jens/Source/shotwell/src/Printing.vala"
				if (floor (_tmp66_) != floor (_tmp67_)) {
#line 6973 "Printing.c"
					gdouble canvas_tmp = 0.0;
					gdouble _tmp68_;
					gdouble _tmp69_;
					gdouble _tmp70_;
#line 967 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp68_ = canvas_width;
#line 967 "/home/jens/Source/shotwell/src/Printing.vala"
					canvas_tmp = _tmp68_;
#line 968 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp69_ = canvas_height;
#line 968 "/home/jens/Source/shotwell/src/Printing.vala"
					canvas_width = _tmp69_;
#line 969 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp70_ = canvas_tmp;
#line 969 "/home/jens/Source/shotwell/src/Printing.vala"
					canvas_height = _tmp70_;
#line 6990 "Printing.c"
				}
#line 972 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp71_ = page_width;
#line 972 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp72_ = canvas_width;
#line 972 "/home/jens/Source/shotwell/src/Printing.vala"
				dx = (_tmp71_ - _tmp72_) / 2.0;
#line 973 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp73_ = page_height;
#line 973 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp74_ = canvas_height;
#line 973 "/home/jens/Source/shotwell/src/Printing.vala"
				dy = (_tmp73_ - _tmp74_) / 2.0;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp75_ = photos;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp76_ = gee_list_get (_tmp75_, page_num);
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp77_ = (Photo*) _tmp76_;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp78_ = dx;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp79_ = dy;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp80_ = canvas_width;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp81_ = canvas_height;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp82_ = job;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				print_manager_fit_image_to_canvas (self, _tmp77_, _tmp78_, _tmp79_, _tmp80_, _tmp81_, TRUE, _tmp82_, job_context);
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_g_object_unref0 (_tmp77_);
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp83_ = job;
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp84_ = print_job_get_local_settings (_tmp83_);
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp85_ = _tmp84_;
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp86_ = print_settings_is_print_titles_enabled (_tmp85_);
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp85_);
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				if (_tmp86_) {
#line 7036 "Printing.c"
					gdouble _tmp87_;
					gdouble _tmp88_;
					GeeList* _tmp89_;
					gpointer _tmp90_;
					Photo* _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					PrintJob* _tmp94_;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp87_ = page_width;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp88_ = page_height;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp89_ = photos;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp90_ = gee_list_get (_tmp89_, page_num);
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp91_ = (Photo*) _tmp90_;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp92_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, TYPE_DATA_OBJECT, DataObject));
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp93_ = _tmp92_;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp94_ = job;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					print_manager_add_title_to_canvas (self, _tmp87_ / 2, _tmp88_, _tmp93_, _tmp94_, job_context);
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (_tmp93_);
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_object_unref0 (_tmp91_);
#line 7067 "Printing.c"
				}
			}
#line 982 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp95_ = self->priv->progress_dialog;
#line 982 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp95_ != NULL) {
#line 7074 "Printing.c"
				ProgressDialog* _tmp96_;
				GeeList* _tmp97_;
				gint _tmp98_;
				gint _tmp99_;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp96_ = self->priv->progress_dialog;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp97_ = photos;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp98_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, GEE_TYPE_COLLECTION, GeeCollection));
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp99_ = _tmp98_;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				progress_dialog_monitor (_tmp96_, (guint64) page_num, (guint64) _tmp99_, TRUE);
#line 7089 "Printing.c"
			}
#line 984 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 7093 "Printing.c"
		}
#line 945 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 7097 "Printing.c"
		{
			PrintLayout layout = 0;
			PrintJob* _tmp100_;
			PrintSettings* _tmp101_;
			PrintSettings* _tmp102_;
			PrintLayout _tmp103_;
			gint nx = 0;
			PrintLayout _tmp104_;
			gint ny = 0;
			PrintLayout _tmp105_;
			gint start = 0;
			PrintLayout _tmp106_;
			gdouble canvas_width = 0.0;
			gdouble _tmp107_;
			gint _tmp108_;
			gint _tmp109_;
			gdouble canvas_height = 0.0;
			gdouble _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp100_ = job;
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp101_ = print_job_get_local_settings (_tmp100_);
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp102_ = _tmp101_;
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp103_ = (PrintLayout) print_settings_get_image_per_page_selection (_tmp102_);
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_print_settings_unref0 (_tmp102_);
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			layout = _tmp103_;
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp104_ = layout;
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
			nx = print_layout_get_x (_tmp104_);
#line 989 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp105_ = layout;
#line 989 "/home/jens/Source/shotwell/src/Printing.vala"
			ny = print_layout_get_y (_tmp105_);
#line 990 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp106_ = layout;
#line 990 "/home/jens/Source/shotwell/src/Printing.vala"
			start = page_num * print_layout_get_per_page (_tmp106_);
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp107_ = page_width;
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp108_ = nx;
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp109_ = nx;
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
			canvas_width = ((gdouble) (_tmp107_ - (PRINT_MANAGER_IMAGE_DISTANCE * (_tmp108_ - 1)))) / _tmp109_;
#line 992 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp110_ = page_height;
#line 992 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp111_ = ny;
#line 992 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp112_ = ny;
#line 992 "/home/jens/Source/shotwell/src/Printing.vala"
			canvas_height = ((gdouble) (_tmp110_ - (PRINT_MANAGER_IMAGE_DISTANCE * (_tmp111_ - 1)))) / _tmp112_;
#line 7158 "Printing.c"
			{
				gint y = 0;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
				y = 0;
#line 7163 "Printing.c"
				{
					gboolean _tmp113_ = FALSE;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp113_ = TRUE;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
					while (TRUE) {
#line 7170 "Printing.c"
						gint _tmp115_;
						gint _tmp116_;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
						if (!_tmp113_) {
#line 7175 "Printing.c"
							gint _tmp114_;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
							_tmp114_ = y;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
							y = _tmp114_ + 1;
#line 7181 "Printing.c"
						}
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp113_ = FALSE;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp115_ = y;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp116_ = ny;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
						if (!(_tmp115_ < _tmp116_)) {
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
							break;
#line 7193 "Printing.c"
						}
						{
							gint x = 0;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
							x = 0;
#line 7199 "Printing.c"
							{
								gboolean _tmp117_ = FALSE;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
								_tmp117_ = TRUE;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
								while (TRUE) {
#line 7206 "Printing.c"
									gint _tmp119_;
									gint _tmp120_;
									gint i = 0;
									gint _tmp121_;
									gint _tmp122_;
									gint _tmp123_;
									gint _tmp124_;
									gint _tmp125_;
									GeeList* _tmp126_;
									gint _tmp127_;
									gint _tmp128_;
									ProgressDialog* _tmp159_;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
									if (!_tmp117_) {
#line 7221 "Printing.c"
										gint _tmp118_;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp118_ = x;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
										x = _tmp118_ + 1;
#line 7227 "Printing.c"
									}
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp117_ = FALSE;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp119_ = x;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp120_ = nx;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
									if (!(_tmp119_ < _tmp120_)) {
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
										break;
#line 7239 "Printing.c"
									}
#line 995 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp121_ = start;
#line 995 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp122_ = y;
#line 995 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp123_ = nx;
#line 995 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp124_ = x;
#line 995 "/home/jens/Source/shotwell/src/Printing.vala"
									i = (_tmp121_ + (_tmp122_ * _tmp123_)) + _tmp124_;
#line 996 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp125_ = i;
#line 996 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp126_ = photos;
#line 996 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp127_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, GEE_TYPE_COLLECTION, GeeCollection));
#line 996 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp128_ = _tmp127_;
#line 996 "/home/jens/Source/shotwell/src/Printing.vala"
									if (_tmp125_ < _tmp128_) {
#line 7261 "Printing.c"
										gdouble dx = 0.0;
										gint _tmp129_;
										gdouble _tmp130_;
										gint _tmp131_;
										gdouble dy = 0.0;
										gint _tmp132_;
										gdouble _tmp133_;
										gint _tmp134_;
										GeeList* _tmp135_;
										gint _tmp136_;
										gpointer _tmp137_;
										Photo* _tmp138_;
										gdouble _tmp139_;
										gdouble _tmp140_;
										gdouble _tmp141_;
										gdouble _tmp142_;
										PrintJob* _tmp143_;
										PrintJob* _tmp144_;
										PrintSettings* _tmp145_;
										PrintSettings* _tmp146_;
										gboolean _tmp147_;
#line 997 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp129_ = x;
#line 997 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp130_ = canvas_width;
#line 997 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp131_ = x;
#line 997 "/home/jens/Source/shotwell/src/Printing.vala"
										dx = (_tmp129_ * _tmp130_) + (_tmp131_ * PRINT_MANAGER_IMAGE_DISTANCE);
#line 998 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp132_ = y;
#line 998 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp133_ = canvas_height;
#line 998 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp134_ = y;
#line 998 "/home/jens/Source/shotwell/src/Printing.vala"
										dy = (_tmp132_ * _tmp133_) + (_tmp134_ * PRINT_MANAGER_IMAGE_DISTANCE);
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp135_ = photos;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp136_ = i;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp137_ = gee_list_get (_tmp135_, _tmp136_);
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp138_ = (Photo*) _tmp137_;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp139_ = dx;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp140_ = dy;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp141_ = canvas_width;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp142_ = canvas_height;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp143_ = job;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										print_manager_fit_image_to_canvas (self, _tmp138_, _tmp139_, _tmp140_, _tmp141_, _tmp142_, FALSE, _tmp143_, job_context);
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_g_object_unref0 (_tmp138_);
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp144_ = job;
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp145_ = print_job_get_local_settings (_tmp144_);
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp146_ = _tmp145_;
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp147_ = print_settings_is_print_titles_enabled (_tmp146_);
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										_print_settings_unref0 (_tmp146_);
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										if (_tmp147_) {
#line 7333 "Printing.c"
											gdouble _tmp148_;
											gdouble _tmp149_;
											gdouble _tmp150_;
											gdouble _tmp151_;
											GeeList* _tmp152_;
											gint _tmp153_;
											gpointer _tmp154_;
											Photo* _tmp155_;
											gchar* _tmp156_;
											gchar* _tmp157_;
											PrintJob* _tmp158_;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp148_ = dx;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp149_ = canvas_width;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp150_ = dy;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp151_ = canvas_height;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp152_ = photos;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp153_ = i;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp154_ = gee_list_get (_tmp152_, _tmp153_);
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp155_ = (Photo*) _tmp154_;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp156_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp155_, TYPE_DATA_OBJECT, DataObject));
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp157_ = _tmp156_;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp158_ = job;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											print_manager_add_title_to_canvas (self, _tmp148_ + (_tmp149_ / 2), _tmp150_ + _tmp151_, _tmp157_, _tmp158_, job_context);
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_g_free0 (_tmp157_);
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_g_object_unref0 (_tmp155_);
#line 7373 "Printing.c"
										}
									}
#line 1007 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp159_ = self->priv->progress_dialog;
#line 1007 "/home/jens/Source/shotwell/src/Printing.vala"
									if (_tmp159_ != NULL) {
#line 7380 "Printing.c"
										ProgressDialog* _tmp160_;
										gint _tmp161_;
										GeeList* _tmp162_;
										gint _tmp163_;
										gint _tmp164_;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp160_ = self->priv->progress_dialog;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp161_ = i;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp162_ = photos;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp163_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp164_ = _tmp163_;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
										progress_dialog_monitor (_tmp160_, (guint64) _tmp161_, (guint64) _tmp164_, TRUE);
#line 7398 "Printing.c"
									}
								}
							}
						}
					}
				}
			}
#line 1011 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 7408 "Printing.c"
		}
		default:
		{
#line 1014 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:1014: unknown or unsupported layout mode");
#line 7414 "Printing.c"
		}
	}
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (photos);
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	_cairo_destroy0 (dc);
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (page_setup);
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (job);
#line 7425 "Printing.c"
}


static void
_print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply (GtkPrintOperation* _sender,
                                                                               GtkWidget* widget,
                                                                               gpointer self)
{
#line 1020 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_on_custom_widget_apply ((PrintManager*) self, widget);
#line 7436 "Printing.c"
}


static GObject*
print_manager_on_create_custom_widget (PrintManager* self,
                                       GtkPrintOperation* emitting_object)
{
	GObject* result = NULL;
	CustomPrintTab* _tmp0_;
	CustomPrintTab* _tmp1_;
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_MANAGER (self), NULL);
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (GTK_IS_PRINT_OPERATION (emitting_object), NULL);
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = custom_print_tab_new (G_TYPE_CHECK_INSTANCE_CAST (emitting_object, TYPE_PRINT_JOB, PrintJob));
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
	g_object_ref_sink (_tmp0_);
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_tab);
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->custom_tab = _tmp0_;
#line 1020 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (emitting_object, TYPE_PRINT_JOB, PrintJob), gtk_print_operation_get_type (), GtkPrintOperation), "custom-widget-apply", (GCallback) _print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply, self);
#line 1021 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->custom_tab;
#line 1021 "/home/jens/Source/shotwell/src/Printing.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject);
#line 1021 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 7467 "Printing.c"
}


static void
print_manager_on_custom_widget_apply (PrintManager* self,
                                      GtkWidget* custom_widget)
{
	CustomPrintTab* tab = NULL;
	CustomPrintTab* _tmp0_;
	PrintJob* _tmp1_;
	PrintJob* _tmp2_;
	PrintSettings* _tmp3_;
	PrintSettings* _tmp4_;
	PrintSettings* _tmp5_;
	PrintSettings* _tmp6_;
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_WIDGET (custom_widget));
#line 1025 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (custom_widget, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab));
#line 1025 "/home/jens/Source/shotwell/src/Printing.vala"
	tab = _tmp0_;
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = custom_print_tab_get_source_job (tab);
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _tmp1_;
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_get_local_settings (tab);
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_;
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	print_job_set_local_settings (_tmp2_, _tmp4_);
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp4_);
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp2_);
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = custom_print_tab_get_local_settings (tab);
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = _tmp5_;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_set_global_settings (self, _tmp6_);
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp6_);
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (tab);
#line 7515 "Printing.c"
}


static void
print_manager_fit_image_to_canvas (PrintManager* self,
                                   Photo* photo,
                                   gdouble x,
                                   gdouble y,
                                   gdouble canvas_width,
                                   gdouble canvas_height,
                                   gboolean crop,
                                   PrintJob* job,
                                   GtkPrintContext* job_context)
{
	cairo_t* dc = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	Dimensions photo_dimensions = {0};
	Dimensions _tmp2_ = {0};
	gdouble photo_aspect_ratio = 0.0;
	gdouble canvas_aspect_ratio = 0.0;
	gdouble target_width = 0.0;
	gdouble target_height = 0.0;
	gdouble dpi = 0.0;
	PrintSettings* _tmp3_;
	PrintSettings* _tmp4_;
	gdouble _tmp5_;
	gdouble x_offset = 0.0;
	gdouble _tmp14_;
	gdouble y_offset = 0.0;
	gdouble _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	gint w = 0;
	gdouble _tmp20_;
	gint h = 0;
	gdouble _tmp21_;
	Dimensions viewport = {0};
	gint _tmp22_;
	gint _tmp23_;
	cairo_t* _tmp72_;
	GError * _inner_error_ = NULL;
#line 1030 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 1030 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PHOTO (photo));
#line 1030 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_JOB (job));
#line 1030 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_CONTEXT (job_context));
#line 1031 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = gtk_print_context_get_cairo_context (job_context);
#line 1031 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _cairo_reference0 (_tmp0_);
#line 1031 "/home/jens/Source/shotwell/src/Printing.vala"
	dc = _tmp1_;
#line 1032 "/home/jens/Source/shotwell/src/Printing.vala"
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp2_);
#line 1032 "/home/jens/Source/shotwell/src/Printing.vala"
	photo_dimensions = _tmp2_;
#line 1033 "/home/jens/Source/shotwell/src/Printing.vala"
	photo_aspect_ratio = dimensions_get_aspect_ratio (&photo_dimensions);
#line 1034 "/home/jens/Source/shotwell/src/Printing.vala"
	canvas_aspect_ratio = ((gdouble) canvas_width) / canvas_height;
#line 1036 "/home/jens/Source/shotwell/src/Printing.vala"
	target_width = 0.0;
#line 1037 "/home/jens/Source/shotwell/src/Printing.vala"
	target_height = 0.0;
#line 1038 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = print_job_get_local_settings (job);
#line 1038 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_;
#line 1038 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = (gdouble) print_settings_get_content_ppi (_tmp4_);
#line 1038 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp4_);
#line 1038 "/home/jens/Source/shotwell/src/Printing.vala"
	dpi = _tmp5_;
#line 1040 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!crop) {
#line 7598 "Printing.c"
		gdouble _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp12_;
		gdouble _tmp13_;
#line 1041 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = canvas_aspect_ratio;
#line 1041 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7_ = photo_aspect_ratio;
#line 1041 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp6_ < _tmp7_) {
#line 7609 "Printing.c"
			gdouble _tmp8_;
			gdouble _tmp9_;
#line 1042 "/home/jens/Source/shotwell/src/Printing.vala"
			target_width = canvas_width;
#line 1043 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = target_width;
#line 1043 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp9_ = photo_aspect_ratio;
#line 1043 "/home/jens/Source/shotwell/src/Printing.vala"
			target_height = _tmp8_ * (1.0 / _tmp9_);
#line 7620 "Printing.c"
		} else {
			gdouble _tmp10_;
			gdouble _tmp11_;
#line 1045 "/home/jens/Source/shotwell/src/Printing.vala"
			target_height = canvas_height;
#line 1046 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp10_ = target_height;
#line 1046 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp11_ = photo_aspect_ratio;
#line 1046 "/home/jens/Source/shotwell/src/Printing.vala"
			target_width = _tmp10_ * _tmp11_;
#line 7632 "Printing.c"
		}
#line 1048 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp12_ = target_width;
#line 1048 "/home/jens/Source/shotwell/src/Printing.vala"
		x = x + ((canvas_width - _tmp12_) / 2.0);
#line 1049 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp13_ = target_height;
#line 1049 "/home/jens/Source/shotwell/src/Printing.vala"
		y = y + ((canvas_height - _tmp13_) / 2.0);
#line 7642 "Printing.c"
	}
#line 1052 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = dpi;
#line 1052 "/home/jens/Source/shotwell/src/Printing.vala"
	x_offset = _tmp14_ * x;
#line 1053 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = dpi;
#line 1053 "/home/jens/Source/shotwell/src/Printing.vala"
	y_offset = _tmp15_ * y;
#line 1054 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = dc;
#line 1054 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_save (_tmp16_);
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = dc;
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp18_ = x_offset;
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp19_ = y_offset;
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_translate (_tmp17_, _tmp18_, _tmp19_);
#line 1057 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp20_ = dpi;
#line 1057 "/home/jens/Source/shotwell/src/Printing.vala"
	w = (gint) (_tmp20_ * canvas_width);
#line 1058 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp21_ = dpi;
#line 1058 "/home/jens/Source/shotwell/src/Printing.vala"
	h = (gint) (_tmp21_ * canvas_height);
#line 1059 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp22_ = w;
#line 1059 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp23_ = h;
#line 1059 "/home/jens/Source/shotwell/src/Printing.vala"
	dimensions_init (&viewport, _tmp22_, _tmp23_);
#line 7678 "Printing.c"
	{
		gboolean _tmp24_ = FALSE;
		cairo_t* _tmp67_;
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
		if (crop) {
#line 7684 "Printing.c"
			gdouble _tmp25_;
			gdouble _tmp26_;
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp25_ = canvas_aspect_ratio;
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp26_ = photo_aspect_ratio;
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp24_ = !print_manager_are_approximately_equal (self, _tmp25_, _tmp26_);
#line 7693 "Printing.c"
		} else {
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp24_ = FALSE;
#line 7697 "Printing.c"
		}
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp24_) {
#line 7701 "Printing.c"
			Scaling pixbuf_scaling = {0};
			Dimensions _tmp27_;
			Scaling _tmp28_ = {0};
			GdkPixbuf* photo_pixbuf = NULL;
			Scaling _tmp29_;
			GdkPixbuf* _tmp30_;
			Dimensions scaled_photo_dimensions = {0};
			GdkPixbuf* _tmp31_;
			Dimensions _tmp32_ = {0};
			gint shave_vertical = 0;
			gint shave_horizontal = 0;
			gdouble _tmp33_;
			gdouble _tmp34_;
			GdkPixbuf* shaved_pixbuf = NULL;
			GdkPixbuf* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			Dimensions _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			Dimensions _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			GdkPixbuf* _tmp54_;
			GdkPixbuf* _tmp55_;
			GdkPixbuf* _tmp56_;
			cairo_t* _tmp57_;
			GdkPixbuf* _tmp58_;
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp27_ = viewport;
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
			scaling_to_fill_viewport (&_tmp27_, &_tmp28_);
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
			pixbuf_scaling = _tmp28_;
#line 1064 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp29_ = pixbuf_scaling;
#line 1064 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp30_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp29_, &_inner_error_);
#line 1064 "/home/jens/Source/shotwell/src/Printing.vala"
			photo_pixbuf = _tmp30_;
#line 1064 "/home/jens/Source/shotwell/src/Printing.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7744 "Printing.c"
				goto __catch479_g_error;
			}
#line 1065 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp31_ = photo_pixbuf;
#line 1065 "/home/jens/Source/shotwell/src/Printing.vala"
			dimensions_for_pixbuf (_tmp31_, &_tmp32_);
#line 1065 "/home/jens/Source/shotwell/src/Printing.vala"
			scaled_photo_dimensions = _tmp32_;
#line 1066 "/home/jens/Source/shotwell/src/Printing.vala"
			shave_vertical = 0;
#line 1067 "/home/jens/Source/shotwell/src/Printing.vala"
			shave_horizontal = 0;
#line 1068 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp33_ = canvas_aspect_ratio;
#line 1068 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp34_ = photo_aspect_ratio;
#line 1068 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp33_ < _tmp34_) {
#line 7763 "Printing.c"
				Dimensions _tmp35_;
				gint _tmp36_;
				Dimensions _tmp37_;
				gint _tmp38_;
				gdouble _tmp39_;
#line 1069 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp35_ = scaled_photo_dimensions;
#line 1069 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp36_ = _tmp35_.width;
#line 1069 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp37_ = scaled_photo_dimensions;
#line 1069 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp38_ = _tmp37_.height;
#line 1069 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp39_ = canvas_aspect_ratio;
#line 1069 "/home/jens/Source/shotwell/src/Printing.vala"
				shave_vertical = (gint) ((_tmp36_ - (_tmp38_ * _tmp39_)) / 2.0);
#line 7781 "Printing.c"
			} else {
				Dimensions _tmp40_;
				gint _tmp41_;
				Dimensions _tmp42_;
				gint _tmp43_;
				gdouble _tmp44_;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp40_ = scaled_photo_dimensions;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp41_ = _tmp40_.height;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp42_ = scaled_photo_dimensions;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp43_ = _tmp42_.width;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp44_ = canvas_aspect_ratio;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
				shave_horizontal = (gint) ((_tmp41_ - (_tmp43_ * (1.0 / _tmp44_))) / 2.0);
#line 7800 "Printing.c"
			}
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp45_ = photo_pixbuf;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp46_ = shave_vertical;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp47_ = shave_horizontal;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp48_ = scaled_photo_dimensions;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp49_ = _tmp48_.width;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp50_ = shave_vertical;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp51_ = scaled_photo_dimensions;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp52_ = _tmp51_.height;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp53_ = shave_horizontal;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp54_ = gdk_pixbuf_new_subpixbuf (_tmp45_, _tmp46_, _tmp47_, _tmp49_ - (2 * _tmp50_), _tmp52_ - (2 * _tmp53_));
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			shaved_pixbuf = _tmp54_;
#line 1075 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp55_ = shaved_pixbuf;
#line 1075 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp56_ = scaling_perform_on_pixbuf (&pixbuf_scaling, _tmp55_, GDK_INTERP_HYPER, TRUE);
#line 1075 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (photo_pixbuf);
#line 1075 "/home/jens/Source/shotwell/src/Printing.vala"
			photo_pixbuf = _tmp56_;
#line 1076 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp57_ = dc;
#line 1076 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp58_ = photo_pixbuf;
#line 1076 "/home/jens/Source/shotwell/src/Printing.vala"
			gdk_cairo_set_source_pixbuf (_tmp57_, _tmp58_, 0.0, 0.0);
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (shaved_pixbuf);
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (photo_pixbuf);
#line 7842 "Printing.c"
		} else {
			Scaling pixbuf_scaling = {0};
			Dimensions _tmp59_;
			Scaling _tmp60_ = {0};
			GdkPixbuf* photo_pixbuf = NULL;
			Scaling _tmp61_;
			GdkPixbuf* _tmp62_;
			GdkPixbuf* _tmp63_;
			GdkPixbuf* _tmp64_;
			cairo_t* _tmp65_;
			GdkPixbuf* _tmp66_;
#line 1078 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp59_ = viewport;
#line 1078 "/home/jens/Source/shotwell/src/Printing.vala"
			scaling_for_viewport (&_tmp59_, TRUE, &_tmp60_);
#line 1078 "/home/jens/Source/shotwell/src/Printing.vala"
			pixbuf_scaling = _tmp60_;
#line 1079 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp61_ = pixbuf_scaling;
#line 1079 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp62_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp61_, &_inner_error_);
#line 1079 "/home/jens/Source/shotwell/src/Printing.vala"
			photo_pixbuf = _tmp62_;
#line 1079 "/home/jens/Source/shotwell/src/Printing.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7868 "Printing.c"
				goto __catch479_g_error;
			}
#line 1080 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp63_ = photo_pixbuf;
#line 1080 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp64_ = scaling_perform_on_pixbuf (&pixbuf_scaling, _tmp63_, GDK_INTERP_HYPER, TRUE);
#line 1080 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (photo_pixbuf);
#line 1080 "/home/jens/Source/shotwell/src/Printing.vala"
			photo_pixbuf = _tmp64_;
#line 1081 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp65_ = dc;
#line 1081 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp66_ = photo_pixbuf;
#line 1081 "/home/jens/Source/shotwell/src/Printing.vala"
			gdk_cairo_set_source_pixbuf (_tmp65_, _tmp66_, 0.0, 0.0);
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (photo_pixbuf);
#line 7887 "Printing.c"
		}
#line 1083 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp67_ = dc;
#line 1083 "/home/jens/Source/shotwell/src/Printing.vala"
		cairo_paint (_tmp67_);
#line 7893 "Printing.c"
	}
	goto __finally479;
	__catch479_g_error:
	{
		GError* e = NULL;
		GError* _tmp68_;
		const gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		e = _inner_error_;
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		_inner_error_ = NULL;
#line 1086 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation));
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp68_ = e;
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp69_ = _tmp68_->message;
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp70_ = g_strdup_printf (_ ("Unable to print photo:\n\n%s"), _tmp69_);
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp71_ = _tmp70_;
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		app_window_error_message (_tmp71_, NULL);
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp71_);
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_error_free0 (e);
#line 7923 "Printing.c"
	}
	__finally479:
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		_cairo_destroy0 (dc);
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		g_clear_error (&_inner_error_);
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 7936 "Printing.c"
	}
#line 1089 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp72_ = dc;
#line 1089 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_restore (_tmp72_);
#line 1030 "/home/jens/Source/shotwell/src/Printing.vala"
	_cairo_destroy0 (dc);
#line 7944 "Printing.c"
}


static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 7953 "Printing.c"
}


static void
print_manager_add_title_to_canvas (PrintManager* self,
                                   gdouble x,
                                   gdouble y,
                                   const gchar* title,
                                   PrintJob* job,
                                   GtkPrintContext* job_context)
{
	cairo_t* dc = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gdouble dpi = 0.0;
	PrintSettings* _tmp2_;
	PrintSettings* _tmp3_;
	gdouble _tmp4_;
	PangoFontDescription* title_font_description = NULL;
	PrintSettings* _tmp5_;
	PrintSettings* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	PangoFontDescription* _tmp9_;
	PangoFontDescription* _tmp10_;
	PangoLayout* title_layout = NULL;
	PangoLayout* _tmp11_;
	PangoContext* context = NULL;
	PangoContext* _tmp12_;
	PangoContext* _tmp13_;
	gint title_width = 0;
	gint title_height = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gdouble tx = 0.0;
	gdouble ty = 0.0;
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (title != NULL);
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_JOB (job));
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_CONTEXT (job_context));
#line 1093 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = gtk_print_context_get_cairo_context (job_context);
#line 1093 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _cairo_reference0 (_tmp0_);
#line 1093 "/home/jens/Source/shotwell/src/Printing.vala"
	dc = _tmp1_;
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = print_job_get_local_settings (job);
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_;
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = (gdouble) print_settings_get_content_ppi (_tmp3_);
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp3_);
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
	dpi = _tmp4_;
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = print_job_get_local_settings (job);
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = _tmp5_;
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = print_settings_get_print_titles_font (_tmp6_);
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = _tmp7_;
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = pango_font_description_from_string (_tmp8_);
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp8_);
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp6_);
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	title_font_description = _tmp10_;
#line 1096 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = pango_cairo_create_layout (dc);
#line 1096 "/home/jens/Source/shotwell/src/Printing.vala"
	title_layout = _tmp11_;
#line 1097 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = pango_layout_get_context (title_layout);
#line 1097 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 1097 "/home/jens/Source/shotwell/src/Printing.vala"
	context = _tmp13_;
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_cairo_context_set_resolution (context, dpi);
#line 1099 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_layout_set_font_description (title_layout, title_font_description);
#line 1100 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_layout_set_text (title_layout, title, -1);
#line 1102 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_layout_get_pixel_size (title_layout, &_tmp14_, &_tmp15_);
#line 1102 "/home/jens/Source/shotwell/src/Printing.vala"
	title_width = _tmp14_;
#line 1102 "/home/jens/Source/shotwell/src/Printing.vala"
	title_height = _tmp15_;
#line 1103 "/home/jens/Source/shotwell/src/Printing.vala"
	tx = (dpi * x) - (title_width / 2);
#line 1104 "/home/jens/Source/shotwell/src/Printing.vala"
	ty = (dpi * y) - title_height;
#line 1107 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_rectangle (dc, tx - 10, ty + 2, (gdouble) (title_width + 20), (gdouble) title_height);
#line 1108 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_set_source_rgba (dc, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 1109 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_set_line_width (dc, (gdouble) 2);
#line 1110 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_stroke_preserve (dc);
#line 1111 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_set_source_rgba (dc, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.5);
#line 1112 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_fill (dc);
#line 1113 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_set_source_rgba (dc, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
#line 1115 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_move_to (dc, tx, ty + 2);
#line 1116 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_cairo_show_layout (dc, title_layout);
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (context);
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (title_layout);
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	__vala_PangoFontDescription_free0 (title_font_description);
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	_cairo_destroy0 (dc);
#line 8084 "Printing.c"
}


static gboolean
print_manager_are_approximately_equal (PrintManager* self,
                                       gdouble val1,
                                       gdouble val2)
{
	gboolean result = FALSE;
	gdouble accept_err = 0.0;
#line 1119 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_MANAGER (self), FALSE);
#line 1120 "/home/jens/Source/shotwell/src/Printing.vala"
	accept_err = 0.005;
#line 1121 "/home/jens/Source/shotwell/src/Printing.vala"
	result = fabs (val1 - val2) <= accept_err;
#line 1121 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 8103 "Printing.c"
}


PrintSettings*
print_manager_get_global_settings (PrintManager* self)
{
	PrintSettings* result = NULL;
	PrintSettings* _tmp0_;
	PrintSettings* _tmp1_;
#line 1124 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_MANAGER (self), NULL);
#line 1125 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->settings;
#line 1125 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _print_settings_ref0 (_tmp0_);
#line 1125 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 1125 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 8123 "Printing.c"
}


void
print_manager_set_global_settings (PrintManager* self,
                                   PrintSettings* settings)
{
	PrintSettings* _tmp0_;
#line 1128 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 1128 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (settings));
#line 1129 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = _print_settings_ref0 (settings);
#line 1129 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 1129 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->settings = _tmp0_;
#line 1130 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_save (settings);
#line 8144 "Printing.c"
}


static void
value_print_manager_init (GValue* value)
{
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	value->data[0].v_pointer = NULL;
#line 8153 "Printing.c"
}


static void
value_print_manager_free_value (GValue* value)
{
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (value->data[0].v_pointer) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_unref (value->data[0].v_pointer);
#line 8164 "Printing.c"
	}
}


static void
value_print_manager_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (src_value->data[0].v_pointer) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = print_manager_ref (src_value->data[0].v_pointer);
#line 8177 "Printing.c"
	} else {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = NULL;
#line 8181 "Printing.c"
	}
}


static gpointer
value_print_manager_peek_pointer (const GValue* value)
{
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 8191 "Printing.c"
}


static gchar*
value_print_manager_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (collect_values[0].v_pointer) {
#line 8203 "Printing.c"
		PrintManager * object;
		object = collect_values[0].v_pointer;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		if (object->parent_instance.g_class == NULL) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8210 "Printing.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8214 "Printing.c"
		}
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = print_manager_ref (object);
#line 8218 "Printing.c"
	} else {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 8222 "Printing.c"
	}
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 8226 "Printing.c"
}


static gchar*
value_print_manager_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	PrintManager ** object_p;
	object_p = collect_values[0].v_pointer;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!object_p) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 8242 "Printing.c"
	}
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!value->data[0].v_pointer) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = NULL;
#line 8248 "Printing.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = value->data[0].v_pointer;
#line 8252 "Printing.c"
	} else {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = print_manager_ref (value->data[0].v_pointer);
#line 8256 "Printing.c"
	}
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 8260 "Printing.c"
}


GParamSpec*
param_spec_print_manager (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecPrintManager* spec;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PRINT_MANAGER), NULL);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	return G_PARAM_SPEC (spec);
#line 8280 "Printing.c"
}


gpointer
value_get_print_manager (const GValue* value)
{
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER), NULL);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 8291 "Printing.c"
}


void
value_set_print_manager (GValue* value,
                         gpointer v_object)
{
	PrintManager * old;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER));
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_MANAGER));
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_ref (value->data[0].v_pointer);
#line 8314 "Printing.c"
	} else {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 8318 "Printing.c"
	}
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_unref (old);
#line 8324 "Printing.c"
	}
}


void
value_take_print_manager (GValue* value,
                          gpointer v_object)
{
	PrintManager * old;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER));
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_MANAGER));
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 8346 "Printing.c"
	} else {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 8350 "Printing.c"
	}
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_unref (old);
#line 8356 "Printing.c"
	}
}


static void
print_manager_class_init (PrintManagerClass * klass)
{
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_parent_class = g_type_class_peek_parent (klass);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	((PrintManagerClass *) klass)->finalize = print_manager_finalize;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_type_class_add_private (klass, sizeof (PrintManagerPrivate));
#line 8370 "Printing.c"
}


static void
print_manager_instance_init (PrintManager * self)
{
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv = PRINT_MANAGER_GET_PRIVATE (self);
#line 779 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->progress_dialog = NULL;
#line 780 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->cancellable = NULL;
#line 781 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->standard_sizes = NULL;
#line 781 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->standard_sizes_length1 = 0;
#line 781 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->_standard_sizes_size_ = self->priv->standard_sizes_length1;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	self->ref_count = 1;
#line 8391 "Printing.c"
}


static void
print_manager_finalize (PrintManager * obj)
{
	PrintManager * self;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_MANAGER, PrintManager);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_handlers_destroy (self);
#line 776 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 777 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->user_page_setup);
#line 778 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_tab);
#line 779 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 780 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 781 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->standard_sizes = (_vala_array_free (self->priv->standard_sizes, self->priv->standard_sizes_length1, (GDestroyNotify) standard_print_size_unref), NULL);
#line 8415 "Printing.c"
}


GType
print_manager_get_type (void)
{
	static volatile gsize print_manager_type_id__volatile = 0;
	if (g_once_init_enter (&print_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_print_manager_init, value_print_manager_free_value, value_print_manager_copy_value, value_print_manager_peek_pointer, "p", value_print_manager_collect_value, "p", value_print_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PrintManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintManager), 0, (GInstanceInitFunc) print_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType print_manager_type_id;
		print_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PrintManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&print_manager_type_id__volatile, print_manager_type_id);
	}
	return print_manager_type_id__volatile;
}


gpointer
print_manager_ref (gpointer instance)
{
	PrintManager * self;
	self = instance;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_atomic_int_inc (&self->ref_count);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	return instance;
#line 8444 "Printing.c"
}


void
print_manager_unref (gpointer instance)
{
	PrintManager * self;
	self = instance;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		PRINT_MANAGER_GET_CLASS (self)->finalize (self);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8459 "Printing.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



