/* ClockEffect.c generated by valac 0.40.4, the Vala compiler
 * generated from ClockEffect.vala, do not modify */

/* Copyright 2013 Jens Bav
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <shotwell-plugin-dev-1.0.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define TYPE_SHOTWELL_TRANSITION_DESCRIPTOR (shotwell_transition_descriptor_get_type ())
#define SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptor))
#define SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define SHOTWELL_TRANSITION_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))

typedef struct _ShotwellTransitionDescriptor ShotwellTransitionDescriptor;
typedef struct _ShotwellTransitionDescriptorClass ShotwellTransitionDescriptorClass;
typedef struct _ShotwellTransitionDescriptorPrivate ShotwellTransitionDescriptorPrivate;

#define TYPE_CLOCK_EFFECT_DESCRIPTOR (clock_effect_descriptor_get_type ())
#define CLOCK_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLOCK_EFFECT_DESCRIPTOR, ClockEffectDescriptor))
#define CLOCK_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLOCK_EFFECT_DESCRIPTOR, ClockEffectDescriptorClass))
#define IS_CLOCK_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLOCK_EFFECT_DESCRIPTOR))
#define IS_CLOCK_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLOCK_EFFECT_DESCRIPTOR))
#define CLOCK_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLOCK_EFFECT_DESCRIPTOR, ClockEffectDescriptorClass))

typedef struct _ClockEffectDescriptor ClockEffectDescriptor;
typedef struct _ClockEffectDescriptorClass ClockEffectDescriptorClass;
typedef struct _ClockEffectDescriptorPrivate ClockEffectDescriptorPrivate;
enum  {
	CLOCK_EFFECT_DESCRIPTOR_0_PROPERTY,
	CLOCK_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* clock_effect_descriptor_properties[CLOCK_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_CLOCK_EFFECT (clock_effect_get_type ())
#define CLOCK_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLOCK_EFFECT, ClockEffect))
#define CLOCK_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLOCK_EFFECT, ClockEffectClass))
#define IS_CLOCK_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLOCK_EFFECT))
#define IS_CLOCK_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLOCK_EFFECT))
#define CLOCK_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLOCK_EFFECT, ClockEffectClass))

typedef struct _ClockEffect ClockEffect;
typedef struct _ClockEffectClass ClockEffectClass;
typedef struct _ClockEffectPrivate ClockEffectPrivate;
enum  {
	CLOCK_EFFECT_0_PROPERTY,
	CLOCK_EFFECT_NUM_PROPERTIES
};
static GParamSpec* clock_effect_properties[CLOCK_EFFECT_NUM_PROPERTIES];

struct _ShotwellTransitionDescriptor {
	GObject parent_instance;
	ShotwellTransitionDescriptorPrivate * priv;
};

struct _ShotwellTransitionDescriptorClass {
	GObjectClass parent_class;
	const gchar* (*get_id) (ShotwellTransitionDescriptor* self);
	const gchar* (*get_pluggable_name) (ShotwellTransitionDescriptor* self);
	SpitTransitionsEffect* (*create) (ShotwellTransitionDescriptor* self, SpitHostInterface* host);
};

struct _ClockEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	ClockEffectDescriptorPrivate * priv;
};

struct _ClockEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _ClockEffect {
	GObject parent_instance;
	ClockEffectPrivate * priv;
};

struct _ClockEffectClass {
	GObjectClass parent_class;
};


static gpointer clock_effect_descriptor_parent_class = NULL;
static gpointer clock_effect_parent_class = NULL;
static SpitTransitionsEffectIface * clock_effect_spit_transitions_effect_parent_iface = NULL;

GType shotwell_transition_descriptor_get_type (void) G_GNUC_CONST;
GType clock_effect_descriptor_get_type (void) G_GNUC_CONST;
ClockEffectDescriptor* clock_effect_descriptor_new (GFile* resource_directory);
ClockEffectDescriptor* clock_effect_descriptor_construct (GType object_type,
                                                          GFile* resource_directory);
ShotwellTransitionDescriptor* shotwell_transition_descriptor_construct (GType object_type,
                                                                        GFile* resource_directory);
static const gchar* clock_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* clock_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* clock_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                            SpitHostInterface* host);
ClockEffect* clock_effect_new (void);
ClockEffect* clock_effect_construct (GType object_type);
GType clock_effect_get_type (void) G_GNUC_CONST;
#define CLOCK_EFFECT_DESIRED_FPS 25
#define CLOCK_EFFECT_MIN_FPS 15
#define CLOCK_EFFECT_TOP_RADIANT (0.5 * G_PI)
static void clock_effect_real_get_fps (SpitTransitionsEffect* base,
                                gint* desired_fps,
                                gint* min_fps);
static void clock_effect_real_start (SpitTransitionsEffect* base,
                              SpitTransitionsVisuals* visuals,
                              SpitTransitionsMotion* motion);
static gboolean clock_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void clock_effect_real_paint (SpitTransitionsEffect* base,
                              SpitTransitionsVisuals* visuals,
                              SpitTransitionsMotion* motion,
                              cairo_t* ctx,
                              gint width,
                              gint height,
                              gint frame_number);
static void clock_effect_real_advance (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion,
                                gint frame_number);
static void clock_effect_real_cancel (SpitTransitionsEffect* base);


ClockEffectDescriptor*
clock_effect_descriptor_construct (GType object_type,
                                   GFile* resource_directory)
{
	ClockEffectDescriptor * self = NULL;
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	g_return_val_if_fail (G_IS_FILE (resource_directory), NULL);
#line 12 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	self = (ClockEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, resource_directory);
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	return self;
#line 153 "ClockEffect.c"
}


ClockEffectDescriptor*
clock_effect_descriptor_new (GFile* resource_directory)
{
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	return clock_effect_descriptor_construct (TYPE_CLOCK_EFFECT_DESCRIPTOR, resource_directory);
#line 162 "ClockEffect.c"
}


static const gchar*
clock_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	ClockEffectDescriptor * self;
	const gchar* result = NULL;
#line 15 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CLOCK_EFFECT_DESCRIPTOR, ClockEffectDescriptor);
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	result = "org.yorba.shotwell.transitions.clock";
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	return result;
#line 177 "ClockEffect.c"
}


static const gchar*
clock_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	ClockEffectDescriptor * self;
	const gchar* result = NULL;
#line 19 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CLOCK_EFFECT_DESCRIPTOR, ClockEffectDescriptor);
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	result = _ ("Clock");
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	return result;
#line 192 "ClockEffect.c"
}


static SpitTransitionsEffect*
clock_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                     SpitHostInterface* host)
{
	ClockEffectDescriptor * self;
	SpitTransitionsEffect* result = NULL;
	ClockEffect* _tmp0_;
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CLOCK_EFFECT_DESCRIPTOR, ClockEffectDescriptor);
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (host), NULL);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_tmp0_ = clock_effect_new ();
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	return result;
#line 213 "ClockEffect.c"
}


static void
clock_effect_descriptor_class_init (ClockEffectDescriptorClass * klass)
{
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	clock_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor *)) clock_effect_descriptor_real_get_id;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor *)) clock_effect_descriptor_real_get_pluggable_name;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor *, SpitHostInterface*)) clock_effect_descriptor_real_create;
#line 228 "ClockEffect.c"
}


static void
clock_effect_descriptor_instance_init (ClockEffectDescriptor * self)
{
}


GType
clock_effect_descriptor_get_type (void)
{
	static volatile gsize clock_effect_descriptor_type_id__volatile = 0;
	if (g_once_init_enter (&clock_effect_descriptor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClockEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clock_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClockEffectDescriptor), 0, (GInstanceInitFunc) clock_effect_descriptor_instance_init, NULL };
		GType clock_effect_descriptor_type_id;
		clock_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "ClockEffectDescriptor", &g_define_type_info, 0);
		g_once_init_leave (&clock_effect_descriptor_type_id__volatile, clock_effect_descriptor_type_id);
	}
	return clock_effect_descriptor_type_id__volatile;
}


ClockEffect*
clock_effect_construct (GType object_type)
{
	ClockEffect * self = NULL;
#line 33 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	self = (ClockEffect*) g_object_new (object_type, NULL);
#line 33 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	return self;
#line 260 "ClockEffect.c"
}


ClockEffect*
clock_effect_new (void)
{
#line 33 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	return clock_effect_construct (TYPE_CLOCK_EFFECT);
#line 269 "ClockEffect.c"
}


static void
clock_effect_real_get_fps (SpitTransitionsEffect* base,
                           gint* desired_fps,
                           gint* min_fps)
{
	ClockEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
#line 36 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CLOCK_EFFECT, ClockEffect);
#line 37 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_vala_desired_fps = CLOCK_EFFECT_DESIRED_FPS;
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_vala_min_fps = CLOCK_EFFECT_MIN_FPS;
#line 36 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	if (desired_fps) {
#line 36 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		*desired_fps = _vala_desired_fps;
#line 291 "ClockEffect.c"
	}
#line 36 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	if (min_fps) {
#line 36 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		*min_fps = _vala_min_fps;
#line 297 "ClockEffect.c"
	}
}


static void
clock_effect_real_start (SpitTransitionsEffect* base,
                         SpitTransitionsVisuals* visuals,
                         SpitTransitionsMotion* motion)
{
	ClockEffect * self;
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CLOCK_EFFECT, ClockEffect);
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 314 "ClockEffect.c"
}


static gboolean
clock_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	ClockEffect * self;
	gboolean result = FALSE;
#line 44 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CLOCK_EFFECT, ClockEffect);
#line 45 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	result = TRUE;
#line 45 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	return result;
#line 329 "ClockEffect.c"
}


static void
clock_effect_real_paint (SpitTransitionsEffect* base,
                         SpitTransitionsVisuals* visuals,
                         SpitTransitionsMotion* motion,
                         cairo_t* ctx,
                         gint width,
                         gint height,
                         gint frame_number)
{
	ClockEffect * self;
	gdouble alpha = 0.0;
	gdouble start_angle = 0.0;
	gdouble stop_angle = 0.0;
	SpitTransitionsDirection _tmp0_;
	SpitTransitionsDirection _tmp1_;
	gint radius = 0;
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _tmp5_;
	gint _tmp6_;
	GdkRectangle _tmp7_ = {0};
	GdkRectangle _tmp8_;
	gint _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp21_;
	GdkPixbuf* _tmp22_;
#line 48 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CLOCK_EFFECT, ClockEffect);
#line 48 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 48 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 48 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	g_return_if_fail (ctx != NULL);
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	start_angle = -CLOCK_EFFECT_TOP_RADIANT;
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	stop_angle = -CLOCK_EFFECT_TOP_RADIANT;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_tmp0_ = spit_transitions_motion_get_direction (motion);
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_tmp1_ = _tmp0_;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	if (_tmp1_ == SPIT_TRANSITIONS_DIRECTION_FORWARD) {
#line 379 "ClockEffect.c"
		gdouble _tmp2_;
#line 54 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp2_ = alpha;
#line 54 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		stop_angle = ((_tmp2_ * G_PI) * 2) - CLOCK_EFFECT_TOP_RADIANT;
#line 385 "ClockEffect.c"
	} else {
		gdouble _tmp3_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp3_ = alpha;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		start_angle = ((2 * (1 - _tmp3_)) * G_PI) - CLOCK_EFFECT_TOP_RADIANT;
#line 392 "ClockEffect.c"
	}
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	spit_transitions_visuals_get_to_pos (visuals, &_tmp4_);
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_tmp5_ = _tmp4_;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_tmp6_ = _tmp5_.width;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	spit_transitions_visuals_get_to_pos (visuals, &_tmp7_);
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_tmp8_ = _tmp7_;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_tmp9_ = _tmp8_.height;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	radius = (gint) fmax ((gdouble) _tmp6_, (gdouble) _tmp9_);
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_tmp10_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_tmp11_ = _tmp10_;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	if (_tmp11_ != NULL) {
#line 414 "ClockEffect.c"
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkRectangle _tmp14_ = {0};
		GdkRectangle _tmp15_;
		gint _tmp16_;
		GdkRectangle _tmp17_ = {0};
		GdkRectangle _tmp18_;
		gint _tmp19_;
		gdouble _tmp20_;
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp12_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp13_ = _tmp12_;
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		spit_transitions_visuals_get_from_pos (visuals, &_tmp14_);
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp15_ = _tmp14_;
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp16_ = _tmp15_.x;
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		spit_transitions_visuals_get_from_pos (visuals, &_tmp17_);
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp18_ = _tmp17_;
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp19_ = _tmp18_.y;
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		gdk_cairo_set_source_pixbuf (ctx, _tmp13_, (gdouble) _tmp16_, (gdouble) _tmp19_);
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp20_ = alpha;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		cairo_paint_with_alpha (ctx, 1 - _tmp20_);
#line 446 "ClockEffect.c"
	}
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_tmp21_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	_tmp22_ = _tmp21_;
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	if (_tmp22_ != NULL) {
#line 454 "ClockEffect.c"
		GdkPixbuf* _tmp23_;
		GdkPixbuf* _tmp24_;
		GdkRectangle _tmp25_ = {0};
		GdkRectangle _tmp26_;
		gint _tmp27_;
		GdkRectangle _tmp28_ = {0};
		GdkRectangle _tmp29_;
		gint _tmp30_;
		gint x = 0;
		GdkRectangle _tmp31_ = {0};
		GdkRectangle _tmp32_;
		gint _tmp33_;
		GdkRectangle _tmp34_ = {0};
		GdkRectangle _tmp35_;
		gint _tmp36_;
		gint y = 0;
		GdkRectangle _tmp37_ = {0};
		GdkRectangle _tmp38_;
		gint _tmp39_;
		GdkRectangle _tmp40_ = {0};
		GdkRectangle _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gdouble _tmp48_;
		gdouble _tmp49_;
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp23_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp24_ = _tmp23_;
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		spit_transitions_visuals_get_to_pos (visuals, &_tmp25_);
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp26_ = _tmp25_;
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp27_ = _tmp26_.x;
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		spit_transitions_visuals_get_to_pos (visuals, &_tmp28_);
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp29_ = _tmp28_;
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp30_ = _tmp29_.y;
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		gdk_cairo_set_source_pixbuf (ctx, _tmp24_, (gdouble) _tmp27_, (gdouble) _tmp30_);
#line 69 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		spit_transitions_visuals_get_to_pos (visuals, &_tmp31_);
#line 69 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp32_ = _tmp31_;
#line 69 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp33_ = _tmp32_.x;
#line 69 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		spit_transitions_visuals_get_to_pos (visuals, &_tmp34_);
#line 69 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp35_ = _tmp34_;
#line 69 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp36_ = _tmp35_.width;
#line 69 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		x = _tmp33_ + (((gint) _tmp36_) / 2);
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		spit_transitions_visuals_get_to_pos (visuals, &_tmp37_);
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp38_ = _tmp37_;
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp39_ = _tmp38_.y;
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		spit_transitions_visuals_get_to_pos (visuals, &_tmp40_);
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp41_ = _tmp40_;
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp42_ = _tmp41_.height;
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		y = _tmp39_ + (((gint) _tmp42_) / 2);
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp43_ = x;
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp44_ = y;
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		cairo_move_to (ctx, (gdouble) _tmp43_, (gdouble) _tmp44_);
#line 73 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp45_ = x;
#line 73 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp46_ = y;
#line 73 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp47_ = radius;
#line 73 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp48_ = start_angle;
#line 73 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		_tmp49_ = stop_angle;
#line 73 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		cairo_arc (ctx, (gdouble) _tmp45_, (gdouble) _tmp46_, (gdouble) _tmp47_, _tmp48_, _tmp49_);
#line 74 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
		cairo_fill_preserve (ctx);
#line 550 "ClockEffect.c"
	}
}


static void
clock_effect_real_advance (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion,
                           gint frame_number)
{
	ClockEffect * self;
#line 78 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CLOCK_EFFECT, ClockEffect);
#line 78 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 78 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 568 "ClockEffect.c"
}


static void
clock_effect_real_cancel (SpitTransitionsEffect* base)
{
	ClockEffect * self;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CLOCK_EFFECT, ClockEffect);
#line 578 "ClockEffect.c"
}


static void
clock_effect_class_init (ClockEffectClass * klass)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	clock_effect_parent_class = g_type_class_peek_parent (klass);
#line 587 "ClockEffect.c"
}


static void
clock_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	clock_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	iface->get_fps = (void (*) (SpitTransitionsEffect *, gint*, gint*)) clock_effect_real_get_fps;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	iface->start = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*)) clock_effect_real_start;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect *)) clock_effect_real_needs_clear_background;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	iface->paint = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) clock_effect_real_paint;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	iface->advance = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) clock_effect_real_advance;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ClockEffect.vala"
	iface->cancel = (void (*) (SpitTransitionsEffect *)) clock_effect_real_cancel;
#line 608 "ClockEffect.c"
}


static void
clock_effect_instance_init (ClockEffect * self)
{
}


GType
clock_effect_get_type (void)
{
	static volatile gsize clock_effect_type_id__volatile = 0;
	if (g_once_init_enter (&clock_effect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClockEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clock_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClockEffect), 0, (GInstanceInitFunc) clock_effect_instance_init, NULL };
		static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) clock_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clock_effect_type_id;
		clock_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "ClockEffect", &g_define_type_info, 0);
		g_type_add_interface_static (clock_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
		g_once_init_leave (&clock_effect_type_id__volatile, clock_effect_type_id);
	}
	return clock_effect_type_id__volatile;
}



