#!/usr/bin/python

import sys

if len(sys.argv) != 2:
    print >> sys.stderr, 'Usage: mkmbrhdr.py /path/to/mbr.bin'
    sys.exit(1)

mbr = open(sys.argv[1], "rb")
mbr_code = mbr.read(512)
mbr.close()

print >> sys.stderr, 'MBR code is %d bytes' % len(mbr_code)

print """
/*
 * MBR boot code - from syslinux
 */

#ifndef __SYSLINUX_MBR_H__
#define __SYSLINUX_MBR_H__

#define MBR_BOOTCODE_SIZE (440)

#define SYSLINUX_MBR_SIZE (%d)

#if SYSLINUX_MBR_SIZE > MBR_BOOTCODE_SIZE
# error MBR code overlength!
#endif

static UINT8 syslinux_mbr[SYSLINUX_MBR_SIZE] = {""" % len(mbr_code)


wrap = 0
for byte in mbr_code:
    if wrap == 0:
        sys.stdout.write("   ")
        
    sys.stdout.write(" 0x%02x," % ord(byte))
    wrap += 1

    if wrap == 8:
        wrap = 0
        sys.stdout.write("\n")

print """
};

#endif /* __SYSLINUX_MBR_H__ */
"""
