RabbitMQ `3.11.7` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Bug Fixes

 * `direct_exchange_routing_v2` feature flag could sometimes fail to enable on freshly started nodes.

   GitHub issue: [#6847](https://github.com/rabbitmq/rabbitmq-server/pull/6847)

#### Enhancements

 * Improvements to the feature flag subsystem.

   GitHub issues: [#6682](https://github.com/rabbitmq/rabbitmq-server/pull/6682), [#6791](https://github.com/rabbitmq/rabbitmq-server/pull/6791), [#6832](https://github.com/rabbitmq/rabbitmq-server/pull/6832)

 * Preserve additional information in the log message when heartbeat frame cannot
   be sent due to a TCP timeout.

   GitHub issue: [#6708](https://github.com/rabbitmq/rabbitmq-server/pull/6708)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl add_vhost` now coerces a single string value of `--tags` into an array.

   GitHub issue: [#6877](https://github.com/rabbitmq/rabbitmq-server/pull/6877)


### Stream Plugin

#### Bug Fixes

 * Core server did not correctly translate empty stream message bodies to AMQP 0-9-1 when a stream was
   consumed by an AMQP 0-9-1 (as opposed to RabbitMQ Stream protocol) client.

   GitHub issue: [#6835](https://github.com/rabbitmq/rabbitmq-server/pull/6835)


### Web STOMP Plugin

#### Bug Fixes

 * `ERROR` frames delivery is now correctly delivered w.r.t. TCP connection closure for clients that run into
   certain types of exceptions.

   Contributed by @csicar.

   GitHub issue: [#6789](https://github.com/rabbitmq/rabbitmq-server/pull/6789)


## Dependency Upgrades

 * `prometheus.erl` was upgraded [from `4.9.1` to `4.10.0`](https://github.com/deadtrickster/prometheus.erl/tags)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.7.tar.xz`
instead of the source tarball produced by GitHub.
