RabbitMQ `3.11.15` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25 and supports Erlang versions up to `25.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Bug Fixes

 * Operator policies now can define `"ha-sync-mode"`, a classic mirrored queue setting. Note that classic mirrored queues are
   [deprecated and will be removed in RabbitMQ 4.0](https://blog.rabbitmq.com/posts/2021/08/4.0-deprecation-announcements/).

   All users of CMQs should [migrate to quorum queues](https://blog.rabbitmq.com/posts/2023/02/quorum-queues-migration/) or [streams](https://rabbitmq.com/streams.html),
   or a combination of both.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#8043](https://github.com/rabbitmq/rabbitmq-server/pull/8043)


### RPM Package

#### Bug Fixes

 * The package unintentionally limited supported Erlang versions to `<= 25.3.0` instead of `< 26`.

   GitHub issue: [rabbitmq/rabbitmq-packaging#44](https://github.com/rabbitmq/rabbitmq-packaging/pull/44)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.15.tar.xz`
instead of the source tarball produced by GitHub.
