/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

@GwtCompatible
public class UnmodifiableCollectionTests {
    public static void assertMapEntryIsUnmodifiable(Map.Entry<?, ?> entry) {
        try {
            entry.setValue(null);
            TestCase.fail((String)"setValue on unmodifiable Map.Entry succeeded");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static void assertIteratorIsUnmodifiable(Iterator<?> iterator) {
        while (iterator.hasNext()) {
            iterator.next();
            try {
                iterator.remove();
                TestCase.fail((String)"Remove on unmodifiable iterator succeeded");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public static void assertIteratorsInOrder(Iterator<?> expectedIterator, Iterator<?> actualIterator) {
        int i = 0;
        while (expectedIterator.hasNext()) {
            Object expected = expectedIterator.next();
            TestCase.assertTrue((String)("index " + i + " expected <" + expected + "., actual is exhausted"), (boolean)actualIterator.hasNext());
            Object actual = actualIterator.next();
            TestCase.assertEquals((String)("index " + i), expected, actual);
            ++i;
        }
        if (actualIterator.hasNext()) {
            TestCase.fail((String)("index " + i + ", expected is exhausted, actual <" + actualIterator.next() + ">"));
        }
    }

    public static <E> void assertCollectionIsUnmodifiable(Collection<E> collection, E sampleElement) {
        ArrayList<E> siblingCollection = new ArrayList<E>();
        siblingCollection.add(sampleElement);
        ArrayList copy = new ArrayList();
        copy.addAll(collection);
        try {
            collection.add(sampleElement);
            TestCase.fail((String)"add succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
        try {
            collection.addAll(siblingCollection);
            TestCase.fail((String)"addAll succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
        try {
            collection.clear();
            TestCase.fail((String)"clear succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
        UnmodifiableCollectionTests.assertIteratorIsUnmodifiable(collection.iterator());
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
        try {
            collection.remove(sampleElement);
            TestCase.fail((String)"remove succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
        try {
            collection.removeAll(siblingCollection);
            TestCase.fail((String)"removeAll succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
        try {
            collection.retainAll(siblingCollection);
            TestCase.fail((String)"retainAll succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
    }

    public static <E> void assertSetIsUnmodifiable(Set<E> set, E sampleElement) {
        UnmodifiableCollectionTests.assertCollectionIsUnmodifiable(set, sampleElement);
    }

    public static <E> void assertMultisetIsUnmodifiable(Multiset<E> multiset, final E sampleElement) {
        LinkedHashMultiset copy = LinkedHashMultiset.create(multiset);
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
        UnmodifiableCollectionTests.assertCollectionIsUnmodifiable(multiset, sampleElement);
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
        try {
            multiset.add(sampleElement, 2);
            TestCase.fail((String)"add(Object, int) succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
        try {
            multiset.remove(sampleElement, 2);
            TestCase.fail((String)"remove(Object, int) succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
        UnmodifiableCollectionTests.assertSetIsUnmodifiable(multiset.elementSet(), sampleElement);
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
        UnmodifiableCollectionTests.assertSetIsUnmodifiable(multiset.entrySet(), new Multiset.Entry<E>(){

            public int getCount() {
                return 1;
            }

            public E getElement() {
                return sampleElement;
            }
        });
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
    }

    public static <K, V> void assertMultimapIsUnmodifiable(Multimap<K, V> multimap, K sampleKey, V sampleValue) {
        List<Map.Entry<K, V>> originalEntries = Collections.unmodifiableList(Lists.newArrayList((Iterable)multimap.entries()));
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        Set<V> sampleValueAsCollection = Collections.singleton(sampleValue);
        try {
            multimap.clear();
            TestCase.fail((String)"clear succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        UnmodifiableCollectionTests.assertSetIsUnmodifiable(multimap.asMap().entrySet(), Maps.immutableEntry(sampleKey, sampleValueAsCollection));
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        if (!multimap.isEmpty()) {
            Collection values = (Collection)multimap.asMap().entrySet().iterator().next().getValue();
            UnmodifiableCollectionTests.assertCollectionIsUnmodifiable(values, sampleValue);
        }
        UnmodifiableCollectionTests.assertCollectionIsUnmodifiable(multimap.entries(), Maps.immutableEntry(sampleKey, sampleValue));
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        for (Map.Entry entry : multimap.entries()) {
            UnmodifiableCollectionTests.assertMapEntryIsUnmodifiable(entry);
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        UnmodifiableCollectionTests.assertMultisetIsUnmodifiable(multimap.keys(), sampleKey);
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        UnmodifiableCollectionTests.assertSetIsUnmodifiable(multimap.keySet(), sampleKey);
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        if (!multimap.isEmpty()) {
            Object key = multimap.keySet().iterator().next();
            UnmodifiableCollectionTests.assertCollectionIsUnmodifiable(multimap.get(key), sampleValue);
            UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        }
        try {
            multimap.put(sampleKey, sampleValue);
            TestCase.fail((String)"put succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        try {
            multimap.putAll(sampleKey, sampleValueAsCollection);
            TestCase.fail((String)"putAll(K, Iterable) succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        ArrayListMultimap multimap2 = ArrayListMultimap.create();
        multimap2.put(sampleKey, sampleValue);
        try {
            multimap.putAll((Multimap)multimap2);
            TestCase.fail((String)"putAll(Multimap<K, V>) succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        try {
            multimap.remove(sampleKey, sampleValue);
            TestCase.fail((String)"remove succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        try {
            multimap.removeAll(sampleKey);
            TestCase.fail((String)"removeAll succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        try {
            multimap.replaceValues(sampleKey, sampleValueAsCollection);
            TestCase.fail((String)"replaceValues succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        try {
            multimap.asMap().remove(sampleKey);
            TestCase.fail((String)"asMap().remove() succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        if (!multimap.isEmpty()) {
            Object presentKey = multimap.keySet().iterator().next();
            try {
                ((Collection)multimap.asMap().get(presentKey)).remove(sampleValue);
                TestCase.fail((String)"asMap().get().remove() succeeded on unmodifiable multimap");
            }
            catch (UnsupportedOperationException expected) {
                // empty catch block
            }
            UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
            try {
                ((Collection)multimap.asMap().values().iterator().next()).remove(sampleValue);
                TestCase.fail((String)"asMap().values().iterator().next().remove() succeeded on unmodifiable multimap");
            }
            catch (UnsupportedOperationException expected) {
                // empty catch block
            }
            try {
                ((Collection)multimap.asMap().values().toArray()[0]).clear();
                TestCase.fail((String)"asMap().values().toArray()[0].clear() succeeded on unmodifiable multimap");
            }
            catch (UnsupportedOperationException expected) {
                // empty catch block
            }
        }
        UnmodifiableCollectionTests.assertCollectionIsUnmodifiable(multimap.values(), sampleValue);
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
    }

    private static <E> void assertCollectionsAreEquivalent(Collection<E> expected, Collection<E> actual) {
        UnmodifiableCollectionTests.assertIteratorsInOrder(expected.iterator(), actual.iterator());
    }

    private static <K, V> void assertMultimapRemainsUnmodified(Multimap<K, V> expected, List<Map.Entry<K, V>> actual) {
        UnmodifiableCollectionTests.assertIteratorsInOrder(expected.entries().iterator(), actual.iterator());
    }
}

