/*
 * Decompiled with CFR 0.152.
 */
package org.anywikidraw.any.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class HtmlForm {
    private static Random random = new Random();
    private HashMap<String, Parameter> parameters = new HashMap();

    protected static String randomString() {
        return Long.toString(random.nextLong(), 36);
    }

    public static String createBoundary() {
        return "---------------------------" + HtmlForm.randomString() + HtmlForm.randomString() + HtmlForm.randomString();
    }

    public void putString(String string, String string2) {
        StringParameter stringParameter = new StringParameter();
        stringParameter.name = string;
        stringParameter.value = string2;
        this.parameters.put(string, stringParameter);
    }

    public void putFile(String string, String string2, String string3, byte[] byArray) {
        FileParameter fileParameter = new FileParameter();
        fileParameter.name = string;
        fileParameter.filename = string2;
        fileParameter.contentType = string3;
        fileParameter.data = byArray;
        this.parameters.put(string, fileParameter);
    }

    public void putFile(String string, String string2, String string3, InputStream inputStream) throws IOException {
        FileParameter fileParameter = new FileParameter();
        fileParameter.name = string;
        fileParameter.filename = string2;
        fileParameter.contentType = string3;
        byte[] byArray = new byte[512];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        fileParameter.data = byteArrayOutputStream.toByteArray();
        this.parameters.put(string, fileParameter);
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void writeForm(OutputStream outputStream) throws IOException {
        this.writeForm(outputStream, HtmlForm.createBoundary());
    }

    public void writeForm(OutputStream outputStream, String string) throws IOException {
        for (Parameter parameter : this.parameters.values()) {
            parameter.writeParameter(outputStream, string);
        }
        outputStream.write(("--" + string + "\r\n--").getBytes("UTF-8"));
    }

    public static class FileParameter
    extends Parameter {
        String filename;
        String contentType;
        byte[] data;

        @Override
        protected void writeParameter(OutputStream outputStream, String string) throws IOException {
            this.write(outputStream, "--");
            this.write(outputStream, string);
            this.writeName(outputStream, this.name);
            this.write(outputStream, "; filename=\"");
            this.write(outputStream, this.filename);
            this.write(outputStream, "\"");
            this.newline(outputStream);
            this.write(outputStream, "Content-Type: ");
            String string2 = this.contentType;
            if (string2 == null) {
                string2 = "application/octet-stream";
            }
            this.writeln(outputStream, string2);
            this.newline(outputStream);
            outputStream.write(this.data);
            this.newline(outputStream);
        }
    }

    public static abstract class Parameter {
        String name;

        protected abstract void writeParameter(OutputStream var1, String var2) throws IOException;

        protected void write(OutputStream outputStream, String string) throws IOException {
            outputStream.write(string.getBytes("UTF-8"));
        }

        protected void newline(OutputStream outputStream) throws IOException {
            outputStream.write("\r\n".getBytes("UTF-8"));
        }

        protected void writeln(OutputStream outputStream, String string) throws IOException {
            this.write(outputStream, string);
            this.newline(outputStream);
        }

        protected void writeName(OutputStream outputStream, String string) throws IOException {
            this.newline(outputStream);
            this.write(outputStream, "Content-Disposition: form-data; name=\"");
            this.write(outputStream, string);
            this.write(outputStream, "\"");
        }
    }

    public static class StringParameter
    extends Parameter {
        String value;

        @Override
        protected void writeParameter(OutputStream outputStream, String string) throws IOException {
            this.write(outputStream, "--");
            this.write(outputStream, string);
            this.writeName(outputStream, this.name);
            this.newline(outputStream);
            this.newline(outputStream);
            this.writeln(outputStream, this.value);
        }
    }
}

