/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class AutoscrollHelper {
    private int autoscrollMargin = 20;
    private Insets autoscrollInsets = new Insets(0, 0, 0, 0);

    public AutoscrollHelper(int n) {
        this.autoscrollMargin = n;
    }

    public void setAutoscrollMargin(int n) {
        this.autoscrollMargin = n;
    }

    public int getAutoscrollMargin() {
        return this.autoscrollMargin;
    }

    public abstract Dimension getSize();

    public abstract Rectangle getVisibleRect();

    public abstract void scrollRectToVisible(Rectangle var1);

    public void autoscroll(Point point) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getVisibleRect();
        int n5 = rectangle.y + rectangle.height;
        int n6 = rectangle.x + rectangle.width;
        if (point.y - rectangle.y <= this.autoscrollMargin && rectangle.y > 0) {
            n = this.autoscrollMargin;
        }
        if (point.x - rectangle.x <= this.autoscrollMargin && rectangle.x > 0) {
            n2 = this.autoscrollMargin;
        }
        if (n5 - point.y <= this.autoscrollMargin && n5 < dimension.height) {
            n3 = this.autoscrollMargin;
        }
        if (n6 - point.x <= this.autoscrollMargin && n6 < dimension.width) {
            n4 = this.autoscrollMargin;
        }
        rectangle.x += n4 - n2;
        rectangle.y += n3 - n;
        this.scrollRectToVisible(rectangle);
    }

    public Insets getAutoscrollInsets() {
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getVisibleRect();
        this.autoscrollInsets.top = rectangle.y + this.autoscrollMargin;
        this.autoscrollInsets.left = rectangle.x + this.autoscrollMargin;
        this.autoscrollInsets.bottom = dimension.height - (rectangle.y + rectangle.height) + this.autoscrollMargin;
        this.autoscrollInsets.right = dimension.width - (rectangle.x + rectangle.width) + this.autoscrollMargin;
        return this.autoscrollInsets;
    }
}

