
# Copyright (C) 2015 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.

"""Table of functions that have ABI-mandated offsets in the dispatch table.

The first 407 entries are required by indirect GLX. The rest can use any
numbers and don't need this table at all, but that removal is TODO.

The first 407 entries will never change."""
offsets = {
    "NewList": 0,
    "EndList": 1,
    "CallList": 2,
    "CallLists": 3,
    "DeleteLists": 4,
    "GenLists": 5,
    "ListBase": 6,
    "Begin": 7,
    "Bitmap": 8,
    "Color3b": 9,
    "Color3bv": 10,
    "Color3d": 11,
    "Color3dv": 12,
    "Color3f": 13,
    "Color3fv": 14,
    "Color3i": 15,
    "Color3iv": 16,
    "Color3s": 17,
    "Color3sv": 18,
    "Color3ub": 19,
    "Color3ubv": 20,
    "Color3ui": 21,
    "Color3uiv": 22,
    "Color3us": 23,
    "Color3usv": 24,
    "Color4b": 25,
    "Color4bv": 26,
    "Color4d": 27,
    "Color4dv": 28,
    "Color4f": 29,
    "Color4fv": 30,
    "Color4i": 31,
    "Color4iv": 32,
    "Color4s": 33,
    "Color4sv": 34,
    "Color4ub": 35,
    "Color4ubv": 36,
    "Color4ui": 37,
    "Color4uiv": 38,
    "Color4us": 39,
    "Color4usv": 40,
    "EdgeFlag": 41,
    "EdgeFlagv": 42,
    "End": 43,
    "Indexd": 44,
    "Indexdv": 45,
    "Indexf": 46,
    "Indexfv": 47,
    "Indexi": 48,
    "Indexiv": 49,
    "Indexs": 50,
    "Indexsv": 51,
    "Normal3b": 52,
    "Normal3bv": 53,
    "Normal3d": 54,
    "Normal3dv": 55,
    "Normal3f": 56,
    "Normal3fv": 57,
    "Normal3i": 58,
    "Normal3iv": 59,
    "Normal3s": 60,
    "Normal3sv": 61,
    "RasterPos2d": 62,
    "RasterPos2dv": 63,
    "RasterPos2f": 64,
    "RasterPos2fv": 65,
    "RasterPos2i": 66,
    "RasterPos2iv": 67,
    "RasterPos2s": 68,
    "RasterPos2sv": 69,
    "RasterPos3d": 70,
    "RasterPos3dv": 71,
    "RasterPos3f": 72,
    "RasterPos3fv": 73,
    "RasterPos3i": 74,
    "RasterPos3iv": 75,
    "RasterPos3s": 76,
    "RasterPos3sv": 77,
    "RasterPos4d": 78,
    "RasterPos4dv": 79,
    "RasterPos4f": 80,
    "RasterPos4fv": 81,
    "RasterPos4i": 82,
    "RasterPos4iv": 83,
    "RasterPos4s": 84,
    "RasterPos4sv": 85,
    "Rectd": 86,
    "Rectdv": 87,
    "Rectf": 88,
    "Rectfv": 89,
    "Recti": 90,
    "Rectiv": 91,
    "Rects": 92,
    "Rectsv": 93,
    "TexCoord1d": 94,
    "TexCoord1dv": 95,
    "TexCoord1f": 96,
    "TexCoord1fv": 97,
    "TexCoord1i": 98,
    "TexCoord1iv": 99,
    "TexCoord1s": 100,
    "TexCoord1sv": 101,
    "TexCoord2d": 102,
    "TexCoord2dv": 103,
    "TexCoord2f": 104,
    "TexCoord2fv": 105,
    "TexCoord2i": 106,
    "TexCoord2iv": 107,
    "TexCoord2s": 108,
    "TexCoord2sv": 109,
    "TexCoord3d": 110,
    "TexCoord3dv": 111,
    "TexCoord3f": 112,
    "TexCoord3fv": 113,
    "TexCoord3i": 114,
    "TexCoord3iv": 115,
    "TexCoord3s": 116,
    "TexCoord3sv": 117,
    "TexCoord4d": 118,
    "TexCoord4dv": 119,
    "TexCoord4f": 120,
    "TexCoord4fv": 121,
    "TexCoord4i": 122,
    "TexCoord4iv": 123,
    "TexCoord4s": 124,
    "TexCoord4sv": 125,
    "Vertex2d": 126,
    "Vertex2dv": 127,
    "Vertex2f": 128,
    "Vertex2fv": 129,
    "Vertex2i": 130,
    "Vertex2iv": 131,
    "Vertex2s": 132,
    "Vertex2sv": 133,
    "Vertex3d": 134,
    "Vertex3dv": 135,
    "Vertex3f": 136,
    "Vertex3fv": 137,
    "Vertex3i": 138,
    "Vertex3iv": 139,
    "Vertex3s": 140,
    "Vertex3sv": 141,
    "Vertex4d": 142,
    "Vertex4dv": 143,
    "Vertex4f": 144,
    "Vertex4fv": 145,
    "Vertex4i": 146,
    "Vertex4iv": 147,
    "Vertex4s": 148,
    "Vertex4sv": 149,
    "ClipPlane": 150,
    "ColorMaterial": 151,
    "CullFace": 152,
    "Fogf": 153,
    "Fogfv": 154,
    "Fogi": 155,
    "Fogiv": 156,
    "FrontFace": 157,
    "Hint": 158,
    "Lightf": 159,
    "Lightfv": 160,
    "Lighti": 161,
    "Lightiv": 162,
    "LightModelf": 163,
    "LightModelfv": 164,
    "LightModeli": 165,
    "LightModeliv": 166,
    "LineStipple": 167,
    "LineWidth": 168,
    "Materialf": 169,
    "Materialfv": 170,
    "Materiali": 171,
    "Materialiv": 172,
    "PointSize": 173,
    "PolygonMode": 174,
    "PolygonStipple": 175,
    "Scissor": 176,
    "ShadeModel": 177,
    "TexParameterf": 178,
    "TexParameterfv": 179,
    "TexParameteri": 180,
    "TexParameteriv": 181,
    "TexImage1D": 182,
    "TexImage2D": 183,
    "TexEnvf": 184,
    "TexEnvfv": 185,
    "TexEnvi": 186,
    "TexEnviv": 187,
    "TexGend": 188,
    "TexGendv": 189,
    "TexGenf": 190,
    "TexGenfv": 191,
    "TexGeni": 192,
    "TexGeniv": 193,
    "FeedbackBuffer": 194,
    "SelectBuffer": 195,
    "RenderMode": 196,
    "InitNames": 197,
    "LoadName": 198,
    "PassThrough": 199,
    "PopName": 200,
    "PushName": 201,
    "DrawBuffer": 202,
    "Clear": 203,
    "ClearAccum": 204,
    "ClearIndex": 205,
    "ClearColor": 206,
    "ClearStencil": 207,
    "ClearDepth": 208,
    "StencilMask": 209,
    "ColorMask": 210,
    "DepthMask": 211,
    "IndexMask": 212,
    "Accum": 213,
    "Disable": 214,
    "Enable": 215,
    "Finish": 216,
    "Flush": 217,
    "PopAttrib": 218,
    "PushAttrib": 219,
    "Map1d": 220,
    "Map1f": 221,
    "Map2d": 222,
    "Map2f": 223,
    "MapGrid1d": 224,
    "MapGrid1f": 225,
    "MapGrid2d": 226,
    "MapGrid2f": 227,
    "EvalCoord1d": 228,
    "EvalCoord1dv": 229,
    "EvalCoord1f": 230,
    "EvalCoord1fv": 231,
    "EvalCoord2d": 232,
    "EvalCoord2dv": 233,
    "EvalCoord2f": 234,
    "EvalCoord2fv": 235,
    "EvalMesh1": 236,
    "EvalPoint1": 237,
    "EvalMesh2": 238,
    "EvalPoint2": 239,
    "AlphaFunc": 240,
    "BlendFunc": 241,
    "LogicOp": 242,
    "StencilFunc": 243,
    "StencilOp": 244,
    "DepthFunc": 245,
    "PixelZoom": 246,
    "PixelTransferf": 247,
    "PixelTransferi": 248,
    "PixelStoref": 249,
    "PixelStorei": 250,
    "PixelMapfv": 251,
    "PixelMapuiv": 252,
    "PixelMapusv": 253,
    "ReadBuffer": 254,
    "CopyPixels": 255,
    "ReadPixels": 256,
    "DrawPixels": 257,
    "GetBooleanv": 258,
    "GetClipPlane": 259,
    "GetDoublev": 260,
    "GetError": 261,
    "GetFloatv": 262,
    "GetIntegerv": 263,
    "GetLightfv": 264,
    "GetLightiv": 265,
    "GetMapdv": 266,
    "GetMapfv": 267,
    "GetMapiv": 268,
    "GetMaterialfv": 269,
    "GetMaterialiv": 270,
    "GetPixelMapfv": 271,
    "GetPixelMapuiv": 272,
    "GetPixelMapusv": 273,
    "GetPolygonStipple": 274,
    "GetString": 275,
    "GetTexEnvfv": 276,
    "GetTexEnviv": 277,
    "GetTexGendv": 278,
    "GetTexGenfv": 279,
    "GetTexGeniv": 280,
    "GetTexImage": 281,
    "GetTexParameterfv": 282,
    "GetTexParameteriv": 283,
    "GetTexLevelParameterfv": 284,
    "GetTexLevelParameteriv": 285,
    "IsEnabled": 286,
    "IsList": 287,
    "DepthRange": 288,
    "Frustum": 289,
    "LoadIdentity": 290,
    "LoadMatrixf": 291,
    "LoadMatrixd": 292,
    "MatrixMode": 293,
    "MultMatrixf": 294,
    "MultMatrixd": 295,
    "Ortho": 296,
    "PopMatrix": 297,
    "PushMatrix": 298,
    "Rotated": 299,
    "Rotatef": 300,
    "Scaled": 301,
    "Scalef": 302,
    "Translated": 303,
    "Translatef": 304,
    "Viewport": 305,
    "ArrayElement": 306,
    "BindTexture": 307,
    "ColorPointer": 308,
    "DisableClientState": 309,
    "DrawArrays": 310,
    "DrawElements": 311,
    "EdgeFlagPointer": 312,
    "EnableClientState": 313,
    "IndexPointer": 314,
    "Indexub": 315,
    "Indexubv": 316,
    "InterleavedArrays": 317,
    "NormalPointer": 318,
    "PolygonOffset": 319,
    "TexCoordPointer": 320,
    "VertexPointer": 321,
    "AreTexturesResident": 322,
    "CopyTexImage1D": 323,
    "CopyTexImage2D": 324,
    "CopyTexSubImage1D": 325,
    "CopyTexSubImage2D": 326,
    "DeleteTextures": 327,
    "GenTextures": 328,
    "GetPointerv": 329,
    "IsTexture": 330,
    "PrioritizeTextures": 331,
    "TexSubImage1D": 332,
    "TexSubImage2D": 333,
    "PopClientAttrib": 334,
    "PushClientAttrib": 335,
    "BlendColor": 336,
    "BlendEquation": 337,
    "DrawRangeElements": 338,
    "ColorTable": 339,
    "ColorTableParameterfv": 340,
    "ColorTableParameteriv": 341,
    "CopyColorTable": 342,
    "GetColorTable": 343,
    "GetColorTableParameterfv": 344,
    "GetColorTableParameteriv": 345,
    "ColorSubTable": 346,
    "CopyColorSubTable": 347,
    "ConvolutionFilter1D": 348,
    "ConvolutionFilter2D": 349,
    "ConvolutionParameterf": 350,
    "ConvolutionParameterfv": 351,
    "ConvolutionParameteri": 352,
    "ConvolutionParameteriv": 353,
    "CopyConvolutionFilter1D": 354,
    "CopyConvolutionFilter2D": 355,
    "GetConvolutionFilter": 356,
    "GetConvolutionParameterfv": 357,
    "GetConvolutionParameteriv": 358,
    "GetSeparableFilter": 359,
    "SeparableFilter2D": 360,
    "GetHistogram": 361,
    "GetHistogramParameterfv": 362,
    "GetHistogramParameteriv": 363,
    "GetMinmax": 364,
    "GetMinmaxParameterfv": 365,
    "GetMinmaxParameteriv": 366,
    "Histogram": 367,
    "Minmax": 368,
    "ResetHistogram": 369,
    "ResetMinmax": 370,
    "TexImage3D": 371,
    "TexSubImage3D": 372,
    "CopyTexSubImage3D": 373,
    "ActiveTexture": 374,
    "ClientActiveTexture": 375,
    "MultiTexCoord1d": 376,
    "MultiTexCoord1dv": 377,
    "MultiTexCoord1fARB": 378,
    "MultiTexCoord1fvARB": 379,
    "MultiTexCoord1i": 380,
    "MultiTexCoord1iv": 381,
    "MultiTexCoord1s": 382,
    "MultiTexCoord1sv": 383,
    "MultiTexCoord2d": 384,
    "MultiTexCoord2dv": 385,
    "MultiTexCoord2fARB": 386,
    "MultiTexCoord2fvARB": 387,
    "MultiTexCoord2i": 388,
    "MultiTexCoord2iv": 389,
    "MultiTexCoord2s": 390,
    "MultiTexCoord2sv": 391,
    "MultiTexCoord3d": 392,
    "MultiTexCoord3dv": 393,
    "MultiTexCoord3fARB": 394,
    "MultiTexCoord3fvARB": 395,
    "MultiTexCoord3i": 396,
    "MultiTexCoord3iv": 397,
    "MultiTexCoord3s": 398,
    "MultiTexCoord3sv": 399,
    "MultiTexCoord4d": 400,
    "MultiTexCoord4dv": 401,
    "MultiTexCoord4fARB": 402,
    "MultiTexCoord4fvARB": 403,
    "MultiTexCoord4i": 404,
    "MultiTexCoord4iv": 405,
    "MultiTexCoord4s": 406,
    "MultiTexCoord4sv": 407,
    "CompressedTexImage1D": 408,
    "CompressedTexImage2D": 409,
    "CompressedTexImage3D": 410,
    "CompressedTexSubImage1D": 411,
    "CompressedTexSubImage2D": 412,
    "CompressedTexSubImage3D": 413,
    "GetCompressedTexImage": 414,
    "LoadTransposeMatrixd": 415,
    "LoadTransposeMatrixf": 416,
    "MultTransposeMatrixd": 417,
    "MultTransposeMatrixf": 418,
    "SampleCoverage": 419,
    "BlendFuncSeparate": 420,
    "FogCoordPointer": 421,
    "FogCoordd": 422,
    "FogCoorddv": 423,
    "MultiDrawArrays": 424,
    "PointParameterf": 425,
    "PointParameterfv": 426,
    "PointParameteri": 427,
    "PointParameteriv": 428,
    "SecondaryColor3b": 429,
    "SecondaryColor3bv": 430,
    "SecondaryColor3d": 431,
    "SecondaryColor3dv": 432,
    "SecondaryColor3i": 433,
    "SecondaryColor3iv": 434,
    "SecondaryColor3s": 435,
    "SecondaryColor3sv": 436,
    "SecondaryColor3ub": 437,
    "SecondaryColor3ubv": 438,
    "SecondaryColor3ui": 439,
    "SecondaryColor3uiv": 440,
    "SecondaryColor3us": 441,
    "SecondaryColor3usv": 442,
    "SecondaryColorPointer": 443,
    "WindowPos2d": 444,
    "WindowPos2dv": 445,
    "WindowPos2f": 446,
    "WindowPos2fv": 447,
    "WindowPos2i": 448,
    "WindowPos2iv": 449,
    "WindowPos2s": 450,
    "WindowPos2sv": 451,
    "WindowPos3d": 452,
    "WindowPos3dv": 453,
    "WindowPos3f": 454,
    "WindowPos3fv": 455,
    "WindowPos3i": 456,
    "WindowPos3iv": 457,
    "WindowPos3s": 458,
    "WindowPos3sv": 459,
    "BeginQuery": 460,
    "BindBuffer": 461,
    "BufferData": 462,
    "BufferSubData": 463,
    "DeleteBuffers": 464,
    "DeleteQueries": 465,
    "EndQuery": 466,
    "GenBuffers": 467,
    "GenQueries": 468,
    "GetBufferParameteriv": 469,
    "GetBufferPointerv": 470,
    "GetBufferSubData": 471,
    "GetQueryObjectiv": 472,
    "GetQueryObjectuiv": 473,
    "GetQueryiv": 474,
    "IsBuffer": 475,
    "IsQuery": 476,
    "MapBuffer": 477,
    "UnmapBuffer": 478,
    "AttachShader": 479,
    "BindAttribLocation": 480,
    "BlendEquationSeparate": 481,
    "CompileShader": 482,
    "CreateProgram": 483,
    "CreateShader": 484,
    "DeleteProgram": 485,
    "DeleteShader": 486,
    "DetachShader": 487,
    "DisableVertexAttribArray": 488,
    "DrawBuffers": 489,
    "EnableVertexAttribArray": 490,
    "GetActiveAttrib": 491,
    "GetActiveUniform": 492,
    "GetAttachedShaders": 493,
    "GetAttribLocation": 494,
    "GetProgramInfoLog": 495,
    "GetProgramiv": 496,
    "GetShaderInfoLog": 497,
    "GetShaderSource": 498,
    "GetShaderiv": 499,
    "GetUniformLocation": 500,
    "GetUniformfv": 501,
    "GetUniformiv": 502,
    "GetVertexAttribPointerv": 503,
    "GetVertexAttribdv": 504,
    "GetVertexAttribfv": 505,
    "GetVertexAttribiv": 506,
    "IsProgram": 507,
    "IsShader": 508,
    "LinkProgram": 509,
    "ShaderSource": 510,
    "StencilFuncSeparate": 511,
    "StencilMaskSeparate": 512,
    "StencilOpSeparate": 513,
    "Uniform1f": 514,
    "Uniform1fv": 515,
    "Uniform1i": 516,
    "Uniform1iv": 517,
    "Uniform2f": 518,
    "Uniform2fv": 519,
    "Uniform2i": 520,
    "Uniform2iv": 521,
    "Uniform3f": 522,
    "Uniform3fv": 523,
    "Uniform3i": 524,
    "Uniform3iv": 525,
    "Uniform4f": 526,
    "Uniform4fv": 527,
    "Uniform4i": 528,
    "Uniform4iv": 529,
    "UniformMatrix2fv": 530,
    "UniformMatrix3fv": 531,
    "UniformMatrix4fv": 532,
    "UseProgram": 533,
    "ValidateProgram": 534,
    "VertexAttrib1d": 535,
    "VertexAttrib1dv": 536,
    "VertexAttrib1s": 537,
    "VertexAttrib1sv": 538,
    "VertexAttrib2d": 539,
    "VertexAttrib2dv": 540,
    "VertexAttrib2s": 541,
    "VertexAttrib2sv": 542,
    "VertexAttrib3d": 543,
    "VertexAttrib3dv": 544,
    "VertexAttrib3s": 545,
    "VertexAttrib3sv": 546,
    "VertexAttrib4Nbv": 547,
    "VertexAttrib4Niv": 548,
    "VertexAttrib4Nsv": 549,
    "VertexAttrib4Nub": 550,
    "VertexAttrib4Nubv": 551,
    "VertexAttrib4Nuiv": 552,
    "VertexAttrib4Nusv": 553,
    "VertexAttrib4bv": 554,
    "VertexAttrib4d": 555,
    "VertexAttrib4dv": 556,
    "VertexAttrib4iv": 557,
    "VertexAttrib4s": 558,
    "VertexAttrib4sv": 559,
    "VertexAttrib4ubv": 560,
    "VertexAttrib4uiv": 561,
    "VertexAttrib4usv": 562,
    "VertexAttribPointer": 563,
    "UniformMatrix2x3fv": 564,
    "UniformMatrix2x4fv": 565,
    "UniformMatrix3x2fv": 566,
    "UniformMatrix3x4fv": 567,
    "UniformMatrix4x2fv": 568,
    "UniformMatrix4x3fv": 569,
    "BeginConditionalRender": 570,
    "BeginTransformFeedback": 571,
    "BindBufferBase": 572,
    "BindBufferRange": 573,
    "BindFragDataLocation": 574,
    "ClampColor": 575,
    "ClearBufferfi": 576,
    "ClearBufferfv": 577,
    "ClearBufferiv": 578,
    "ClearBufferuiv": 579,
    "ColorMaski": 580,
    "Disablei": 581,
    "Enablei": 582,
    "EndConditionalRender": 583,
    "EndTransformFeedback": 584,
    "GetBooleani_v": 585,
    "GetFragDataLocation": 586,
    "GetIntegeri_v": 587,
    "GetStringi": 588,
    "GetTexParameterIiv": 589,
    "GetTexParameterIuiv": 590,
    "GetTransformFeedbackVarying": 591,
    "GetUniformuiv": 592,
    "GetVertexAttribIiv": 593,
    "GetVertexAttribIuiv": 594,
    "IsEnabledi": 595,
    "TexParameterIiv": 596,
    "TexParameterIuiv": 597,
    "TransformFeedbackVaryings": 598,
    "Uniform1ui": 599,
    "Uniform1uiv": 600,
    "Uniform2ui": 601,
    "Uniform2uiv": 602,
    "Uniform3ui": 603,
    "Uniform3uiv": 604,
    "Uniform4ui": 605,
    "Uniform4uiv": 606,
    "VertexAttribI1iv": 607,
    "VertexAttribI1uiv": 608,
    "VertexAttribI4bv": 609,
    "VertexAttribI4sv": 610,
    "VertexAttribI4ubv": 611,
    "VertexAttribI4usv": 612,
    "VertexAttribIPointer": 613,
    "PrimitiveRestartIndex": 614,
    "TexBuffer": 615,
    "FramebufferTexture": 616,
    "GetBufferParameteri64v": 617,
    "GetInteger64i_v": 618,
    "VertexAttribDivisor": 619,
    "MinSampleShading": 620,
    "MemoryBarrierByRegion": 621,
    "BindProgramARB": 622,
    "DeleteProgramsARB": 623,
    "GenProgramsARB": 624,
    "GetProgramEnvParameterdvARB": 625,
    "GetProgramEnvParameterfvARB": 626,
    "GetProgramLocalParameterdvARB": 627,
    "GetProgramLocalParameterfvARB": 628,
    "GetProgramStringARB": 629,
    "GetProgramivARB": 630,
    "IsProgramARB": 631,
    "ProgramEnvParameter4dARB": 632,
    "ProgramEnvParameter4dvARB": 633,
    "ProgramEnvParameter4fARB": 634,
    "ProgramEnvParameter4fvARB": 635,
    "ProgramLocalParameter4dARB": 636,
    "ProgramLocalParameter4dvARB": 637,
    "ProgramLocalParameter4fARB": 638,
    "ProgramLocalParameter4fvARB": 639,
    "ProgramStringARB": 640,
    "VertexAttrib1fARB": 641,
    "VertexAttrib1fvARB": 642,
    "VertexAttrib2fARB": 643,
    "VertexAttrib2fvARB": 644,
    "VertexAttrib3fARB": 645,
    "VertexAttrib3fvARB": 646,
    "VertexAttrib4fARB": 647,
    "VertexAttrib4fvARB": 648,
    "AttachObjectARB": 649,
    "CreateProgramObjectARB": 650,
    "CreateShaderObjectARB": 651,
    "DeleteObjectARB": 652,
    "DetachObjectARB": 653,
    "GetAttachedObjectsARB": 654,
    "GetHandleARB": 655,
    "GetInfoLogARB": 656,
    "GetObjectParameterfvARB": 657,
    "GetObjectParameterivARB": 658,
    "DrawArraysInstanced": 659,
    "DrawElementsInstanced": 660,
    "BindFramebuffer": 661,
    "BindRenderbuffer": 662,
    "BlitFramebuffer": 663,
    "CheckFramebufferStatus": 664,
    "DeleteFramebuffers": 665,
    "DeleteRenderbuffers": 666,
    "FramebufferRenderbuffer": 667,
    "FramebufferTexture1D": 668,
    "FramebufferTexture2D": 669,
    "FramebufferTexture3D": 670,
    "FramebufferTextureLayer": 671,
    "GenFramebuffers": 672,
    "GenRenderbuffers": 673,
    "GenerateMipmap": 674,
    "GetFramebufferAttachmentParameteriv": 675,
    "GetRenderbufferParameteriv": 676,
    "IsFramebuffer": 677,
    "IsRenderbuffer": 678,
    "RenderbufferStorage": 679,
    "RenderbufferStorageMultisample": 680,
    "FlushMappedBufferRange": 681,
    "MapBufferRange": 682,
    "BindVertexArray": 683,
    "DeleteVertexArrays": 684,
    "GenVertexArrays": 685,
    "IsVertexArray": 686,
    "GetActiveUniformBlockName": 687,
    "GetActiveUniformBlockiv": 688,
    "GetActiveUniformName": 689,
    "GetActiveUniformsiv": 690,
    "GetUniformBlockIndex": 691,
    "GetUniformIndices": 692,
    "UniformBlockBinding": 693,
    "CopyBufferSubData": 694,
    "ClientWaitSync": 695,
    "DeleteSync": 696,
    "FenceSync": 697,
    "GetInteger64v": 698,
    "GetSynciv": 699,
    "IsSync": 700,
    "WaitSync": 701,
    "DrawElementsBaseVertex": 702,
    "DrawElementsInstancedBaseVertex": 703,
    "DrawRangeElementsBaseVertex": 704,
    "MultiDrawElementsBaseVertex": 705,
    "ProvokingVertex": 706,
    "GetMultisamplefv": 707,
    "SampleMaski": 708,
    "TexImage2DMultisample": 709,
    "TexImage3DMultisample": 710,
    "BlendEquationSeparateiARB": 711,
    "BlendEquationiARB": 712,
    "BlendFuncSeparateiARB": 713,
    "BlendFunciARB": 714,
    "BindFragDataLocationIndexed": 715,
    "GetFragDataIndex": 716,
    "BindSampler": 717,
    "DeleteSamplers": 718,
    "GenSamplers": 719,
    "GetSamplerParameterIiv": 720,
    "GetSamplerParameterIuiv": 721,
    "GetSamplerParameterfv": 722,
    "GetSamplerParameteriv": 723,
    "IsSampler": 724,
    "SamplerParameterIiv": 725,
    "SamplerParameterIuiv": 726,
    "SamplerParameterf": 727,
    "SamplerParameterfv": 728,
    "SamplerParameteri": 729,
    "SamplerParameteriv": 730,
    "GetQueryObjecti64v": 731,
    "GetQueryObjectui64v": 732,
    "QueryCounter": 733,
    "ColorP3ui": 734,
    "ColorP3uiv": 735,
    "ColorP4ui": 736,
    "ColorP4uiv": 737,
    "MultiTexCoordP1ui": 738,
    "MultiTexCoordP1uiv": 739,
    "MultiTexCoordP2ui": 740,
    "MultiTexCoordP2uiv": 741,
    "MultiTexCoordP3ui": 742,
    "MultiTexCoordP3uiv": 743,
    "MultiTexCoordP4ui": 744,
    "MultiTexCoordP4uiv": 745,
    "NormalP3ui": 746,
    "NormalP3uiv": 747,
    "SecondaryColorP3ui": 748,
    "SecondaryColorP3uiv": 749,
    "TexCoordP1ui": 750,
    "TexCoordP1uiv": 751,
    "TexCoordP2ui": 752,
    "TexCoordP2uiv": 753,
    "TexCoordP3ui": 754,
    "TexCoordP3uiv": 755,
    "TexCoordP4ui": 756,
    "TexCoordP4uiv": 757,
    "VertexAttribP1ui": 758,
    "VertexAttribP1uiv": 759,
    "VertexAttribP2ui": 760,
    "VertexAttribP2uiv": 761,
    "VertexAttribP3ui": 762,
    "VertexAttribP3uiv": 763,
    "VertexAttribP4ui": 764,
    "VertexAttribP4uiv": 765,
    "VertexP2ui": 766,
    "VertexP2uiv": 767,
    "VertexP3ui": 768,
    "VertexP3uiv": 769,
    "VertexP4ui": 770,
    "VertexP4uiv": 771,
    "DrawArraysIndirect": 772,
    "DrawElementsIndirect": 773,
    "GetUniformdv": 774,
    "Uniform1d": 775,
    "Uniform1dv": 776,
    "Uniform2d": 777,
    "Uniform2dv": 778,
    "Uniform3d": 779,
    "Uniform3dv": 780,
    "Uniform4d": 781,
    "Uniform4dv": 782,
    "UniformMatrix2dv": 783,
    "UniformMatrix2x3dv": 784,
    "UniformMatrix2x4dv": 785,
    "UniformMatrix3dv": 786,
    "UniformMatrix3x2dv": 787,
    "UniformMatrix3x4dv": 788,
    "UniformMatrix4dv": 789,
    "UniformMatrix4x2dv": 790,
    "UniformMatrix4x3dv": 791,
    "GetActiveSubroutineName": 792,
    "GetActiveSubroutineUniformName": 793,
    "GetActiveSubroutineUniformiv": 794,
    "GetProgramStageiv": 795,
    "GetSubroutineIndex": 796,
    "GetSubroutineUniformLocation": 797,
    "GetUniformSubroutineuiv": 798,
    "UniformSubroutinesuiv": 799,
    "PatchParameterfv": 800,
    "PatchParameteri": 801,
    "BindTransformFeedback": 802,
    "DeleteTransformFeedbacks": 803,
    "DrawTransformFeedback": 804,
    "GenTransformFeedbacks": 805,
    "IsTransformFeedback": 806,
    "PauseTransformFeedback": 807,
    "ResumeTransformFeedback": 808,
    "BeginQueryIndexed": 809,
    "DrawTransformFeedbackStream": 810,
    "EndQueryIndexed": 811,
    "GetQueryIndexediv": 812,
    "ClearDepthf": 813,
    "DepthRangef": 814,
    "GetShaderPrecisionFormat": 815,
    "ReleaseShaderCompiler": 816,
    "ShaderBinary": 817,
    "GetProgramBinary": 818,
    "ProgramBinary": 819,
    "ProgramParameteri": 820,
    "GetVertexAttribLdv": 821,
    "VertexAttribL1d": 822,
    "VertexAttribL1dv": 823,
    "VertexAttribL2d": 824,
    "VertexAttribL2dv": 825,
    "VertexAttribL3d": 826,
    "VertexAttribL3dv": 827,
    "VertexAttribL4d": 828,
    "VertexAttribL4dv": 829,
    "VertexAttribLPointer": 830,
    "DepthRangeArrayv": 831,
    "DepthRangeIndexed": 832,
    "GetDoublei_v": 833,
    "GetFloati_v": 834,
    "ScissorArrayv": 835,
    "ScissorIndexed": 836,
    "ScissorIndexedv": 837,
    "ViewportArrayv": 838,
    "ViewportIndexedf": 839,
    "ViewportIndexedfv": 840,
    "GetGraphicsResetStatusARB": 841,
    "GetnColorTableARB": 842,
    "GetnCompressedTexImageARB": 843,
    "GetnConvolutionFilterARB": 844,
    "GetnHistogramARB": 845,
    "GetnMapdvARB": 846,
    "GetnMapfvARB": 847,
    "GetnMapivARB": 848,
    "GetnMinmaxARB": 849,
    "GetnPixelMapfvARB": 850,
    "GetnPixelMapuivARB": 851,
    "GetnPixelMapusvARB": 852,
    "GetnPolygonStippleARB": 853,
    "GetnSeparableFilterARB": 854,
    "GetnTexImageARB": 855,
    "GetnUniformdvARB": 856,
    "GetnUniformfvARB": 857,
    "GetnUniformivARB": 858,
    "GetnUniformuivARB": 859,
    "ReadnPixelsARB": 860,
    "DrawArraysInstancedBaseInstance": 861,
    "DrawElementsInstancedBaseInstance": 862,
    "DrawElementsInstancedBaseVertexBaseInstance": 863,
    "DrawTransformFeedbackInstanced": 864,
    "DrawTransformFeedbackStreamInstanced": 865,
    "GetInternalformativ": 866,
    "GetActiveAtomicCounterBufferiv": 867,
    "BindImageTexture": 868,
    "MemoryBarrier": 869,
    "TexStorage1D": 870,
    "TexStorage2D": 871,
    "TexStorage3D": 872,
    "TextureStorage1DEXT": 873,
    "TextureStorage2DEXT": 874,
    "TextureStorage3DEXT": 875,
    "ClearBufferData": 876,
    "ClearBufferSubData": 877,
    "DispatchCompute": 878,
    "DispatchComputeIndirect": 879,
    "CopyImageSubData": 880,
    "TextureView": 881,
    "BindVertexBuffer": 882,
    "VertexAttribBinding": 883,
    "VertexAttribFormat": 884,
    "VertexAttribIFormat": 885,
    "VertexAttribLFormat": 886,
    "VertexBindingDivisor": 887,
    "FramebufferParameteri": 888,
    "GetFramebufferParameteriv": 889,
    "GetInternalformati64v": 890,
    "MultiDrawArraysIndirect": 891,
    "MultiDrawElementsIndirect": 892,
    "GetProgramInterfaceiv": 893,
    "GetProgramResourceIndex": 894,
    "GetProgramResourceLocation": 895,
    "GetProgramResourceLocationIndex": 896,
    "GetProgramResourceName": 897,
    "GetProgramResourceiv": 898,
    "ShaderStorageBlockBinding": 899,
    "TexBufferRange": 900,
    "TexStorage2DMultisample": 901,
    "TexStorage3DMultisample": 902,
    "BufferStorage": 903,
    "ClearTexImage": 904,
    "ClearTexSubImage": 905,
    "BindBuffersBase": 906,
    "BindBuffersRange": 907,
    "BindImageTextures": 908,
    "BindSamplers": 909,
    "BindTextures": 910,
    "BindVertexBuffers": 911,
    "GetImageHandleARB": 912,
    "GetTextureHandleARB": 913,
    "GetTextureSamplerHandleARB": 914,
    "GetVertexAttribLui64vARB": 915,
    "IsImageHandleResidentARB": 916,
    "IsTextureHandleResidentARB": 917,
    "MakeImageHandleNonResidentARB": 918,
    "MakeImageHandleResidentARB": 919,
    "MakeTextureHandleNonResidentARB": 920,
    "MakeTextureHandleResidentARB": 921,
    "ProgramUniformHandleui64ARB": 922,
    "ProgramUniformHandleui64vARB": 923,
    "UniformHandleui64ARB": 924,
    "UniformHandleui64vARB": 925,
    "VertexAttribL1ui64ARB": 926,
    "VertexAttribL1ui64vARB": 927,
    "DispatchComputeGroupSizeARB": 928,
    "MultiDrawArraysIndirectCountARB": 929,
    "MultiDrawElementsIndirectCountARB": 930,
    "ClipControl": 931,
    "BindTextureUnit": 932,
    "BlitNamedFramebuffer": 933,
    "CheckNamedFramebufferStatus": 934,
    "ClearNamedBufferData": 935,
    "ClearNamedBufferSubData": 936,
    "ClearNamedFramebufferfi": 937,
    "ClearNamedFramebufferfv": 938,
    "ClearNamedFramebufferiv": 939,
    "ClearNamedFramebufferuiv": 940,
    "CompressedTextureSubImage1D": 941,
    "CompressedTextureSubImage2D": 942,
    "CompressedTextureSubImage3D": 943,
    "CopyNamedBufferSubData": 944,
    "CopyTextureSubImage1D": 945,
    "CopyTextureSubImage2D": 946,
    "CopyTextureSubImage3D": 947,
    "CreateBuffers": 948,
    "CreateFramebuffers": 949,
    "CreateProgramPipelines": 950,
    "CreateQueries": 951,
    "CreateRenderbuffers": 952,
    "CreateSamplers": 953,
    "CreateTextures": 954,
    "CreateTransformFeedbacks": 955,
    "CreateVertexArrays": 956,
    "DisableVertexArrayAttrib": 957,
    "EnableVertexArrayAttrib": 958,
    "FlushMappedNamedBufferRange": 959,
    "GenerateTextureMipmap": 960,
    "GetCompressedTextureImage": 961,
    "GetNamedBufferParameteri64v": 962,
    "GetNamedBufferParameteriv": 963,
    "GetNamedBufferPointerv": 964,
    "GetNamedBufferSubData": 965,
    "GetNamedFramebufferAttachmentParameteriv": 966,
    "GetNamedFramebufferParameteriv": 967,
    "GetNamedRenderbufferParameteriv": 968,
    "GetQueryBufferObjecti64v": 969,
    "GetQueryBufferObjectiv": 970,
    "GetQueryBufferObjectui64v": 971,
    "GetQueryBufferObjectuiv": 972,
    "GetTextureImage": 973,
    "GetTextureLevelParameterfv": 974,
    "GetTextureLevelParameteriv": 975,
    "GetTextureParameterIiv": 976,
    "GetTextureParameterIuiv": 977,
    "GetTextureParameterfv": 978,
    "GetTextureParameteriv": 979,
    "GetTransformFeedbacki64_v": 980,
    "GetTransformFeedbacki_v": 981,
    "GetTransformFeedbackiv": 982,
    "GetVertexArrayIndexed64iv": 983,
    "GetVertexArrayIndexediv": 984,
    "GetVertexArrayiv": 985,
    "InvalidateNamedFramebufferData": 986,
    "InvalidateNamedFramebufferSubData": 987,
    "MapNamedBuffer": 988,
    "MapNamedBufferRange": 989,
    "NamedBufferData": 990,
    "NamedBufferStorage": 991,
    "NamedBufferSubData": 992,
    "NamedFramebufferDrawBuffer": 993,
    "NamedFramebufferDrawBuffers": 994,
    "NamedFramebufferParameteri": 995,
    "NamedFramebufferReadBuffer": 996,
    "NamedFramebufferRenderbuffer": 997,
    "NamedFramebufferTexture": 998,
    "NamedFramebufferTextureLayer": 999,
    "NamedRenderbufferStorage": 1000,
    "NamedRenderbufferStorageMultisample": 1001,
    "TextureBuffer": 1002,
    "TextureBufferRange": 1003,
    "TextureParameterIiv": 1004,
    "TextureParameterIuiv": 1005,
    "TextureParameterf": 1006,
    "TextureParameterfv": 1007,
    "TextureParameteri": 1008,
    "TextureParameteriv": 1009,
    "TextureStorage1D": 1010,
    "TextureStorage2D": 1011,
    "TextureStorage2DMultisample": 1012,
    "TextureStorage3D": 1013,
    "TextureStorage3DMultisample": 1014,
    "TextureSubImage1D": 1015,
    "TextureSubImage2D": 1016,
    "TextureSubImage3D": 1017,
    "TransformFeedbackBufferBase": 1018,
    "TransformFeedbackBufferRange": 1019,
    "UnmapNamedBufferEXT": 1020,
    "VertexArrayAttribBinding": 1021,
    "VertexArrayAttribFormat": 1022,
    "VertexArrayAttribIFormat": 1023,
    "VertexArrayAttribLFormat": 1024,
    "VertexArrayBindingDivisor": 1025,
    "VertexArrayElementBuffer": 1026,
    "VertexArrayVertexBuffer": 1027,
    "VertexArrayVertexBuffers": 1028,
    "GetCompressedTextureSubImage": 1029,
    "GetTextureSubImage": 1030,
    "BufferPageCommitmentARB": 1031,
    "NamedBufferPageCommitmentARB": 1032,
    "GetUniformi64vARB": 1033,
    "GetUniformui64vARB": 1034,
    "GetnUniformi64vARB": 1035,
    "GetnUniformui64vARB": 1036,
    "ProgramUniform1i64ARB": 1037,
    "ProgramUniform1i64vARB": 1038,
    "ProgramUniform1ui64ARB": 1039,
    "ProgramUniform1ui64vARB": 1040,
    "ProgramUniform2i64ARB": 1041,
    "ProgramUniform2i64vARB": 1042,
    "ProgramUniform2ui64ARB": 1043,
    "ProgramUniform2ui64vARB": 1044,
    "ProgramUniform3i64ARB": 1045,
    "ProgramUniform3i64vARB": 1046,
    "ProgramUniform3ui64ARB": 1047,
    "ProgramUniform3ui64vARB": 1048,
    "ProgramUniform4i64ARB": 1049,
    "ProgramUniform4i64vARB": 1050,
    "ProgramUniform4ui64ARB": 1051,
    "ProgramUniform4ui64vARB": 1052,
    "Uniform1i64ARB": 1053,
    "Uniform1i64vARB": 1054,
    "Uniform1ui64ARB": 1055,
    "Uniform1ui64vARB": 1056,
    "Uniform2i64ARB": 1057,
    "Uniform2i64vARB": 1058,
    "Uniform2ui64ARB": 1059,
    "Uniform2ui64vARB": 1060,
    "Uniform3i64ARB": 1061,
    "Uniform3i64vARB": 1062,
    "Uniform3ui64ARB": 1063,
    "Uniform3ui64vARB": 1064,
    "Uniform4i64ARB": 1065,
    "Uniform4i64vARB": 1066,
    "Uniform4ui64ARB": 1067,
    "Uniform4ui64vARB": 1068,
    "EvaluateDepthValuesARB": 1069,
    "FramebufferSampleLocationsfvARB": 1070,
    "NamedFramebufferSampleLocationsfvARB": 1071,
    "SpecializeShaderARB": 1072,
    "InvalidateBufferData": 1073,
    "InvalidateBufferSubData": 1074,
    "InvalidateFramebuffer": 1075,
    "InvalidateSubFramebuffer": 1076,
    "InvalidateTexImage": 1077,
    "InvalidateTexSubImage": 1078,
    "DrawTexfOES": 1079,
    "DrawTexfvOES": 1080,
    "DrawTexiOES": 1081,
    "DrawTexivOES": 1082,
    "DrawTexsOES": 1083,
    "DrawTexsvOES": 1084,
    "DrawTexxOES": 1085,
    "DrawTexxvOES": 1086,
    "PointSizePointerOES": 1087,
    "QueryMatrixxOES": 1088,
    "SampleMaskSGIS": 1089,
    "SamplePatternSGIS": 1090,
    "ColorPointerEXT": 1091,
    "EdgeFlagPointerEXT": 1092,
    "IndexPointerEXT": 1093,
    "NormalPointerEXT": 1094,
    "TexCoordPointerEXT": 1095,
    "VertexPointerEXT": 1096,
    "DiscardFramebufferEXT": 1097,
    "ActiveShaderProgram": 1098,
    "BindProgramPipeline": 1099,
    "CreateShaderProgramv": 1100,
    "DeleteProgramPipelines": 1101,
    "GenProgramPipelines": 1102,
    "GetProgramPipelineInfoLog": 1103,
    "GetProgramPipelineiv": 1104,
    "IsProgramPipeline": 1105,
    "LockArraysEXT": 1106,
    "ProgramUniform1d": 1107,
    "ProgramUniform1dv": 1108,
    "ProgramUniform1f": 1109,
    "ProgramUniform1fv": 1110,
    "ProgramUniform1i": 1111,
    "ProgramUniform1iv": 1112,
    "ProgramUniform1ui": 1113,
    "ProgramUniform1uiv": 1114,
    "ProgramUniform2d": 1115,
    "ProgramUniform2dv": 1116,
    "ProgramUniform2f": 1117,
    "ProgramUniform2fv": 1118,
    "ProgramUniform2i": 1119,
    "ProgramUniform2iv": 1120,
    "ProgramUniform2ui": 1121,
    "ProgramUniform2uiv": 1122,
    "ProgramUniform3d": 1123,
    "ProgramUniform3dv": 1124,
    "ProgramUniform3f": 1125,
    "ProgramUniform3fv": 1126,
    "ProgramUniform3i": 1127,
    "ProgramUniform3iv": 1128,
    "ProgramUniform3ui": 1129,
    "ProgramUniform3uiv": 1130,
    "ProgramUniform4d": 1131,
    "ProgramUniform4dv": 1132,
    "ProgramUniform4f": 1133,
    "ProgramUniform4fv": 1134,
    "ProgramUniform4i": 1135,
    "ProgramUniform4iv": 1136,
    "ProgramUniform4ui": 1137,
    "ProgramUniform4uiv": 1138,
    "ProgramUniformMatrix2dv": 1139,
    "ProgramUniformMatrix2fv": 1140,
    "ProgramUniformMatrix2x3dv": 1141,
    "ProgramUniformMatrix2x3fv": 1142,
    "ProgramUniformMatrix2x4dv": 1143,
    "ProgramUniformMatrix2x4fv": 1144,
    "ProgramUniformMatrix3dv": 1145,
    "ProgramUniformMatrix3fv": 1146,
    "ProgramUniformMatrix3x2dv": 1147,
    "ProgramUniformMatrix3x2fv": 1148,
    "ProgramUniformMatrix3x4dv": 1149,
    "ProgramUniformMatrix3x4fv": 1150,
    "ProgramUniformMatrix4dv": 1151,
    "ProgramUniformMatrix4fv": 1152,
    "ProgramUniformMatrix4x2dv": 1153,
    "ProgramUniformMatrix4x2fv": 1154,
    "ProgramUniformMatrix4x3dv": 1155,
    "ProgramUniformMatrix4x3fv": 1156,
    "UnlockArraysEXT": 1157,
    "UseProgramStages": 1158,
    "ValidateProgramPipeline": 1159,
    "FramebufferTexture2DMultisampleEXT": 1160,
    "DebugMessageCallback": 1161,
    "DebugMessageControl": 1162,
    "DebugMessageInsert": 1163,
    "GetDebugMessageLog": 1164,
    "GetObjectLabel": 1165,
    "GetObjectPtrLabel": 1166,
    "ObjectLabel": 1167,
    "ObjectPtrLabel": 1168,
    "PopDebugGroup": 1169,
    "PushDebugGroup": 1170,
    "SecondaryColor3fEXT": 1171,
    "SecondaryColor3fvEXT": 1172,
    "MultiDrawElements": 1173,
    "FogCoordfEXT": 1174,
    "FogCoordfvEXT": 1175,
    "ResizeBuffersMESA": 1176,
    "WindowPos4dMESA": 1177,
    "WindowPos4dvMESA": 1178,
    "WindowPos4fMESA": 1179,
    "WindowPos4fvMESA": 1180,
    "WindowPos4iMESA": 1181,
    "WindowPos4ivMESA": 1182,
    "WindowPos4sMESA": 1183,
    "WindowPos4svMESA": 1184,
    "MultiModeDrawArraysIBM": 1185,
    "MultiModeDrawElementsIBM": 1186,
    "AreProgramsResidentNV": 1187,
    "ExecuteProgramNV": 1188,
    "GetProgramParameterdvNV": 1189,
    "GetProgramParameterfvNV": 1190,
    "GetProgramStringNV": 1191,
    "GetProgramivNV": 1192,
    "GetTrackMatrixivNV": 1193,
    "GetVertexAttribdvNV": 1194,
    "GetVertexAttribfvNV": 1195,
    "GetVertexAttribivNV": 1196,
    "LoadProgramNV": 1197,
    "ProgramParameters4dvNV": 1198,
    "ProgramParameters4fvNV": 1199,
    "RequestResidentProgramsNV": 1200,
    "TrackMatrixNV": 1201,
    "VertexAttrib1dNV": 1202,
    "VertexAttrib1dvNV": 1203,
    "VertexAttrib1fNV": 1204,
    "VertexAttrib1fvNV": 1205,
    "VertexAttrib1sNV": 1206,
    "VertexAttrib1svNV": 1207,
    "VertexAttrib2dNV": 1208,
    "VertexAttrib2dvNV": 1209,
    "VertexAttrib2fNV": 1210,
    "VertexAttrib2fvNV": 1211,
    "VertexAttrib2sNV": 1212,
    "VertexAttrib2svNV": 1213,
    "VertexAttrib3dNV": 1214,
    "VertexAttrib3dvNV": 1215,
    "VertexAttrib3fNV": 1216,
    "VertexAttrib3fvNV": 1217,
    "VertexAttrib3sNV": 1218,
    "VertexAttrib3svNV": 1219,
    "VertexAttrib4dNV": 1220,
    "VertexAttrib4dvNV": 1221,
    "VertexAttrib4fNV": 1222,
    "VertexAttrib4fvNV": 1223,
    "VertexAttrib4sNV": 1224,
    "VertexAttrib4svNV": 1225,
    "VertexAttrib4ubNV": 1226,
    "VertexAttrib4ubvNV": 1227,
    "VertexAttribPointerNV": 1228,
    "VertexAttribs1dvNV": 1229,
    "VertexAttribs1fvNV": 1230,
    "VertexAttribs1svNV": 1231,
    "VertexAttribs2dvNV": 1232,
    "VertexAttribs2fvNV": 1233,
    "VertexAttribs2svNV": 1234,
    "VertexAttribs3dvNV": 1235,
    "VertexAttribs3fvNV": 1236,
    "VertexAttribs3svNV": 1237,
    "VertexAttribs4dvNV": 1238,
    "VertexAttribs4fvNV": 1239,
    "VertexAttribs4svNV": 1240,
    "VertexAttribs4ubvNV": 1241,
    "GetTexBumpParameterfvATI": 1242,
    "GetTexBumpParameterivATI": 1243,
    "TexBumpParameterfvATI": 1244,
    "TexBumpParameterivATI": 1245,
    "AlphaFragmentOp1ATI": 1246,
    "AlphaFragmentOp2ATI": 1247,
    "AlphaFragmentOp3ATI": 1248,
    "BeginFragmentShaderATI": 1249,
    "BindFragmentShaderATI": 1250,
    "ColorFragmentOp1ATI": 1251,
    "ColorFragmentOp2ATI": 1252,
    "ColorFragmentOp3ATI": 1253,
    "DeleteFragmentShaderATI": 1254,
    "EndFragmentShaderATI": 1255,
    "GenFragmentShadersATI": 1256,
    "PassTexCoordATI": 1257,
    "SampleMapATI": 1258,
    "SetFragmentShaderConstantATI": 1259,
    "DepthRangeArrayfvOES": 1260,
    "DepthRangeIndexedfOES": 1261,
    "ActiveStencilFaceEXT": 1262,
    "GetProgramNamedParameterdvNV": 1263,
    "GetProgramNamedParameterfvNV": 1264,
    "ProgramNamedParameter4dNV": 1265,
    "ProgramNamedParameter4dvNV": 1266,
    "ProgramNamedParameter4fNV": 1267,
    "ProgramNamedParameter4fvNV": 1268,
    "PrimitiveRestartNV": 1269,
    "GetTexGenxvOES": 1270,
    "TexGenxOES": 1271,
    "TexGenxvOES": 1272,
    "DepthBoundsEXT": 1273,
    "BindFramebufferEXT": 1274,
    "BindRenderbufferEXT": 1275,
    "StringMarkerGREMEDY": 1276,
    "BufferParameteriAPPLE": 1277,
    "FlushMappedBufferRangeAPPLE": 1278,
    "VertexAttribI1iEXT": 1279,
    "VertexAttribI1uiEXT": 1280,
    "VertexAttribI2iEXT": 1281,
    "VertexAttribI2ivEXT": 1282,
    "VertexAttribI2uiEXT": 1283,
    "VertexAttribI2uivEXT": 1284,
    "VertexAttribI3iEXT": 1285,
    "VertexAttribI3ivEXT": 1286,
    "VertexAttribI3uiEXT": 1287,
    "VertexAttribI3uivEXT": 1288,
    "VertexAttribI4iEXT": 1289,
    "VertexAttribI4ivEXT": 1290,
    "VertexAttribI4uiEXT": 1291,
    "VertexAttribI4uivEXT": 1292,
    "ClearColorIiEXT": 1293,
    "ClearColorIuiEXT": 1294,
    "BindBufferOffsetEXT": 1295,
    "BeginPerfMonitorAMD": 1296,
    "DeletePerfMonitorsAMD": 1297,
    "EndPerfMonitorAMD": 1298,
    "GenPerfMonitorsAMD": 1299,
    "GetPerfMonitorCounterDataAMD": 1300,
    "GetPerfMonitorCounterInfoAMD": 1301,
    "GetPerfMonitorCounterStringAMD": 1302,
    "GetPerfMonitorCountersAMD": 1303,
    "GetPerfMonitorGroupStringAMD": 1304,
    "GetPerfMonitorGroupsAMD": 1305,
    "SelectPerfMonitorCountersAMD": 1306,
    "GetObjectParameterivAPPLE": 1307,
    "ObjectPurgeableAPPLE": 1308,
    "ObjectUnpurgeableAPPLE": 1309,
    "ActiveProgramEXT": 1310,
    "CreateShaderProgramEXT": 1311,
    "UseShaderProgramEXT": 1312,
    "TextureBarrierNV": 1313,
    "VDPAUFiniNV": 1314,
    "VDPAUGetSurfaceivNV": 1315,
    "VDPAUInitNV": 1316,
    "VDPAUIsSurfaceNV": 1317,
    "VDPAUMapSurfacesNV": 1318,
    "VDPAURegisterOutputSurfaceNV": 1319,
    "VDPAURegisterVideoSurfaceNV": 1320,
    "VDPAUSurfaceAccessNV": 1321,
    "VDPAUUnmapSurfacesNV": 1322,
    "VDPAUUnregisterSurfaceNV": 1323,
    "BeginPerfQueryINTEL": 1324,
    "CreatePerfQueryINTEL": 1325,
    "DeletePerfQueryINTEL": 1326,
    "EndPerfQueryINTEL": 1327,
    "GetFirstPerfQueryIdINTEL": 1328,
    "GetNextPerfQueryIdINTEL": 1329,
    "GetPerfCounterInfoINTEL": 1330,
    "GetPerfQueryDataINTEL": 1331,
    "GetPerfQueryIdByNameINTEL": 1332,
    "GetPerfQueryInfoINTEL": 1333,
    "PolygonOffsetClampEXT": 1334,
    "SubpixelPrecisionBiasNV": 1335,
    "ConservativeRasterParameterfNV": 1336,
    "ConservativeRasterParameteriNV": 1337,
    "WindowRectanglesEXT": 1338,
    "BufferStorageMemEXT": 1339,
    "CreateMemoryObjectsEXT": 1340,
    "DeleteMemoryObjectsEXT": 1341,
    "DeleteSemaphoresEXT": 1342,
    "GenSemaphoresEXT": 1343,
    "GetMemoryObjectParameterivEXT": 1344,
    "GetSemaphoreParameterui64vEXT": 1345,
    "GetUnsignedBytei_vEXT": 1346,
    "GetUnsignedBytevEXT": 1347,
    "IsMemoryObjectEXT": 1348,
    "IsSemaphoreEXT": 1349,
    "MemoryObjectParameterivEXT": 1350,
    "NamedBufferStorageMemEXT": 1351,
    "SemaphoreParameterui64vEXT": 1352,
    "SignalSemaphoreEXT": 1353,
    "TexStorageMem1DEXT": 1354,
    "TexStorageMem2DEXT": 1355,
    "TexStorageMem2DMultisampleEXT": 1356,
    "TexStorageMem3DEXT": 1357,
    "TexStorageMem3DMultisampleEXT": 1358,
    "TextureStorageMem1DEXT": 1359,
    "TextureStorageMem2DEXT": 1360,
    "TextureStorageMem2DMultisampleEXT": 1361,
    "TextureStorageMem3DEXT": 1362,
    "TextureStorageMem3DMultisampleEXT": 1363,
    "WaitSemaphoreEXT": 1364,
    "ImportMemoryFdEXT": 1365,
    "ImportSemaphoreFdEXT": 1366,
    "FramebufferFetchBarrierEXT": 1367,
    "NamedRenderbufferStorageMultisampleAdvancedAMD": 1368,
    "RenderbufferStorageMultisampleAdvancedAMD": 1369,
    "StencilFuncSeparateATI": 1370,
    "ProgramEnvParameters4fvEXT": 1371,
    "ProgramLocalParameters4fvEXT": 1372,
    "EGLImageTargetRenderbufferStorageOES": 1373,
    "EGLImageTargetTexture2DOES": 1374,
    "AlphaFuncx": 1375,
    "ClearColorx": 1376,
    "ClearDepthx": 1377,
    "Color4x": 1378,
    "DepthRangex": 1379,
    "Fogx": 1380,
    "Fogxv": 1381,
    "Frustumf": 1382,
    "Frustumx": 1383,
    "LightModelx": 1384,
    "LightModelxv": 1385,
    "Lightx": 1386,
    "Lightxv": 1387,
    "LineWidthx": 1388,
    "LoadMatrixx": 1389,
    "Materialx": 1390,
    "Materialxv": 1391,
    "MultMatrixx": 1392,
    "MultiTexCoord4x": 1393,
    "Normal3x": 1394,
    "Orthof": 1395,
    "Orthox": 1396,
    "PointSizex": 1397,
    "PolygonOffsetx": 1398,
    "Rotatex": 1399,
    "SampleCoveragex": 1400,
    "Scalex": 1401,
    "TexEnvx": 1402,
    "TexEnvxv": 1403,
    "TexParameterx": 1404,
    "Translatex": 1405,
    "ClipPlanef": 1406,
    "ClipPlanex": 1407,
    "GetClipPlanef": 1408,
    "GetClipPlanex": 1409,
    "GetFixedv": 1410,
    "GetLightxv": 1411,
    "GetMaterialxv": 1412,
    "GetTexEnvxv": 1413,
    "GetTexParameterxv": 1414,
    "PointParameterx": 1415,
    "PointParameterxv": 1416,
    "TexParameterxv": 1417,
    "BlendBarrier": 1418,
    "PrimitiveBoundingBox": 1419,
    "MaxShaderCompilerThreadsKHR": 1420,
    "MatrixLoadfEXT": 1421,
    "MatrixLoaddEXT": 1422,
    "MatrixMultfEXT": 1423,
    "MatrixMultdEXT": 1424,
    "MatrixLoadIdentityEXT": 1425,
    "MatrixRotatefEXT": 1426,
    "MatrixRotatedEXT": 1427,
    "MatrixScalefEXT": 1428,
    "MatrixScaledEXT": 1429,
    "MatrixTranslatefEXT": 1430,
    "MatrixTranslatedEXT": 1431,
    "MatrixOrthoEXT": 1432,
    "MatrixFrustumEXT": 1433,
    "MatrixPushEXT": 1434,
    "MatrixPopEXT": 1435,
    "MatrixLoadTransposefEXT": 1436,
    "MatrixLoadTransposedEXT": 1437,
    "MatrixMultTransposefEXT": 1438,
    "MatrixMultTransposedEXT": 1439,
    "BindMultiTextureEXT": 1440,
    "NamedBufferDataEXT": 1441,
    "NamedBufferSubDataEXT": 1442,
    "NamedBufferStorageEXT": 1443,
    "MapNamedBufferRangeEXT": 1444,
    "TextureImage1DEXT": 1445,
    "TextureImage2DEXT": 1446,
    "TextureImage3DEXT": 1447,
    "TextureSubImage1DEXT": 1448,
    "TextureSubImage2DEXT": 1449,
    "TextureSubImage3DEXT": 1450,
    "CopyTextureImage1DEXT": 1451,
    "CopyTextureImage2DEXT": 1452,
    "CopyTextureSubImage1DEXT": 1453,
    "CopyTextureSubImage2DEXT": 1454,
    "CopyTextureSubImage3DEXT": 1455,
    "MapNamedBufferEXT": 1456,
    "GetTextureParameterivEXT": 1457,
    "GetTextureParameterfvEXT": 1458,
    "TextureParameteriEXT": 1459,
    "TextureParameterivEXT": 1460,
    "TextureParameterfEXT": 1461,
    "TextureParameterfvEXT": 1462,
    "GetTextureImageEXT": 1463,
    "GetTextureLevelParameterivEXT": 1464,
    "GetTextureLevelParameterfvEXT": 1465,
    "GetNamedBufferSubDataEXT": 1466,
    "GetNamedBufferPointervEXT": 1467,
    "GetNamedBufferParameterivEXT": 1468,
    "FlushMappedNamedBufferRangeEXT": 1469,
    "FramebufferDrawBufferEXT": 1470,
    "FramebufferDrawBuffersEXT": 1471,
    "FramebufferReadBufferEXT": 1472,
    "GetFramebufferParameterivEXT": 1473,
    "CheckNamedFramebufferStatusEXT": 1474,
    "NamedFramebufferTexture1DEXT": 1475,
    "NamedFramebufferTexture2DEXT": 1476,
    "NamedFramebufferTexture3DEXT": 1477,
    "NamedFramebufferRenderbufferEXT": 1478,
    "GetNamedFramebufferAttachmentParameterivEXT": 1479,
    "EnableClientStateiEXT": 1480,
    "DisableClientStateiEXT": 1481,
    "GetPointerIndexedvEXT": 1482,
    "MultiTexEnviEXT": 1483,
    "MultiTexEnvivEXT": 1484,
    "MultiTexEnvfEXT": 1485,
    "MultiTexEnvfvEXT": 1486,
    "GetMultiTexEnvivEXT": 1487,
    "GetMultiTexEnvfvEXT": 1488,
    "MultiTexParameteriEXT": 1489,
    "MultiTexParameterivEXT": 1490,
    "MultiTexParameterfEXT": 1491,
    "MultiTexParameterfvEXT": 1492,
    "GetMultiTexImageEXT": 1493,
    "MultiTexImage1DEXT": 1494,
    "MultiTexImage2DEXT": 1495,
    "MultiTexImage3DEXT": 1496,
    "MultiTexSubImage1DEXT": 1497,
    "MultiTexSubImage2DEXT": 1498,
    "MultiTexSubImage3DEXT": 1499,
    "GetMultiTexParameterivEXT": 1500,
    "GetMultiTexParameterfvEXT": 1501,
    "CopyMultiTexImage1DEXT": 1502,
    "CopyMultiTexImage2DEXT": 1503,
    "CopyMultiTexSubImage1DEXT": 1504,
    "CopyMultiTexSubImage2DEXT": 1505,
    "CopyMultiTexSubImage3DEXT": 1506,
    "MultiTexGendEXT": 1507,
    "MultiTexGendvEXT": 1508,
    "MultiTexGenfEXT": 1509,
    "MultiTexGenfvEXT": 1510,
    "MultiTexGeniEXT": 1511,
    "MultiTexGenivEXT": 1512,
    "GetMultiTexGendvEXT": 1513,
    "GetMultiTexGenfvEXT": 1514,
    "GetMultiTexGenivEXT": 1515,
    "MultiTexCoordPointerEXT": 1516,
    "BindImageTextureEXT": 1517,
    "CompressedTextureImage1DEXT": 1518,
    "CompressedTextureImage2DEXT": 1519,
    "CompressedTextureImage3DEXT": 1520,
    "CompressedTextureSubImage1DEXT": 1521,
    "CompressedTextureSubImage2DEXT": 1522,
    "CompressedTextureSubImage3DEXT": 1523,
    "GetCompressedTextureImageEXT": 1524,
    "CompressedMultiTexImage1DEXT": 1525,
    "CompressedMultiTexImage2DEXT": 1526,
    "CompressedMultiTexImage3DEXT": 1527,
    "CompressedMultiTexSubImage1DEXT": 1528,
    "CompressedMultiTexSubImage2DEXT": 1529,
    "CompressedMultiTexSubImage3DEXT": 1530,
    "GetCompressedMultiTexImageEXT": 1531,
    "GetMultiTexLevelParameterivEXT": 1532,
    "GetMultiTexLevelParameterfvEXT": 1533,
    "FramebufferParameteriMESA": 1534,
    "GetFramebufferParameterivMESA": 1535,
    "NamedRenderbufferStorageEXT": 1536,
    "GetNamedRenderbufferParameterivEXT": 1537,
    "ClientAttribDefaultEXT": 1538,
    "PushClientAttribDefaultEXT": 1539,
    "NamedProgramStringEXT": 1540,
    "GetNamedProgramStringEXT": 1541,
    "NamedProgramLocalParameter4fEXT": 1542,
    "NamedProgramLocalParameter4fvEXT": 1543,
    "GetNamedProgramLocalParameterfvEXT": 1544,
    "NamedProgramLocalParameter4dEXT": 1545,
    "NamedProgramLocalParameter4dvEXT": 1546,
    "GetNamedProgramLocalParameterdvEXT": 1547,
    "GetNamedProgramivEXT": 1548,
    "TextureBufferEXT": 1549,
    "MultiTexBufferEXT": 1550,
    "TextureParameterIivEXT": 1551,
    "TextureParameterIuivEXT": 1552,
    "GetTextureParameterIivEXT": 1553,
    "GetTextureParameterIuivEXT": 1554,
    "MultiTexParameterIivEXT": 1555,
    "MultiTexParameterIuivEXT": 1556,
    "GetMultiTexParameterIivEXT": 1557,
    "GetMultiTexParameterIuivEXT": 1558,
    "NamedProgramLocalParameters4fvEXT": 1559,
    "GenerateTextureMipmapEXT": 1560,
    "GenerateMultiTexMipmapEXT": 1561,
    "NamedRenderbufferStorageMultisampleEXT": 1562,
    "NamedCopyBufferSubDataEXT": 1563,
    "VertexArrayVertexOffsetEXT": 1564,
    "VertexArrayColorOffsetEXT": 1565,
    "VertexArrayEdgeFlagOffsetEXT": 1566,
    "VertexArrayIndexOffsetEXT": 1567,
    "VertexArrayNormalOffsetEXT": 1568,
    "VertexArrayTexCoordOffsetEXT": 1569,
    "VertexArrayMultiTexCoordOffsetEXT": 1570,
    "VertexArrayFogCoordOffsetEXT": 1571,
    "VertexArraySecondaryColorOffsetEXT": 1572,
    "VertexArrayVertexAttribOffsetEXT": 1573,
    "VertexArrayVertexAttribIOffsetEXT": 1574,
    "EnableVertexArrayEXT": 1575,
    "DisableVertexArrayEXT": 1576,
    "EnableVertexArrayAttribEXT": 1577,
    "DisableVertexArrayAttribEXT": 1578,
    "GetVertexArrayIntegervEXT": 1579,
    "GetVertexArrayPointervEXT": 1580,
    "GetVertexArrayIntegeri_vEXT": 1581,
    "GetVertexArrayPointeri_vEXT": 1582,
    "ClearNamedBufferDataEXT": 1583,
    "ClearNamedBufferSubDataEXT": 1584,
    "NamedFramebufferParameteriEXT": 1585,
    "GetNamedFramebufferParameterivEXT": 1586,
    "VertexArrayVertexAttribLOffsetEXT": 1587,
    "VertexArrayVertexAttribDivisorEXT": 1588,
    "TextureBufferRangeEXT": 1589,
    "TextureStorage2DMultisampleEXT": 1590,
    "TextureStorage3DMultisampleEXT": 1591,
    "VertexArrayBindVertexBufferEXT": 1592,
    "VertexArrayVertexAttribFormatEXT": 1593,
    "VertexArrayVertexAttribIFormatEXT": 1594,
    "VertexArrayVertexAttribLFormatEXT": 1595,
    "VertexArrayVertexAttribBindingEXT": 1596,
    "VertexArrayVertexBindingDivisorEXT": 1597,
    "NamedBufferPageCommitmentEXT": 1598,
    "NamedStringARB": 1599,
    "DeleteNamedStringARB": 1600,
    "CompileShaderIncludeARB": 1601,
    "IsNamedStringARB": 1602,
    "GetNamedStringARB": 1603,
    "GetNamedStringivARB": 1604,
    "EGLImageTargetTexStorageEXT" : 1605,
    "EGLImageTargetTextureStorageEXT" : 1606,
    "CopyImageSubDataNV": 1607,
    "ViewportSwizzleNV": 1608,
    "AlphaToCoverageDitherControlNV": 1609,
    "InternalBufferSubDataCopyMESA": 1610,
    "Vertex2hNV": 1611,
    "Vertex2hvNV": 1612,
    "Vertex3hNV": 1613,
    "Vertex3hvNV": 1614,
    "Vertex4hNV": 1615,
    "Vertex4hvNV": 1616,
    "Normal3hNV": 1617,
    "Normal3hvNV": 1618,
    "Color3hNV": 1619,
    "Color3hvNV": 1620,
    "Color4hNV": 1621,
    "Color4hvNV": 1622,
    "TexCoord1hNV": 1623,
    "TexCoord1hvNV": 1624,
    "TexCoord2hNV": 1625,
    "TexCoord2hvNV": 1626,
    "TexCoord3hNV": 1627,
    "TexCoord3hvNV": 1628,
    "TexCoord4hNV": 1629,
    "TexCoord4hvNV": 1630,
    "MultiTexCoord1hNV": 1631,
    "MultiTexCoord1hvNV": 1632,
    "MultiTexCoord2hNV": 1633,
    "MultiTexCoord2hvNV": 1634,
    "MultiTexCoord3hNV": 1635,
    "MultiTexCoord3hvNV": 1636,
    "MultiTexCoord4hNV": 1637,
    "MultiTexCoord4hvNV": 1638,
    "FogCoordhNV": 1639,
    "FogCoordhvNV": 1640,
    "SecondaryColor3hNV": 1641,
    "SecondaryColor3hvNV": 1642,
    "InternalSetError": 1643,
    "VertexAttrib1hNV": 1644,
    "VertexAttrib1hvNV": 1645,
    "VertexAttrib2hNV": 1646,
    "VertexAttrib2hvNV": 1647,
    "VertexAttrib3hNV": 1648,
    "VertexAttrib3hvNV": 1649,
    "VertexAttrib4hNV": 1650,
    "VertexAttrib4hvNV": 1651,
    "VertexAttribs1hvNV": 1652,
    "VertexAttribs2hvNV": 1653,
    "VertexAttribs3hvNV": 1654,
    "VertexAttribs4hvNV": 1655,
    "TexPageCommitmentARB": 1656,
    "TexturePageCommitmentEXT": 1657,
    "ImportMemoryWin32HandleEXT": 1658,
    "ImportSemaphoreWin32HandleEXT": 1659,
    "ImportMemoryWin32NameEXT": 1660,
    "ImportSemaphoreWin32NameEXT": 1661,
    "GetObjectLabelEXT": 1662,
    "LabelObjectEXT": 1663,
    "DrawArraysUserBuf": 1664,
    "DrawElementsUserBuf": 1665,
    "MultiDrawArraysUserBuf": 1666,
    "MultiDrawElementsUserBuf": 1667,
    "DrawArraysInstancedBaseInstanceDrawID": 1668,
    "DrawElementsInstancedBaseVertexBaseInstanceDrawID": 1669,
    "InternalInvalidateFramebufferAncillaryMESA": 1670,
    "DrawElementsPacked": 1671,
    "DrawElementsUserBufPacked": 1672,
    "TexStorageAttribs2DEXT": 1673,
    "TexStorageAttribs3DEXT": 1674,
    "FramebufferTextureMultiviewOVR": 1675,
    "NamedFramebufferTextureMultiviewOVR": 1676,
    "FramebufferTextureMultisampleMultiviewOVR": 1677,
}

functions = [
    "Accum",
    "ActiveShaderProgram",
    "ActiveTexture",
    "ActiveTextureARB",
    "AlphaFunc",
    "AlphaFuncx",
    "AreTexturesResident",
    "AreTexturesResidentEXT",
    "ArrayElement",
    "ArrayElementEXT",
    "AttachObjectARB",
    "AttachShader",
    "Begin",
    "BeginConditionalRender",
    "BeginConditionalRenderNV",
    "BeginQuery",
    "BeginQueryARB",
    "BeginQueryIndexed",
    "BeginTransformFeedback",
    "BindAttribLocation",
    "BindAttribLocationARB",
    "BindBuffer",
    "BindBufferARB",
    "BindBufferBase",
    "BindBufferRange",
    "BindBuffersBase",
    "BindBuffersRange",
    "BindFragDataLocation",
    "BindFragDataLocationEXT",
    "BindFragDataLocationIndexed",
    "BindFramebuffer",
    "BindFramebufferEXT",
    "BindImageTexture",
    "BindImageTextures",
    "BindProgramARB",
    "BindProgramPipeline",
    "BindRenderbuffer",
    "BindRenderbufferEXT",
    "BindSampler",
    "BindSamplers",
    "BindTexture",
    "BindTextureEXT",
    "BindTextures",
    "BindTransformFeedback",
    "BindVertexArray",
    "BindVertexBuffer",
    "BindVertexBuffers",
    "Bitmap",
    "BlendBarrier",
    "BlendColor",
    "BlendColorEXT",
    "BlendEquation",
    "BlendEquationEXT",
    "BlendEquationi",
    "BlendEquationiARB",
    "BlendEquationSeparate",
    "BlendEquationSeparatei",
    "BlendEquationSeparateiARB",
    "BlendFunc",
    "BlendFunci",
    "BlendFunciARB",
    "BlendFuncSeparate",
    "BlendFuncSeparateEXT",
    "BlendFuncSeparatei",
    "BlendFuncSeparateiARB",
    "BlitFramebuffer",
    "BufferData",
    "BufferDataARB",
    "BufferStorage",
    "BufferSubData",
    "BufferSubDataARB",
    "CallList",
    "CallLists",
    "CheckFramebufferStatus",
    "CheckFramebufferStatusEXT",
    "ClampColor",
    "ClampColorARB",
    "Clear",
    "ClearAccum",
    "ClearBufferData",
    "ClearBufferfi",
    "ClearBufferfv",
    "ClearBufferiv",
    "ClearBufferSubData",
    "ClearBufferuiv",
    "ClearColor",
    "ClearColorIiEXT",
    "ClearColorIuiEXT",
    "ClearColorx",
    "ClearDepth",
    "ClearDepthf",
    "ClearDepthx",
    "ClearIndex",
    "ClearStencil",
    "ClearTexImage",
    "ClearTexSubImage",
    "ClientActiveTexture",
    "ClientActiveTextureARB",
    "ClientWaitSync",
    "ClipPlane",
    "ClipPlanef",
    "ClipPlanex",
    "Color3b",
    "Color3bv",
    "Color3d",
    "Color3dv",
    "Color3f",
    "Color3fv",
    "Color3i",
    "Color3iv",
    "Color3s",
    "Color3sv",
    "Color3ub",
    "Color3ubv",
    "Color3ui",
    "Color3uiv",
    "Color3us",
    "Color3usv",
    "Color4b",
    "Color4bv",
    "Color4d",
    "Color4dv",
    "Color4f",
    "Color4fv",
    "Color4i",
    "Color4iv",
    "Color4s",
    "Color4sv",
    "Color4ub",
    "Color4ubv",
    "Color4ui",
    "Color4uiv",
    "Color4us",
    "Color4usv",
    "Color4x",
    "ColorMask",
    "ColorMaski",
    "ColorMaskIndexedEXT",
    "ColorMaterial",
    "ColorP3ui",
    "ColorP3uiv",
    "ColorP4ui",
    "ColorP4uiv",
    "ColorPointer",
    "ColorPointerEXT",
    "ColorSubTable",
    "ColorTable",
    "ColorTableParameterfv",
    "ColorTableParameteriv",
    "CompileShader",
    "CompileShaderARB",
    "CompressedTexImage1D",
    "CompressedTexImage1DARB",
    "CompressedTexImage2D",
    "CompressedTexImage2DARB",
    "CompressedTexImage3D",
    "CompressedTexImage3DARB",
    "CompressedTexSubImage1D",
    "CompressedTexSubImage1DARB",
    "CompressedTexSubImage2D",
    "CompressedTexSubImage2DARB",
    "CompressedTexSubImage3D",
    "CompressedTexSubImage3DARB",
    "ConvolutionFilter1D",
    "ConvolutionFilter2D",
    "ConvolutionParameterf",
    "ConvolutionParameterfv",
    "ConvolutionParameteri",
    "ConvolutionParameteriv",
    "CopyBufferSubData",
    "CopyColorSubTable",
    "CopyColorTable",
    "CopyConvolutionFilter1D",
    "CopyConvolutionFilter2D",
    "CopyImageSubData",
    "CopyPixels",
    "CopyTexImage1D",
    "CopyTexImage2D",
    "CopyTexSubImage1D",
    "CopyTexSubImage2D",
    "CopyTexSubImage3D",
    "CopyTexSubImage3DEXT",
    "CreateProgram",
    "CreateProgramObjectARB",
    "CreateShader",
    "CreateShaderObjectARB",
    "CreateShaderProgramv",
    "CullFace",
    "DebugMessageCallback",
    "DebugMessageCallbackARB",
    "DebugMessageControl",
    "DebugMessageControlARB",
    "DebugMessageInsert",
    "DebugMessageInsertARB",
    "DeleteBuffers",
    "DeleteBuffersARB",
    "DeleteFramebuffers",
    "DeleteFramebuffersEXT",
    "DeleteLists",
    "DeleteObjectARB",
    "DeleteProgram",
    "DeleteProgramPipelines",
    "DeleteProgramsARB",
    "DeleteQueries",
    "DeleteQueriesARB",
    "DeleteRenderbuffers",
    "DeleteRenderbuffersEXT",
    "DeleteSamplers",
    "DeleteShader",
    "DeleteSync",
    "DeleteTextures",
    "DeleteTexturesEXT",
    "DeleteTransformFeedbacks",
    "DeleteVertexArrays",
    "DepthFunc",
    "DepthMask",
    "DepthRange",
    "DepthRangeArrayv",
    "DepthRangef",
    "DepthRangeIndexed",
    "DepthRangex",
    "DetachObjectARB",
    "DetachShader",
    "Disable",
    "DisableClientState",
    "Disablei",
    "DisableIndexedEXT",
    "DisableVertexAttribArray",
    "DisableVertexAttribArrayARB",
    "DispatchCompute",
    "DispatchComputeIndirect",
    "DrawArrays",
    "DrawArraysEXT",
    "DrawArraysIndirect",
    "DrawArraysInstanced",
    "DrawArraysInstancedARB",
    "DrawArraysInstancedBaseInstance",
    "DrawArraysInstancedEXT",
    "DrawBuffer",
    "DrawBuffers",
    "DrawBuffersARB",
    "DrawBuffersATI",
    "DrawElements",
    "DrawElementsBaseVertex",
    "DrawElementsIndirect",
    "DrawElementsInstanced",
    "DrawElementsInstancedARB",
    "DrawElementsInstancedBaseInstance",
    "DrawElementsInstancedBaseVertex",
    "DrawElementsInstancedBaseVertexBaseInstance",
    "DrawElementsInstancedEXT",
    "DrawPixels",
    "DrawRangeElements",
    "DrawRangeElementsBaseVertex",
    "DrawRangeElementsEXT",
    "DrawTransformFeedback",
    "DrawTransformFeedbackInstanced",
    "DrawTransformFeedbackStream",
    "DrawTransformFeedbackStreamInstanced",
    "EdgeFlag",
    "EdgeFlagPointer",
    "EdgeFlagPointerEXT",
    "EdgeFlagv",
    "Enable",
    "EnableClientState",
    "Enablei",
    "EnableIndexedEXT",
    "EnableVertexAttribArray",
    "EnableVertexAttribArrayARB",
    "End",
    "EndConditionalRender",
    "EndConditionalRenderNV",
    "EndList",
    "EndQuery",
    "EndQueryARB",
    "EndQueryIndexed",
    "EndTransformFeedback",
    "EvalCoord1d",
    "EvalCoord1dv",
    "EvalCoord1f",
    "EvalCoord1fv",
    "EvalCoord2d",
    "EvalCoord2dv",
    "EvalCoord2f",
    "EvalCoord2fv",
    "EvalMesh1",
    "EvalMesh2",
    "EvalPoint1",
    "EvalPoint2",
    "FeedbackBuffer",
    "FenceSync",
    "Finish",
    "Flush",
    "FlushMappedBufferRange",
    "FogCoordd",
    "FogCoorddEXT",
    "FogCoorddv",
    "FogCoorddvEXT",
    "FogCoordf",
    "FogCoordfEXT",
    "FogCoordfv",
    "FogCoordfvEXT",
    "FogCoordPointer",
    "FogCoordPointerEXT",
    "Fogf",
    "Fogfv",
    "Fogi",
    "Fogiv",
    "Fogx",
    "Fogxv",
    "FramebufferParameteri",
    "FramebufferRenderbuffer",
    "FramebufferRenderbufferEXT",
    "FramebufferTexture",
    "FramebufferTexture1D",
    "FramebufferTexture1DEXT",
    "FramebufferTexture2D",
    "FramebufferTexture2DEXT",
    "FramebufferTexture3D",
    "FramebufferTexture3DEXT",
    "FramebufferTextureARB",
    "FramebufferTextureLayer",
    "FramebufferTextureLayerARB",
    "FramebufferTextureLayerEXT",
    "FramebufferTextureMultisampleMultiviewOVR",
    "FramebufferTextureMultiviewOVR",
    "FrontFace",
    "Frustum",
    "Frustumf",
    "Frustumx",
    "GenBuffers",
    "GenBuffersARB",
    "GenerateMipmap",
    "GenerateMipmapEXT",
    "GenFramebuffers",
    "GenFramebuffersEXT",
    "GenLists",
    "GenProgramPipelines",
    "GenProgramsARB",
    "GenQueries",
    "GenQueriesARB",
    "GenRenderbuffers",
    "GenRenderbuffersEXT",
    "GenSamplers",
    "GenTextures",
    "GenTexturesEXT",
    "GenTransformFeedbacks",
    "GenVertexArrays",
    "GetActiveAtomicCounterBufferiv",
    "GetActiveAttrib",
    "GetActiveAttribARB",
    "GetActiveUniform",
    "GetActiveUniformARB",
    "GetActiveUniformBlockiv",
    "GetActiveUniformBlockName",
    "GetActiveUniformName",
    "GetActiveUniformsiv",
    "GetAttachedObjectsARB",
    "GetAttachedShaders",
    "GetAttribLocation",
    "GetAttribLocationARB",
    "GetBooleani_v",
    "GetBooleanIndexedvEXT",
    "GetBooleanv",
    "GetBufferParameteri64v",
    "GetBufferParameteriv",
    "GetBufferParameterivARB",
    "GetBufferPointerv",
    "GetBufferPointervARB",
    "GetBufferSubData",
    "GetBufferSubDataARB",
    "GetClipPlane",
    "GetClipPlanef",
    "GetClipPlanex",
    "GetColorTable",
    "GetColorTableParameterfv",
    "GetColorTableParameteriv",
    "GetCompressedTexImage",
    "GetCompressedTexImageARB",
    "GetConvolutionFilter",
    "GetConvolutionParameterfv",
    "GetConvolutionParameteriv",
    "GetDebugMessageLog",
    "GetDebugMessageLogARB",
    "GetDoublei_v",
    "GetDoublev",
    "GetError",
    "GetFixedv",
    "GetFloati_v",
    "GetFloatv",
    "GetFragDataIndex",
    "GetFragDataLocation",
    "GetFragDataLocationEXT",
    "GetFramebufferAttachmentParameteriv",
    "GetFramebufferAttachmentParameterivEXT",
    "GetFramebufferParameteriv",
    "GetGraphicsResetStatus",
    "GetGraphicsResetStatusARB",
    "GetHandleARB",
    "GetHistogram",
    "GetHistogramParameterfv",
    "GetHistogramParameteriv",
    "GetInfoLogARB",
    "GetInteger64i_v",
    "GetInteger64v",
    "GetIntegeri_v",
    "GetIntegerIndexedvEXT",
    "GetIntegerv",
    "GetLightfv",
    "GetLightiv",
    "GetLightxv",
    "GetMapdv",
    "GetMapfv",
    "GetMapiv",
    "GetMaterialfv",
    "GetMaterialiv",
    "GetMaterialxv",
    "GetMinmax",
    "GetMinmaxParameterfv",
    "GetMinmaxParameteriv",
    "GetMultisamplefv",
    "GetnColorTableARB",
    "GetnCompressedTexImageARB",
    "GetnConvolutionFilterARB",
    "GetnHistogramARB",
    "GetnMapdvARB",
    "GetnMapfvARB",
    "GetnMapivARB",
    "GetnMinmaxARB",
    "GetnPixelMapfvARB",
    "GetnPixelMapuivARB",
    "GetnPixelMapusvARB",
    "GetnPolygonStippleARB",
    "GetnSeparableFilterARB",
    "GetnTexImageARB",
    "GetnUniformdvARB",
    "GetnUniformfv",
    "GetnUniformfvARB",
    "GetnUniformiv",
    "GetnUniformivARB",
    "GetnUniformuiv",
    "GetnUniformuivARB",
    "GetObjectLabel",
    "GetObjectLabelEXT",
    "GetObjectParameterfvARB",
    "GetObjectParameterivARB",
    "GetObjectPtrLabel",
    "GetPixelMapfv",
    "GetPixelMapuiv",
    "GetPixelMapusv",
    "GetPointerv",
    "GetPointervEXT",
    "GetPolygonStipple",
    "GetProgramBinary",
    "GetProgramEnvParameterdvARB",
    "GetProgramEnvParameterfvARB",
    "GetProgramInfoLog",
    "GetProgramInterfaceiv",
    "GetProgramiv",
    "GetProgramivARB",
    "GetProgramLocalParameterdvARB",
    "GetProgramLocalParameterfvARB",
    "GetProgramPipelineInfoLog",
    "GetProgramPipelineiv",
    "GetProgramResourceIndex",
    "GetProgramResourceiv",
    "GetProgramResourceLocation",
    "GetProgramResourceName",
    "GetProgramStringARB",
    "GetQueryIndexediv",
    "GetQueryiv",
    "GetQueryivARB",
    "GetQueryObjectiv",
    "GetQueryObjectivARB",
    "GetQueryObjectuiv",
    "GetQueryObjectuivARB",
    "GetRenderbufferParameteriv",
    "GetRenderbufferParameterivEXT",
    "GetSamplerParameterfv",
    "GetSamplerParameterIiv",
    "GetSamplerParameterIuiv",
    "GetSamplerParameteriv",
    "GetSeparableFilter",
    "GetShaderInfoLog",
    "GetShaderiv",
    "GetShaderPrecisionFormat",
    "GetShaderSource",
    "GetShaderSourceARB",
    "GetString",
    "GetStringi",
    "GetSynciv",
    "GetTexEnvfv",
    "GetTexEnviv",
    "GetTexEnvxv",
    "GetTexGendv",
    "GetTexGenfv",
    "GetTexGeniv",
    "GetTexImage",
    "GetTexLevelParameterfv",
    "GetTexLevelParameteriv",
    "GetTexParameterfv",
    "GetTexParameterIiv",
    "GetTexParameterIivEXT",
    "GetTexParameterIuiv",
    "GetTexParameterIuivEXT",
    "GetTexParameteriv",
    "GetTexParameterxv",
    "GetTransformFeedbackVarying",
    "GetUniformBlockIndex",
    "GetUniformfv",
    "GetUniformfvARB",
    "GetUniformIndices",
    "GetUniformiv",
    "GetUniformivARB",
    "GetUniformLocation",
    "GetUniformLocationARB",
    "GetUniformuiv",
    "GetUniformuivEXT",
    "GetVertexAttribdv",
    "GetVertexAttribdvARB",
    "GetVertexAttribfv",
    "GetVertexAttribfvARB",
    "GetVertexAttribIiv",
    "GetVertexAttribIivEXT",
    "GetVertexAttribIuiv",
    "GetVertexAttribIuivEXT",
    "GetVertexAttribiv",
    "GetVertexAttribivARB",
    "GetVertexAttribPointerv",
    "GetVertexAttribPointervARB",
    "Hint",
    "Histogram",
    "Indexd",
    "Indexdv",
    "Indexf",
    "Indexfv",
    "Indexi",
    "Indexiv",
    "IndexMask",
    "IndexPointer",
    "IndexPointerEXT",
    "Indexs",
    "Indexsv",
    "Indexub",
    "Indexubv",
    "InitNames",
    "InterleavedArrays",
    "InvalidateBufferData",
    "InvalidateBufferSubData",
    "InvalidateFramebuffer",
    "InvalidateSubFramebuffer",
    "InvalidateTexImage",
    "InvalidateTexSubImage",
    "IsBuffer",
    "IsBufferARB",
    "IsEnabled",
    "IsEnabledi",
    "IsEnabledIndexedEXT",
    "IsFramebuffer",
    "IsFramebufferEXT",
    "IsList",
    "IsProgram",
    "IsProgramARB",
    "IsProgramPipeline",
    "IsQuery",
    "IsQueryARB",
    "IsRenderbuffer",
    "IsRenderbufferEXT",
    "IsSampler",
    "IsShader",
    "IsSync",
    "IsTexture",
    "IsTextureEXT",
    "IsTransformFeedback",
    "IsVertexArray",
    "LabelObjectEXT",
    "Lightf",
    "Lightfv",
    "Lighti",
    "Lightiv",
    "LightModelf",
    "LightModelfv",
    "LightModeli",
    "LightModeliv",
    "LightModelx",
    "LightModelxv",
    "Lightx",
    "Lightxv",
    "LineStipple",
    "LineWidth",
    "LineWidthx",
    "LinkProgram",
    "LinkProgramARB",
    "ListBase",
    "LoadIdentity",
    "LoadMatrixd",
    "LoadMatrixf",
    "LoadMatrixx",
    "LoadName",
    "LoadTransposeMatrixd",
    "LoadTransposeMatrixdARB",
    "LoadTransposeMatrixf",
    "LoadTransposeMatrixfARB",
    "LockArraysEXT",
    "LogicOp",
    "Map1d",
    "Map1f",
    "Map2d",
    "Map2f",
    "MapBuffer",
    "MapBufferARB",
    "MapBufferRange",
    "MapGrid1d",
    "MapGrid1f",
    "MapGrid2d",
    "MapGrid2f",
    "Materialf",
    "Materialfv",
    "Materiali",
    "Materialiv",
    "Materialx",
    "Materialxv",
    "MatrixMode",
    "MemoryBarrier",
    "MemoryBarrierByRegion",
    "Minmax",
    "MinSampleShading",
    "MinSampleShadingARB",
    "MultiDrawArrays",
    "MultiDrawArraysEXT",
    "MultiDrawArraysIndirect",
    "MultiDrawElements",
    "MultiDrawElementsBaseVertex",
    "MultiDrawElementsEXT",
    "MultiDrawElementsIndirect",
    "MultiTexCoord1d",
    "MultiTexCoord1dARB",
    "MultiTexCoord1dv",
    "MultiTexCoord1dvARB",
    "MultiTexCoord1f",
    "MultiTexCoord1fARB",
    "MultiTexCoord1fv",
    "MultiTexCoord1fvARB",
    "MultiTexCoord1i",
    "MultiTexCoord1iARB",
    "MultiTexCoord1iv",
    "MultiTexCoord1ivARB",
    "MultiTexCoord1s",
    "MultiTexCoord1sARB",
    "MultiTexCoord1sv",
    "MultiTexCoord1svARB",
    "MultiTexCoord2d",
    "MultiTexCoord2dARB",
    "MultiTexCoord2dv",
    "MultiTexCoord2dvARB",
    "MultiTexCoord2f",
    "MultiTexCoord2fARB",
    "MultiTexCoord2fv",
    "MultiTexCoord2fvARB",
    "MultiTexCoord2i",
    "MultiTexCoord2iARB",
    "MultiTexCoord2iv",
    "MultiTexCoord2ivARB",
    "MultiTexCoord2s",
    "MultiTexCoord2sARB",
    "MultiTexCoord2sv",
    "MultiTexCoord2svARB",
    "MultiTexCoord3d",
    "MultiTexCoord3dARB",
    "MultiTexCoord3dv",
    "MultiTexCoord3dvARB",
    "MultiTexCoord3f",
    "MultiTexCoord3fARB",
    "MultiTexCoord3fv",
    "MultiTexCoord3fvARB",
    "MultiTexCoord3i",
    "MultiTexCoord3iARB",
    "MultiTexCoord3iv",
    "MultiTexCoord3ivARB",
    "MultiTexCoord3s",
    "MultiTexCoord3sARB",
    "MultiTexCoord3sv",
    "MultiTexCoord3svARB",
    "MultiTexCoord4d",
    "MultiTexCoord4dARB",
    "MultiTexCoord4dv",
    "MultiTexCoord4dvARB",
    "MultiTexCoord4f",
    "MultiTexCoord4fARB",
    "MultiTexCoord4fv",
    "MultiTexCoord4fvARB",
    "MultiTexCoord4i",
    "MultiTexCoord4iARB",
    "MultiTexCoord4iv",
    "MultiTexCoord4ivARB",
    "MultiTexCoord4s",
    "MultiTexCoord4sARB",
    "MultiTexCoord4sv",
    "MultiTexCoord4svARB",
    "MultiTexCoord4x",
    "MultiTexCoordP1ui",
    "MultiTexCoordP1uiv",
    "MultiTexCoordP2ui",
    "MultiTexCoordP2uiv",
    "MultiTexCoordP3ui",
    "MultiTexCoordP3uiv",
    "MultiTexCoordP4ui",
    "MultiTexCoordP4uiv",
    "MultMatrixd",
    "MultMatrixf",
    "MultMatrixx",
    "MultTransposeMatrixd",
    "MultTransposeMatrixdARB",
    "MultTransposeMatrixf",
    "MultTransposeMatrixfARB",
    "NewList",
    "Normal3b",
    "Normal3bv",
    "Normal3d",
    "Normal3dv",
    "Normal3f",
    "Normal3fv",
    "Normal3i",
    "Normal3iv",
    "Normal3s",
    "Normal3sv",
    "Normal3x",
    "NormalP3ui",
    "NormalP3uiv",
    "NormalPointer",
    "NormalPointerEXT",
    "ObjectLabel",
    "ObjectPtrLabel",
    "Ortho",
    "Orthof",
    "Orthox",
    "PassThrough",
    "PatchParameteri",
    "PauseTransformFeedback",
    "PixelMapfv",
    "PixelMapuiv",
    "PixelMapusv",
    "PixelStoref",
    "PixelStorei",
    "PixelTransferf",
    "PixelTransferi",
    "PixelZoom",
    "PointParameterf",
    "PointParameterfARB",
    "PointParameterfEXT",
    "PointParameterfv",
    "PointParameterfvARB",
    "PointParameterfvEXT",
    "PointParameteri",
    "PointParameteriv",
    "PointParameterx",
    "PointParameterxv",
    "PointSize",
    "PointSizePointerOES",
    "PointSizex",
    "PolygonMode",
    "PolygonOffset",
    "PolygonOffsetx",
    "PolygonStipple",
    "PopAttrib",
    "PopClientAttrib",
    "PopDebugGroup",
    "PopMatrix",
    "PopName",
    "PrimitiveBoundingBox",
    "PrimitiveRestartIndex",
    "PrimitiveRestartIndexNV",
    "PrimitiveRestartNV",
    "PrioritizeTextures",
    "PrioritizeTexturesEXT",
    "ProgramBinary",
    "ProgramEnvParameter4dARB",
    "ProgramEnvParameter4dvARB",
    "ProgramEnvParameter4fARB",
    "ProgramEnvParameter4fvARB",
    "ProgramLocalParameter4dARB",
    "ProgramLocalParameter4dvARB",
    "ProgramLocalParameter4fARB",
    "ProgramLocalParameter4fvARB",
    "ProgramParameteri",
    "ProgramParameteriARB",
    "ProgramStringARB",
    "ProgramUniform1f",
    "ProgramUniform1fv",
    "ProgramUniform1i",
    "ProgramUniform1iv",
    "ProgramUniform1ui",
    "ProgramUniform1uiv",
    "ProgramUniform2f",
    "ProgramUniform2fv",
    "ProgramUniform2i",
    "ProgramUniform2iv",
    "ProgramUniform2ui",
    "ProgramUniform2uiv",
    "ProgramUniform3f",
    "ProgramUniform3fv",
    "ProgramUniform3i",
    "ProgramUniform3iv",
    "ProgramUniform3ui",
    "ProgramUniform3uiv",
    "ProgramUniform4f",
    "ProgramUniform4fv",
    "ProgramUniform4i",
    "ProgramUniform4iv",
    "ProgramUniform4ui",
    "ProgramUniform4uiv",
    "ProgramUniformMatrix2fv",
    "ProgramUniformMatrix2x3fv",
    "ProgramUniformMatrix2x4fv",
    "ProgramUniformMatrix3fv",
    "ProgramUniformMatrix3x2fv",
    "ProgramUniformMatrix3x4fv",
    "ProgramUniformMatrix4fv",
    "ProgramUniformMatrix4x2fv",
    "ProgramUniformMatrix4x3fv",
    "ProvokingVertex",
    "ProvokingVertexEXT",
    "PushAttrib",
    "PushClientAttrib",
    "PushDebugGroup",
    "PushMatrix",
    "PushName",
    "RasterPos2d",
    "RasterPos2dv",
    "RasterPos2f",
    "RasterPos2fv",
    "RasterPos2i",
    "RasterPos2iv",
    "RasterPos2s",
    "RasterPos2sv",
    "RasterPos3d",
    "RasterPos3dv",
    "RasterPos3f",
    "RasterPos3fv",
    "RasterPos3i",
    "RasterPos3iv",
    "RasterPos3s",
    "RasterPos3sv",
    "RasterPos4d",
    "RasterPos4dv",
    "RasterPos4f",
    "RasterPos4fv",
    "RasterPos4i",
    "RasterPos4iv",
    "RasterPos4s",
    "RasterPos4sv",
    "ReadBuffer",
    "ReadnPixels",
    "ReadnPixelsARB",
    "ReadPixels",
    "Rectd",
    "Rectdv",
    "Rectf",
    "Rectfv",
    "Recti",
    "Rectiv",
    "Rects",
    "Rectsv",
    "ReleaseShaderCompiler",
    "RenderbufferStorage",
    "RenderbufferStorageEXT",
    "RenderbufferStorageMultisample",
    "RenderbufferStorageMultisampleEXT",
    "RenderMode",
    "ResetHistogram",
    "ResetMinmax",
    "ResumeTransformFeedback",
    "Rotated",
    "Rotatef",
    "Rotatex",
    "SampleCoverage",
    "SampleCoverageARB",
    "SampleCoveragex",
    "SampleMaski",
    "SamplerParameterf",
    "SamplerParameterfv",
    "SamplerParameteri",
    "SamplerParameterIiv",
    "SamplerParameterIuiv",
    "SamplerParameteriv",
    "Scaled",
    "Scalef",
    "Scalex",
    "Scissor",
    "ScissorArrayv",
    "ScissorIndexed",
    "ScissorIndexedv",
    "SecondaryColor3b",
    "SecondaryColor3bEXT",
    "SecondaryColor3bv",
    "SecondaryColor3bvEXT",
    "SecondaryColor3d",
    "SecondaryColor3dEXT",
    "SecondaryColor3dv",
    "SecondaryColor3dvEXT",
    "SecondaryColor3f",
    "SecondaryColor3fEXT",
    "SecondaryColor3fv",
    "SecondaryColor3fvEXT",
    "SecondaryColor3i",
    "SecondaryColor3iEXT",
    "SecondaryColor3iv",
    "SecondaryColor3ivEXT",
    "SecondaryColor3s",
    "SecondaryColor3sEXT",
    "SecondaryColor3sv",
    "SecondaryColor3svEXT",
    "SecondaryColor3ub",
    "SecondaryColor3ubEXT",
    "SecondaryColor3ubv",
    "SecondaryColor3ubvEXT",
    "SecondaryColor3ui",
    "SecondaryColor3uiEXT",
    "SecondaryColor3uiv",
    "SecondaryColor3uivEXT",
    "SecondaryColor3us",
    "SecondaryColor3usEXT",
    "SecondaryColor3usv",
    "SecondaryColor3usvEXT",
    "SecondaryColorP3ui",
    "SecondaryColorP3uiv",
    "SecondaryColorPointer",
    "SecondaryColorPointerEXT",
    "SelectBuffer",
    "SeparableFilter2D",
    "ShadeModel",
    "ShaderBinary",
    "ShaderSource",
    "ShaderSourceARB",
    "StencilFunc",
    "StencilFuncSeparate",
    "StencilMask",
    "StencilMaskSeparate",
    "StencilOp",
    "StencilOpSeparate",
    "TexBuffer",
    "TexBufferARB",
    "TexBufferRange",
    "TexCoord1d",
    "TexCoord1dv",
    "TexCoord1f",
    "TexCoord1fv",
    "TexCoord1i",
    "TexCoord1iv",
    "TexCoord1s",
    "TexCoord1sv",
    "TexCoord2d",
    "TexCoord2dv",
    "TexCoord2f",
    "TexCoord2fv",
    "TexCoord2i",
    "TexCoord2iv",
    "TexCoord2s",
    "TexCoord2sv",
    "TexCoord3d",
    "TexCoord3dv",
    "TexCoord3f",
    "TexCoord3fv",
    "TexCoord3i",
    "TexCoord3iv",
    "TexCoord3s",
    "TexCoord3sv",
    "TexCoord4d",
    "TexCoord4dv",
    "TexCoord4f",
    "TexCoord4fv",
    "TexCoord4i",
    "TexCoord4iv",
    "TexCoord4s",
    "TexCoord4sv",
    "TexCoordP1ui",
    "TexCoordP1uiv",
    "TexCoordP2ui",
    "TexCoordP2uiv",
    "TexCoordP3ui",
    "TexCoordP3uiv",
    "TexCoordP4ui",
    "TexCoordP4uiv",
    "TexCoordPointer",
    "TexCoordPointerEXT",
    "TexEnvf",
    "TexEnvfv",
    "TexEnvi",
    "TexEnviv",
    "TexEnvx",
    "TexEnvxv",
    "TexGend",
    "TexGendv",
    "TexGenf",
    "TexGenfv",
    "TexGeni",
    "TexGeniv",
    "TexImage1D",
    "TexImage2D",
    "TexImage2DMultisample",
    "TexImage3D",
    "TexImage3DEXT",
    "TexImage3DMultisample",
    "TexParameterf",
    "TexParameterfv",
    "TexParameteri",
    "TexParameterIiv",
    "TexParameterIivEXT",
    "TexParameterIuiv",
    "TexParameterIuivEXT",
    "TexParameteriv",
    "TexParameterx",
    "TexParameterxv",
    "TexStorage1D",
    "TexStorage2D",
    "TexStorage2DMultisample",
    "TexStorage3D",
    "TexStorage3DMultisample",
    "TexStorageAttribs2DEXT",
    "TexStorageAttribs3DEXT",
    "TexSubImage1D",
    "TexSubImage2D",
    "TexSubImage3D",
    "TexSubImage3DEXT",
    "TextureBarrierNV",
    "TextureStorage1DEXT",
    "TextureStorage2DEXT",
    "TextureStorage3DEXT",
    "TextureView",
    "TransformFeedbackVaryings",
    "Translated",
    "Translatef",
    "Translatex",
    "Uniform1f",
    "Uniform1fARB",
    "Uniform1fv",
    "Uniform1fvARB",
    "Uniform1i",
    "Uniform1iARB",
    "Uniform1iv",
    "Uniform1ivARB",
    "Uniform1ui",
    "Uniform1uiEXT",
    "Uniform1uiv",
    "Uniform1uivEXT",
    "Uniform2f",
    "Uniform2fARB",
    "Uniform2fv",
    "Uniform2fvARB",
    "Uniform2i",
    "Uniform2iARB",
    "Uniform2iv",
    "Uniform2ivARB",
    "Uniform2ui",
    "Uniform2uiEXT",
    "Uniform2uiv",
    "Uniform2uivEXT",
    "Uniform3f",
    "Uniform3fARB",
    "Uniform3fv",
    "Uniform3fvARB",
    "Uniform3i",
    "Uniform3iARB",
    "Uniform3iv",
    "Uniform3ivARB",
    "Uniform3ui",
    "Uniform3uiEXT",
    "Uniform3uiv",
    "Uniform3uivEXT",
    "Uniform4f",
    "Uniform4fARB",
    "Uniform4fv",
    "Uniform4fvARB",
    "Uniform4i",
    "Uniform4iARB",
    "Uniform4iv",
    "Uniform4ivARB",
    "Uniform4ui",
    "Uniform4uiEXT",
    "Uniform4uiv",
    "Uniform4uivEXT",
    "UniformBlockBinding",
    "UniformMatrix2fv",
    "UniformMatrix2fvARB",
    "UniformMatrix2x3fv",
    "UniformMatrix2x4fv",
    "UniformMatrix3fv",
    "UniformMatrix3fvARB",
    "UniformMatrix3x2fv",
    "UniformMatrix3x4fv",
    "UniformMatrix4fv",
    "UniformMatrix4fvARB",
    "UniformMatrix4x2fv",
    "UniformMatrix4x3fv",
    "UnlockArraysEXT",
    "UnmapBuffer",
    "UnmapBufferARB",
    "UseProgram",
    "UseProgramObjectARB",
    "UseProgramStages",
    "ValidateProgram",
    "ValidateProgramARB",
    "ValidateProgramPipeline",
    "Vertex2d",
    "Vertex2dv",
    "Vertex2f",
    "Vertex2fv",
    "Vertex2i",
    "Vertex2iv",
    "Vertex2s",
    "Vertex2sv",
    "Vertex3d",
    "Vertex3dv",
    "Vertex3f",
    "Vertex3fv",
    "Vertex3i",
    "Vertex3iv",
    "Vertex3s",
    "Vertex3sv",
    "Vertex4d",
    "Vertex4dv",
    "Vertex4f",
    "Vertex4fv",
    "Vertex4i",
    "Vertex4iv",
    "Vertex4s",
    "Vertex4sv",
    "VertexAttrib1d",
    "VertexAttrib1dARB",
    "VertexAttrib1dv",
    "VertexAttrib1dvARB",
    "VertexAttrib1f",
    "VertexAttrib1fARB",
    "VertexAttrib1fv",
    "VertexAttrib1fvARB",
    "VertexAttrib1s",
    "VertexAttrib1sARB",
    "VertexAttrib1sv",
    "VertexAttrib1svARB",
    "VertexAttrib2d",
    "VertexAttrib2dARB",
    "VertexAttrib2dv",
    "VertexAttrib2dvARB",
    "VertexAttrib2f",
    "VertexAttrib2fARB",
    "VertexAttrib2fv",
    "VertexAttrib2fvARB",
    "VertexAttrib2s",
    "VertexAttrib2sARB",
    "VertexAttrib2sv",
    "VertexAttrib2svARB",
    "VertexAttrib3d",
    "VertexAttrib3dARB",
    "VertexAttrib3dv",
    "VertexAttrib3dvARB",
    "VertexAttrib3f",
    "VertexAttrib3fARB",
    "VertexAttrib3fv",
    "VertexAttrib3fvARB",
    "VertexAttrib3s",
    "VertexAttrib3sARB",
    "VertexAttrib3sv",
    "VertexAttrib3svARB",
    "VertexAttrib4bv",
    "VertexAttrib4bvARB",
    "VertexAttrib4d",
    "VertexAttrib4dARB",
    "VertexAttrib4dv",
    "VertexAttrib4dvARB",
    "VertexAttrib4f",
    "VertexAttrib4fARB",
    "VertexAttrib4fv",
    "VertexAttrib4fvARB",
    "VertexAttrib4iv",
    "VertexAttrib4ivARB",
    "VertexAttrib4Nbv",
    "VertexAttrib4NbvARB",
    "VertexAttrib4Niv",
    "VertexAttrib4NivARB",
    "VertexAttrib4Nsv",
    "VertexAttrib4NsvARB",
    "VertexAttrib4Nub",
    "VertexAttrib4NubARB",
    "VertexAttrib4Nubv",
    "VertexAttrib4NubvARB",
    "VertexAttrib4Nuiv",
    "VertexAttrib4NuivARB",
    "VertexAttrib4Nusv",
    "VertexAttrib4NusvARB",
    "VertexAttrib4s",
    "VertexAttrib4sARB",
    "VertexAttrib4sv",
    "VertexAttrib4svARB",
    "VertexAttrib4ubv",
    "VertexAttrib4ubvARB",
    "VertexAttrib4uiv",
    "VertexAttrib4uivARB",
    "VertexAttrib4usv",
    "VertexAttrib4usvARB",
    "VertexAttribBinding",
    "VertexAttribDivisor",
    "VertexAttribDivisorARB",
    "VertexAttribFormat",
    "VertexAttribI1i",
    "VertexAttribI1iEXT",
    "VertexAttribI1iv",
    "VertexAttribI1ivEXT",
    "VertexAttribI1ui",
    "VertexAttribI1uiEXT",
    "VertexAttribI1uiv",
    "VertexAttribI1uivEXT",
    "VertexAttribI2i",
    "VertexAttribI2iEXT",
    "VertexAttribI2iv",
    "VertexAttribI2ivEXT",
    "VertexAttribI2ui",
    "VertexAttribI2uiEXT",
    "VertexAttribI2uiv",
    "VertexAttribI2uivEXT",
    "VertexAttribI3i",
    "VertexAttribI3iEXT",
    "VertexAttribI3iv",
    "VertexAttribI3ivEXT",
    "VertexAttribI3ui",
    "VertexAttribI3uiEXT",
    "VertexAttribI3uiv",
    "VertexAttribI3uivEXT",
    "VertexAttribI4bv",
    "VertexAttribI4bvEXT",
    "VertexAttribI4i",
    "VertexAttribI4iEXT",
    "VertexAttribI4iv",
    "VertexAttribI4ivEXT",
    "VertexAttribI4sv",
    "VertexAttribI4svEXT",
    "VertexAttribI4ubv",
    "VertexAttribI4ubvEXT",
    "VertexAttribI4ui",
    "VertexAttribI4uiEXT",
    "VertexAttribI4uiv",
    "VertexAttribI4uivEXT",
    "VertexAttribI4usv",
    "VertexAttribI4usvEXT",
    "VertexAttribIFormat",
    "VertexAttribIPointer",
    "VertexAttribIPointerEXT",
    "VertexAttribLFormat",
    "VertexAttribP1ui",
    "VertexAttribP1uiv",
    "VertexAttribP2ui",
    "VertexAttribP2uiv",
    "VertexAttribP3ui",
    "VertexAttribP3uiv",
    "VertexAttribP4ui",
    "VertexAttribP4uiv",
    "VertexAttribPointer",
    "VertexAttribPointerARB",
    "VertexBindingDivisor",
    "VertexP2ui",
    "VertexP2uiv",
    "VertexP3ui",
    "VertexP3uiv",
    "VertexP4ui",
    "VertexP4uiv",
    "VertexPointer",
    "VertexPointerEXT",
    "Viewport",
    "ViewportArrayv",
    "ViewportIndexedf",
    "ViewportIndexedfv",
    "WaitSync",
    "WindowPos2d",
    "WindowPos2dARB",
    "WindowPos2dv",
    "WindowPos2dvARB",
    "WindowPos2f",
    "WindowPos2fARB",
    "WindowPos2fv",
    "WindowPos2fvARB",
    "WindowPos2i",
    "WindowPos2iARB",
    "WindowPos2iv",
    "WindowPos2ivARB",
    "WindowPos2s",
    "WindowPos2sARB",
    "WindowPos2sv",
    "WindowPos2svARB",
    "WindowPos3d",
    "WindowPos3dARB",
    "WindowPos3dv",
    "WindowPos3dvARB",
    "WindowPos3f",
    "WindowPos3fARB",
    "WindowPos3fv",
    "WindowPos3fvARB",
    "WindowPos3i",
    "WindowPos3iARB",
    "WindowPos3iv",
    "WindowPos3ivARB",
    "WindowPos3s",
    "WindowPos3sARB",
    "WindowPos3sv",
    "WindowPos3svARB",
]
