/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-tool.c
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */
#include <stdlib.h>
#include <stdio.h>
#include <glib/gstdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

static UnityWebappsService *service = NULL;

static void
print_help () 
{
  g_printf("Usage: unity-webapps-tool <COMMAND>\n");
  g_printf("Possible commands include:\n");
  g_printf("   help - display this message\n");
  g_printf("   list - list running web-application contexts");
  g_printf("   shutdown - shutdown the Unity Webapps System");
}

static UnityWebappsContext *
make_context_proxy (const gchar *name)
{
  return unity_webapps_context_new_for_context_name (service, name);
}

static void
list_contexts ()
{
  gchar **contexts;
  guint i, len;
  
  contexts = unity_webapps_service_list_contexts (service);
  if (contexts == NULL)
	{
	  return;
	}
  len = g_strv_length ((gchar **)contexts);

  g_printf("Running contexts:\n");
  for (i = 0; i < len; i++)
	{
	  UnityWebappsContext *context;
	  const gchar *context_name;
	  
	  context_name = contexts[i];
	  if (context_name[0] == '\0')
		continue;

	  context = make_context_proxy (context_name);
	  
	  
	  g_printf(" * %s (%s)\n", unity_webapps_context_get_name (context),
			   context_name);
	}

  g_strfreev (contexts);
}

static void
shutdown_all ()
{
  gchar **contexts;
  guint i, len;
  
  contexts = unity_webapps_service_list_contexts (service);
  if (contexts == NULL)
	{
	  return;
	}
  len = g_strv_length ((gchar **)contexts);

  printf("Shutting down contexts\n");
  for (i = 0; i < len; i++)
	{
	  UnityWebappsContext *context;
	  const gchar *context_name;
	  gboolean shutdown;
	  
	  context_name = contexts[i];
	  context = make_context_proxy (context_name);
	  
	  g_printf(" * Shutting down %s (%s)..", unity_webapps_context_get_name (context),
			   context_name);
	  
	  shutdown = unity_webapps_context_shutdown (context);
	  if (shutdown == FALSE)
		{
		  g_printf("Failed to shutdown\n");
		}
	  else
		{
		  g_printf("Done\n");
		}
	  
	  g_printf("Shutting down service...");
	  unity_webapps_service_shutdown (service);
	  g_printf("Done\n");

	}

  g_strfreev (contexts);
}

gint
main (gint argc, gchar **argv)
{
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  if (argc == 1)
	{
	  print_help();
	  exit(0);
	}
  if (g_strcmp0(argv[1], "help") == 0)
	{
	  print_help();
	  exit(0);
	}
  if (g_strcmp0(argv[1], "list") == 0)
	{
	  list_contexts();
	  exit(0);
	}
  if (g_strcmp0(argv[1], "shutdown") == 0)
	{
	  shutdown_all();
	  exit(0);
	}
  print_help();

  
  exit (0);
  
}
