/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-tool.c
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>."
 */
#include <stdlib.h>
#include <stdio.h>
#include <glib.h>
#include <glib/gstdio.h>

#include "unity-webapps-application-info.h"
#include "unity-webapps-permissions.h"

static gchar *name = NULL;
static gchar *domain = NULL;
static gchar *icon_uri = NULL;
static gchar *homepage = NULL;

static gboolean force = FALSE;

static GOptionEntry option_entries[] = 
  {
	{ "name", 'n', 0, G_OPTION_ARG_STRING,
	  &name, "Application name", NULL},
	{ "domain", 'd', 0, G_OPTION_ARG_STRING,
	  &domain, "Application domain", NULL},
	{ "icon-uri", 'i', 0, G_OPTION_ARG_STRING,
	  &icon_uri, "Application main icon URI", NULL},
	{ "homepage", 'h', G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_STRING,
	  &homepage, "Application homepage", NULL},
	{ "force", 'f', 0, G_OPTION_ARG_NONE,
	  &force, "Force install even if Domain has been blacklisted", NULL},
	{ NULL, }
  };

static void
unity_webapps_installer_parse_args (gint *argc, 
									gchar ***argv)
{
  GOptionContext *context;
  GError *error;
	
  context = g_option_context_new (" - Install Unity Webapps");
	
  // TODO: Localization
  g_option_context_add_main_entries (context, option_entries, NULL);
  
  error = NULL;
	
  if (!g_option_context_parse (context, argc, argv, &error))
	{
	  g_printf("Failed to parse arguments: %s \n", error->message);
	  g_error_free (error);
			
	  exit(1);
	}
  
  return;
}

static void
unity_webapps_installer_install_application ()
{
  UnityWebappsApplicationInfo *info;
  gchar *saved_icon, *desktop_file_path;
  GError *error;
  
  info = unity_webapps_application_info_new (name, domain, icon_uri, NULL);

  printf("Installing application: %s at %s\n", name, domain);
  saved_icon = unity_webapps_application_info_save_icon_file (info);
  
  if (saved_icon == NULL)
	{
	  g_error ("Failed to save icon file!");
	  exit(1);
	}
  
  printf("   * Wrote icon file: %s", saved_icon);
  
  error = NULL;
  
  unity_webapps_application_info_ensure_desktop_file (info,
													 &error);
  
  if (error != NULL)
	{
	  g_error ("Failed to write desktop file: %s \n", error->message);
	  g_error_free (error);

	  exit (1);
	}

  desktop_file_path = unity_webapps_application_info_get_desktop_file_path (info);
  
  printf("   * Wrote desktop file: %s\n", desktop_file_path);
  
  if (homepage != NULL)
	{
	  homepage = domain;
	}

  unity_webapps_application_info_set_homepage (info, homepage);

  
  return;
}

static void
unity_webapps_installer_authorize_application ()
{
  gboolean dontask;
	
  dontask = unity_webapps_permissions_get_domain_dontask (domain);
	
  if (dontask == TRUE)
	{
	  printf("Trying to install application at domain %s, which has been blacklisted due to user action.\n", domain);
	  
	  if (force == TRUE)
		{
		  printf("Forcing install anyway\n");
		}
	  else 
		{
		  exit(1);
		}
	}
	
  unity_webapps_permissions_allow_domain (domain);
  
  return;
}

gint
main (gint argc, gchar **argv)
{
  g_type_init ();
  
  unity_webapps_installer_parse_args (&argc, &argv);
  unity_webapps_installer_authorize_application ();
  unity_webapps_installer_install_application ();
  
  return 0;
}
