#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"
#include "uwa-test-client.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;

static guint callbacks = 0;

static void
on_action_one(UnityWebappsContext *context, gpointer user_data)
{
  printf("Got action 1 with: %s\n", (gchar*) user_data);
  callbacks ++;
}

static void
on_action_two (UnityWebappsContext *context, gpointer user_data)
{
  callbacks ++;
  
  printf("Got action 2 with: %s\n", (gchar*) user_data);
  
  if (callbacks == 2)
    {
      uwa_emit_test_finished ();
    }
}

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  UnityWebappsApplicationActionDesc desc[] = {
    {"/Action 1", on_action_one, "user data one"},
    {"/Action 2", on_action_two, "user data two"}
  };
  unity_webapps_context_add_application_actions (context, desc, 2);
}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
